<?php
class EXfood_Ordering_Food {
	public function __construct()
    {
		add_action( 'wp_ajax_exfood_user_checkout', array( &$this,'exfood_user_checkout') );
		add_action( 'wp_ajax_nopriv_exfood_user_checkout', array( &$this,'exfood_user_checkout') );
		add_action( 'exfood_checkout_success', array( &$this,'user_order_success'),10,3 );

    }
    public function validate_data($data,$recaptcha){

    	$fname = exfood_get_option('exfood_ck_fname','exfood_advanced_options');
		$lname = exfood_get_option('exfood_ck_lname','exfood_advanced_options');
		$date = exfood_get_option('exfood_ck_date','exfood_advanced_options');
		$time = exfood_get_option('exfood_ck_time','exfood_advanced_options');
		$location = exfood_get_option('exfood_ck_location','exfood_advanced_options');
		$address = exfood_get_option('exfood_ck_address','exfood_advanced_options');
		$phone = exfood_get_option('exfood_ck_phone','exfood_advanced_options');
		$email = exfood_get_option('exfood_ck_email','exfood_advanced_options');
		$note = exfood_get_option('exfood_ck_note','exfood_advanced_options');
		$minimum_amount = exfood_get_option('exfood_ck_mini_amount','exfood_advanced_options');
    	$html ='';
    	if( $fname!='no' && $fname!='disable' && (!isset($data['_fname']) || $data['_fname']=='') ){
    		$html .='<p>'.esc_html__('Billing First name is a required field','wp-food').'</p>';
    	}
    	if($lname!='no' && $lname!='disable' && (!isset($data['_lname']) || $data['_lname']=='') ){
    		$html .='<p>'.esc_html__('Billing Last name is a required field.','wp-food').'</p>';
    	}
    	if($date!='no' && $date!='disable' && (!isset($data['_date']) || $data['_date']=='') ){
    		$html .='<p>'.esc_html__('Billing Date is a required field.','wp-food').'</p>';
    	}
    	if($time!='no' && $time!='disable' && (!isset($data['_time']) || $data['_time']=='') ){
    		$html .='<p>'.esc_html__('Billing Time is a required field.','wp-food').'</p>';
    	}
    	if($location!='no' && $location!='disable' && (!isset($data['_location']) || $data['_location']=='') ){
    		$html .='<p>'.esc_html__('Billing Location is a required field.','wp-food').'</p>';
    	}
    	if($address!='no' && $address!='disable' && $data['_type'] !='order-pick' && (!isset($data['_address']) || $data['_address']=='') ){
    		$html .='<p>'.esc_html__('Billing Address is a required field.','wp-food').'</p>';
    	}
    	if($phone!='no' && $phone!='disable' && (!isset($data['_phone']) || $data['_phone']=='') ){
    		$html .='<p>'.esc_html__('Billing Phone is a required field.','wp-food').'</p>';
    	}
    	if($email!='no' && $email!='disable' && (!isset($data['_email']) || $data['_email']=='') ){
    		$html .='<p>'.esc_html__('Billing Email is a required field.','wp-food').'</p>';
    	}else if( $email!='no' && $email!='disable' && !exfood_checkemail($data['_email'])){
    		$html .='<p>'.esc_html__('Invalid email address.','wp-food').'</p>';
    	}
    	if($note!='no' && $note!='disable' && (!isset($data['_note']) || $data['_note']=='') ){
    		$html .='<p>'.esc_html__('Billing Note is a required field.','wp-food').'</p>';
    	}
    	//print_r($data);
    	$tsl_stt = exf_check_time_delivery_status($data);
    	if($tsl_stt!=''){
    		$html .='<p>'.$tsl_stt.'</p>';
    	}
    	if ($minimum_amount != '' && intval($minimum_amount) > 0) {
    		if(isset ($_SESSION['ex_userfood']) && !empty($_SESSION['ex_userfood'])){
    			$data_food = $_SESSION['ex_userfood'];
    			$total_amount = exwpfd_total_price($data_food);
    			$currency = exfood_get_option('exfood_currency');
    			if ($currency=='') {
					$currency ='$';
				}
    			if ($total_amount < $minimum_amount) {
    				$html .='<p>'.sprintf( esc_html__( 'Please order from %s. Thank you!', 'wp-food' ), exfood_price_with_currency($minimum_amount) ).'</p>';
    			}
    		}
    	}
    	$terms_page = exfood_get_option('exfood_terms_page','exfood_advanced_options');
    	if ($terms_page!= '' && filter_var($terms_page, FILTER_VALIDATE_URL) === FALSE) {
	    	$terns_url = get_permalink( $terms_page );
	    }else{
	    	$terns_url = $terms_page;
	    }
    	if( $terns_url!='' && (!isset($data['_terns']) || $data['_terns']!='yes')){
    		$html .='<p>'.esc_html__('Please read and accept the terms and conditions to proceed with your order.','wp-food').'</p>';
    	}
    	$captcha = exfood_get_option('exfood_ck_captcha','exfood_advanced_options');
		$captcha_key = exfood_get_option('exfood_captcha_secret','exfood_advanced_options');
    	if($captcha!='no' && $captcha_key!=''){
	    	$post = http_build_query(
			 	array (
			 		'response' => $recaptcha,
			 		'secret' => $captcha_key,
			 		'remoteip' => $_SERVER['REMOTE_ADDR']
			 	)
			);
			$opts = array('http' => 
				array (
					'method' => 'POST',
					'header' => 'application/x-www-form-urlencoded',
					'content' => $post
				)
			);
			$context = stream_context_create($opts);
			if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] != 'on') {
				$serverResponse = @file_get_contents('http://www.google.com/recaptcha/api/siteverify', false, $context);
			}else{
				$serverResponse = @file_get_contents('https://www.google.com/recaptcha/api/siteverify', false, $context);
			}
			if (!$serverResponse) {
				if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] != 'on') {
					$google_url = "http://www.google.com/recaptcha/api/siteverify";
				}else{
					$google_url = "https://www.google.com/recaptcha/api/siteverify";
				}
				$url = $google_url."?secret=".$captcha_key."&response=".$recaptcha;

				$curl = curl_init();
			    curl_setopt($curl, CURLOPT_URL, $url);
			    curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
			    curl_setopt($curl, CURLOPT_TIMEOUT, 15);
			    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, TRUE);
			    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, TRUE); 
			    $curlData = curl_exec($curl);

			    curl_close($curl);
			    $serverResponse = json_decode($curlData, TRUE);
			    if (!$serverResponse) {
					$html .='<p>'.esc_html__('Failed to validate Recaptcha.','wp-food').'</p>';
				}
			}
			$result = json_encode($serverResponse);
			$result = json_decode($result);
			if (!$serverResponse["success"] && !$result -> success) {
				$html .='<p>'.esc_html__('Invalid Recaptcha.','wp-food').'</p>';
			}
		}
    	$html = apply_filters( 'exfood_validate_checkout_field', $html, $data );
    	return $html;
    }
    function exfood_user_checkout(){
    	$data_order = array();
		parse_str($_POST['data'], $data_order);
		$recaptcha = $_POST['recaptcha'];
		$validate_data = $this->validate_data($data_order,$recaptcha);
		if($validate_data!=''){
			$notice = '<div class="exfood-validate-warning">'.$validate_data.'</div>';
			$output =  array('status'=>2,'html_content'=> $notice);
			echo str_replace('\/', '/', json_encode($output));
			exit;
		}
		session_start();
		if(isset ($_SESSION['ex_userfood']) && !empty($_SESSION['ex_userfood'])){
			$status = 1;
			$data_food = $_SESSION['ex_userfood'];
			$tax_rate = exfood_get_option('exfood_tax_rate','exfood_advanced_options');
			$final_total = exfood_update_total_price($_SESSION['ex_userfood'],1);
			$shipping_fee_check = $tax_check = false;
			$tax = $shipping_fee = 0;
			if(is_numeric($tax_rate)){
				$tax_check = true;
				$tax = ($final_total * $tax_rate)/100;
				$final_total = $tax + $final_total;
			}else{ $tax_rate = 0;}
			$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');
			$shipping_fee = isset($_SESSION['exwpfd_shiping_fee']) && is_numeric($_SESSION['exwpfd_shiping_fee']) ? $_SESSION['exwpfd_shiping_fee'] : 0;
			if(is_numeric($shipping_fee) && $shipping_fee > 0){
				$shipping_fee_check = true;
				if($shipping_free!='' && $final_total >= $shipping_free){
					$shipping_fee = 0;
					$data_food['shipping_fee_ld'] = esc_html__( 'Free', 'wp-food' );
				}
				$final_total = $shipping_fee + $final_total;
			}else{ $shipping_fee = 0;}
			if ($shipping_fee_check || $tax_check) { 
			}else{
				$final_total = 0;
			}
			$data_food['tax_rate'] = $tax_rate;
			$data_food['shipping_fee'] = $shipping_fee;
			$data_food['final_total'] = $final_total;
			$attr = array(
				'post_title'    => $data_order['_fname'].' '.$data_order['_lname'].' - '.$data_order['_email'],
				'post_content'  => '',
				'post_status'   => 'publish',
				'post_type'      => 'exfood_order',
			);
			if($new_ID = wp_insert_post( $attr, false )){
				update_post_meta( $new_ID, 'exorder_fname', $data_order['_fname']);
				update_post_meta( $new_ID, 'exorder_lname', $data_order['_lname']);
				update_post_meta( $new_ID, 'exorder_phone', $data_order['_phone']);
				update_post_meta( $new_ID, 'exorder_email', $data_order['_email']);
				update_post_meta( $new_ID, 'exorder_type', $data_order['_type']);
				update_post_meta( $new_ID, 'exorder_store', $data_order['_store']);
				update_post_meta( $new_ID, 'exorder_date', $data_order['_date']);
				update_post_meta( $new_ID, 'exorder_time', $data_order['_time']);
				update_post_meta( $new_ID, 'exorder_location', $data_order['_location']);
				update_post_meta( $new_ID, 'exorder_address', $data_order['_address']);
				update_post_meta( $new_ID, 'exorder_note', $data_order['_note']);
				update_post_meta( $new_ID, 'exorder_food', $data_food);
				if(isset ($_SESSION['ex_userid']) && $_SESSION['ex_userid']!=0){
					update_post_meta( $new_ID, 'exorder_userid', $_SESSION['ex_userid']);
				}
				//$html = '<div class="exfood-warning">'.esc_html__('your order has been placed, we will contact with you very soon','wp-food').'</div>';
				ob_start();
				do_action( 'exfood_checkout_success', $data_order, $data_food, $new_ID );
				$html = ob_get_contents();
				ob_end_clean();
				$_SESSION['ex_userfood'] = '';
			}else{
				$status = 0;
				$html = '<div class="exfood-warning">'.esc_html__('Oops, Something went wrong, please try again!','wp-food').'</div>';
			}
		}else{
			$status = 0;
			$html = '<div class="exfood-warning">'.esc_html__('Oops, Something went wrong, There is no item in your Cart!','wp-food').'</div>';
		}
		$output =  array('status'=>$status,'html_content'=> $html);
		echo str_replace('\/', '/', json_encode($output));
		exit;
    }
    function user_order_success($data_order, $data_food, $new_ID){
    	global $userfood, $billing, $id;
    	$userfood = $data_food; $id = $new_ID; $billing = $data_order;
    	exfood_template_plugin('thankyou',false);
    }
}
$EXfood_Ordering_Food = new EXfood_Ordering_Food();