<?php
//shortcode
include plugin_dir_path(__FILE__).'shortcodes/wp-food-list.php';
include plugin_dir_path(__FILE__).'shortcodes/wp-food-grid.php';
include plugin_dir_path(__FILE__).'shortcodes/wp-food-table.php';
include plugin_dir_path(__FILE__).'shortcodes/wp-food-carousel.php';
include plugin_dir_path(__FILE__).'shortcodes/wp-food-mini-cart.php';
include plugin_dir_path(__FILE__).'shortcodes/wp-food-user.php';
//widget
include plugin_dir_path(__FILE__).'widgets/wp-food.php';

include plugin_dir_path(__FILE__).'payments/class-paypal-payment.php';

if(!function_exists('exfood_startsWith')){
	function exfood_startsWith($haystack, $needle)
	{
		return !strncmp($haystack, $needle, strlen($needle));
	}
} 
if(!function_exists('exfood_get_google_fonts_url')){
	function exfood_get_google_fonts_url ($font_names) {
	
		$font_url = '';
	
		$font_url = add_query_arg( 'family', urlencode(implode('|', $font_names)) , "//fonts.googleapis.com/css" );
		return $font_url;
	} 
}
if(!function_exists('exfood_get_google_font_name')){
	function exfood_get_google_font_name($family_name){
		$name = $family_name;
		if(exfood_startsWith($family_name, 'http')){
			// $family_name is a full link, so first, we need to cut off the link
			$idx = strpos($name,'=');
			if($idx > -1){
				$name = substr($name, $idx);
			}
		}
		$idx = strpos($name,':');
		if($idx > -1){
			$name = substr($name, 0, $idx);
			$name = str_replace('+',' ', $name);
		}
		return $name;
	}
}
if(!function_exists('exfood_template_plugin')){
	function exfood_template_plugin($pageName,$shortcode=false){
		if(isset($shortcode) && $shortcode== true){
			if (locate_template('wp-food/content-shortcodes/content-' . $pageName . '.php') != '') {
				get_template_part('wp-food/content-shortcodes/content', $pageName);
			} else {
				include exfood_get_plugin_url().'templates/content-shortcodes/content-' . $pageName . '.php';
			}
		}else{
			if (locate_template('wp-food/' . $pageName . '.php') != '') {
				get_template_part('wp-food/'.$pageName);
			} else {
				include exfood_get_plugin_url().'templates/' . $pageName . '.php';
			}
		}
	}
}

if(!function_exists('EX_WPFood_query')){
    function EX_WPFood_query($posttype, $count, $order, $orderby, $cat, $tag, $taxonomy, $meta_key, $ids, $on_sale, $meta_value=false,$page=false,$mult=false, $active_filter=false){
    	if(isset($active_filter) && $active_filter!=''){ $cat = $active_filter;}
		$posttype = 'ex_food';
		if($orderby == 'sale'){
			$meta_key = 'exfood_sale_price';
			$orderby = 'meta_value_num';
		}
		if($posttype == 'ex_food' && $taxonomy == ''){
			$taxonomy = 'exfood_cat';
		}
		$posttype = explode(",", $posttype);
		if($ids!=''){ //specify IDs
			$ids = explode(",", $ids);
			$args = array(
				'post_type' => $posttype,
				'posts_per_page' => $count,
				'post_status' => array( 'publish' ),
				'post__in' =>  $ids,
				'order' => $order,
				'orderby' => $orderby,
				'ignore_sticky_posts' => 1,
			);
		}elseif($ids==''){
			$args = array(
				'post_type' => $posttype,
				'posts_per_page' => $count,
				'post_status' => array( 'publish' ),
				'tag' => $tag,
				'order' => $order,
				'orderby' => $orderby,
				'meta_key' => $meta_key,
				'ignore_sticky_posts' => 1,
			);
			if(!is_array($cat) && $taxonomy =='') {
				$cats = explode(",",$cat);
				if(is_numeric($cats[0])){
					$args['category__in'] = $cats;
				}else{			 
					$args['category_name'] = $cat;
				}
			}elseif( is_array($cat) && count($cat) > 0 && $taxonomy ==''){
				$args['category__in'] = $cat;
			}
			$loc = isset($_SESSION['ex_userloc']) && $_SESSION['ex_userloc']!='' ? $_SESSION['ex_userloc'] :'';
			if($taxonomy !='' && $tag!=''){
				$tags = explode(",",$tag);
				if(is_numeric($tags[0])){$field_tag = 'term_id'; }
				else{ $field_tag = 'slug'; }
				if(count($tags)>1){
					  $texo = array(
						  'relation' => 'OR',
					  );
					  foreach($tags as $iterm) {
						  $texo[] = 
							  array(
								  'taxonomy' => $taxonomy,
								  'field' => $field_tag,
								  'terms' => $iterm,
							  );
					  }
					  if($loc!=''){$texo = array($texo);}
				  }else{
					  $texo = array(
						  array(
								  'taxonomy' => $taxonomy,
								  'field' => $field_tag,
								  'terms' => $tags,
							  )
					  );
				}
			}
			//cats
			if($taxonomy !='' && $cat!=''){
				$cats = explode(",",$cat);
				if(is_numeric($cats[0])){$field = 'term_id'; }
				else{ $field = 'slug'; }
				if(count($cats)>1){
					  $texo = array(
						  'relation' => 'OR',
					  );
					  foreach($cats as $iterm) {
						  $texo[] = 
							  array(
								  'taxonomy' => $taxonomy,
								  'field' => $field,
								  'terms' => $iterm,
							  );
					  }
					  if($loc!=''){$texo = array($texo);}
				  }else{
					  $texo = array(
						  array(
								  'taxonomy' => $taxonomy,
								  'field' => $field,
								  'terms' => $cats,
							  )
					  );
				}
			}
			if(isset($mult) && $mult!=''){
				$texo['relation'] = 'AND';
				$texo[] = 
					array(
						'taxonomy' => 'wpex_category',
						'field' => 'term_id',
						'terms' => $mult,
					);
			}
			// user select loc
			//check if ( exfood_get_option('exfood_enable_loc') =='yes' ) {
				
				if($loc!=''){
					$loc = explode(",",$loc);
					if(is_numeric($loc[0])){$field = 'term_id'; }
					else{ $field = 'slug'; }
					if(!isset($texo) || !is_array($texo)){ $texo = array();}
					$texo['relation'] = 'AND';
					if(count($loc)>1){
						  foreach($loc as $iterm) {
							  $texo[] = 
								  array(
									  'taxonomy' => 'exfood_loc',
									  'field' => $field,
									  'terms' => $iterm,
								  );
						  }
					  }else{
						  $texo[] = 
							  array(
									  'taxonomy' => 'exfood_loc',
									  'field' => $field,
									  'terms' => $loc,
						  );
					}
				}
			//}
			if(isset($texo)){
				$args += array('tax_query' => $texo);
			}
		}
		if(isset($meta_value) && $meta_value!='' && $meta_key!=''){
			if(!empty($args['meta_query'])){
				$args['meta_query']['relation'] = 'AND';
			}
			$args['meta_query'][] = array(
				'key'  => $meta_key,
				'value' => $meta_value,
				'compare' => '='
			);
		}
		if(isset($on_sale) && $on_sale =='yes'){
			if(!empty($args['meta_query'])){
				$args['meta_query']['relation'] = 'AND';
			}
			$args['meta_query'][] = array(
				'key'  => 'exfood_sale_price',
				'value' => '0',
				'compare' => '>',
				'type'    => 'NUMERIC',
			);
		}	
		if(isset($page) && $page!=''){
			$args['paged'] = $page;
		}
		return apply_filters( 'exfood_query', $args );
	}
}


if(!function_exists('EX_WPFood_customlink')){
	function EX_WPFood_customlink($id){
		if ( exfood_get_option('exfood_disable_single') =='yes' ) {
			return 'javascript:;';
		}
		return get_the_permalink($id);
	}
}


if(!function_exists('exfood_page_number_html')){
	if(!function_exists('exfood_page_number_html')){
		function exfood_page_number_html($the_query,$ID,$atts,$num_pg,$args,$arr_ids){
			if(function_exists('paginate_links')) {
				echo '<div class="exwpfd-pagination">';
				echo '
					<input type="hidden"  name="id_grid" value='.esc_attr($ID).'>
					<input type="hidden"  name="num_page" value='.esc_attr($num_pg).'>
					<input type="hidden"  name="num_page_uu" value="1">
					<input type="hidden"  name="current_page" value="1">
					<input type="hidden"  name="ajax_url" value='.esc_url(admin_url( 'admin-ajax.php' )).'>
					<input type="hidden"  name="param_query" value='.esc_attr(json_encode($args)).'>
					<input type="hidden"  name="param_ids" value='.esc_attr(json_encode($arr_ids)).'>
					<input type="hidden" id="param_shortcode" name="param_shortcode" value='.esc_attr(json_encode($atts)).'>
				';
				if($num_pg > 1){
					$page_link =  paginate_links( array(
						'base'         => esc_url_raw( str_replace( 999999999, '%#%', get_pagenum_link( 999999999, false ) ) ),
						'format'       => '?paged=%#%',
						'add_args'     => false,
						'show_all'     => true,
						'current' => max( 1, get_query_var('paged') ),
						'total' => $num_pg,
						'prev_next'    => false,
						'type'         => 'array',
						'end_size'     => 3,
						'mid_size'     => 3
					) );
					$class = '';
					if ( get_query_var('paged')<2) {
						$class = 'disable-click';
					}
					$prev_link = '<a class="prev-ajax '.$class.'" href="javascript:;">&larr;</a>';
					$next_link = '<a class="next-ajax" href="javascript:;">&rarr;</a>';
					array_unshift($page_link, $prev_link);
					$page_link[] = $next_link;
					echo '<div class="page-navi">'.implode($page_link).'</div>';
				}
				echo '</div>';
			}
		}
	}
}

if(!function_exists('exfood_ajax_navigate_html')){
	function exfood_ajax_navigate_html($ID,$atts,$num_pg,$args,$arr_ids){
		echo '
			<div class="ex-loadmore">
				<input type="hidden"  name="id_grid" value="'.esc_attr($ID).'">
				<input type="hidden"  name="num_page" value="'.esc_attr($num_pg).'">
				<input type="hidden"  name="num_page_uu" value="1">
				<input type="hidden"  name="current_page" value="1">
				<input type="hidden"  name="ajax_url" value="'.esc_url(admin_url( 'admin-ajax.php' )).'">
				<input type="hidden"  name="param_query" value='.esc_attr(json_encode($args)).'>
				<input type="hidden"  name="param_ids" value='.esc_attr(json_encode($arr_ids)).'>
				<input type="hidden" id="param_shortcode" name="param_shortcode" value='.esc_attr(str_replace('\/', '/', json_encode($atts))).'>';
				if($num_pg > 1){
					echo '
					<a  href="javascript:void(0)" class="loadmore-exfood" data-id="'.esc_attr($ID).'">
						<span class="load-text">'.esc_html__('Load more','wp-food').'</span><span></span>&nbsp;<span></span>&nbsp;<span></span>
					</a>';
				}
				echo '
		</div>';
	}
}

add_action( 'wp_ajax_exfood_loadmore', 'ajax_exfood_loadmore' );
add_action( 'wp_ajax_nopriv_exfood_loadmore', 'ajax_exfood_loadmore' );
function ajax_exfood_loadmore(){
	global $columns,$number_excerpt,$show_time,$orderby,$img_size,$ID;
	global $ID,$number_excerpt,$img_size;
	$atts = json_decode( stripslashes( $_POST['param_shortcode'] ), true );
	$ID = isset($atts['ID']) && $atts['ID'] !=''? $atts['ID'] : 'ex-'.rand(10,9999);
	$style = isset($atts['style']) && $atts['style'] !=''? $atts['style'] : '1';
	$column = isset($atts['column']) && $atts['column'] !=''? $atts['column'] : '2';
	$posttype   = isset($atts['posttype']) && $atts['posttype']!='' ? $atts['posttype'] : 'ex_food';
	$ids   = isset($atts['ids']) ? $atts['ids'] : '';
	$taxonomy  = isset($atts['taxonomy']) ? $atts['taxonomy'] : '';
	$cat   = isset($atts['cat']) ? $atts['cat'] : '';
	$tag  = isset($atts['tag']) ? $atts['tag'] : '';
	$count   = isset($atts['count']) &&  $atts['count'] !=''? $atts['count'] : '9';
	$posts_per_page   = isset($atts['posts_per_page']) && $atts['posts_per_page'] !=''? $atts['posts_per_page'] : '3';
	$order  = isset($atts['order']) ? $atts['order'] : '';
	$orderby  = isset($atts['orderby']) ? $atts['orderby'] : '';
	$meta_key  = isset($atts['meta_key']) ? $atts['meta_key'] : '';
	$meta_value  = isset($atts['meta_value']) ? $atts['meta_value'] : '';
	$class  = isset($atts['class']) ? $atts['class'] : '';
	$img_size =  isset($atts['img_size']) ? $atts['img_size'] :'';
	$number_excerpt =  isset($atts['number_excerpt'])&& $atts['number_excerpt']!='' ? $atts['number_excerpt'] : '10';
	$page = $_POST['page'];
	$layout = isset($_POST['layout']) ? $_POST['layout'] : '';
	$param_query = json_decode( stripslashes( $_POST['param_query'] ), true );
	$param_ids = '';
	if(isset($_POST['param_ids']) && $_POST['param_ids']!=''){
		$param_ids =  json_decode( stripslashes( $_POST['param_ids'] ), true )!='' ? json_decode( stripslashes( $_POST['param_ids'] ), true ) : explode(",",$_POST['param_ids']);
	}
	$end_it_nb ='';
	if($page!=''){ 
		$param_query['paged'] = $page;
		$count_check = $page*$posts_per_page;
		if(($count_check > $count) && (($count_check - $count)< $posts_per_page)){$end_it_nb = $count - (($page - 1)*$posts_per_page);}
		else if(($count_check > $count)) {die;}
	}
	if($orderby =='rand' && is_array($param_ids)){
		$param_query['post__not_in'] = $param_ids;
		$param_query['paged'] = 1;
	}
	global $wpdb;
	$first_char = isset($_POST['char']) ? $_POST['char'] : '';
	if($first_char!=''){
		$postids = $wpdb->get_col($wpdb->prepare("
			SELECT      ID
			FROM        $wpdb->posts
			WHERE       post_type = 'ex_food' AND SUBSTR($wpdb->posts.post_title,1,1) = %s
			ORDER BY    $wpdb->posts.post_title",
			$first_char)
		);
		if(!empty($postids)){
			$param_query['post__in'] = $postids;
		}else{
			echo esc_html__('No matching records found','wp-food');die;
		}
	}
	
	$the_query = new WP_Query( $param_query );
	$it = $the_query->post_count;
	ob_start();
	if($the_query->have_posts()){
		$i =0;
		$arr_ids = array();
		$html_modal = '';
		while($the_query->have_posts()){ $the_query->the_post();
			$i++;
			$arr_ids[] = get_the_ID();
			if($layout=='table'){
				exfood_template_plugin('table-'.$style,1);
			}else if($layout=='list'){
				echo '<div class="fditem-list item-grid" data-id="ex_id-'.esc_attr($ID).'-'.get_the_ID().'" data-id_food="'.get_the_ID().'" id="ctc-'.esc_attr($ID).'-'.get_the_ID().'"> ';
						exf_custom_color('list',$style,'ctc-'.esc_attr($ID).'-'.get_the_ID());
						?>
					<div class="exp-arrow" >
						<?php 
						exfood_template_plugin('list-'.$style,1);
						?>
					<div class="exwpfd_clearfix"></div>
					</div>
					<?php
				echo '</div>';
			}else{
				echo '<div class="item-grid" data-id="ex_id-'.esc_attr($ID).'-'.get_the_ID().'" data-id_food="'.get_the_ID().'" id="ctc-'.esc_attr($ID).'-'.get_the_ID().'"> ';
					exf_custom_color('grid',$style,'ctc-'.esc_attr($ID).'-'.get_the_ID());
					?>
					<div class="exp-arrow">
						<?php 
						exfood_template_plugin('grid-'.$style,1);
						?>
					<div class="exwpfd_clearfix"></div>
					</div>
					<?php
				echo '</div>';
			}
			if($end_it_nb!='' && $end_it_nb == $i){break;}
		}
		wp_reset_postdata();
		
		if($orderby =='rand' && is_array($param_ids)){
		
		}?>
        </div>
        <?php
	}
	$html = ob_get_clean();
	$output =  array('html_content'=>$html,'html_modal'=> $html_modal);
	echo str_replace('\/', '/', json_encode($output));
	die;
}

add_action( 'wp_ajax_exfood_category', 'ajax_exfood_category' );
add_action( 'wp_ajax_nopriv_exfood_category', 'ajax_exfood_category' );
function ajax_exfood_category(){
	global $ID,$number_excerpt,$img_size;
	$atts = json_decode( stripslashes( $_POST['param_shortcode'] ), true );
	$ID = isset($atts['ID']) && $atts['ID'] !=''? $atts['ID'] : 'ex-'.rand(10,9999);
	$ids   = isset($atts['ids']) ? $atts['ids'] : '';
	$count   = isset($atts['count']) &&  $atts['count'] !=''? $atts['count'] : '9';
	$style = isset($atts['style']) && $atts['style'] !=''? $atts['style'] : '1';
	$posts_per_page   = isset($atts['posts_per_page']) && $atts['posts_per_page'] !=''? $atts['posts_per_page'] : '3';
	$number_excerpt =  isset($atts['number_excerpt'])&& $atts['number_excerpt']!='' ? $atts['number_excerpt'] : '10';
	$cat   = isset($atts['cat']) ? $atts['cat'] : '';
	$page_navi  = isset($atts['page_navi']) ? $atts['page_navi'] : '';
	$img_size =  isset($atts['img_size']) ? $atts['img_size'] :'';
	$page = $_POST['page'];
	$layout = isset($_POST['layout']) ? $_POST['layout'] : '';
	$param_query = json_decode( stripslashes( $_POST['param_query'] ), true );
	$param_ids = '';
	if(isset($_POST['param_ids']) && $_POST['param_ids']!=''){
		$param_ids =  json_decode( stripslashes( $_POST['param_ids'] ), true )!='' ? json_decode( stripslashes( $_POST['param_ids'] ), true ) : explode(",",$_POST['param_ids']);
	}
	$end_it_nb ='';
	if($page!=''){ 
		$param_query['paged'] = $page;
		$count_check = $page*$posts_per_page;
		if(($count_check > $count) && (($count_check - $count)< $posts_per_page)){$end_it_nb = $count - (($page - 1)*$posts_per_page);}
		else if(($count_check > $count)) {die;}
	}
	global $wpdb;
	$param_query['post__in'] ='';
	$loc = '';
	if ( exfood_get_option('exfood_enable_loc') =='yes' ) {
		$loc = isset($_SESSION['ex_userloc']) && $_SESSION['ex_userloc']!='' ? $_SESSION['ex_userloc'] :'';
	}
	if(isset($_POST['cat']) && $_POST['cat']!=''){
		$texo = array(
			array(
				'taxonomy' => 'exfood_cat',
				'field'    => 'slug',
				'terms'    => $_POST['cat'],
			),
		);
	}else{
		$param_query['tax_query'] ='';
		if($cat!=''){
			$taxonomy ='exfood_cat'; 
			$cats = explode(",",$cat);
			if(is_numeric($cats[0])){$field = 'term_id'; }else{ $field = 'slug'; }
			if(count($cats)>1){
				  $texo = array( 'relation' => 'OR');
				  foreach($cats as $iterm) {
					  $texo[] = array(
							  'taxonomy' => $taxonomy,
							  'field' => $field,
							  'terms' => $iterm,
						  );
				  }
				  if($loc!=''){$texo = array($texo);}
			  }else{
				  $texo = array(
					  array(
							  'taxonomy' => $taxonomy,
							  'field' => $field,
							  'terms' => $cats,
						  )
				  );
			}
			
		}
	}
	if ( exfood_get_option('exfood_enable_loc') =='yes' ) {
		if($loc!=''){
			$loc = explode(",",$loc);
			if(is_numeric($loc[0])){$field = 'term_id'; }
			else{ $field = 'slug'; }
			if(!isset($texo) || !is_array($texo)){ $texo = array();}
			$texo['relation'] = 'AND';
			if(count($loc)>1){
				  foreach($loc as $iterm) {
					  $texo[] = 
						  array(
							  'taxonomy' => 'exfood_loc',
							  'field' => $field,
							  'terms' => $iterm,
						  );
				  }
			  }else{
				  $texo[] = 
					  array(
							  'taxonomy' => 'exfood_loc',
							  'field' => $field,
							  'terms' => $loc,
				  );
			}
		}
	}
	if(isset($texo)){
		$param_query['tax_query'] = $texo;
	}
	
	$the_query = new WP_Query( $param_query );
	$it = $the_query->post_count;
	ob_start();
	if($the_query->have_posts()){
		$it = $the_query->found_posts;
		if($it < $count || $count=='-1'){ $count = $it;}
		if($count  > $posts_per_page){
			$num_pg = ceil($count/$posts_per_page);
			$it_ep  = $count%$posts_per_page;
		}else{
			$num_pg = 1;
		}
		$arr_ids = array();
		$html_modal = '';
		while($the_query->have_posts()){ $the_query->the_post();
			$i++;
			if($layout=='list'){
				echo '<div class="fditem-list item-grid" data-id="ex_id-'.esc_attr($ID).'-'.get_the_ID().'" data-id_food="'.get_the_ID().'" id="ctc-'.esc_attr($ID).'-'.get_the_ID().'"> ';
						exf_custom_color('list',$style,'ctc-'.esc_attr($ID).'-'.get_the_ID());
						?>
					<div class="exp-arrow" >
						<?php 
						exfood_template_plugin('list-'.$style,1);
						?>
					<div class="exwpfd_clearfix"></div>
					</div>
					<?php
				echo '</div>';
			}elseif($layout=='table'){
				exfood_template_plugin('table-'.$style,1);
			}else{
				echo '<div class="item-grid" data-id="ex_id-'.esc_attr($ID).'-'.get_the_ID().'" data-id_food="'.get_the_ID().'" id="ctc-'.esc_attr($ID).'-'.get_the_ID().'"> ';
					exf_custom_color('grid',$style,'ctc-'.esc_attr($ID).'-'.get_the_ID());
					?>
					<div class="exp-arrow">
						<?php 
						exfood_template_plugin('grid-'.$style,1);
						?>
					<div class="exwpfd_clearfix"></div>
					</div>
					<?php
				echo '</div>';
			}
			if($end_it_nb!='' && $end_it_nb == $i){break;}
		}
		
		wp_reset_postdata();
		
		?>
        </div>
        <?php
	}

	$html = ob_get_contents();
	ob_end_clean();
	if($html==''){
		$html = esc_html__('No matching records found','wp-food');
	}else if(isset($_POST['cat']) && $_POST['cat']!=''){
		$term = get_term_by('slug', $_POST['cat'], 'exfood_cat');
		if($term->description!=''){
			$html ='<p style="display:block;">'.$term->description.'</p>'.$html;
		}
	}
	ob_start();
	// global $modal_html;
	// 	if(!isset($modal_html) || $modal_html!='on'){
	// 		$modal_html = 'on';
	// 		echo "<div id='exwp_food_modal' class='exwp_modal'></div>";
	// 	}
	if($page_navi=='loadmore'){
		exfood_ajax_navigate_html($ID,$atts,$num_pg,$param_query,$arr_ids); 
	}else{
		exfood_page_number_html($the_query,$ID,$atts,$num_pg,$param_query,$arr_ids);
	}
	$page_navihtml = ob_get_contents();
	ob_end_clean();
	$output =  array('html_content'=>$html,'page_navi'=> $page_navihtml,'html_modal'=>$html_modal);
	echo str_replace('\/', '/', json_encode($output));
	die;
}
if(!function_exists('exfood_search_form_html')){
	function exfood_search_form_html($cats, $order_cat, $pos = false, $active_filter=false,$hide_ftall=false){
		$args = array(
			'hide_empty'        => true,
			'parent'        => '0',
		);
		if($cats !=''){
		    unset($args['parent']);
		}
		$cats = $cats!=''? explode(",",$cats) : array();
		if (!empty($cats) && !is_numeric($cats[0])) {
			$args['slug'] = $cats;
			$args['orderby'] = 'slug__in';
		}else if (!empty($cats)) {
			$args['include'] = $cats;
			$args['orderby'] = 'include';
		}
		if ($order_cat == 'yes' && empty($cats)) {
			$args['meta_key'] = 'exfood_menu_order';
			$args['orderby'] = 'meta_value_num';
		}
		$count_stop = 5;
		$terms = get_terms('exfood_cat', $args);
		$child_cat = apply_filters('exf_filter_child_cat',true);
		?>
        <div class="exwpfd-filter">
	    	<div class="exwpfd-filter-group">
	            <?php if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){ 
	            	$select_option = $list_item = '';
	            	
	            	?>
	            	<div class="ex-menu-list">
	            		<?php if (isset($pos) && $pos=='left'){
	            			$act_cls = 'ex-active-left';
	            		}else{
	            			$act_cls = 'ex-menu-item-active';
	            		}
	            		$all_atcl = $act_cls;
	            		if(isset($active_filter) && $active_filter != ''){
	            			$all_atcl = '';	
	            		}
	            		if(!isset($hide_ftall) || $hide_ftall!='yes'){?>
		            		<a class="ex-menu-item <?php esc_attr_e($all_atcl);?>" href="javascript:;"><?php echo esc_html__('All','wp-food'); ?></a><?php 
		            	}
	            			foreach ( $terms as $term ) {
	            				$all_atcl = '';
	            				if(isset($active_filter) && $active_filter == $term->slug){
	            					$all_atcl = $act_cls;
	            				}
	            				global $wp;
								$curent_url = home_url( $wp->request );
								$curent_url = apply_filters('exwpf_current_link',$curent_url);
						  		echo '<a class="ex-menu-item '.esc_attr($all_atcl).'" href="'.esc_url(add_query_arg( array('menu' => $term->slug), $curent_url )).'" data-value="'. esc_attr($term->slug) .'">'. wp_kses_post($term->name);
						  			if($child_cat!=false){
							  			exwpfd_show_child_inline($cats,$term,$count_stop,$order_cat,'inline');
							  		}
						  		echo '</a>';
						  	}
	            			?>
	            		<div class="exwpfd_clearfix"></div>
	            	</div>
	            	<div class="ex-menu-select">
		                <select name="exfood_cat">
		                	<?php
		                	if(!isset($hide_ftall) || $hide_ftall!='yes'){?> 
			                	<option value=""><?php echo esc_html__('All','wp-food'); ?></option>
			                	<?php  
			                }
	            			foreach ( $terms as $term ) {
	            				$selected  ='';
	            				if(isset($active_filter) && $active_filter == $term->slug){
	            					$selected  ='selected';
	            				}
						  		echo '<option value="'. esc_attr($term->slug) .'" '.esc_attr($selected).'>'. wp_kses_post($term->name) .'</option>';
						  		if($child_cat!=false){
							  		echo exwpfd_show_child_inline($cats,$term,$count_stop,$order_cat,'');
							  	}
						  	}
		                	?>
		                </select>
		            </div>
	            <?php } //if have terms ?>
	        </div>
        </div>
        <?php
	}
}

if(!function_exists('exwpfd_show_child_inline')){
	function exwpfd_show_child_inline($cats,$term,$count_stop,$order_cat,$inline){
		if ($count_stop < 2) {
			return;
		}
		$charactor ='';
		if ($count_stop == 5) {
			$charactor ='— ';
		}elseif ($count_stop == 4) {
			$charactor ='—— ';
		}elseif ($count_stop == 3) {
			$charactor ='——— ';
		}elseif ($count_stop == 2) {
			$charactor ='———— ';
		}
		$args_child = array(
				'child_of' => $term->term_id,
				'parent' => $term->term_id,
				'hide_empty'        => false,
		);
		if ($order_cat == 'yes') {
			$args_child['meta_key'] = 'exfood_menu_order';
			$args_child['orderby'] = 'meta_value_num';
		}
		$second_level_terms = get_terms('exfood_cat', $args_child);
		if ($second_level_terms) {
			$count_stop = $count_stop -1;
			if ($inline != 'inline') {
				foreach ($second_level_terms as $second_level_term) {
					echo '<option value="'. $second_level_term->slug .'">'.$charactor. $second_level_term->name .'</option>';
					exwpfd_show_child_inline($cats,$second_level_term,$count_stop,$order_cat,'');
				}
			}else{
				echo '<span class="exwpfd-caret"></span>';
		        echo '<ul class="exwpfd-ul-child">';
		        global $wp;
				$curent_url = home_url( $wp->request );
				$curent_url = apply_filters('exwpf_current_link',$curent_url);
		        foreach ($second_level_terms as $second_level_term) {
		            $second_term_name = $second_level_term->name;
		            echo '<li class="exwpfd-child-click ex-menu-item" data-value="'.$second_level_term->slug.'" data-url="'.esc_url(add_query_arg( array('menu' => $second_level_term->slug), $curent_url )).'">'.$second_term_name;
		            exwpfd_show_child_inline($cats,$second_level_term,$count_stop,$order_cat,'inline');
		            echo '</li>';
		        }

		        echo '</ul>';
		    }
	    }
	}
}

function exfood_convert_color($color){
	if ($color == '') {
		return;
	}
	$hex  = str_replace("#", "", $color);
	if(strlen($hex) == 3) {
	  $r = hexdec(substr($hex,0,1).substr($hex,0,1));
	  $g = hexdec(substr($hex,1,1).substr($hex,1,1));
	  $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	} else {
	  $r = hexdec(substr($hex,0,2));
	  $g = hexdec(substr($hex,2,2));
	  $b = hexdec(substr($hex,4,2));
	}
	$rgb = $r.','. $g.','.$b;
	return $rgb;
}

if(!function_exists('exfood_sale_badge')){
	function exfood_sale_badge($sale_price){
		if($sale_price !='' ){ ?>
			<div class="exwpfd-ribbon"><span>Sale</span></div>
		<?php }
	}
}
/**
* Show add to cart form
*
* @param array $atts Attributes.
* @return string
*/
function exfood_build_in_cart_form($hide_pm){
	global $attr,$id_food;
	?>
	<div class="exfood-buildin-cart">
		<form class="exform" method="post" action="<?php esc_url(home_url())?>">
			<input type="hidden" name="food_id" value="<?php echo esc_attr($id_food); ?>">
			<?php
			$options = get_post_meta( $id_food, 'exfood_addition_data', true );
			if(is_array($options) && !empty($options)){
				$i = 0;
				foreach ($options as $item) {
					$type = isset($item['_type']) && $item['_type']!='' ? $item['_type'] : 'checkbox';
					$required = isset($item['_required']) && $item['_required']!='' ? 'ex-required' : '';
					echo '<div class="exrow-group ex-'.esc_attr($type).' '.esc_attr($required).'">';
					if($item['_name']){
						if(isset($item['_type']) && isset($item['_price']) &&  $item['_price']!='' && ($item['_type'] =='text' || $item['_type'] =='textarea' )){
							echo  '<span class="exfood-label">'.$item['_name'].' + '.exfood_price_with_currency($item['_price']). '</span>' ;
						}else{
							echo  '<span class="exfood-label">'.$item['_name'].'</span>' ;
						}
					}
					if(isset($item['_type']) && $item['_type'] =='radio'){
						if(isset($item['_value'] ) && (!empty($item['_value'])) ){
							foreach ($item['_value'] as $key => $value) {
								$data_option = explode("|",$value);
								$op_name = isset($data_option[0])? $data_option[0] : '';
								$op_val = isset($data_option[1])? $data_option[1] : '';

								$op_name = $op_val !='' ? $op_name .' + '.exfood_price_with_currency($op_val) : $op_name;
								echo '<span><label><input class="ex-options" type="radio" name="ex_extrafood_'.esc_attr($i).'[]" value="'.esc_attr($key).'|'.esc_attr($value).'" data-price="'.esc_attr($op_val).'">'.wp_kses_post($op_name).'</label></span>';
							}
						}
					}else if(isset($item['_type']) && $item['_type'] =='select'){
						if(isset($item['_value'] ) && (!empty($item['_value'])) ){
							echo '<select class="ex-options" name="ex_extrafood_'.esc_attr($i).'[]">';
							echo '<option value="" data-price="">'.esc_html__( 'Select', 'wp-food' ).'</option>';
							foreach ($item['_value'] as $key => $value) {
								$data_option = explode("|",$value);
								$op_name = isset($data_option[0])? $data_option[0] : '';
								$op_val = isset($data_option[1])? $data_option[1] : '';

								$op_name = $op_val !='' ? $op_name .' + '.exfood_price_with_currency($op_val) : $op_name;
								echo '<option value="'.esc_attr($key).'|'.esc_attr($value).'" data-price="'.esc_attr($op_val).'">'.esc_attr($op_name).'</option>';
							}
							echo '<select>';
						}
					}else 
					if(isset($item['_type']) && $item['_type'] =='text'){
						echo '<input class="ex-options ex-textf" type="text" data-name="'.esc_attr($item['_name']).'" data-price="'.esc_attr($item['_price']).'" name="ex_extrafood_'.esc_attr($i).'[]"/>';
					}else if(isset($item['_type']) && $item['_type'] =='textarea'){
						echo '<textarea class="ex-options ex-textf" data-name="'.esc_attr($item['_name']).'" data-price="'.esc_attr($item['_price']).'" name="ex_extrafood_'.esc_attr($i).'[]"/></textarea>';
					}else{
						if(isset($item['_value'] ) && (!empty($item['_value'])) ){
							foreach ($item['_value'] as $key => $value) {
								$data_option = explode("|",$value);
								$op_name = isset($data_option[0])? $data_option[0] : '';
								$op_val = isset($data_option[1])? $data_option[1] : '';

								$op_name = $op_val !='' ? $op_name .' + '.exfood_price_with_currency($op_val) : $op_name;
								echo '<span><label><input class="ex-options" type="checkbox" name="ex_extrafood_'.esc_attr($i).'[]" value="'.esc_attr($key).'|'.esc_attr($value).'" data-price="'.esc_attr($op_val).'">'.esc_attr($op_name).'</label></span>';
							}
						}
					}
					if($required!=''){
						echo '<p class="ex-required-message">'.esc_html__('This option is required', 'wp-food' ).'</p>';
					}
					echo '</div>';
					$i ++;
					//print_r($item);
				}
			}
			?>
			<div class="exfood-sm">
				<div class="exfood-quantity">
					<?php if($hide_pm!='1'){?>
						<input type="button" class="minus_food" value="-">
						<input type="number" min="1" name="food_qty" class="food_qty" value="1">
						<input type="button" class="plus_food" value="+">
					<?php }else{?>
						<input type="hidden" min="1" name="food_qty" class="food_qty" value="1">
					<?php }?>
				</div>
				<button class="exstyle-button-bin ex-cart">
					<span class="ex-order"><?php esc_html_e( 'Order', 'wp-food' );?></span>
					<span class="ex-added exhidden"><?php esc_html_e( 'Added to cart', 'wp-food' );?></span>
				</button>
			</div>
		</form>
	</div>
	<?php
}
if(!function_exists('exfood_add_to_cart_form_shortcode')){
	function exfood_add_to_cart_form_shortcode( $atts ) {
		global $id_food;
		$id_food = $id_food!='' ? $id_food : get_the_ID();
		$listing_mode = get_post_meta( $id_food, 'exfood_listing', true );
		if(exfood_get_option('exfood_booking') =='disable' || $listing_mode=='yes'){ return;}
		if (!exwpfd_check_open_close_time()) {
			return exwpfd_open_closing_message();
		}
		$hide_pm = isset( $atts['hide_pm']) ? $atts['hide_pm'] : '';
		if ( exfood_get_option('exfood_booking') !='woo' ) {
			ob_start();
			exfood_build_in_cart_form($hide_pm);
			$html = ob_get_contents();
			ob_end_clean();
			return $html;
		}
		if ( empty( $atts ) || !function_exists('woocommerce_template_single_add_to_cart')) { return '';}
		if ( ! isset( $atts['id'] ) && ! isset( $atts['sku'] ) ) { return '';}
		$args = array(
			'posts_per_page'      => 1,
			'post_type'           => 'product',
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'no_found_rows'       => 1,
		);
		if ( isset( $atts['sku'] ) ) {
			$args['meta_query'][] = array(
				'key'     => '_sku',
				'value'   => sanitize_text_field( $atts['sku'] ),
				'compare' => '=',
			);
			$args['post_type'] = array( 'product', 'product_variation' );
		}
		if ( isset( $atts['id'] ) ) {
			$args['p'] = absint( $atts['id'] );
		}
		// Change form action to avoid redirect.
		add_filter( 'woocommerce_add_to_cart_form_action', '__return_empty_string' );
		$single_product = new WP_Query( $args );
		$preselected_id = '0';
		global $wp_food;
		$wp_food = 'woo';
		// Check if sku is a variation.
		if ( isset( $atts['sku'] ) && $single_product->have_posts() && 'product_variation' === $single_product->post->post_type ) {
			$variation = new WC_Product_Variation( $single_product->post->ID );
			$attributes = $variation->get_attributes();
			// Set preselected id to be used by JS to provide context.
			$preselected_id = $single_product->post->ID;
			// Get the parent product object.
			$args = array(
				'posts_per_page'      => 1,
				'post_type'           => 'product',
				'post_status'         => 'publish',
				'ignore_sticky_posts' => 1,
				'no_found_rows'       => 1,
				'p'                   => $single_product->post->post_parent,
			);
			$single_product = new WP_Query( $args );
			?>
			<script type="text/javascript">
				jQuery( document ).ready( function( $ ) {
					var $variations_form = $( '[data-product-page-preselected-id="<?php echo esc_attr( $preselected_id ); ?>"]' ).find( 'form.variations_form' );
					<?php foreach ( $attributes as $attr => $value ) { ?>
						$variations_form.find( 'select[name="<?php echo esc_attr( $attr ); ?>"]' ).val( '<?php echo esc_js( $value ); ?>' );
					<?php } ?>
				});
			</script>
		<?php
		}
		// For "is_single" to always make load comments_template() for reviews.
		$single_product->is_single = false;
		ob_start();
		global $wp_query;
		// Backup query object so following loops think this is a product page.
		$previous_wp_query = $wp_query;
		$wp_query          = $single_product;
		wp_enqueue_script( 'wc-single-product' );
		while ( $single_product->have_posts() ) {
			$single_product->the_post();?>
			<div class="single-product" data-product-page-preselected-id="<?php echo esc_attr( $preselected_id ); ?>">
				<?php woocommerce_template_single_add_to_cart(); 
				if($hide_pm!='1'){?>
					<script type="text/javascript">
						jQuery(document).ready(function() {
							jQuery( '#exwp_food_modal .exfood-woocommerce .cart div.quantity:not(.buttons_added)' ).addClass( 'buttons_added' ).append( '<input type="button" value="+" id="add_ticket" class="plus" />' ).prepend( '<input type="button" value="-" id="minus_ticket" class="minus" />' );
							jQuery('#exwp_food_modal:not(.exf-dis-bt) .exfood-woocommerce .buttons_added').on('click', '#minus_ticket',function() {
								var value = parseInt(jQuery(this).closest(".quantity").find('.qty').val()) - 1;
								if(value>0){
									jQuery(this).closest(".quantity").find('.qty').val(value);
								}
							});
							jQuery('#exwp_food_modal:not(.exf-dis-bt) .exfood-woocommerce .buttons_added').on('click', '#add_ticket',function() {
								var value = parseInt(jQuery(this).closest(".quantity").find('.qty').val()) + 1;
								jQuery(this).closest(".quantity").find('.qty').val(value);
							});
						});
					</script>
				<?php 
				}?>
			</div>
			<?php
		}
		// Restore $previous_wp_query and reset post data.
		$wp_query = $previous_wp_query;
		wp_reset_postdata();
		return '<div class="exfood-woocommerce woocommerce">' . ob_get_clean() . '</div>';
	}
}
add_shortcode( 'ex_wpfood_wooform', 'exfood_add_to_cart_form_shortcode' );

add_action( 'wp_ajax_exfood_booking_info', 'ajax_exfood_booking_info' );
add_action( 'wp_ajax_nopriv_exfood_booking_info', 'ajax_exfood_booking_info' );

function ajax_exfood_booking_info(){
	if(isset($_POST['id_food']) && $_POST['id_food']!=''){
		$product_exist = get_post_meta( $_POST['id_food'], 'exfood_product', true );
		global $atts,$id_food;
		$id_food = $_POST['id_food'];
        if($product_exist!='' && is_numeric($product_exist)){
			$atts['id'] = $product_exist;
		}
		exfood_template_plugin('modal',true);
	}else{
		echo 'error';
	}
	exit;	
}

add_action('wp_ajax_exfood_add_to_cart', 'exfood_ajax_add_to_cart');
add_action('wp_ajax_nopriv_exfood_add_to_cart', 'exfood_ajax_add_to_cart');
function exfood_ajax_add_to_cart() {
	$product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['add-to-cart']));
    $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
    $variation_id = absint($_POST['variation_id']);
    $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
    $product_status = get_post_status($product_id);
    if ($passed_validation) {

        do_action('woocommerce_ajax_added_to_cart', $product_id);

        if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
            wc_add_to_cart_message(array($product_id => $quantity), true);
        }

        WC_AJAX :: get_refreshed_fragments();
    } else {

        $data = array(
            'error' => true,
            'message' => '<p class="exwpfd-out-notice">'.esc_html__( 'Please re-check all required fields and try again', 'wp-food' ).'</p>'
        );

        echo wp_send_json($data);
    }
    //WC_AJAX::get_refreshed_fragments();
    wp_die();
}
add_action('wp_ajax_exfood_refresh_cart', 'exfood_refresh_cart');
add_action('wp_ajax_nopriv_exfood_refresh_cart', 'exfood_refresh_cart');
function exfood_refresh_cart() {
	WC_AJAX :: get_refreshed_fragments();
	wp_die();
}

/*--- Booking button ---*/
if(!function_exists('exfood_booking_button_html')){
	function exfood_booking_button_html($style) {
		$listing_mode = get_post_meta( get_the_ID(), 'exfood_listing', true );
		if (!exwpfd_check_open_close_time() || exfood_get_option('exfood_booking') =='disable' || $listing_mode=='yes') {
			return;
		}
		$html = '<a href="'.get_the_permalink(get_the_ID()).'" class="exstyle-'.esc_attr($style).'-button">'.esc_html__( 'Order', 'wp-food' ).'</a>';
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		$product_exist = get_post_meta( get_the_ID(), 'exfood_product', true );
        if(exfood_get_option('exfood_booking') =='woo' && is_plugin_active( 'woocommerce/woocommerce.php' ) &&$product_exist!='' && is_numeric($product_exist)){
        	$product = wc_get_product ($product_exist);
        	if($product!==false) {
	        	$type = $product->get_type();
				if (is_plugin_active( 'woocommerce-product-addons/woocommerce-product-addons.php' ) ) {
					if(function_exists('get_product_addons')){
						$product_addons = get_product_addons( $product_exist, false );
					}else{
						$product_addons = WC_Product_Addons_Helper::get_product_addons( $product_exist );
						wp_enqueue_script( 'jquery-tiptip', WC()->plugin_url() . '/assets/js/jquery-tiptip/jquery.tipTip.min.js', array( 'jquery' ), WC_VERSION, true );
					}
					if ( is_array( $product_addons ) && sizeof( $product_addons ) > 0 ) {
					}else if($type =='simple'){
						$html = do_shortcode( '[ex_wpfood_wooform id="'.$product_exist.'" hide_pm="1"]');
					}
				}else if (is_plugin_active( 'woocommerce-tm-extra-product-options/tm-woo-extra-product-options.php' ) ) {
					// alway open lightbox
				}else if($type =='simple'){
					$html = do_shortcode( '[ex_wpfood_wooform id="'.$product_exist.'" hide_pm="1"]');
				}
			}
		}else if(exfood_get_option('exfood_booking') !='woo'){
			$options = get_post_meta( get_the_ID(), 'exfood_addition_data', true );
			if(empty($options)){
				global $id_food;
				$id_food = get_the_ID();
				$html = do_shortcode( '[ex_wpfood_wooform id="" hide_pm="1"]');
			}
		}
		//inline button
		echo '<div class="exbt-inline">'.$html.'</div>';
		
	}
}

add_filter( 'woocommerce_add_to_cart_fragments', 'exfood_woo_cart_count_fragments', 10, 1 );
function exfood_woo_cart_count_fragments( $fragments ) {
    $fragments['span.exwpfd-cart-num'] = '<span class="exwpfd-cart-num">' . WC()->cart->get_cart_contents_count() . '</span>';
    
    return $fragments;
}

add_filter( 'woocommerce_add_to_cart_fragments', 'exfood_woo_cart_content_fragments', 10, 1 );
function exfood_woo_cart_content_fragments( $fragments ) {
    ob_start();?>
    <div class="exwpfd-cart-mini"><?php woocommerce_mini_cart(); ?></div>
    <?php
    $fragments['div.exwpfd-cart-mini'] = ob_get_contents();
    ob_get_clean();
    return $fragments;
}
function register_exfood_session(){
	if(is_admin()&& !defined( 'DOING_AJAX' )){ return;}
	if( !session_id() ){
    	session_start();
	}
	$user_ID= get_current_user_id(); 
	$_SESSION['ex_userid'] = $user_ID;
}
add_action('init', 'register_exfood_session');
// exfood price
function exfood_cv_price($price){
	$decimal_sep = exfood_get_option('exfood_decimal_sep');
	if($decimal_sep!='.'){
		$price = str_replace($decimal_sep,".",$price);
	}
	$price = apply_filters('exwf_convent_price',$price);
	return $price;
}
function exfood_price_with_currency($price,$id_food=false){
	$decimal_sep = exfood_get_option('exfood_decimal_sep');
	if($decimal_sep!='.'){
		$price = str_replace($decimal_sep,".",$price);
	}
	include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	if(isset($id_food) && is_numeric($id_food)){
		$id = $id_food;
	}else{ $id = get_the_ID();}
	$product_exist = get_post_meta( $id, 'exfood_product', true );
    if($price=='' && exfood_get_option('exfood_booking') =='woo' && is_plugin_active( 'woocommerce/woocommerce.php' ) && $product_exist!='' && is_numeric($product_exist)){
    	$product = wc_get_product ($product_exist);
    	if($product!==false) {
    		return $product->get_price_html();
    	}
    }
	if($price=='' || !is_numeric($price)){ return;}
	$num_decimal = exfood_get_option('exfood_num_decimal');
	$decimal_sep = exfood_get_option('exfood_decimal_sep');
	$thousand_sep = exfood_get_option('exfood_thousand_sep');
	if ($num_decimal > 0) {
	    $price = number_format((float)$price, $num_decimal, $decimal_sep, $thousand_sep);
	}
	$currency = exfood_get_option('exfood_currency');
	if ($currency=='') {
		$currency ='$';
	}
	$position = exfood_get_option('exfood_position');
	if($position==0){
		$price = $price.$currency;
	}else{
		$price = $currency.$price;
	}
	return $price;
}
function exfood_woo_cart_icon_html(){
	global $cart_icon;
	if(!isset($cart_icon) || $cart_icon!='on'){
		$cart_icon = 'on';
	}else if($cart_icon =='on'){
		return;
	}
	if(is_admin() || exfood_get_option('exfood_booking') =='disable' || (exfood_get_option('exfood_booking') =='woo' && !function_exists('wc_get_cart_url'))){ return;}
	?>
	<div class="exwpfd-shopping-cart">
    	<div class="exwpfd-cart-parent">
    		<a href="javascript:;">
				<img src="<?php echo EXFOOD_PATH.'css/exfdcart2.svg';?>" alt="image">
				<?php if ( exfood_get_option('exfood_booking') !='woo' ) { ?>
					<span class="exwpfd-cart-count"><?php echo !empty($_SESSION['ex_userfood']) ? wp_kses_post(count($_SESSION['ex_userfood'])) : 0; ?></span>
				<?php }else{?>
					<span class="exwpfd-cart-num"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
				<?php }?>
			</a>
		</div>
    </div>
    <div class="exwpfd-overlay"></div>
    <div class="exwpfd-cart-content">
    	<span class="exwpfd-close-cart">&times;</span>
    	<?php exfood_template_plugin('cart-mini',1);?>
	</div>
	<?php
}
function exfood_cart_shortcode(){
	$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
	$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');
	$_SESSION['exwpfd_shiping_fee'] = is_numeric($shipping_fee) && $shipping_fee > 0 ? $shipping_fee : 0;
	$_SESSION['exwpfd_shiping_free'] = is_numeric($shipping_free) && $shipping_free > 0 ? $shipping_free : '';
	ob_start();?>
	<div class="exfood-cart-shortcode exwpfd-cart-content exfood-buildin-cart">
    	<?php exfood_template_plugin('cart',1);?>
	</div>
	<?php
	$cart_content = ob_get_contents();
	ob_end_clean();
	return $cart_content;
}

add_shortcode( 'exfood_cart', 'exfood_cart_shortcode' );

add_action( 'wp_ajax_exfood_add_cart_item', 'ajax_exfood_add_cart_item' );
add_action( 'wp_ajax_nopriv_exfood_add_cart_item', 'ajax_exfood_add_cart_item' );

function ajax_exfood_add_cart_item(){
	$data_food = array();
	parse_str($_POST['data'], $data_food);
	if (!$_SESSION['ex_userfood'] || $_SESSION['ex_userfood']=='' || !is_array($_SESSION['ex_userfood'])) {
		$_SESSION['ex_userfood'] = array();
	}
	$_SESSION['ex_userfood'][] = $data_food;//print_r($data_food);exit;
	ob_start();
	exfood_template_plugin('cart-mini',1);
	$cart_update = ob_get_contents();
	ob_end_clean();
	$output =  array('status'=>1,'cart_content'=> $cart_update);
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}

add_action( 'wp_ajax_exfood_remove_cart_item', 'ajax_exfood_remove_cart_item' );
add_action( 'wp_ajax_nopriv_exfood_remove_cart_item', 'ajax_exfood_remove_cart_item' );

function ajax_exfood_remove_cart_item(){

	$key = $_POST['it_remove'];
	$tax = $shipping_fee = $final_total = 0;
	if(is_numeric($key)){
		unset($_SESSION['ex_userfood'][$key]);
		$avari = 1;
		$total_cart = exfood_update_total_price($_SESSION['ex_userfood'],1);
		$tax_rate = exfood_get_option('exfood_tax_rate','exfood_advanced_options');
		$final_total = $total_cart;
		
		if(is_numeric($tax_rate)){
			$tax_check = true;
			$tax = ($final_total * $tax_rate)/100;
			$final_total = $tax + $final_total;
		}
		$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
		$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');
		if(is_numeric($shipping_fee) && $shipping_fee > 0){
			$shipping_fee_check = true;
			if($shipping_free!='' && $final_total >= $shipping_free){
				$shipping_fee = esc_html__( 'Free', 'wp-food' );
			}else{
				$shipping_fee = exfood_price_with_currency($shipping_fee);
				$final_total = $shipping_fee + $final_total;
			}
		}
	}else{
		$avari = 0;
	}
	$total_price = exfood_update_total_price($_SESSION['ex_userfood'],1);
	$mes = '';
	if(empty($_SESSION['ex_userfood'])){
		$mes = '<div class="exfood-warning">'.esc_html__('Your cart is currently empty.','wp-food').'</div>';
	}
	$output =  array('status'=>$avari,'update_total'=> exfood_price_with_currency($total_price), 'message'=> $mes, 'total'=> $total_price, 'tax'=> exfood_price_with_currency($tax), 'shipping_fee'=> $shipping_fee, 'final_total'=> exfood_price_with_currency($final_total));
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}

function exfood_update_total_price($data,$no_cur=false){
	$total_price = 0;
 	foreach ($data as $key => $value) {
 		if (!isset($value['food_id'])) {
	  		continue;
	  	}
 		$food_id = $value['food_id'];
 		$price_food = get_post_meta( $food_id, 'exfood_price', true );
 		$saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
    	$price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
    	$price_food = is_numeric($price_food) ? $price_food : 0;
    	foreach ($value as $key_it => $item_meta) {
    		if(is_array($item_meta)){
				foreach ($item_meta as $val) {
					$val = explode("|",$val);
					$price = isset ($val[2]) ? $val[2] : 0;
					$price = exfood_cv_price($price);
					$price_food = $price_food + $price*1;
				}
			}
    	}

    	$total_price = $total_price + $price_food * $value['food_qty'];
 	}
 	if(isset($no_cur) && $no_cur==1){
 		return $total_price;
 	}else{
	 	return exfood_price_with_currency($total_price);
	 }
}

add_action( 'wp_ajax_exfood_update_cart_item', 'ajax_exfood_update_cart_item' );
add_action( 'wp_ajax_nopriv_exfood_update_cart_item', 'ajax_exfood_update_cart_item' );

function ajax_exfood_update_cart_item(){
	session_start();
	$key = $_POST['it_update'];
	$qty = $_POST['qty'];
	if(is_numeric($key) && isset($_SESSION['ex_userfood'][$key])){
		$_SESSION['ex_userfood'][$key]['food_qty'] = $qty;
		$avari = 1;
	}else{
		$avari = 0;
		$number_item = count($_SESSION['ex_userfood']);
		$output =  array('status'=>$avari,'info_text'=> esc_html__("This item does not exist in cart","wp-food"),'number_item'=>$number_item);
		echo str_replace('\/', '/', json_encode($output));
		exit;
	}
	$total_price = exfood_update_total_price($_SESSION['ex_userfood']);

	$food_id = $_SESSION['ex_userfood'][$key]['food_id'];
	$price_food = get_post_meta( $food_id, 'exfood_price', true );
	$saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
	$price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
	$price_food = is_numeric($price_food) ? $price_food : 0;
	foreach ($_SESSION['ex_userfood'][$key] as $key_it => $item_meta) {
		if(is_array($item_meta)){
			foreach ($item_meta as $val) {
				$val = explode("|",$val);
				$price = isset ($val[2]) ? $val[2] : 0;
				$price = exfood_cv_price($price);
				$price_food = $price_food + $price*1;
			}
		}
	}

	$total_price = $price_food * $_SESSION['ex_userfood'][$key]['food_qty'];
	$total_cart = exfood_update_total_price($_SESSION['ex_userfood'],1);
	$tax_rate = exfood_get_option('exfood_tax_rate','exfood_advanced_options');
	$final_total_ex = $final_total = $total_cart;
	$tax = 0;
	if(is_numeric($tax_rate)){
		$tax_check = true;
		$tax = ($final_total * $tax_rate)/100;
		$final_total = $tax + $final_total;
	}
	$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
	$shipping_free = exfood_get_option('exfood_shipping_free','exfood_advanced_options');
	if(is_numeric($shipping_fee) && $shipping_fee > 0){
		$shipping_fee_check = true;
		if($shipping_free!='' && $final_total >= $shipping_free){
			$shipping_fee = esc_html__( 'Free', 'wp-food' );
		}else{
			$shipping_fee = exfood_price_with_currency($shipping_fee);
			$final_total = $shipping_fee + $final_total;
		}
	}else{
		$shipping_fee = 0;
	}
	$output =  array('status'=>$avari,'update_price'=> exfood_price_with_currency($total_price),'update_total'=> exfood_price_with_currency($total_cart), 'total'=> $final_total_ex, 'tax'=> exfood_price_with_currency($tax), 'shipping_fee'=> $shipping_fee, 'final_total'=> exfood_price_with_currency($final_total));
	echo str_replace('\/', '/', json_encode($output));
	exit;	
}

function exfood_checkout_shortcode(){
	if (isset($_POST["txn_id"]) && isset($_POST["txn_type"]) && $_POST["txn_id"]!='' && $_POST["txn_type"] !='' && isset($_SESSION['exwpfd_id_pay']) && $_SESSION['exwpfd_id_pay'] != ''){
		echo '<div class="ex-fdck ld-screen exf-pp-loading">';
		echo '<div class="exwpfd-loadcont"><div class="exwpfd-loadicon"></div></div>';
		echo '</div>';
	}
	$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
	$_SESSION['exwpfd_shiping_fee'] = is_numeric($shipping_fee) && $shipping_fee > 0 ? $shipping_fee : 0;
	ob_start();?>
	<div class="exfood-checkout-shortcode">
    	<?php exfood_template_plugin('checkout',1);?>
	</div>
	<?php
	$cart_content = ob_get_contents();
	ob_end_clean();
	return $cart_content;
}

add_shortcode( 'exfood_checkout', 'exfood_checkout_shortcode' );

function exfood_checkemail($email) {
	if(filter_var($email, FILTER_VALIDATE_EMAIL)) {
		return true;
	}else{
		return false;
	}
}
function exfood_select_loc_html($atts){
	$locations = isset($atts['locations']) ? $atts['locations'] : '';
	$args = array(
		'hide_empty'        => true,
		'parent'        => '0',
	);
	$locations = $locations!='' ? explode(",",$locations) : array();
	if (!empty($locations) && !is_numeric($locations[0])) {
		$args['slug'] = $locations;
	}else if (!empty($locations)) {
		$args['include'] = $locations;
	}
	$terms = get_terms('exfood_loc', $args);
	ob_start();
	$loc_selected = isset($_SESSION['ex_userloc']) && $_SESSION['ex_userloc']!='' ? $_SESSION['ex_userloc'] :'';
	?>
	<div class="exfood-select-loc">
		<div>
			<select class="ex-loc-select">
				<?php if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
					global $wp;
					$cr_url =  home_url( $wp->request );
					$cr_url = apply_filters('exwpf_current_link',$cr_url);
		        	$select_option = '';
		        	echo  '<option disabled selected value>'.esc_html__( '-- Select --', 'wp-food' ) .'</option>';
		        	$count_stop = 5;
		        	foreach ( $terms as $term ) {
		        		$url = add_query_arg(array('loc' => $term->slug), $cr_url);
		        		$selected = $loc_selected == $term->slug ? 'selected' : '';
				  		echo '<option value="'. esc_url($url) .'" '.esc_attr($selected).' >'. wp_kses_post($term->name) .'</option>';
				  		exwpfd_show_child_location($locations,$term,$count_stop,$loc_selected,'');
				  	}
		        } //if have terms ?>
			</select>
		</div>
	</div>
	<?php
	$cart_content = ob_get_contents();
	ob_end_clean();
	return $cart_content;
}
add_shortcode( 'exfood_sllocation', 'exfood_select_loc_html' );
if(!function_exists('exwpfd_show_child_location')){
	function exwpfd_show_child_location($locations,$term,$count_stop,$loc_selected,$checkout){
		if ($count_stop < 2) {
			return;
		}
		$charactor ='';
		if ($count_stop == 5) {
			$charactor ='— ';
		}elseif ($count_stop == 4) {
			$charactor ='—— ';
		}elseif ($count_stop == 3) {
			$charactor ='——— ';
		}elseif ($count_stop == 2) {
			$charactor ='———— ';
		}
		$args_child = array(
				'child_of' => $term->term_id,
				'parent' => $term->term_id,
				'hide_empty'        => false,
		);
		// $locations = $locations!='' ? explode(",",$locations) : array();
		// if (!empty($locations) && !is_numeric($locations[0])) {
		// 	$args_child['slug'] = $locations;
		// }else if (!empty($locations)) {
		// 	$args_child['include'] = $locations;
		// }
		$second_level_terms = get_terms('exfood_loc', $args_child);
		$loc_current = '';
		if (isset($_SESSION['exwpfd_data_check']) && $_SESSION['exwpfd_data_check']!='') {
			$data_order = array();
			$data_order = $_SESSION['exwpfd_data_check'];
			$loc_current = isset($data_order['_location']) ? $data_order['_location'] : '';
		}
		if ($second_level_terms) {
			$count_stop = $count_stop -1;
			foreach ($second_level_terms as $second_level_term) {
				if ($checkout !='yes') {
					global $wp;
					$cr_url =  home_url( $wp->request );
					$cr_url = apply_filters('exwpf_current_link',$cr_url);
					$url = add_query_arg(array('loc' => $second_level_term->slug), $cr_url);
	        		$selected = $loc_selected == $second_level_term->slug ? 'selected' : '';
			  		echo '<option value="'. esc_url($url) .'" '.esc_attr($selected).' >'.$charactor. wp_kses_post($second_level_term->name) .'</option>';
				}else{
					$select_loc = '';
	        		if ($second_level_term->slug !='' && $second_level_term->slug == $loc_current) {
		                $select_loc = ' selected="selected"';
		              }
					echo '<option value="'. esc_attr($second_level_term->slug) .'" '.$select_loc.'>'.$charactor. wp_kses_post($second_level_term->name) .'</option>';
				}
				
				exwpfd_show_child_location($locations,$second_level_term,$count_stop,$loc_selected,$checkout);
			}
	    }
	}
}
function exfood_select_location_html($locations){
	if ( exfood_get_option('exfood_enable_loc') !='yes' ) {
		return;
	}
	global $loc_exits;
	$loc_selected = isset($_SESSION['ex_userloc']) && $_SESSION['ex_userloc']!='' ? $_SESSION['ex_userloc'] :'';
	if($loc_selected!=''){
		return;
	}
	if(!isset($loc_exits) || $loc_exits!='on'){
		$loc_exits = 'on';
	}else if($loc_exits =='on'){
		return;
	}
	$atts = array();
	$atts['locations'] = $locations;
	?>
	<div class="ex-popup-location">
		<div class="ex-popup-content">
			<?php
			$icon = exfood_get_option('exfood_loc_icon');
			if($icon!=''){ ?>
				<div class="ex-pop-icon">
					<img src="<?php echo esc_url($icon);?>" alt="image">
				</div>
			<?php } ?>
			<div class="ex-popup-info">
				<h1><?php esc_html_e('Please choose area you want to order','wp-food');?></h1>
				<?php echo exfood_select_loc_html($atts); ?>
			</div>
		</div>
	
	</div>
	<?php
}
add_action( 'init', 'exfood_user_select_location',20 );
function exfood_user_select_location(){
	if(isset($_GET["loc"]) && $_GET["loc"]!=''){
		$term = term_exists( $_GET["loc"], 'exfood_loc' );
		if ( $term !== 0 && $term !== null ) {
			$_SESSION['ex_userloc'] = $_GET["loc"];
		}
	}
}

function exfood_location_field_html($hide_et=false){

	$args = array(
		'hide_empty'        => isset($hide_et) && $hide_et=='no' ? false : true,
		'parent'        => '0',
	);
	$terms = get_terms('exfood_loc', $args);
	ob_start();
	$loc_selected = isset($_SESSION['ex_userloc']) && $_SESSION['ex_userloc']!='' ? $_SESSION['ex_userloc'] :'';
	$loc_current = '';
	if (isset($_SESSION['exwpfd_data_check']) && $_SESSION['exwpfd_data_check']!='') {
		$data_order = array();
		$data_order = $_SESSION['exwpfd_data_check'];
		$loc_current = isset($data_order['_location']) ? $data_order['_location'] : '';
	}
	?>
	<select class="ex-ck-select exwpfd-choice-locate" name="_location">
		<?php if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
			global $wp;
			if ( exfood_get_option('exfood_enable_loc') !='yes' ) {
	        	$select_option = '';
	        	$count_stop = 5;
	        	echo '<option disabled selected value>'.esc_html__( '-- Select --', 'wp-food' ) .'</option>';
	        	foreach ( $terms as $term ) {
	        		$select_loc = '';
	        		if ($term->slug !='' && $term->slug == $loc_current) {
		                $select_loc = ' selected="selected"';
		              }
			  		echo '<option value="'. esc_attr($term->slug) .'" '.$select_loc.'>'. wp_kses_post($term->name) .'</option>';
			  		exwpfd_show_child_location('',$term,$count_stop,$loc_selected,'yes');
			  	}
			}else{
				$term = get_term_by('slug', $loc_selected, 'exfood_loc');
				echo '<option selected value="'.esc_attr( $loc_selected ).'">'.wp_kses_post($term->name).'</option>';
			}
        } //if have terms ?>
	</select>
	<?php
	$loca = ob_get_contents();
	ob_end_clean();
	return $loca;
}

add_action( 'wp_ajax_exfood_loadstore', 'ajax_exfood_loadstore' );
add_action( 'wp_ajax_nopriv_exfood_loadstore', 'ajax_exfood_loadstore' );
function ajax_exfood_loadstore(){
	
	$param_query = json_decode( stripslashes( $_POST['param_query'] ), true );
	$locate_param = '';
	$locate_param = sanitize_text_field($_POST['locate_param']);
	if ($locate_param == '') {
		return;
	}
	ob_start();
	$posts_array = get_posts(
        array(
            'post_status' => array( 'publish'),
            'post_type' => 'exfood_store',
            'tax_query' => array(
                array(
                    'taxonomy' => 'exfood_loc',
                    'field' => 'slug',
                    'terms' => $locate_param,
                )
            )
        )
    );
    
    $count =sizeof($posts_array);
    if ($count == 0) {
    	echo "0";
    	// return;
    }else{
	    echo '<label class="exwpfd-label">'.esc_html__("Select store","wp-food").'</label>';
	    $number = 1;
	    $check='';
		foreach ( $posts_array as $it ) {
			if ($number == 1) {
				$check ='checked="checked"';
			}else{$check ='';}
			$number = $number + 1;
			echo '<label class="exwpfd-container"><p>'.$it->post_title.'</p>
				<span>'.wpautop($it->post_content).'</span>
				<input class="exwpfd-choice-order" type="radio" name="_store" '.$check.' value="'.$it->ID.'">
				<span class="exwpfd-checkmark"></span>
	        </label>';
		}
	}
	// echo "</ul>";
	$html = ob_get_clean();
	$output =  array('html_content'=>$html);
	echo str_replace('\/', '/', json_encode($output));
	die;
}


if(!function_exists('exfood_pagenavi_no_ajax')){
	function exfood_pagenavi_no_ajax($the_query){
		if(function_exists('paginate_links')) {
			echo '<div class="exfood-no-ajax-pagination">';
			echo paginate_links( array(
				'base'         => esc_url_raw( str_replace( 999999999, '%#%', get_pagenum_link( 999999999, false ) ) ),
				'format'       => '',
				'add_args'     => false,
				'current' => max( 1, get_query_var('paged') ),
				'total' => $the_query->max_num_pages,
				'prev_text'    => '&larr;',
				'next_text'    => '&rarr;',
				'type'         => 'list',
				'end_size'     => 3,
				'mid_size'     => 3
			) );
			echo '</div>
			<style type="text/css">
				.exfood-no-ajax-pagination{ margin-top:60px;}
				.exfood-no-ajax-pagination ul{text-align: center;}
				.exfood-no-ajax-pagination ul li{ list-style:none; width:auto; display: inline-block;}
				.exfood-no-ajax-pagination ul li a,
				.exfood-no-ajax-pagination ul li span{
					display: inline-block;
					background: none;
					background-color: #FFFFFF;
					padding: 5px 15px 0 15px;
					color: rgba(153,153,153,1.0);
					margin: 0px 10px 10px 0;
					min-width: 40px;
					min-height: 40px;
					text-align: center;
					text-decoration: none;
					vertical-align: top;
					font-size: 16px;
					border-radius: 0px;
					box-shadow: 0 0 1px rgba(0, 0, 0, 0.15);
					transition: all .2s;
					border: 1px solid rgba(0, 0, 0, 0.15);
					line-height: 1.7;
				}
				.exfood-no-ajax-pagination ul li a:hover,
				.exfood-no-ajax-pagination ul li span.current{ color: rgba(119,119,119,1.0); background-color: rgba(238,238,238,1.0);}
			}
			</style>';
		}
	}
}

if(!function_exists('exwpfd_get_current_time')){
	function exwpfd_get_current_time(){
		$cure_time =  strtotime("now");
		$gmt_offset = get_option('gmt_offset');
		if($gmt_offset!=''){
			$cure_time = $cure_time + ($gmt_offset*3600);
		}
		return $cure_time;
	}
}

if(!function_exists('exwpfd_check_open_close_time')){
	function exwpfd_check_open_close_time(){
		$enable_time = exfood_get_option('exfood_open_close','exfood_advanced_options');
		if ($enable_time == '') {
			return true;
		}
		$cure_time =  exwpfd_get_current_time();
		$hours_current= intval(date('H', $cure_time));
		$minutes_current = intval(date('i', $cure_time));
		// $times is time stamp start 00:00:00
		$times = $cure_time - $hours_current*3600 - $minutes_current*60;
		// New advanced open closing time
		$opcl_time = exfood_get_option('exfood_'.date('D',$cure_time).'_opcl_time','exfood_advanced_options');
		if(is_array($opcl_time) && !empty($opcl_time)){
			$check= true;
			foreach ($opcl_time as $it_time) {
				$open_hours = $it_time['open-time'];
				$close_hours = $it_time['close-time'];
				$open_hours_unix = $times + intval(date('H', strtotime($open_hours)))*3600 + intval(date('i', strtotime($open_hours)))*60;
				$close_hours_unix = $times + intval(date('H', strtotime($close_hours)))*3600 + intval(date('i', strtotime($close_hours)))*60;
				if ($open_hours_unix > $close_hours_unix || $cure_time < $open_hours_unix || $cure_time > $close_hours_unix) {
					$check= false;
				}else{
					$check= true;
					break;
				}
			}
			return $check;
		}else{	
			$open_hours = exfood_get_option('exfood_ck_open_hour','exfood_advanced_options');
			$close_hours = exfood_get_option('exfood_ck_close_hour','exfood_advanced_options');
			if ($open_hours == '' || $close_hours == '') {
				return false;
			}
			$open_hours_unix = $times + intval(date('H', strtotime($open_hours)))*3600 + intval(date('i', strtotime($open_hours)))*60;
			$close_hours_unix = $times + intval(date('H', strtotime($close_hours)))*3600 + intval(date('i', strtotime($close_hours)))*60;
			// echo date_i18n(get_option('time_format'), $times).' '.date_i18n(get_option('time_format'), $open_hours_unix).' '.date_i18n(get_option('time_format'), $close_hours_unix);exit();
			if ($open_hours_unix > $close_hours_unix || $cure_time < $open_hours_unix || $cure_time > $close_hours_unix) {
				return false;
			}
			return true;
		}
		return false;
	}
}
/*-- Get next open hour--*/
if(!function_exists('exwpfd_get_next_open_close_time')){
	function exwpfd_get_next_open_close_time(){
		$cure_time =  exwpfd_get_current_time();
		$hours_current= intval(date('H', $cure_time));
		$minutes_current = intval(date('i', $cure_time));
		// $times is time stamp start 00:00:00
		$times = $cure_time - $hours_current*3600 - $minutes_current*60;
		$open_hours = $close_hours = '';
		for ($i=0; $i < 7; $i++) {
			$check= false;
			$timck = $cure_time + ($i * 86400);
			$opcl_time = exfood_get_option('exfood_'.date('D',$timck).'_opcl_time','exfood_advanced_options');
			if(is_array($opcl_time) && !empty($opcl_time)){
				
				foreach ($opcl_time as $it_time) {
					$open_hours = $it_time['open-time'];
					$close_hours = $it_time['close-time'];
					if($i == 0){
						$open_hours_unix = $times + intval(date('H', strtotime($open_hours)))*3600 + intval(date('i', strtotime($open_hours)))*60;
						$close_hours_unix = $times + intval(date('H', strtotime($close_hours)))*3600 + intval(date('i', strtotime($close_hours)))*60;
						if ($open_hours_unix >  $cure_time ) {
							$check= true;
							break;
						}
					}else if($open_hours!=$close_hours){

						$check= true;
						break;
					}
				}
			}
			if($check==true){
				break;
			}	
		}
		if($check==true){
			if($i ==0){ $timck = '';}
			return array($open_hours,$close_hours,$timck);
		}
	}
}
/*---- Open closing time message----*/
if(!function_exists('exwpfd_open_closing_message')){
	function exwpfd_open_closing_message(){
		ob_start();
		$next_op = exwpfd_get_next_open_close_time();
		if(array($next_op) && !empty($next_op)){
			$fp = date_i18n(get_option('time_format'),strtotime($next_op[0]));
			$to = date_i18n(get_option('time_format'),strtotime($next_op[1]));
			$nday = isset($next_op[2]) && is_numeric($next_op[2]) ? date_i18n('l',$next_op[2]) : esc_html__( 'Today', 'wp-food' );
			$text = sprintf( esc_html__( 'Ordering food is now closed, please come back from %1$s to %2$s %3$s', 'wp-food' ), $fp, $to, $nday);
		}else{
			$text = esc_html__( 'Ordering food is now closed','wp-food');
		}

		$text = apply_filters( 'exfood_opcl_text', $text, $next_op );

		echo '<p class="exwpfd-out-notice">' .$text.'</p>';
		$html = ob_get_contents();
		ob_end_clean();
		return $html;
	}
}

if(!function_exists('exwpfd_total_price')){
	function exwpfd_total_price($userfood){
		$total_price = 0;
		foreach ($userfood as $key => $value) {
			if (!isset($value['food_id'])) {
              continue;
            }
			$food_id = $value['food_id'];
	        $price_food = get_post_meta( $food_id, 'exfood_price', true );
	        $saleprice = get_post_meta( $food_id, 'exfood_sale_price', true );
	        $price_food = $saleprice!='' && is_numeric($saleprice) ? $saleprice : $price_food;
	        $price_food = is_numeric($price_food) ? $price_food : 0;
	        foreach ($value as $key_it => $item_meta) {
	        	if(is_array($item_meta)){
					foreach ($item_meta as $val) {
						$val = explode("|",$val);
						$price = isset ($val[2]) ? $val[2] : '';
						$price = exfood_cv_price($price);
						$price_food = $price!='' && is_numeric($price) ? $price_food + $price*1 : $price_food;
					}
                }
	        }
	        $price_food = $price_food * $value['food_qty'];
			$total_price = $total_price + $price_food;
		}
		return $total_price;
	}
}
if(!function_exists('exwpfd_show_reviews')){
	function exwpfd_show_reviews($id_food){
    	$score = get_post_meta( $id_food, 'exfood_score', true );
    	if(is_numeric($score) && $score!=''){
    		$html_star ='';
	    	for( $x = 0; $x < 5; $x++ ){
		        if( floor($score)-$x >= 1 )
		        { $html_star .= '<i class="icon ion-md-star"></i>'; }
		        elseif( $score-$x > 0 )
		        { $html_star .= '<i class="icon ion-md-star-half"></i>'; }
		        else
		        { $html_star .=  '<i class="icon ion-md-star-outline"></i>'; }
		    }
		    echo '<div class="exwpfd-admin-review"><span> '.$html_star.'</span></div>
				<style type="text/css">.we-admin-review i{ color:#FF9800}</style>
		    ';
		}
    }
}

if(!function_exists('exwpfd_payment_method_html')){
	function exwpfd_payment_method_html(){
		$paypal_check = exfood_get_option('exfood_paypal_check','exfood_payment_options');
		$paypal_email = exfood_get_option('exfood_paypal_email','exfood_payment_options');
		$paypal_enable_cash = exfood_get_option('exfood_cash_check','exfood_payment_options');
	    if($paypal_check !='yes' || $paypal_email =='' || !filter_var($paypal_email, FILTER_VALIDATE_EMAIL)) { 
	    	return;
	    }
	    $order_cash = 'checked="checked"';
		$order_pay = $order_pay_pull ='';
		if (isset($_SESSION['exwpfd_data_check']) && $_SESSION['exwpfd_data_check']!='') {
			$data_order = array();
			$data_order = $_SESSION['exwpfd_data_check'];
			$order_pay_pull = isset($data_order['payment_method']) ? $data_order['payment_method'] : '';
		}
		if (($order_pay_pull !='' && $order_pay_pull == 'paypal') ||  $paypal_enable_cash !='yes') {
			$order_pay = 'checked="checked"';
			$order_cash = '';
		}
	    ?>
	    <div class="exwpfd-payment exfood-cart-shortcode exwpfd-cart-content">
	    	<?php if($paypal_enable_cash == 'yes') { 	?>
		        <label class="exwpfd-container exwpfd-inline"><span class="exwpfd-pay-label"><?php esc_html_e('Cash on delivery','wp-food');?></span>
		          <input class="exwpfd-choice-order" type="radio" <?php echo $order_cash;?> name="payment_method" value="cash">
		          <span class="exwpfd-checkmark"></span>
		        </label>
		    <?php } ?>
	        <label class="exwpfd-container exwpfd-inline"><span class="exwpfd-pay-label"><?php esc_html_e('Paypal','wp-food');?></span>
	          <input class="exwpfd-choice-order" type="radio" <?php echo $order_pay;?> name="payment_method" value="paypal">
	          <span class="exwpfd-checkmark"></span>
	        </label>
	    </div>
    <?php }
}

function exfood_loadstore_payment($locate_param,$store_select){
	if ($locate_param == '' || $store_select == '') {
		return;
	}
	$posts_array = get_posts(
        array(
            'post_status' => array( 'publish'),
            'post_type' => 'exfood_store',
            'tax_query' => array(
                array(
                    'taxonomy' => 'exfood_loc',
                    'field' => 'slug',
                    'terms' => $locate_param,
                )
            )
        )
    );
    
    $count =sizeof($posts_array);
    if ($count == 0) {
    	return;
    }else{
	    echo '<label class="exwpfd-label">'.esc_html__("Select store","wp-food").'</label>';
	    $check='';
		foreach ( $posts_array as $it ) {
			if ($store_select == $it->ID) {
				$check ='checked="checked"';
			}else{$check ='';}
			$it_content = $it->post_content;
			echo '<label class="exwpfd-container"><p>'.$it->post_title.'</p>
				<span>'.wpautop($it->post_content).'</span>
				<input class="exwpfd-choice-order" type="radio" name="_store" '.$check.' value="'.$it->ID.'">
				<span class="exwpfd-checkmark"></span>
	        </label>';
		}
	}
}

// shipping fee
add_action( 'wp_ajax_exfood_add_remove_shipping_fee', 'ajax_exfood_add_remove_shipping_fee' );
add_action( 'wp_ajax_nopriv_exfood_add_remove_shipping_fee', 'ajax_exfood_add_remove_shipping_fee' );
function ajax_exfood_add_remove_shipping_fee(){
	
	$order_type = sanitize_text_field($_POST['type']);
	$shipping_fee = exfood_get_option('exfood_shipping_fee','exfood_advanced_options');
	ob_start();
	if($order_type=='order-delivery' && is_numeric($shipping_fee) && $shipping_fee > 0){
		$_SESSION['exwpfd_shiping_fee'] = $shipping_fee;
	}else{
		$_SESSION['exwpfd_shiping_fee'] = 0;
	}
	global $checkout;
    $checkout = 1;
    exfood_template_plugin('cart',1);
	// echo "</ul>";
	$html = ob_get_clean();
	$output =  array('html_content'=>$html);
	echo str_replace('\/', '/', json_encode($output));
	die;
}
function exf_custom_color($sc,$style,$id){
	$color = get_post_meta( get_the_ID(), 'exfood_custom_color',true );
	if($color==''){ return;}
	?>
	<style type="text/css">
		<?php if($sc=='grid'){
			if($style=='1' || $style=='2'){
				?>
				.ex-wfdlist #<?php echo esc_attr($id);?> figcaption .exbt-inline > a,
				#<?php echo esc_attr($id);?> .exfood-woocommerce.woocommerce form.cart button[type="submit"]{background:<?php echo esc_attr($color);?>;}
				#<?php echo esc_attr($id);?> figcaption h5{color:<?php echo esc_attr($color);?>;}
				<?php
			}else if( $style=='3'){?>
				#<?php echo esc_attr($id);?> figcaption h5{color:<?php echo esc_attr($color);?>;}
				<?php
			}else if($style=='4'){?>
				.ex-wfdlist #<?php echo esc_attr($id);?> .exwpfd-icon-plus:before,
				.ex-wfdlist #<?php echo esc_attr($id);?> .exwpfd-icon-plus:after,
				#<?php echo esc_attr($id);?> figcaption h5{background:<?php echo esc_attr($color);?>;}
				.ex-wfdlist #<?php echo esc_attr($id);?> .exstyle-4 figcaption,
				.ex-wfdlist.style-4 #<?php echo esc_attr($id);?>.item-grid,
				.ex-wfdlist #<?php echo esc_attr($id);?> .exstyle-4-button.exwpfd-choice{border-color:<?php echo esc_attr($color);?>;}
				<?php
			}
		}else if($sc=='list' || $sc=='table'){ ?>
			.ex-wfdlist #<?php echo esc_attr($id);?> .exwpfd-icon-plus:before,
			.ex-wfdlist #<?php echo esc_attr($id);?> .exwpfd-icon-plus:after,
			#<?php echo esc_attr($id);?> figcaption h5{background:<?php echo esc_attr($color);?>;}
			.ex-wfdlist #<?php echo esc_attr($id);?> .exwpfd-choice{border-color:<?php echo esc_attr($color);?>;}
			<?php
		}?>
	</style>
	<?php
}
// ajax check time delivery available or not
add_action( 'wp_ajax_exf_time_delivery_status', 'ajax_exf_time_delivery_status' );
add_action( 'wp_ajax_nopriv_exf_time_delivery_status', 'ajax_exf_time_delivery_status' );
function ajax_exf_time_delivery_status(){
	$data =array();
	$data['_date'] = isset($_POST['date']) && $_POST['date']!='' && is_numeric($_POST['date']) ? $_POST['date'] : strtotime(date("Y-m-d"));
	$data['_time'] = isset($_POST['time']) ? $_POST['time'] : '';
	$html = exf_check_time_delivery_status($data);
	if($html!=''){
		$html = '<p class="exf-time-stt">'.$html.'</p>';
	}
	$output =  array('html_content'=>$html);
	echo str_replace('\/', '/', json_encode($output));
	die;
}
function exf_check_time_delivery_status($data){
	$date_deli = isset($data['_date']) ? $data['_date'] : '';
	// advanced slots
	$adv_timesl = exfood_get_option('exfood_adv_timedeli','exfood_adv_timesl_options');
	$_ftimesl = '';
	if( $date_deli !='' && is_array($adv_timesl) && !empty($adv_timesl)){
		$day_ofd = date('D',$date_deli);
		foreach ($adv_timesl as $it_timesl) {
			if(isset ($it_timesl['repeat_'.$day_ofd]) && $it_timesl['repeat_'.$day_ofd] =='on'){
				$_ftimesl = isset($it_timesl['exfood_deli_time']) && is_array($it_timesl['exfood_deli_time']) ? $it_timesl['exfood_deli_time'] : '';
				break;
			}
		}
	}

	$_time = isset($_ftimesl) && is_array($_ftimesl) ? $_ftimesl : exfood_get_option('exfood_deli_time','exfood_advanced_options');
    if(!empty($_time) && $date_deli!=''){
    	foreach ($_time as $key => $value) {
    		$name = isset($value['name-ts']) && $value['name-ts']!=''? $value['name-ts'] : ($value['start-time'].' - '.$value['end-time']);
    		if( isset($value['max-odts']) && is_numeric($value['max-odts']) && $value['max-odts']> 0 && $name == $data['_time'] ){
    			$args = array(
					'posts_per_page' => 1,
					'post_type'   => 'exfood_order',
					'post_status' =>  '',
					'meta_query' => array(
				        array(
				            'key'   => 'exorder_time',
				            'value' => $data['_time'],
				            'compare' => '=',
				        ),
				        array(
				            'key' => 'exorder_date',
				            'value'   => $date_deli,
				            'type'    => 'numeric',
				            'compare' => '=',
				        ),
				    )
				);
				$args = apply_filters( 'exf_arr_query_max_order', $args );
				$my_query = new WP_Query($args);
				$total_rs = $my_query->found_posts;
				if ( $total_rs >= $value['max-odts']){
					$msg = esc_html__( 'Sorry, the time delivery you have selected has full order, please try again with different delivery date or time','wp-food' );
					return $msg; 
			    }
    		}
    	}
    }
}



add_action( 'wp_ajax_exf_time_delivery_slots', 'ajax_exf_time_delivery_slots' );
add_action( 'wp_ajax_nopriv_exf_time_delivery_slots', 'ajax_exf_time_delivery_slots' );
function ajax_exf_time_delivery_slots(){
	$data =array();
	$data['exfood_date_deli'] = isset($_POST['date']) && $_POST['date']!='' && is_numeric($_POST['date']) ? $_POST['date'] : strtotime(date("Y-m-d"));
	$adv_timesl = exfood_get_option('exfood_adv_timedeli','exfood_adv_timesl_options');
	$html_timesl ='';
	$def_timesl = exfood_get_option('exfood_deli_time','exfood_advanced_options');

	$cure_time = 0;
	$date_before = exfood_get_option('exfood_ck_beforedate','exfood_advanced_options');
	if(is_numeric($date_before)){
		$cure_time =  apply_filters( 'exf_disable_book_day', strtotime("+$date_before day") );

	}else if(is_numeric(str_replace("m","",$date_before))){
		$cure_time =  strtotime("now");
		$cure_time = $cure_time + str_replace("m","",$date_before)*60;
	}
	$gmt_offset = get_option('gmt_offset');
	if($gmt_offset!=''){
		$cure_time = $cure_time + ($gmt_offset*3600);
	}

	if(is_array($def_timesl) && !empty($def_timesl)){
		$html_timesl .= '<select name="_time" class="ex-ck-select" data-time="'.json_encode($def_timesl).'" data-crtime="'.esc_attr($cure_time).'" data-date="'.strtotime(date('Y-m-d', $cure_time)).'" data-placeholder="">';
		foreach ($def_timesl as $time_option) {
			$r_time ='';
			if(isset($time_option['start-time']) && $time_option['start-time']!='' && $time_option['end-time']!=''){
				$r_time = $time_option['start-time'].' - '.$time_option['end-time'];
			}elseif(isset($time_option['start-time']) && $time_option['start-time']!=''){
				$r_time = $time_option['start-time'];
			}
			$name = isset($time_option['name-ts']) && $time_option['name-ts']!=''? $time_option['name-ts'] : $r_time;
			$disable ='';
			$_time_base = apply_filters('exf_timebase_to_check_delivery',$time_option['start-time'],$time_option);
			if($_time_base!=''){
				$_timeck = $_time_base;
				$_timeck = explode(':', $_timeck);
		    	$_timeck = $_timeck[1] * 60 + $_timeck[0] * 3600;
				if(($data['exfood_date_deli'] + $_timeck) < $cure_time){
					$disable ='disabled="disabled"';
				}
			}
			$html_timesl .='<option value="'.esc_attr($name).'" '.$disable.'>'.$name.'</option>';
		}
		$html_timesl .= '</select>';
	}else{
		$html_timesl ='<input type="text" name="_time" id="" placeholder="" value="">';
	}
	if(is_array($adv_timesl) && !empty($adv_timesl)){
		$day_ofd = date('D',$data['exfood_date_deli']);
		foreach ($adv_timesl as $it_timesl) {
			if(isset ($it_timesl['repeat_'.$day_ofd]) && $it_timesl['repeat_'.$day_ofd] =='on'){
				//print_r( $it_timesl);
				$html_timesl ='';
				$html_timesl .= '<select name="_time" class="ex-ck-select" data-time="'.json_encode($def_timesl).'" data-crtime="'.esc_attr($cure_time).'" data-date="'.strtotime(date('Y-m-d', $cure_time)).'" data-placeholder="">';
				if(isset($it_timesl['exfood_deli_time']) && is_array($it_timesl['exfood_deli_time'])){
					$def_timesl = $it_timesl['exfood_deli_time'];
					//$html_timesl .='<option value="">'.esc_html__('Please choose a time slot','wp-food').'</option>';
					foreach ($it_timesl['exfood_deli_time'] as $time_option) {
						$r_time ='';
						if(isset($time_option['start-time']) && $time_option['start-time']!='' && $time_option['end-time']!=''){
							$r_time = $time_option['start-time'].' - '.$time_option['end-time'];
						}elseif(isset($time_option['start-time']) && $time_option['start-time']!=''){
							$r_time = $time_option['start-time'];
						}
						$name = isset($time_option['name-ts']) && $time_option['name-ts']!=''? $time_option['name-ts'] : $r_time;
						$_time_base = apply_filters('exwpf_timebase_to_check_delivery',$time_option['start-time'],$time_option);
						if($_time_base!=''){
							$_timeck = $_time_base;
							$_timeck = explode(':', $_timeck);
		    				$_timeck = $_timeck[1] * 60 + $_timeck[0] * 3600;
		    				$disable ='';
		    				if($time_option['start-time']!='' && ($data['exfood_date_deli'] + $_timeck) < $cure_time){
		    					$disable ='disabled="disabled"';
		    				}
		    			}
						$html_timesl .='<option value="'.esc_attr($name).'" '.$disable.'>'.$name.'</option>';
					}
				}else{
					$html_timesl .='<option value="">'.esc_html__('No time slot available for selection','wp-food').'</option>';
				}
				$html_timesl .= '</select>';
				break;
			}
		}
	}
	$output =  array('html_timesl' => $html_timesl,'data_time' => json_encode($def_timesl));
	echo str_replace('\/', '/', json_encode($output));
	die;
}