<?php
  $customlink = EX_WPFood_customlink(get_the_ID());
  global $number_excerpt,$img_size;
  if($img_size==''){$img_size = 'exfood_400x400';}
  $price = get_post_meta( get_the_ID(), 'exfood_price', true );
  $saleprice = get_post_meta( get_the_ID(), 'exfood_sale_price', true );
  $custom_price = get_post_meta( get_the_ID(), 'exfood_custom_price', true );
  if ($custom_price != '') {
    $price = $custom_price;
  }else{
    $price = exfood_price_with_currency($price);
    if ($saleprice > 0 && is_numeric($saleprice)){
      $saleprice = exfood_price_with_currency($saleprice);
    }
  }
  $excerpt = '';
  if(has_excerpt(get_the_ID())){
    if($number_excerpt=='full'){
      $excerpt = get_the_excerpt();
    }else{
      $excerpt = wp_trim_words(get_the_excerpt(),$number_excerpt,'...');
    }
    $excerpt = '<p>'.$excerpt.'</p>';
  }
?>
<figure class="exstyle-3 tppost-<?php the_ID();?> <?php if($number_excerpt !='0'){ echo "exstyle-3-center"; }?>">
  <div class="exstyle-3-image ex-fly-cart" style="background-image: url(<?php echo get_the_post_thumbnail_url(get_the_ID(),$img_size); ?>)">
    <a class="exwpfd_modal_click" href="<?php echo esc_url($customlink); ?>"></a>
    <?php exfood_sale_badge($saleprice); 
    if(exfood_get_option('exfood_booking') !='woo'){
      exfood_booking_button_html(3);
    }else{?>
      <div class="exbt-inline">
        <a href="<?php echo esc_url($customlink); ?>" class="exstyle-3-button"><?php esc_html_e( 'Order', 'wp-food' ) ?></a>
      </div>
    <?php }?>
  </div><figcaption>
    <h3><a class="exwpfd_modal_click" href="<?php echo esc_url($customlink); ?>"><?php the_title(); ?></a></h3>
    <h5>
      <?php if ($saleprice !='' && $custom_price == '') {?>
        <del><?php echo wp_kses_post($price); ?></del> <ins><?php echo wp_kses_post($saleprice); ?></ins>
      <?php }else{
        echo wp_kses_post($price);
      } ?>
    </h5>
    <?php 
    echo ($excerpt);
    ?>
  </figcaption>
</figure>