<?php
  $customlink = EX_WPFood_customlink(get_the_ID());
  global $number_excerpt,$img_size;
  if($img_size==''){$img_size = 'exfood_400x400';}
  $price = get_post_meta( get_the_ID(), 'exfood_price', true );
  $saleprice = get_post_meta( get_the_ID(), 'exfood_sale_price', true );
  $custom_price = get_post_meta( get_the_ID(), 'exfood_custom_price', true );
  if ($custom_price != '') {
    $price = $custom_price;
  }else{
    $price = exfood_price_with_currency($price);
    if ($saleprice > 0 && is_numeric($saleprice)){
      $saleprice = exfood_price_with_currency($saleprice);
    }
  }
?>
<figure class="exstyle-4 tppost-<?php the_ID();?>">
  
  <div class="exstyle-4-image">
    <a class="exwpfd_modal_click" href="<?php echo esc_url($customlink); ?>">
      <?php the_post_thumbnail($img_size); ?>
    </a>
    <?php exfood_sale_badge($saleprice); ?>
  </div><figcaption>
    <h3><a class="exwpfd_modal_click" href="<?php echo esc_url($customlink); ?>"><?php the_title(); ?></a></h3>
    <?php 
    $id = get_the_ID();
    if(has_excerpt($id)){
      if($number_excerpt=='full'){
        $excerpt = get_the_excerpt();
      }else{
        $excerpt = wp_trim_words(get_the_excerpt(),$number_excerpt,'...');
      }?>
      <p><?php echo ($excerpt); ?></p>
    <?php }
    ?>
    <h5>
      <?php if ($saleprice !='' && $custom_price == '') {?>
        <del><?php echo wp_kses_post($price); ?></del> <ins><?php echo wp_kses_post($saleprice); ?></ins>
      <?php }else{
        echo wp_kses_post($price);
      } ?>
    </h5>
    <?php echo '<div class="ex-hidden">'; exfood_booking_button_html(1); echo '</div>';?>
    <?php if (exwpfd_check_open_close_time() && exfood_get_option('exfood_booking') !='disable') { ?>
      <button class="exstyle-4-button exwpfd-choice"><div class="exwpfd-icon-plus"></div></button>
    <?php }?>
    
    <!-- <button class="exstyle-4-button">
      <div class="exwpfd-icon-plus"></div>
    </button> -->
  </figcaption>
</figure>