<?php
  $customlink = EX_WPFood_customlink(get_the_ID());
  global $number_excerpt,$img_size;
  if($img_size==''){$img_size = 'exfood_80x80';}
  $price = get_post_meta( get_the_ID(), 'exfood_price', true );
  $saleprice = get_post_meta( get_the_ID(), 'exfood_sale_price', true );
  $custom_price = get_post_meta( get_the_ID(), 'exfood_custom_price', true );
  if ($custom_price != '') {
    $price = $custom_price;
  }else{
    $price = exfood_price_with_currency($price);
    if ($saleprice > 0 && is_numeric($saleprice)){
      $saleprice = exfood_price_with_currency($saleprice);
    }
  }
  $excerpt = '';
  if(has_excerpt(get_the_ID())){
    if($number_excerpt=='full'){
      $excerpt = get_the_excerpt();
    }else{
      $excerpt = wp_trim_words(get_the_excerpt(),$number_excerpt,'...');
    }
    $excerpt = '<p>'.$excerpt.'</p>';
  }
?>
<figure class="fdstyle-list-2">
  <a class="exwpfd_modal_click" href="<?php echo esc_url($customlink); ?>"></a>
  <?php if(has_post_thumbnail(get_the_ID())){ ?>
    <div class="exf-img"><?php the_post_thumbnail($img_size); ?></div>
  <?php }?>
  <div class="fdlist_2_detail">
    <div class="fdlist_2_title">
      <div class="fdlist_2_name exwpfd-list-name"><?php the_title(); ?></div>
      <div class="fdlist_2_price">
        <span>
          <?php if ($saleprice !='' && $custom_price == '') {?>
            <del><?php echo wp_kses_post($price); ?></del> <ins><?php echo wp_kses_post($saleprice); ?></ins>
          <?php }else{
            echo wp_kses_post($price);
          } ?>
        </span>
        <?php if (exwpfd_check_open_close_time() && exfood_get_option('exfood_booking') !='disable') { ?>
          <span class="exfood-addicon">
            <?php echo '<div class="ex-hidden">'; exfood_booking_button_html(1); echo '</div>';?>
            <button class="exwpfd_modal_click exwpfd-choice" data="food_id=<?php echo get_the_ID(); ?>&food_qty=1"><div class="exwpfd-icon-plus"></div></button>
          </span>
        <?php }?>
      </div>
    </div>
  </div>
  <?php
    echo $excerpt;
  ?>
</figure>