<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit( );
}
/**
 * @Packge    : adina
 * @version   : 1.0
 * @Author    : Themedox
 * @Author URI: https://www.themedox.com/
 */
 
// demo import file
function adina_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__('Adina Demo','adina'),
            'local_import_file'            =>  trailingslashit(get_template_directory()) . 'inc/demo-data/demo-data.xml',
            'local_import_widget_file'     =>  trailingslashit(get_template_directory()) . 'inc/demo-data/widgets.wie',
            'local_import_customizer_file'     =>  trailingslashit(get_template_directory()) . 'inc/demo-data/customizer.dat',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit(get_template_directory()) . 'inc/demo-data/theme-options.json',
                    'option_name' => 'adina_opt',
                ),
            ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'adina_import_files' );

// demo import setup
function adina_after_import_setup() {
	// Assign menus to their locations.
	$main_menu   = get_term_by( 'name', 'Main Menu', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', array(
			'primary-menu'    => $main_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$front_page_id 	= get_page_by_title( 'Main Demo' );
	$blog_page_id  	= get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );


    
}
add_action( 'pt-ocdi/after_import', 'adina_after_import_setup' );


//disable the branding notice after successful demo import
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

//change the location, title and other parameters of the plugin page
function adina_import_plugin_page_setup( $default_settings ) {
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title']  = esc_html__( 'Adina Demo Import' , 'adina' );
	$default_settings['menu_title']  = esc_html__( 'Import Demo Data' , 'adina' );
	$default_settings['capability']  = 'import';
	$default_settings['menu_slug']   = 'adina-demo-import';

	return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'adina_import_plugin_page_setup' );
 
// Enqueue scripts
function adina_demo_import_custom_scripts(){
	if( isset( $_GET['page'] ) && $_GET['page'] == 'adina-demo-import' ){
		// style
		wp_enqueue_style( 'adina-demo-import', ADINA_DEMO_DIR_URI.'css/adina.demo.import.css', array(), '1.0', false );
	}
}
add_action( 'admin_enqueue_scripts', 'adina_demo_import_custom_scripts' );