<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if ( post_password_required() ) {
        return;
    }


    if( have_comments() ) :
?>
<!-- Comments -->
<div class="td-postbox-comment mb-60">
    <?php 
        $comments_number = get_comments_number();

        if ( $comments_number == 1 ) {
            $comment_text = __( 'Feedback', 'adina' );
        } else {
            $comment_text = __( 'Feedbacks', 'adina' );
        }
    ?>
    <h3 class="td-postbox-comment-title pb-10">
        <span><?php echo esc_html( 'User', 'adina' ) ?></span> <?php echo esc_html($comment_text); ?> 
        (<?php printf( '%02d', number_format_i18n( $comments_number ) ); ?>)
    </h3>



    <ul>
        <?php
            the_comments_navigation();
                wp_list_comments( array(
                    'style'       => 'ul',
                    'short_ping'  => true,
                    'avatar_size' => 100,
                    'callback'    => 'adina_comment_callback'
                ) );
            the_comments_navigation();
        ?>
    </ul>
</div>

<!-- End of Comments -->
<?php
    endif;
?>

<?php
    $commenter = wp_get_current_commenter();
	$req = get_option( 'require_name_email' );
    $aria_req = ( $req ? "required" : '' );

    $consent = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';
    
	$fields =  array(
        'author'                => '<div class="row"><div class="col-lg-6 col-md-6 mb-20"><div class="td-postbox-comment-input"><input type="text" name="author" placeholder="'. esc_attr__( 'Name', 'adina' ) .'" value="'. esc_attr( $commenter['comment_author'] ).'" '.esc_attr( $aria_req ).'></div></div>',
        'email'                 => '<div class="col-lg-6 col-md-6 mb-20"><div class="td-postbox-comment-input"><input type="email" name="email"  value="' . esc_attr(  $commenter['comment_author_email'] ) .'" placeholder="'. esc_attr__( 'Email', 'adina' ) .'" '.esc_attr( $aria_req ).'></div></div></div>',
        'url'                   => '',
        'cookies'               => '<div class="row"><div class="col-12"><div class="custom-checkbox notice"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . esc_attr( $consent ) . ' />' . '<label for="wp-comment-cookies-consent">'  . esc_html__( ' Save my name, email, and website in this browser for the next time I comment.','adina' ) .  '<span class="checkmark"></span> </label> </div></div></div>'
    );

	$args = array(
    	'comment_field'         => '<div class="row"><div class="col-12 mb-20"><div class="td-postbox-comment-textarea"> <textarea class="form-control" name="comment" id="comment" placeholder="' . esc_attr__( 'Write your message', 'adina' ) . '" ' . esc_attr( $aria_req ) . '></textarea></div></div></div> ',
        'class_form'            => 'contact-page__form contact-form-validated',
    	'title_reply'           => esc_html__( 'Add Feedback & Reviews', 'adina' ),
    	'title_reply_before'    => '<div class="td-postbox-comment-form-content mb-40 d-flex align-items-center justify-content-between"><h3 class="td-postbox-comment-form-title">',
        'title_reply_after'     => '</h3></div>',
        'comment_notes_before'  => '<p class="comment-notes"><span>'.esc_html__('Your email address will not be published. Required fields are marked *','adina').'</span></p>',
        'logged_in_as'          => '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>','adina' ), admin_url( 'profile.php' ), esc_attr( $user_identity ), wp_logout_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</p>',
        'class_submit'          => 'fav-btn style1',
        'submit_field'          => '<div class="col-12"><div class="td-postbox-comment-btn">%1$s %2$s</div></div>',
    	'submit_button'         => '<button type="submit" name="%1$s" id="%2$s" class="td-btn td-left-right">'.esc_html__('Send Message','adina').'
                                        <span class="td-arrow-angle ml-10"> 
                                          <svg class="td-arrow-svg-top-right" xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 10.00 10.00">
                                             <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                             <path d="M1.018 10.009 0 8.991l7.569-7.582H1.723L1.737 0h8.26v8.274H8.574l.013-5.847Z" />
                                          </svg> 
                                       </span>
                                    </button>',
    	'fields'                => $fields,
	);

    if(  comments_open() ) {
        echo '<!-- Comment Form -->';
        echo '<div id="comments" class="td-postbox-comment-form">';
            comment_form( $args );
        echo '</div>';
        echo '<!-- End of Comment Form -->';
    }
