<?php

/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'yourprefix_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/WebDevStudios/CMB2
 */

 /**
 * Only return default value if we don't have a post ID (in the 'post' query variable)
 *
 * @param  bool  $default On/Off (true/false)
 * @return mixed          Returns true or '', the blank default
 */
function adina_set_checkbox_default_for_new_post( $default ) {
	return isset( $_GET['post'] ) ? '' : ( $default ? (string) $default : '' );
}

add_action( 'cmb2_admin_init', 'adina_register_metabox' );

/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */

function adina_register_metabox() {

	$prefix = '_adina_';

	$prefixpage = '_adinapage_';

	$adina_service_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'service_page_control',
		'title'         => esc_html__( 'Service Page Controller', 'adina' ),
		'object_types'  => array( 'adina_service' ), // Post type
		'closed'        => true
	) );
	

	$adina_post_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'blog_post_control',
		'title'         => esc_html__( 'Post Thumb Controller', 'adina' ),
		'object_types'  => array( 'post' ), // Post type
		'closed'        => true
	) );
	$adina_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Video', 'adina' ),
		'desc' => esc_html__( 'Use This Field When Post Format Video', 'adina' ),
		'id'   => $prefix . 'post_format_video',
        'type' => 'text_url',
    ) );
	$adina_post_meta->add_field( array(
		'name' => esc_html__( 'Post Format Audio', 'adina' ),
		'desc' => esc_html__( 'Use This Field When Post Format Audio', 'adina' ),
		'id'   => $prefix . 'post_format_audio',
        'type' => 'oembed',
    ) );
	$adina_post_meta->add_field( array(
		'name' => esc_html__( 'Post Thumbnail For Slider', 'adina' ),
		'desc' => esc_html__( 'Use This Field When You Want A Slider In Post Thumbnail', 'adina' ),
		'id'   => $prefix . 'post_format_slider',
        'type' => 'file_list',
    ) );

	$adina_page_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_meta_section',
		'title'         => esc_html__( 'Page Meta', 'adina' ),
		'object_types'  => array( 'page' ), // Post type
        'closed'        => true
    ) );

    $adina_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Area', 'adina' ),
		'desc' => esc_html__( 'check to display page breadcrumb area.', 'adina' ),
		'id'   => $prefix . 'page_breadcrumb_area',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   => esc_html__('Show','adina'),
            '2'     => esc_html__('Hide','adina'),
        )
    ) );


    $adina_page_meta->add_field( array(
		'name' => esc_html__( 'Page Breadcrumb Settings', 'adina' ),
		'id'   => $prefix . 'page_breadcrumb_settings',
        'type' => 'select',
        'default'   => 'global',
        'options'   => array(
            'global'   => esc_html__( 'Global Settings', 'adina' ),
            'page'     => esc_html__( 'Page Settings', 'adina' ),
        )
	) );

	$adina_page_meta->add_field( array(
	    'name'    => esc_html__( 'Breadcumb Image', 'adina' ),
	    'desc'    => esc_html__( 'Upload an image or enter an URL.', 'adina' ),
	    'id'      => $prefix . 'breadcumb_image',
	    'type'    => 'file',
	    // Optional:
	    'options' => array(
	        'url' => false, // Hide the text input for the url
	    ),
	    'text'    => array(
	        'add_upload_file_text' => __( 'Add File', 'adina' ) // Change upload button text. Default: "Add or Upload File"
	    ),
	    'preview_size' => 'large', // Image size to use when previewing in the admin.
	) );

    $adina_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title', 'adina' ),
		'desc' => esc_html__( 'check to display Page Title.', 'adina' ),
		'id'   => $prefix . 'page_title',
        'type' => 'select',
        'default' => '1',
        'options'   => array(
            '1'   	=> esc_html__( 'Show','adina'),
            '2'     => esc_html__( 'Hide','adina'),
        )
	) );

    $adina_page_meta->add_field( array(
		'name' => esc_html__( 'Page Title Settings', 'adina' ),
		'id'   => $prefix . 'page_title_settings',
        'type' => 'select',
        'options'   => array(
            'default'  => esc_html__('Default Title','adina'),
            'custom'  => esc_html__('Custom Title','adina'),
        ),
        'default'   => 'default'
    ) );

    $adina_page_meta->add_field( array(
		'name' => esc_html__( 'Custom Page Title', 'adina' ),
		'id'   => $prefix . 'custom_page_title',
        'type' => 'text'
    ) );

    $adina_page_meta->add_field( array(
		'name' => esc_html__( 'Breadcrumb', 'adina' ),
		'desc' => esc_html__( 'Select Show to display breadcrumb area', 'adina' ),
		'id'   => $prefix . 'page_breadcrumb_trigger',
        'type' => 'switch_btn',
        'default' => adina_set_checkbox_default_for_new_post( true ),
    ) );

    $adina_layout_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'page_layout_section',
		'title'         => esc_html__( 'Page Layout', 'adina' ),
        'context' 		=> 'side',
        'priority' 		=> 'high',
        'object_types'  => array( 'page' ), // Post type
        'closed'        => true
	) );

	$adina_layout_meta->add_field( array(
		'desc'       => esc_html__( 'Set page layout container,container fluid,fullwidth or both. It\'s work only in template builder page.', 'adina' ),
		'id'         => $prefix . 'custom_page_layout',
		'type'       => 'radio',
        'options' => array(
            '1' => esc_html__( 'Container', 'adina' ),
            '2' => esc_html__( 'Container Fluid', 'adina' ),
            '3' => esc_html__( 'Fullwidth', 'adina' ),
        ),
	) );

	$adina_product_meta = new_cmb2_box( array(
		'id'            => $prefixpage . 'product_meta_section',
		'title'         => esc_html__( 'Swap Image', 'adina' ),
		'object_types'  => array( 'product' ), // Post type
		'closed'        => true,
		'context'		=> 'side',
		'priority'		=> 'default'
	) );

	$adina_product_meta->add_field( array(
		'name' 		=> esc_html__( 'Product Swap Image', 'adina' ),
		'desc' 		=> esc_html__( 'Set Product Swap Image', 'adina' ),
		'id'   		=> $prefix.'product_swap_image',
		'type'    	=> 'file',
		// Optional:
		'options' 	=> array(
			'url' 		=> false, // Hide the text input for the url
		),
		'text'    	=> array(
			'add_upload_file_text' => __( 'Add Swap Image', 'adina' ) // Change upload button text. Default: "Add or Upload File"
		),
	) );
}

add_action( 'cmb2_admin_init', 'adina_register_taxonomy_metabox' );
/**
 * Hook in and add a metabox to add fields to taxonomy terms
 */
function adina_register_taxonomy_metabox() {

    $prefix = '_adina_';
	/**
	 * Metabox to add fields to categories and tags
	 */
	$adina_term_meta = new_cmb2_box( array(
		'id'               => $prefix.'term_edit',
		'title'            => esc_html__( 'Category Metabox', 'adina' ),
		'object_types'     => array( 'term' ),
		'taxonomies'       => array( 'category'),
	) );
	$adina_term_meta->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'adina' ),
		'id'       => $prefix.'term_extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );
	$adina_term_meta->add_field( array(
		'name' => esc_html__( 'Category Image', 'adina' ),
		'desc' => esc_html__( 'Set Category Image', 'adina' ),
		'id'   => $prefix.'term_avatar',
        'type' => 'file',
        'text'    => array(
			'add_upload_file_text' => esc_html__('Add Image','adina') // Change upload button text. Default: "Add or Upload File"
		),
	) );



	/**
	 * Metabox to add fields to events
	 */
	$adina_term_events = new_cmb2_box( array(
		'id'               => $prefix.'events',
		'title'            => esc_html__( 'Events Metabox', 'adina' ),
		'object_types'     => array( 'adina_event' ),
	) );
	$adina_term_events->add_field( array(
		'name'     => esc_html__( 'Event Date', 'adina' ),
		'id'       => $prefix.'event_date',
		'type'     => 'text_date_timestamp',
	) );
	$adina_term_events->add_field( array(
		'name'     => esc_html__( 'Event Time', 'adina' ),
		'id'       => $prefix.'event_time',
		'type'     => 'text',
		'default'  => esc_html__( '8:00 AM - 5:00 PM','adina' ),
	) );
	$adina_term_events->add_field( array(
		'name'     => esc_html__( 'Event Type', 'adina' ),
		'id'       => $prefix.'event_type',
		'type'     => 'text',
		'default'  => esc_html__( 'Online','adina' ),
	) );
	$adina_term_events->add_field( array(
		'name'     => esc_html__( 'Event Speaker', 'adina' ),
		'id'       => $prefix.'event_speaker',
		'type'     => 'text',
		'default'  => esc_html__( '20 Speaker','adina' ),
	) );

	

	/**
	 * Metabox to add fields to class widget
	 */
	
	 $adina_term_class = new_cmb2_box( array(
		'id'               => $prefix.'class',
		'title'            => esc_html__( 'class Metabox', 'adina' ),
		'object_types'     => array( 'adina_class' ),
	) );

	$adina_term_class->add_field( array(
		'name'     => esc_html__( 'Class Info', 'adina' ),
		'id'       => $prefix.'class_list',
		'type'     => 'wysiwyg',
		'default'  => esc_html__( '11 - 13 Years','adina' ),
	) );


	$adina_term_class->add_field( array(
		'name'     => esc_html__( 'Price', 'adina' ),
		'id'       => $prefix.'class_price',
		'type'     => 'text',
		'default'  => esc_html__( '$29','adina' ),
	) );
	
	$adina_term_class->add_field( array(
		'name'     => esc_html__( 'Duration', 'adina' ),
		'id'       => $prefix.'class_duration',
		'type'     => 'text',
		'default'  => esc_html__( '/ month','adina' ),
	) );


	/**
	 * Metabox to add fields to Teachers widget
	 */
	
	 $adina_term_teachers = new_cmb2_box( array(
		'id'               => $prefix.'teachers',
		'title'            => esc_html__( 'Teachers Metabox', 'adina' ),
		'object_types'     => array( 'adina_teacher' ),
	) );

	$adina_term_teachers->add_field( array(
		'name'     => esc_html__( 'Designation', 'adina' ),
		'id'       => $prefix.'teachers_designation',
		'type'     => 'text',
		'default'  => esc_html__( 'Principal and Manager','adina' ),
	) );

	$adina_term_teachers->add_field( array(
		'name'     => esc_html__( 'Phone Number', 'adina' ),
		'id'       => $prefix.'teachers_number',
		'type'     => 'text',
		'default'  => esc_html__( '+44 (0) 207 689 7888','adina' ),
	) );

	$profiles_group = $adina_term_teachers->add_field( array(
        'id'          => $prefix . 'profiles',
        'type'        => 'group',
        'description' => __( 'Add social profiles', 'adina' ),
        'options'     => array(
            'group_title'   => __( 'Profile {#}', 'adina' ),
            'add_button'    => __( 'Add Another Profile', 'adina' ),
            'remove_button' => __( 'Remove Profile', 'adina' ),
            'sortable'      => true,
        ),
    ) );

    // Add fields to the repeatable group
    $adina_term_teachers->add_group_field( $profiles_group, array(
        'name' => __( 'Social Network', 'adina' ),
        'id'   => 'network',
        'type' => 'text',
    ) );

    $adina_term_teachers->add_group_field( $profiles_group, array(
        'name' => __( 'Profile URL', 'adina' ),
        'id'   => 'url',
        'type' => 'text_url',
    ) );

}
