<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "adina_opt";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }


    $alowhtml = array(
        'p' => array(
            'class' => array()
        ),
        'span' => array()
    );


    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();

    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => esc_html__( 'Adina Options', 'adina' ),
        'page_title'           => esc_html__( 'Adina Options', 'adina' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );


    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'adina' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'adina' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'adina' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'adina' )
        )
    );
    Redux::set_help_tab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'adina' );
    Redux::set_help_sidebar( $opt_name, $content );



    // -> START General Fields




    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Preloader', 'adina' ),
        'id'               => 'adina_preloader',
        'subsection'       => false,
        'fields'           => array(
            array(
                'id'       => 'adina_display_preloader',
                'type'     => 'switch',
                'title'    => esc_html__( 'Preloader', 'adina' ),
                'subtitle' => esc_html__( 'Switch Enabled to Display Preloader.', 'adina' ),
                'default'  => true,
                'on'       => esc_html__('Enabled','adina'),
                'off'      => esc_html__('Disabled','adina'),
            ),
        )
    ));

    Redux::setSection( $opt_name, array(
        'icon'             => 'el  el-foursquare',
        'title'            => esc_html__( 'Logo', 'adina' ),
        'id'               => 'logo_settings',
        'customizer_width' => '450px',
        'fields'           => array(
            array(
                'id'       => 'logo',
                'type'     => 'media',
                'title'    => esc_html__( 'Logo', 'adina' ),
                'subtitle' => esc_html__( 'Choose the site Dark logo', 'adina' ),
                'default'  => array(
                    'url' => 'https://wp.framerpeak.com/adina/wp-content/uploads/2024/09/site-logo.svg',
                ),
            ),
            array(
                'id'       => 'white_logo',
                'type'     => 'media',
                'title'    => esc_html__( 'White Logo', 'adina' ),
                'subtitle' => esc_html__( 'Choose the site White logo', 'adina' ),
                'default'  => array(
                    'url' => 'https://wp.framerpeak.com/adina/wp-content/uploads/2024/09/white-logo.svg',
                ),
            ),
    
        ),
    ) );


    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header', 'adina' ),
        'id'               => 'adina_header',
        'customizer_width' => '400px',
        'icon'             => 'el el-credit-card',
        'fields'           => array(
            array(
                'id'       => 'adina_header_options',
                'type'     => 'button_set',
                'default'  => '1',
                'options'  => array(
                    "1"   => esc_html__('Prebuilt','adina'),
                    "2"      => esc_html__('Header Builder','adina'),
                ),
                'title'    => esc_html__( 'Header Options', 'adina' ),
                'subtitle' => esc_html__( 'Select header options.', 'adina' ),
            ),
            array(
                'id'       => 'adina_header_select_options',
                'type'     => 'select',
                'data'     => 'posts',
                'args'     => array(
                    'post_type'     => 'adina_header'
                ),
                'title'    => esc_html__( 'Header', 'adina' ),
                'subtitle' => esc_html__( 'Select header.', 'adina' ),
                'required' => array( 'adina_header_options', 'equals', '2' )
            ),

        ),
    ) );
    // -> START Header Logo
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Logo', 'adina' ),
        'id'               => 'adina_header_logo_option',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'adina_site_logo',
                'type'     => 'media',
                'url'      => true,
                'title'    => esc_html__( 'Site Logo', 'adina' ),
                'compiler' => 'true',
                'subtitle' => esc_html__( 'Upload your site logo for header ( recommendation png format ).', 'adina' ),
            ),
            array(
                'id'       => 'adina_site_logo_dimensions',
                'type'     => 'dimensions',
                'units'    => array('px'),
                'title'    => esc_html__('Logo Dimensions (Width/Height).', 'adina'),
                'output'   => array('.logo-box-one a img'),
                'subtitle' => esc_html__('Set logo dimensions to choose width, height, and unit.', 'adina'),
            ),
            array(
                'id'       => 'adina_site_logomargin_dimensions',
                'type'     => 'spacing',
                'mode'     => 'margin',
                'output'   => array('.logo-box-one a img'),
                'units_extended' => 'false',
                'units'    => array('px'),
                'title'    => esc_html__('Logo Top and Bottom Margin.', 'adina'),
                'left'     => false,
                'right'    => false,
                'subtitle' => esc_html__('Set logo top and bottom margin.', 'adina'),
                'default'            => array(
                    'units'           => 'px'
                )
            ),
            array(
                'id'       => 'adina_text_title',
                'type'     => 'text',
                'validate' => 'html',
                'title'    => esc_html__( 'Text Logo', 'adina' ),
                'subtitle' => esc_html__( 'Write your logo text use as logo ( You can use span tag for text color ).', 'adina' ),
            )
        )
    ) );
    // -> End Header Logo

    // -> START Header Menu
    Redux::setSection( $opt_name, array(
        'title'            => esc_html__( 'Header Menu', 'adina' ),
        'id'               => 'adina_header_menu_option',
        'subsection'       => true,
        'fields'           => array(
            array(
                'id'       => 'adina_header_menu_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Menu Color', 'adina' ),
                'output'   => array( 'color'    =>  '.menu-style1 > ul > li > a, .navbar-wrap ul li a' ),
            ),
            array(
                'id'       => 'adina_header_menu_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Menu Hover Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Menu Hover Color', 'adina' ),
                'output'   => array( 'color'    =>  '.menu-style1 > ul > li > a:hover, .navbar-wrap>ul>li.active>a, .navbar-wrap>ul>li:hover>a' ),
            ),
            array(
                'id'       => 'adina_header_submenu_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Submenu Color', 'adina' ),
                'output'   => array( 'color'    =>  '.main-menu ul li ul.sub-menu li a, .navbar-wrap ul li .sub-menu li a' ),
            ),
            array(
                'id'       => 'adina_header_submenu_hover_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Hover Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Submenu Hover Color', 'adina' ),
                'output'   => array( 'color'    =>  '.main-menu ul li ul.sub-menu li a:hover, .navbar-wrap ul li .sub-menu li a:hover' ),
            ),
            array(
                'id'       => 'adina_header_submenu_hover_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Submenu Hover Bg Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Submenu Hover Bg Color', 'adina' ),
                'output'   => array( 'background-color'    =>  '.navbar-wrap ul li .sub-menu li a:hover' ),
            ),
        )
    ) );
    // -> End Header Menu

     

    // -> START Blog Page
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Blog', 'adina' ),
        'id'         => 'adina_blog_page',
        'icon'  => 'el el-blogger',
        'fields'     => array(

            array(
                'id'       => 'adina_blog_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Layout', 'adina' ),
                'subtitle' => esc_html__( 'Choose blog layout from here. If you use this option then you will able to change three type of blog layout ( Default Left Sidebar Layour ). ', 'adina' ),
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','adina'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','adina'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','adina'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '3'
            ),
            array(
                'id'       => 'adina_blog_grid',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Post Column', 'adina' ),
                'subtitle' => esc_html__( 'Select your blog post column from here. If you use this option then you will able to select three type of blog post layout ( Default Two Column ).', 'adina' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','adina'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/1column.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','adina'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/2column.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','adina'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/3column.png' )
                    ),

                ),
                'default'  => '1'
            ),

            array(
                'id'      => 'adina_blog_style',
                'type'     => 'select',
                'options'  => array(
                    'blog_style_one' => esc_html__('Blog Style One','adina'),
                    'blog_style_two' => esc_html__('Blog Style Two','adina'),
                ),
                'default'  => 'blog_style_two',
                'title'   => esc_html__('Blog Style', 'adina'),
            ),

            array(
                'id'       => 'adina_blog_page_title_switcher',
                'type'     => 'switch',
                'default'  => 1,
                'on'       => esc_html__('Show','adina'),
                'off'      => esc_html__('Hide','adina'),
                'title'    => esc_html__('Blog Page Title', 'adina'),
                'subtitle' => esc_html__('Control blog page title show / hide. If you use this option then you will able to show / hide your blog page title ( Default Setting Show ).', 'adina'),
            ),
            array(
                'id'       => 'adina_blog_page_title_setting',
                'type'     => 'button_set',
                'title'    => esc_html__('Blog Page Title Setting', 'adina'),
                'subtitle' => esc_html__('Control blog page title setting. If you use this option then you can able to show default or custom blog page title ( Default Blog ).', 'adina'),
                'options'  => array(
                    "predefine"   => esc_html__('Default','adina'),
                    "custom"      => esc_html__('Custom','adina'),
                ),
                'default'  => 'predefine',
                'required' => array("adina_blog_page_title_switcher","equals","1")
            ),
            array(
                'id'       => 'adina_blog_page_custom_title',
                'type'     => 'text',
                'title'    => esc_html__('Blog Custom Title', 'adina'),
                'subtitle' => esc_html__('Set blog page custom title form here. If you use this option then you will able to set your won title text.', 'adina'),
                'required' => array('adina_blog_page_title_setting','equals','custom')
            ),
            array(
                'id'            => 'adina_blog_postExcerpt',
                'type'          => 'slider',
                'title'         => esc_html__('Blog Posts Excerpt', 'adina'),
                'subtitle'      => esc_html__('Control the number of characters you want to show in the blog page for each post.. If you use this option then you can able to control your blog post characters from here ( Default show 10 ).', 'adina'),
                "default"       => 46,
                "min"           => 0,
                "step"          => 1,
                "max"           => 100,
                'resolution'    => 1,
                'display_value' => 'text',
            ),
            array(
                'id'       => 'adina_blog_readmore_setting',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Read More Text Setting', 'adina' ),
                'subtitle' => esc_html__( 'Control read more text from here.', 'adina' ),
                'options'  => array(
                    "default"   => esc_html__('Default','adina'),
                    "custom"    => esc_html__('Custom','adina'),
                ),
                'default'  => 'default',
            ),
            array(
                'id'       => 'adina_blog_custom_readmore',
                'type'     => 'text',
                'title'    => esc_html__('Read More Text', 'adina'),
                'subtitle' => esc_html__('Set read moer text here. If you use this option then you will able to set your won text.', 'adina'),
                'required' => array('adina_blog_readmore_setting','equals','custom')
            ),
            array(
                'id'       => 'adina_blog_title_color',
                'output'   => array( '.fav-blog .blog-title a'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Title Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Blog Title Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_blog_title_hover_color',
                'output'   => array( '.fav-blog .blog-title a:hover'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Title Hover Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Blog Title Hover Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_blog_contant_color',
                'output'   => array( '.blog-standard-page__single-content .blog-text'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Excerpt / Content Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Blog Excerpt / Content Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_blog_read_more_button_color',
                'output'   => array( '.blog-standard-page__single-content .btn-box .thm-btn'),
                'type'     => 'color',
                'title'    => esc_html__( 'Read More Button Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Read More Button Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_blog_read_more_button_hover_color',
                'output'   => array( '.blog-standard-page__single-content .btn-box .thm-btn:hover'),
                'type'     => 'color',
                'title'    => esc_html__( 'Read More Button Hover Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Read More Button Hover Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_blog_read_more_button_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Read More Button Bg Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Read More Button Bg Color', 'adina' ),
                'output'   => array( 'background-color'    =>  '.thm-btn:after' ),
            ),
            array(
                'id'       => 'adina_blog_read_more_button_hover_bg_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Read More Button Hover Bg Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Read More Button Hover Bg Color', 'adina' ),
                'output'   => array( 'background-color'    =>  '.blog-standard-page__single-content .btn-box .thm-btn::before' ),
            ),
            array(
                'id'       => 'adina_blog_pagination_active_color',
                'output'   => array( 'background-color'    =>  '.styled-pagination li:hover a, .styled-pagination li.active a, .styled-pagination li a.active' ),
                'type'     => 'color',
                'title'    => esc_html__('Blog Pagination Active Color', 'adina'),
                'subtitle' => esc_html__('Set Blog Pagination Active Color.', 'adina'),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Single Blog Page', 'adina' ),
        'id'         => 'adina_post_detail_styles',
        'subsection' => true,
        'fields'     => array(

            array(
                'id'       => 'adina_blog_single_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Layout', 'adina' ),
                'subtitle' => esc_html__( 'Choose blog single page layout from here. If you use this option then you will able to change three type of blog single page layout ( Default Left Sidebar Layour ). ', 'adina' ),
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','adina'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','adina'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','adina'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '3'
            ),
            array(
                'id'       => 'adina_post_details_title_position',
                'type'     => 'button_set',
                'default'  => 'header',
                'options'  => array(
                    'header'        => esc_html__('On Header','adina'),
                    'below'         => esc_html__('Below Thumbnail','adina'),
                ),
                'title'    => esc_html__('Blog Post Title Position', 'adina'),
                'subtitle' => esc_html__('Control blog post title position from here.', 'adina'),
            ),
            array(
                'id'       => 'adina_post_details_custom_title',
                'type'     => 'text',
                'title'    => esc_html__('Blog Details Custom Title', 'adina'),
                'subtitle' => esc_html__('This title will show in Breadcrumb title.', 'adina'),
                'required' => array('adina_post_details_title_position','equals','below')
            ),
            array(
                'id'       => 'adina_post_details_share_options',
                'type'     => 'switch',
                'title'    => esc_html__('Share Options', 'adina'),
                'subtitle' => esc_html__('Control post share options from here. If you use this option then you will able to show or hide post share options.', 'adina'),
                'on'        => esc_html__('Show','adina'),
                'off'       => esc_html__('Hide','adina'),
                'default'   => '0',
            ),
            array(
                'id'       => 'adina_post_details_related_post',
                'type'     => 'switch',
                'title'    => esc_html__('Related Post', 'adina'),
                'subtitle' => esc_html__('Control related post from here. If you use this option then you will able to show or hide related post ( Default setting Show ).', 'adina'),
                'on'        => esc_html__('Show','adina'),
                'off'       => esc_html__('Hide','adina'),
                'default'   => false,
            ),
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Meta Data', 'adina' ),
        'id'         => 'adina_common_meta_data',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'adina_blog_meta_icon_color',
                'output'   => array( '.blog-standard-page__single-content .meta-box li a i'),
                'type'     => 'color',
                'title'    => esc_html__('Blog Meta Icon Color', 'adina'),
                'subtitle' => esc_html__('Set Blog Meta Icon Color.', 'adina'),
            ),
            array(
                'id'       => 'adina_blog_meta_text_color',
                'output'   => array( '.blog-standard-page__single-content .meta-box li a'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Meta Text Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Blog Meta Text Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_blog_meta_text_hover_color',
                'output'   => array( '.blog-standard-page__single-content .meta-box li a:hover'),
                'type'     => 'color',
                'title'    => esc_html__( 'Blog Meta Hover Text Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Blog Meta Hover Text Color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_display_post_date',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Date', 'adina' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Date.', 'adina' ),
                'default'  => true,
                'on'        => esc_html__('Enabled','adina'),
                'off'       => esc_html__('Disabled','adina'),
            ),
            array(
                'id'       => 'adina_display_post_author',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Auhtor', 'adina' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Author.', 'adina' ),
                'default'  => true,
                'on'        => esc_html__( 'Enabled', 'adina'),
                'off'       => esc_html__( 'Disabled', 'adina'),
            ),
            array(
                'id'       => 'adina_display_post_comments',
                'type'     => 'switch',
                'title'    => esc_html__( 'Post Comments', 'adina' ),
                'subtitle' => esc_html__( 'Switch On to Display Post Comments.', 'adina' ),
                'default'  => true,
                'on'        => esc_html__( 'Enabled', 'adina'),
                'off'       => esc_html__( 'Disabled', 'adina'),
            ),
            array(
                'id'       => 'adina_display_post_category',
                'type'     => 'switch',
                'title'    => esc_html__( 'Category', 'adina' ),
                'subtitle' => esc_html__( 'Switch On to Display Category.', 'adina' ),
                'default'  => true,
                'on'        => esc_html__('Enabled','adina'),
                'off'       => esc_html__('Disabled','adina'),
            ),
        )
    ));

    /* Sidebar Start */
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Sidebar Options', 'adina' ),
        'id'         => 'adina_sidebar_options',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'      => 'adina_sidebar_bg_color',
                'type'    => 'color',
                'title'   => esc_html__('Widgets Background Color', 'adina'),
                'output'  => array('background-color'   => '.sidebar .widget')
            ),
            array(
                'id'      => 'adina_sidebar_padding_margin_box_shadow_trigger',
                'type'    => 'switch',
                'title'   => esc_html__('Widgets Custom Box Shadow/Padding/Margin/border', 'adina'),
                'on'      => esc_html__('Show','adina'),
                'off'     => esc_html__('Hide','adina'),
                'default' => false
            ),
            array(
                'id'      => 'box-shadow',
                'type'    => 'box_shadow',
                'title'   => esc_html__('Box Shadow', 'adina'),
                'units'   => array( 'px', 'em', 'rem' ),
                'output'  => ( '.sidebar .widget' ),
                'opacity' => true,
                'rgba'    => true,
                'required'=> array( 'adina_sidebar_padding_margin_box_shadow_trigger', 'equals' , '1' )
            ),
            array(
                'id'      => 'adina_sidebar_widget_margin',
                'type'    => 'spacing',
                'title'   => esc_html__('Widget Margin', 'adina'),
                'units'   => array('em', 'px'),
                'output'  => ( '.sidebar .widget+.widget' ),
                'mode'    => 'margin',
                'required'=> array( 'adina_sidebar_padding_margin_box_shadow_trigger', 'equals' , '1' )
            ),
            array(
                'id'      => 'adina_sidebar_widget_padding',
                'type'    => 'spacing',
                'title'   => esc_html__('Widget Padding', 'adina'),
                'units'   => array('em', 'px'),
                'output'  => ( '.sidebar .widget' ),
                'mode'    => 'padding',
                'required'=> array( 'adina_sidebar_padding_margin_box_shadow_trigger', 'equals' , '1' )
            ),
            array(
                'id'      => 'adina_sidebar_widget_border',
                'type'    => 'border',
                'title'   => esc_html__('Widget Border', 'adina'),
                'units'   => array('em', 'px'),
                'output'  => ( '.sidebar .widget' ),
                'all'     => false,
                'required'=> array( 'adina_sidebar_padding_margin_box_shadow_trigger', 'equals' , '1' )
            ),
            array(
                'id'      => 'adina_sidebar_widget_title_heading_tag',
                'type'     => 'select',
                'options'  => array(
                    'h1'        => esc_html__('H1','adina'),
                    'h2'        => esc_html__('H2','adina'),
                    'h3'        => esc_html__('H3','adina'),
                    'h4'        => esc_html__('H4','adina'),
                    'h5'        => esc_html__('H5','adina'),
                    'h6'        => esc_html__('H6','adina'),
                ),
                'default'  => 'h3',
                'title'   => esc_html__('Widget Title Tag', 'adina'),
            ),
            array(
                'id'      => 'adina_sidebar_widget_title_margin',
                'type'    => 'spacing',
                'title'   => esc_html__('Widget Title Margin', 'adina'),
                'mode'    => 'margin',
                'output'  => array('.sidebar .widget .widget_title, .widget .wp-block-search__label, .wp-block-heading'),
                'units'   => array('em', 'px'),
            ),
            array(
                'id'      => 'adina_sidebar_widget_title_padding',
                'type'    => 'spacing',
                'title'   => esc_html__('Widget Title Padding', 'adina'),
                'mode'    => 'padding',
                'output'  => array('.sidebar .widget .widget_title, .widget .wp-block-search__label, .wp-block-heading'),
                'units'   => array('em', 'px'),
            ),
            array(
                'id'       => 'adina_sidebar_widget_title_color',
                'output'   =>  array('.sidebar .widget .widget_title, .widget .wp-block-search__label, .wp-block-heading'),
                'type'     => 'color',
                'title'    => esc_html__('Widget Title Color', 'adina'),
                'subtitle' => esc_html__('Set Widget Title Color.', 'adina'),
            ),
            array(
                'id'       => 'adina_sidebar_widget_text_color',
                'output'   => array('.sidebar .widget'),
                'type'     => 'color',
                'title'    => esc_html__('Widget Text Color', 'adina'),
                'subtitle' => esc_html__('Set Widget Text Color.', 'adina'),
            ),
            array(
                'id'       => 'adina_sidebar_widget_anchor_color',
                'type'     => 'color',
                'output'   => array('.sidebar .widget a'),
                'title'    => esc_html__('Widget Anchor Color', 'adina'),
                'subtitle' => esc_html__('Set Widget Anchor Color.', 'adina'),
            ),
            array(
                'id'       => 'adina_sidebar_widget_anchor_hover_color',
                'type'     => 'color',
                'output'   => array('.sidebar .widget a:hover'),
                'title'    => esc_html__('Widget Hover Color', 'adina'),
                'subtitle' => esc_html__('Set Widget Anchor Hover Color.', 'adina'),
            )
        )
    ));
    /* Sidebar End */

    /* End blog Page */

    // -> START Page Option
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Page', 'adina' ),
        'id'         => 'adina_page_page',
        'icon'  => 'el el-file',
        'fields'     => array(
            array(
                'id'       => 'adina_page_sidebar',
                'type'     => 'image_select',
                'title'    => esc_html__( 'Select layout', 'adina' ),
                'subtitle' => esc_html__( 'Choose your page layout. If you use this option then you will able to choose three type of page layout ( Default no sidebar ). ', 'adina' ),
                //Must provide key => value(array:title|img) pairs for radio options
                'options'  => array(
                    '1' => array(
                        'alt' => esc_attr__('1 Column','adina'),
                        'img' => esc_url( get_template_directory_uri(). '/assets/img/no-sideber.png')
                    ),
                    '2' => array(
                        'alt' => esc_attr__('2 Column Left','adina'),
                        'img' => esc_url( get_template_directory_uri() .'/assets/img/left-sideber.png')
                    ),
                    '3' => array(
                        'alt' => esc_attr__('2 Column Right','adina'),
                        'img' => esc_url(  get_template_directory_uri() .'/assets/img/right-sideber.png' )
                    ),

                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'adina_page_layoutopt',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Settings', 'adina'),
                'subtitle' => esc_html__('Set page sidebar. If you use this option then you will able to set three type of sidebar ( Default no sidebar ).', 'adina'),
                //Must provide key => value pairs for options
                'options' => array(
                    '1' => esc_html__( 'Page Sidebar', 'adina' ),
                    '2' => esc_html__( 'Blog Sidebar', 'adina' )
                 ),
                'default' => '1',
                'required'  => array('adina_page_sidebar','!=','1')
            ),
            array(
                'id'       => 'adina_page_title_switcher',
                'type'     => 'switch',
                'title'    => esc_html__('Title', 'adina'),
                'subtitle' => esc_html__('Switch enabled to display page title. Fot this option you will able to show / hide page title.  Default setting Enabled', 'adina'),
                'default'  => '1',
                'on'        => esc_html__('Enabled','adina'),
                'off'       => esc_html__('Disabled','adina'),
            ),
            array(
                'id'       => 'adina_page_title_tag',
                'type'     => 'select',
                'options'  => array(
                    'h1'        => esc_html__('H1','adina'),
                    'h2'        => esc_html__('H2','adina'),
                    'h3'        => esc_html__('H3','adina'),
                    'h4'        => esc_html__('H4','adina'),
                    'h5'        => esc_html__('H5','adina'),
                    'h6'        => esc_html__('H6','adina'),
                ),
                'default'  => 'h2',
                'title'    => esc_html__( 'Title Tag', 'adina' ),
                'subtitle' => esc_html__( 'Select page title tag. If you use this option then you can able to change title tag H1 - H6 ( Default tag H1 )', 'adina' ),
                'required' => array("adina_page_title_switcher","equals","1")
            ),
            array(
                'id'       => 'adina_allHeader_title_color',
                'type'     => 'color',
                'title'    => esc_html__( 'Title Color', 'adina' ),
                'subtitle' => esc_html__( 'Set Title Color', 'adina' ),
                'output'   => array( 'color' => '.page-header__inner .breadcumb-title' ),
            ),
            array(
                'id'       => 'adina_allHeader_bg',
                'type'     => 'background',
                'title'    => esc_html__( 'Background', 'adina' ),
                'output'   => array('.page-header__bg::after'),
                'subtitle' => esc_html__( 'Setting page header background. If you use this option then you will able to set Background Color, Background Image, Background Repeat, Background Size, Background Attachment, Background Position.', 'adina' ),
            ),
            array(
                'id'       => 'adina_enable_breadcrumb',
                'type'     => 'switch',
                'title'    => esc_html__( 'Breadcrumb Hide/Show', 'adina' ),
                'subtitle' => esc_html__( 'Hide / Show breadcrumb from all pages and posts ( Default settings hide ).', 'adina' ),
                'default'  => '1',
                'on'       => 'Show',
                'off'      => 'Hide',
            ),
            array(
                'id'      => 'adina_breadcrumb_padding',
                'type'    => 'spacing',
                'title'   => esc_html__('Breadcrumb Padding', 'adina'),
                'units'   => array('em', 'px'),
                'output'  => ( '.td-breadcrumb-area, .td-breadcrumb-area.breadcrumb-default-pd' ),
                'mode'    => 'padding',
            ),
            array(
                'id'       => 'adina_allHeader_breadcrumbtextcolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Breadcrumb Color', 'adina' ),
                'subtitle' => esc_html__( 'Choose page header breadcrumb text color here.If you user this option then you will able to set page breadcrumb color.', 'adina' ),
                'required' => array("adina_page_title_switcher","equals","1"),
                'output'   => array( 'color' => '.page-header__inner .thm-breadcrumb li' ),
            ),
            array(
                'id'       => 'adina_allHeader_breadcrumbtextactivecolor',
                'type'     => 'color',
                'title'    => esc_html__( 'Breadcrumb Active Color', 'adina' ),
                'subtitle' => esc_html__( 'Choose page header breadcrumb text active color here.If you user this option then you will able to set page breadcrumb active color.', 'adina' ),
                'required' => array( "adina_page_title_switcher", "equals", "1" ),
                'output'   => array( 'color' => '.page-header__inner .thm-breadcrumb li:last-child' ),
            ),
            array(
                'id'       => 'adina_allHeader_dividercolor',
                'type'     => 'color',
                'output'   => array( 'color'=>'.thm-breadcrumb li::after' ),
                'title'    => esc_html__( 'Breadcrumb Divider Color', 'adina' ),
                'subtitle' => esc_html__( 'Choose breadcrumb divider color.', 'adina' ),
            ),
            array(
                'id'       => 'adina_enable_breadcrumb_big_text',
                'type'     => 'switch',
                'title'    => esc_html__( 'Breadcrumb Big Text Hide/Show', 'adina' ),
                'subtitle' => esc_html__( 'Hide / Show breadcrumb Big Text ( Default settings hide ).', 'adina' ),
                'default'  => '0',
                'on'       => 'Show',
                'off'      => 'Hide',
            ),
            array(
                'id'       => 'adina_breadcrumb_big_text',
                'type'     => 'text',
                'title'    => esc_html__('Breadcrumb Big Text', 'adina'),
                'subtitle' => esc_html__('This title will show in Breadcrumb Bottom', 'adina'),
                'required' => array('adina_enable_breadcrumb_big_text','equals','1')
            ),
        ),
    ) );
    /* End Page option */

    // -> START 404 Page

    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( '404 Page', 'adina' ),
        'id'         => 'adina_404_page',
        'icon'       => 'el el-ban-circle',
        'fields'     => array(

            array(
                'title'     => esc_html__( '404 Page Background', 'adina' ),
                'subtitle'  => esc_html__( 'Add Your 404 Page Background Image', 'adina' ),
                'id'        => 'adina_error_bg',
                'type'      => 'background',
                'output'   => array( '.page-header__bg::before, .page-header__bg::after' ),
            ),
            array(
                'id'       => 'adina_fof_text_color',
                'type'     => 'color',
                'output'   => array( '.page-header__inner .breadcumb-title' ),
                'title'    => esc_html__( 'Title Color', 'adina' ),
                'subtitle' => esc_html__( 'Pick a title color', 'adina' ),
                'validate' => 'color'
            ),
        ),
    ) );

    /* End 404 Page */


    

    // -> START Footer Media
    Redux::setSection( $opt_name , array(
       'title'            => esc_html__( 'Footer', 'adina' ),
       'id'               => 'adina_footer',
       'desc'             => esc_html__( 'adina Footer', 'adina' ),
       'customizer_width' => '400px',
       'icon'              => 'el el-photo',
   ) );

   Redux::setSection( $opt_name, array(
       'title'      => esc_html__( 'Pre-built Footer / Footer Builder', 'adina' ),
       'id'         => 'adina_footer_section',
       'subsection' => true,
       'fields'     => array(
            array(
               'id'       => 'adina_footer_builder_trigger',
               'type'     => 'button_set',
               'default'  => 'prebuilt',
               'options'  => array(
                   'footer_builder'        => esc_html__('Footer Builder','adina'),
                   'prebuilt'              => esc_html__('Pre-built Footer','adina'),
               ),
               'title'    => esc_html__( 'Footer Builder', 'adina' ),
            ),
            array(
               'id'       => 'adina_footer_builder_select',
               'type'     => 'select',
               'required' => array( 'adina_footer_builder_trigger','equals','footer_builder'),
               'data'     => 'posts',
               'args'     => array(
                   'post_type'     => 'adina_footer'
               ),
               'on'       => esc_html__( 'Enabled', 'adina' ),
               'off'      => esc_html__( 'Disable', 'adina' ),
               'title'    => esc_html__( 'Select Footer', 'adina' ),
               'subtitle' => esc_html__( 'First make your footer from footer custom types then select it from here.', 'adina' ),
            ),
           array(
               'id'       => 'adina_disable_footer_bottom',
               'type'     => 'switch',
               'title'    => esc_html__( 'Footer Bottom?', 'adina' ),
               'default'  => 1,
               'on'       => esc_html__('Enabled','adina'),
               'off'      => esc_html__('Disable','adina'),
               'required' => array('adina_footer_builder_trigger','equals','prebuilt'),
            ),
            array(
               'id'       => 'adina_footer_bottom_background',
               'type'     => 'color',
               'title'    => esc_html__( 'Footer Bottom Background Color', 'adina' ),
               'required' => array( 'adina_disable_footer_bottom','=','1' ),
               'output'   => array( 'background-color'   =>   '.footer-copyright' ),
            ),
            array(
               'id'       => 'adina_copyright_text',
               'type'     => 'text',
               'title'    => esc_html__( 'Copyright hello Text', 'adina' ),
               'subtitle' => esc_html__( 'Add Copyright Text', 'adina' ),
               'default'  => sprintf( 'Copyright <i class="fas fa-copyright"></i> %s <a  href="%s">%s</a> All afa Rights Reserved by <a  href="%s">%s</a>',date('Y'),esc_url('#'),__( 'Adina.','adina' ),esc_url('#'),__( 'Themedox', 'adina' ) ),
               'required' => array( 'adina_disable_footer_bottom','equals','1' ),
            ),
            array(
               'id'       => 'adina_footer_copyright_color',
               'type'     => 'color',
               'title'    => esc_html__( 'Footer Copyright Text Color', 'adina' ),
               'subtitle' => esc_html__( 'Set footer copyright text color', 'adina' ),
               'required' => array( 'adina_disable_footer_bottom','equals','1'),
               'output'   => array( '.footer-copyright p' ),
            ),
            array(
               'id'       => 'adina_footer_copyright_acolor',
               'type'     => 'color',
               'title'    => esc_html__( 'Footer Copyright Ancor Color', 'adina' ),
               'subtitle' => esc_html__( 'Set footer copyright ancor color', 'adina' ),
               'required' => array( 'adina_disable_footer_bottom','equals','1'),
               'output'   => array( '.footer-copyright p a' ),
            ),
            array(
               'id'       => 'adina_footer_copyright_a_hover_color',
               'type'     => 'color',
               'title'    => esc_html__( 'Footer Copyright Ancor Hover Color', 'adina' ),
               'subtitle' => esc_html__( 'Set footer copyright ancor Hover color', 'adina' ),
               'required' => array( 'adina_disable_footer_bottom','equals','1'),
               'output'   => array( '.footer-copyright p a:hover' ),
            ),

       ),
   ) );


    /* End Footer Media */

    // -> START Custom Css
    Redux::setSection( $opt_name, array(
        'title'      => esc_html__( 'Custom Css', 'adina' ),
        'id'         => 'adina_custom_css_section',
        'icon'  => 'el el-css',
        'fields'     => array(
            array(
                'id'       => 'adina_css_editor',
                'type'     => 'ace_editor',
                'title'    => esc_html__('CSS Code', 'adina'),
                'subtitle' => esc_html__('Paste your CSS code here.', 'adina'),
                'mode'     => 'css',
                'theme'    => 'monokai',
            )
        ),
    ) );

    /* End custom css */



    if ( file_exists( dirname( __FILE__ ) . '/../README.md' ) ) {
        $section = array(
            'icon'   => 'el el-list-alt',
            'title'  => __( 'Documentation', 'adina' ),
            'fields' => array(
                array(
                    'id'       => '17',
                    'type'     => 'raw',
                    'markdown' => true,
                    'content_path' => dirname( __FILE__ ) . '/../README.md', // FULL PATH, not relative please
                    //'content' => 'Raw content here',
                ),
            ),
        );
        Redux::setSection( $opt_name, $section );
    }
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'adina' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'adina' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }