<?php
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit();
}
/**
 *
 * @Packge      Adina
 * @Author      Themedox
 * @Author URL  https//www.themedox.com
 * @version     1.0
 *
 */

if ( ! function_exists( 'adina_breadcrumbs' ) ) {
    function adina_breadcrumbs( $args = array() ) {
        if ( is_front_page() ) {
            return;
        }
        if ( get_theme_mod( 'ct_ignite_show_breadcrumbs_setting' ) == 'no' ) {
            return;
        }
        global $post;
        $defaults  = array(
            'breadcrumbs_id'      => '',
            'breadcrumbs_classes' => esc_html( 'breadcrumb' ),
            'home_title'          => esc_html__( 'Home', 'adina' )
        );
        $args    = apply_filters( 'adina_breadcrumbs_args', wp_parse_args( $args, $defaults ) );

        $args_el = array();

        if( $args['breadcrumbs_id'] ){

            $args_el[] =  'id="'.esc_attr( $args['breadcrumbs_id'] ).'"';
        }


        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array()
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );

        /*
        * Begin Markup
        */

        // Open the breadcrumbs

        $html = '';
        // Add Homepage link (always present)
        $html .= '<span><a href="' . esc_url( get_home_url('/') ) . '" title="' . esc_attr( $args['home_title'] ) . '">' . esc_attr( $args['home_title'] ) . '</a></span>';
        // Post
        if ( is_singular( 'post' ) ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="page" title="' . esc_attr( get_the_title() ) . '">' . wp_kses( get_the_title(), $allowhtml ) . '</span>';
        } elseif ( is_singular( 'page' ) ) {
            if ( $post->post_parent ) {
                $parents = get_post_ancestors( $post->ID );
                $parents = array_reverse( $parents );
                foreach ( $parents as $parent ) {
                    $html .= '<span class="dvdr">/</span>'; 
                    $html .= '<span class="item-parent item-parent-' . esc_attr( $parent ) . '"><a class="bread-parent bread-parent-' . esc_attr( $parent ) . '" href="' . esc_url( get_permalink( $parent ) ) . '" title="' . esc_attr( get_the_title( $parent ) ) . '">' . esc_html( get_the_title( $parent ) ) . '</a></span>';
                }
            }
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="page" title="' . esc_attr( get_the_title() ) . '">' . wp_kses( get_the_title(), $allowhtml ) . '</span>';
        } elseif ( is_singular( 'attachment' ) ) {
            $parent_id        = $post->post_parent;
            $parent_title     = get_the_title( $parent_id );
            $parent_permalink = esc_url( get_permalink( $parent_id ) );
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="item-parent"><a class="bread-parent" href="' . esc_url( $parent_permalink ) . '" title="' . esc_attr( $parent_title ) . '">' . esc_attr( $parent_title ) . '</a></span>';
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span title="' . esc_attr( get_the_title() ) . '"> ' . wp_kses( get_the_title(), $allowhtml ) . '</span>';
        } elseif ( is_singular() ) {
            $post_type         = get_post_type();
            $post_type_object  = get_post_type_object( $post_type );
            $post_type_archive = get_post_type_archive_link( $post_type );
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="item-cat item-custom-post-type-' . esc_attr( $post_type ) . '"><a class="bread-cat bread-custom-post-type-' . esc_attr( $post_type ) . '" href="' . esc_url( $post_type_archive ) . '" title="' . esc_attr( $post_type_object->labels->name ) . '">' . esc_attr( $post_type_object->labels->name ) . '</a></span>';
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="page bread-' . esc_attr( $post->ID ) . '" title="' . esc_attr( $post->post_title ). '">' . wp_kses( $post->post_title, $allowhtml ) . '</span>';
        } elseif ( is_category() ) {
            $parent = get_queried_object()->category_parent;
            if ( $parent !== 0 ) {
                $parent_category = get_category( $parent );
                $category_link   = get_category_link( $parent );
                $html .= '<span class="dvdr">/</span>'; 
                $html .= '<span class="item-parent item-parent-' . esc_attr( $parent_category->slug ) . '"><a class="bread-parent bread-parent-' . esc_attr( $parent_category->slug ) . '" href="' . esc_url( $categoryspannk ) . '" title="' . esc_attr( $parent_category->name ) . '">' . wp_kses( $parent_category->name, $allowhtml ) . '</a></span>';
            }
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="page bread-cat" title="' . esc_attr( $post->ID ) . '">' . wp_kses( single_cat_title( '', false ), $allowhtml ) . '</span>';
        } elseif ( is_tag() ) {
            $html .= '<span class="active bread-tag">' . wp_kses( single_tag_title( '', false ), $allowhtml ) . '</span>';
        } elseif ( is_author() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-author">' . wp_kses( get_queried_object()->display_name, $allowhtml ) . '</span>';
        } elseif ( is_day() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-day">' . wp_kses( get_the_date(), $allowhtml ) . '</span>';
        } elseif ( is_month() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-month">' . wp_kses( get_the_date( 'F Y' ), $allowhtml ) . '</span>';
        } elseif ( is_year() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-year">' . wp_kses( get_the_date( 'Y' ), $allowhtml ) . '</span>';
        }elseif( is_post_type_archive() ){
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-archive">' . wp_kses( post_type_archive_title( '', false ), $allowhtml ) . '</span>';
        } elseif ( is_archive()  ) {
            $custom_tax_name = get_queried_object()->name;
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-archive">' . esc_attr( $custom_tax_name ) . '</span>';
        }elseif ( is_search() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active bread-search">'.esc_html__('Search results for: ','adina') . get_search_query() . '</span>';
        } elseif ( is_404() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active">' . esc_html__( 'Error 404', 'adina' ) . '</span>';
        } elseif ( is_home() ) {
            $html .= '<span class="dvdr">/</span>'; 
            $html .= '<span class="active page">' . wp_kses( get_the_title( get_option( 'page_for_posts' ) ), $allowhtml ) . '</span>';
        }

        echo apply_filters( 'adina_breadcrumbs_filter', $html );

    }
}