<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

// enqueue css
function adina_common_custom_css(){
	wp_enqueue_style( 'adina-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = adina_opt( 'adina_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	}else{
		$CustomCssOpt = '';
	}

    $customcss = "";

    if( get_header_image() ){
        $adina_header_bg =  get_header_image();
    }else{
        if( adina_meta( 'page_breadcrumb_settings' ) == 'page' && is_page() ){
            if( ! empty( adina_meta( 'breadcumb_image' ) ) ){
                $adina_header_bg = adina_meta( 'breadcumb_image' );
            }
        }
    }

    if( !empty( $adina_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$adina_header_bg}')!important;
        }";
    }



	// theme color
	$adina_primary 	    = adina_opt('adina_primary');
	$adina_secondary      = adina_opt('adina_secondary');
	$adina_secondary_two  = adina_opt('adina_secondary_two');
	$adina_heading_color  = adina_opt('adina_heading_color');
	$adina_body_color     = adina_opt('adina_body_color');
	$adina_body_bg        = adina_opt('adina_body_bg');
	$light_color            = adina_opt('light_color');
	$black_color            = adina_opt('black_color');
	$white_color            = adina_opt('white_color');
	$adina_smoke            = adina_opt('adina_smoke');
	$yellow_color           = adina_opt('yellow_color');
	$success_color          = adina_opt('success_color');
	$error_color            = adina_opt('error_color');
	$border_color           = adina_opt('border_color');

	
	if( !empty( $adina_primary ) ) {
		$customcss .= ":root {
		  --theme-color: {$adina_primary};
		}";
	}

	if( !empty( $adina_secondary ) ) {
		$customcss .= ":root {
			--theme-color2: {$adina_secondary};
		}";
	}

	if( !empty( $adina_secondary_two ) ) {
		$customcss .= ":root {
			--fav-secondary-color: {$adina_secondary_two};
		}";
	}

	if( !empty( $adina_heading_color ) ) {
		$customcss .= ":root {
			--title-color: {$adina_heading_color};
		}";
	}

	if( !empty( $adina_body_color ) ) {
		$customcss .= ":root {
			--body-color: {$adina_body_color};
		}";
	}

	if( !empty( $adina_body_bg ) ) {
		$customcss .= ":root {
			--body-bg: {$adina_body_bg};
		}";
	}

	if( !empty( $light_color ) ) {
		$customcss .= ":root {
			--light-color: {$light_color};
		}";
	}

	if( !empty( $adina_smoke ) ) {
		$customcss .= ":root {
			--smoke-color: {$adina_smoke};
		}";
	}

	if( !empty( $black_color ) ) {
		$customcss .= ":root {
			--black-color: {$black_color};
		}";
	}

	if( !empty( $white_color  ) ) {
		$customcss .= ":root {
			--white-color: {$white_color };
		}";
	}

	if( !empty( $success_color ) ) {
		$customcss .= ":root {
			--success-color: {$success_color};
		}";
	}

	if( !empty( $error_color ) ) {
		$customcss .= ":root {
			--error-color: {$error_color};
		}";
	}

	if( !empty( $border_color ) ) {
		$customcss .= ":root {
			--border-color: {$border_color};
		}";
	}

	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'adina-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'adina_common_custom_css', 100 );