<?php

/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */


// Block direct access
if( ! defined( 'ABSPATH' ) ){
    exit;
}

 // theme option callback
function adina_opt( $id = null, $url = null ){
    global $adina_opt;

    if( $id && $url ){

        if( isset( $adina_opt[$id][$url] ) && $adina_opt[$id][$url] ){
            return $adina_opt[$id][$url];
        }
    }else{
        if( isset( $adina_opt[$id] )  && $adina_opt[$id] ){
            return $adina_opt[$id];
        }
    }
}


/**
 * Get categories.
 */
function adina_get_category() {

    $categories = get_the_category( get_the_ID() );
    $x = 0;
    foreach ( $categories as $category ) {

        if ( $x == 2 ) {
            break;
        }
        $x++;
        print '<a class="news-tag" href="' . get_category_link( $category->term_id ) . '">' . $category->cat_name . '</a>';

    }
}


// theme logo
function adina_theme_logo() {
    // escaping allow html
    $allowhtml = array(
        'a'    => array(
            'href' => array()
        ),
        'span' => array(),
        'i'    => array(
            'class' => array()
        )
    );
    $siteUrl = home_url('/');
    if( has_custom_logo() ) {
        $custom_logo_id = get_theme_mod( 'custom_logo' );
        $siteLogo = '';
        $siteLogo .= '<a href="'.esc_url( $siteUrl ).'">';
        $siteLogo .= adina_img_tag( array(
            "url"   => esc_url( wp_get_attachment_image_url( $custom_logo_id, 'full') )
        ) );
        $siteLogo .= '</a>';

        return $siteLogo;
    } elseif( !adina_opt('adina_text_title') && adina_opt('adina_site_logo', 'url' )  ){

        $siteLogo = '<img src="'.esc_url( adina_opt('adina_site_logo', 'url' ) ).'" alt="'.esc_attr__( 'logo', 'adina' ).'" />';
        return '<a class="logo" href="'.esc_url( $siteUrl ).'">'.$siteLogo.'</a>';


    }elseif( adina_opt('adina_text_title') ){
        return '<h3 class="mb-0"><a class="logo" href="'.esc_url( $siteUrl ).'">'.wp_kses( adina_opt('adina_text_title'), $allowhtml ).'</a></h2>';
    }else{
        return '<h3 class="mb-0"><a class="logo" href="'.esc_url( $siteUrl ).'">'.esc_html( get_bloginfo('name') ).'</a></h2>';
    }
}

// Adina Coming Soon Logo
function adina_coming_soon_logo() {
    // escaping allow html
    $allowhtml = array(
        'a'    => array(
            'href' => array()
        ),
        'span' => array(),
        'i'    => array(
            'class' => array()
        )
    );
    $siteUrl = home_url('/');
    // site logo
    if( adina_opt( 'adina_coming_logo', 'url' )  ){

        $siteLogo = '<img src="'.esc_url( adina_opt('adina_coming_logo', 'url' ) ).'" alt="'.esc_attr__( 'logo', 'adina' ).'" />';

        return '<a class="logo" href="'.esc_url( $siteUrl ).'">'.$siteLogo.'</a>';

    }elseif( adina_opt('adina_coming_site_title') ){
        return '<h2 class="mb-0"><a class="text-logo" href="'.esc_url( $siteUrl ).'">'.wp_kses( adina_opt('adina_coming_site_title'), $allowhtml ).'</a></h2>';
    }else{
        return '<h2 class="mb-0"><a class="text-logo" href="'.esc_url( $siteUrl ).'">'.esc_html( get_bloginfo('name') ).'</a></h2>';
    }
}

// custom meta id callback
function adina_meta( $id = '' ){
    $value = get_post_meta( get_the_ID(), '_adina_'.$id, true );
    return $value;
}


// Blog Date Permalink
function adina_blog_date_permalink() {
    $year  = get_the_time('Y');
    $month_link = get_the_time('m');
    $day   = get_the_time('d');
    $link = get_day_link( $year, $month_link, $day);
    return $link;
}

//audio format iframe match
function adina_iframe_match() {
    $audio_content = adina_embedded_media( array('audio', 'iframe') );
    $iframe_match = preg_match("/\iframe\b/i",$audio_content, $match);
    return $iframe_match;
}


//Post embedded media
function adina_embedded_media( $type = array() ){
    $content = do_shortcode( apply_filters( 'the_content', get_the_content() ) );
    $embed   = get_media_embedded_in_content( $content, $type );


    if( in_array( 'audio' , $type) ){
        if( count( $embed ) > 0 ){
            $output = str_replace( '?visual=true', '?visual=false', $embed[0] );
        }else{
           $output = '';
        }

    }else{
        if( count( $embed ) > 0 ){
            $output = $embed[0];
        }else{
           $output = '';
        }
    }
    return $output;
}


// WP post link pages
function adina_link_pages(){
    wp_link_pages( array(
        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'adina' ) . '</span>',
        'after'       => '</div>',
        'link_before' => '<span>',
        'link_after'  => '</span>',
        'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'adina' ) . ' </span>%',
        'separator'   => '<span class="screen-reader-text">, </span>',
    ) );
}


// Data Background image attr
function adina_data_bg_attr( $imgUrl = '' ){
    return 'data-bg-img="'.esc_url( $imgUrl ).'"';
}

// image alt tag
function adina_image_alt( $url = '' ){
    if( $url != '' ){
        // attachment id by url
        $attachmentid = attachment_url_to_postid( esc_url( $url ) );
       // attachment alt tag
        $image_alt = get_post_meta( esc_html( $attachmentid ) , '_wp_attachment_image_alt', true );
        if( $image_alt ){
            return $image_alt ;
        }else{
            $filename = pathinfo( esc_url( $url ) );
            $alt = str_replace( '-', ' ', $filename['filename'] );
            return $alt;
        }
    }else{
       return;
    }
}


// Flat Content wysiwyg output with meta key and post id

function adina_get_textareahtml_output( $content ) {
    global $wp_embed;

    $content = $wp_embed->autoembed( $content );
    $content = $wp_embed->run_shortcode( $content );
    $content = wpautop( $content );
    $content = do_shortcode( $content );

    return $content;
}

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */

function adina_pingback_header() {
    if ( is_singular() && pings_open() ) {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'adina_pingback_header' );


// Excerpt More
function adina_excerpt_more( $more ) {
    return '...';
}

add_filter( 'excerpt_more', 'adina_excerpt_more' );


// adina comment template callback
function adina_comment_callback( $comment, $args, $depth ) {
        $add_below = 'comment';
    ?>
        <li>
            <div id="comment-<?php comment_ID() ?>">
                <div class="td-postbox-comment-box mb-55">
                    <!-- Author Image -->
                    <?php if( get_avatar( $comment, 80 )  ) : ?>
                        <div class="td-postbox-comment-avatar mr-30">
                            <?php
                                if ( $args['avatar_size'] != 0 ) {
                                    echo get_avatar( $comment, 80 );
                                }
                            ?>
                        </div>
                    <?php endif; ?>

                    <div class="td-postbox-comment-text">
                        <div class="td-postbox-comment-name mb-10 d-flex align-items-center">
                            <!-- Author Name -->
                            <h5>
                                <a href="<?php echo esc_url( get_comment_author_url() ); ?>">
                                    <?php echo esc_html( ucwords( get_comment_author() ) ); ?>
                                </a>
                            </h5>
                            <!-- Post Date -->
                            <span class="post-meta"> 
                                <?php printf( esc_html__('%1$s', 'adina'), get_comment_date() ); ?> 
                            </span>
                        </div>
                        <?php comment_text(); ?>
                        <div class="td-postbox-comment-reply">
                            <?php
                                comment_reply_link(array_merge( $args, array( 'add_below' => $add_below, 'depth' => 1, 'max_depth' => 5, 'reply_text' => '<span><i class="fa-sharp fa-solid fa-reply"></i></span><span>Reply</span>' ) ) );
                            ?>
                            <span class="comment-edit-link"><?php edit_comment_link( '<span class="fas fa-pencil"></span>'.esc_html__( 'Edit', 'adina' ), '  ', '' ); ?></span>
                            <?php if ( $comment->comment_approved == '0' ) : ?>
                                <p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'adina' ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div> 

                </div>
            </div>
        </li>
        <!-- Comment Content -->
    <?php
}

//body class
add_filter( 'body_class', 'adina_body_class' );
function adina_body_class( $classes ) {
    if( class_exists('ReduxFramework') ) {
        $adina_blog_single_sidebar = adina_opt('adina_blog_single_sidebar');
        if( ($adina_blog_single_sidebar != '2' && $adina_blog_single_sidebar != '3' ) || ! is_active_sidebar('adina-blog-sidebar') ) {
            $classes[] = 'no-sidebar';
        }
    } else {
        if( !is_active_sidebar('adina-blog-sidebar') ) {
            $classes[] = 'no-sidebar';
        }
    }
    return $classes;
}


function adina_footer_global_option(){

    // Adina Footer Bottom Enable Disable
    if( class_exists( 'ReduxFramework' ) ){
        $adina_footer_bottom_active = adina_opt( 'adina_disable_footer_bottom' );
    }else{
        $adina_footer_bottom_active = '1';
    }

    $allowhtml = array(
        'p'         => array(
            'class'     => array()
        ),
        'span'      => array(
            'class'     => array(),
        ),
        'a'         => array(
            'href'      => array(),
            'title'     => array()
        ),
        'br'        => array(),
        'em'        => array(),
        'strong'    => array(),
        'b'         => array(),
    );

    if( $adina_footer_bottom_active == '1' ){
        echo '<!-- Footer -->';
        echo '<footer class="footer-main">';

            if( $adina_footer_bottom_active == '1' ){
                $allowhtml = array(
                    'p'         => array(
                        'class'     => array()
                    ),
                    'span'      => array(),
                    'a'         => array(
                        'href'      => array(),
                        'title'     => array(),
                        'class'     => array(),
                    ),
                    'br'        => array(),
                    'em'        => array(),
                    'strong'    => array(),
                    'b'         => array(),
                );
                echo '<div class="copyright-wrap">';
                    echo '<div class="container">';
                        echo '<div class="row align-items-center">';
                            if( ! empty( adina_opt( 'adina_copyright_text' ) ) ){
                                echo '<p class="copyright-text dafd">'.wp_kses( adina_opt( 'adina_copyright_text' ), $allowhtml ).'</p>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
        echo '</footer>';
        echo '<!-- End Footer -->';
    }
}

function adina_social_icon(){
    $adina_social_icon = adina_opt( 'adina_social_links' );
    if( ! empty( $adina_social_icon ) && isset( $adina_social_icon ) ){
        echo '<div class="author-links">';
        foreach( $adina_social_icon as $social_icon ){
            if( ! empty( $social_icon['title'] ) ){
                echo '<a href="'.esc_url( $social_icon['url'] ).'"><i class="'.esc_attr( $social_icon['title'] ).'"></i>'.esc_html( $social_icon['description'] ).'</a>';
            }
        }
        echo '</div>';
    }
}


// global header
function adina_global_header_option() {

    echo '<header class="prebuilt-header">';
        echo '<div id="sticky-header" class="menu-area">';
            echo '<div class="container">';
                echo '<div class="row">';

                    echo '<div class="col-auto">';
                        echo '<div class="td-header-logo">';
                                echo adina_theme_logo();
                        echo '</div>';
                    echo '</div>';

                    echo '<div class="col-auto">';
                        echo '<div class="td-main-menu td-main-menu-01 d-none d-lg-block">';
                            echo '<nav class="td-main-menu-content">';
                                if( has_nav_menu( 'primary-menu' ) ){
                                    wp_nav_menu( array(
                                        "theme_location"    => 'primary-menu',
                                        "container"         => '',
                                        "menu_class"        => '',
                                    ) );
                                }
                            echo '</nav>';
                        echo '</div>';

                        echo '<div class="td-header-bar d-block d-lg-none text-right">';
                            echo '<button class="td-offcanvas-open-btn td-menu-bar">';
                                echo '<span></span>';
                                echo '<span></span>';
                                echo '<span></span>';
                            echo '</button>';
                        echo '</div>';

                    echo '</div>';

                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo '</header>';


    // td-offcanvus-area-start
    echo '<div class="tdoffcanvas-area">';
        echo '<div class="tdoffcanvas">';
            echo '<div class="tdoffcanvas__close-btn">';
                echo '<button class="close-btn"><i class="fal fa-times"></i></button>';
            echo '</div>';
            echo '<div class="tdoffcanvas__logo">';
                echo adina_theme_logo();
            echo '</div>';
            echo '<div class="td-main-menu-mobile d-lg-none"></div>';
        echo '</div>';
    echo '</div>';
    echo '<div class="body-overlay"></div>';
    // td-offcanvus-area-end

}



//Fire the wp_body_open action.
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}

//Remove Tag-Clouds inline style
add_filter( 'wp_generate_tag_cloud', 'adina_remove_tagcloud_inline_style',10,1 );
function adina_remove_tagcloud_inline_style( $input ){
   return preg_replace('/ style=("|\')(.*?)("|\')/','',$input );
}

// password protected form
add_filter('the_password_form','adina_password_form',10,1);
function adina_password_form( $output ) {
    $output = '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" class="post-password-form" method="post"><div class="theme-input-group">
        <input name="post_password" type="password" class="theme-input-style" placeholder="'.esc_attr__( 'Enter Password','adina' ).'">
        <button type="submit" class="submit-btn btn-fill">'.esc_html__( 'Enter','adina' ).'</button></div></form>';
    return $output;
}

function adina_setPostViews( $postID ) {
    $count_key  = 'post_views_count';
    $count      = get_post_meta( $postID, $count_key, true );
    if( $count == '' ){
        $count = 0;
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
    }else{
        $count++;
        update_post_meta( $postID, $count_key, $count );
    }
}

function adina_getPostViews( $postID ){
    $count_key  = 'post_views_count';
    $count      = get_post_meta( $postID, $count_key, true );
    if( $count == '' ){
        delete_post_meta( $postID, $count_key );
        add_post_meta( $postID, $count_key, '0' );
        return __( '0', 'adina' );
    }
    return $count;
}


/* This code filters the Categories widget to include the post count inside the link */
function adina_cat_add_count_span($output) {
    // Modify the category list output to include count in a <span> element
    $output = preg_replace('/<\/a>\s*\(([0-9]+)\)/', ' <span>($1)</span></a>', $output);
    return $output;
}
add_filter('wp_list_categories', 'adina_cat_add_count_span');


/* This code filters the Archive widget to include the post count inside the link */
add_filter( 'get_archives_link', 'adina_archive_remove_count' );
function adina_archive_remove_count( $links ) {
    $links = preg_replace('/<\/a>&nbsp;\([0-9]+\)/', '</a>', $links);
    return $links;
}

// Blog Category
if( ! function_exists( 'adina_blog_category' ) ){
    function adina_blog_category(){
        if( class_exists( 'ReduxFramework' ) ){
            $adina_display_post_category =  adina_opt('adina_display_post_category');
        }else{
            $adina_display_post_category = '1';
        }


        if( $adina_display_post_category ){
            $adina_post_categories = get_the_category();
            if( is_array( $adina_post_categories ) && ! empty( $adina_post_categories ) ){
                echo '<div class="blog-category ">';
                    echo ' <a href="'.esc_url( get_term_link( $adina_post_categories[0]->term_id ) ).'">'.esc_html( $adina_post_categories[0]->name ).'</a> ';
                echo '</div>';
            }
        }
    }
}

// Add Extra Class On Comment Reply Button
function adina_custom_comment_reply_link( $content ) {
    $extra_classes = 'replay-btn';
    return preg_replace( '/comment-reply-link/', 'comment-reply-link ' . $extra_classes, $content);
}

add_filter('comment_reply_link', 'adina_custom_comment_reply_link', 99);

// Add Extra Class On Edit Comment Link
function adina_custom_edit_comment_link( $content ) {
    $extra_classes = 'replay-btn';
    return preg_replace( '/comment-edit-link/', 'comment-edit-link ' . $extra_classes, $content);
}

add_filter('edit_comment_link', 'adina_custom_edit_comment_link', 99);


function adina_post_classes( $classes, $class, $post_id ) {
    if ( get_post_type() === 'post' ) {
        if( ! is_single() ){
            if( adina_opt( 'adina_blog_style' ) == '3' ){
                $classes[] = "fav-blog blog-grid grid-wide";
            }else{
                $classes[] = "fav-blog blog-single";
            }
        }else{
            $classes[] = "fav-blog blog-single";
        }
    }elseif( get_post_type() === 'product' ){
        // Return Class
    }elseif( get_post_type() === 'page' ){
        $classes[] = "page--item";
    }

    return $classes;
}
add_filter( 'post_class', 'adina_post_classes', 10, 3 );

