<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */


// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit;
}

function adina_widgets_init() {

    if( class_exists('ReduxFramework') ) {
        $adina_sidebar_widget_title_heading_tag = adina_opt('adina_sidebar_widget_title_heading_tag');
    } else {
        $adina_sidebar_widget_title_heading_tag = 'h3';
    }

    //sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'adina' ),
        'id'            => 'adina-blog-sidebar',
        'description'   => esc_html__( 'Add Blog Sidebar Widgets Here.', 'adina' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<'.esc_attr($adina_sidebar_widget_title_heading_tag).' class="widget_title">',
        'after_title'   => '</'.esc_attr($adina_sidebar_widget_title_heading_tag).'>',
    ) );

    // page sidebar widgets register
    register_sidebar( array(
        'name'          => esc_html__( 'Page Sidebar', 'adina' ),
        'id'            => 'adina-page-sidebar',
        'description'   => esc_html__( 'Add Page Sidebar Widgets Here.', 'adina' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget_title">',
        'after_title'   => '</h3>',
    ) );

}

add_action( 'widgets_init', 'adina_widgets_init' );