<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Enqueue scripts and styles.
 */
function adina_essential_scripts() {

	

    // google font
    wp_enqueue_style( 'adina-fonts', adina_google_fonts() ,array(), wp_get_theme()->get( 'Version' ) );

    // animate css
    wp_enqueue_style( 'animate-min', get_theme_file_uri( '/assets/css/animate.css' ) ,array(), wp_get_theme()->get( 'Version' ) );

    // Bootstrap 
    wp_enqueue_style( 'bootstrap', get_theme_file_uri( '/assets/css/bootstrap.css' ) ,array(), '5.2.3' );

    // Rangslider
    wp_enqueue_style( 'rangeslider', get_theme_file_uri( '/assets/css/ion.rangeSlider.min.css' ) ,array(), '1.13.2' );

    // magnific popup css
    wp_enqueue_style( 'magnific-popup', get_theme_file_uri( '/assets/css/magnific-popup.css' ) ,array(), wp_get_theme()->get( 'Version' ) );


    // main map css
    wp_enqueue_style( 'spacing', get_theme_file_uri( '/assets/css/spacing.css' ) ,array(), wp_get_theme()->get( 'Version' ) );

    // slick css
    wp_enqueue_style( 'slick', get_theme_file_uri( '/assets/css/slick.css' ) ,array(), wp_get_theme()->get( 'Version' ) );

    // swiper-gl.min
    wp_enqueue_style( 'swiper-gl.min', get_theme_file_uri( '/assets/css/swiper-gl.min.css' ) ,array(), wp_get_theme()->get( 'Version' ) );

    // fontawesome
    wp_enqueue_style( 'font-awesome-pro', get_theme_file_uri( '/assets/css/font-awesome-pro.css' ) ,array(), '6.0.0' );

    // swiper bundle
    wp_enqueue_style( 'swiper-bundle', get_theme_file_uri( '/assets/css/swiper-bundle.css' ) ,array(), '6.5.0' );

    // adina custom style
    wp_enqueue_style( 'adina-custom', get_theme_file_uri('/assets/css/adina-custom.css') ,array(), wp_get_theme()->get( 'Version' ) );

    // adina unit style
    wp_enqueue_style( 'adina-unit', get_theme_file_uri('/assets/css/adina-unit.css') ,array(), wp_get_theme()->get( 'Version' ) );

    // blog default style
    wp_enqueue_style( 'blog-default', get_theme_file_uri('/assets/css/blog-default.css') ,array(), wp_get_theme()->get( 'Version' ) );

    // adina main style
    wp_enqueue_style( 'adina-main-style', get_theme_file_uri('/assets/css/style.css') ,array(), wp_get_theme()->get( 'Version' ) );

    wp_enqueue_style( 'adina-style', get_stylesheet_uri() ,array(), wp_get_theme()->get( 'Version' ) );

    

    // Load Js =====

    // bootstrap-bundle
    wp_enqueue_script( 'bootstrap-bundle', get_theme_file_uri( '/assets/js/bootstrap-bundle.js' ), array( 'jquery' ), '5.1.3', true );

    // ajax-form
    wp_enqueue_script( 'ajax-form', get_theme_file_uri( '/assets/js/ajax-form.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // purecounter
    wp_enqueue_script( 'purecounter', get_theme_file_uri( '/assets/js/purecounter.js' ), array('jquery'), '1.5.0', true );

    // jquery appear
    wp_enqueue_script( 'jquery-appear', get_theme_file_uri( '/assets/js/jquery-appear.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // jquery knob
    wp_enqueue_script( 'jquery-knob', get_theme_file_uri( '/assets/js/jquery-knob.js' ), array( 'jquery' ), '1.2.10', true );

    // imagesloaded
    wp_enqueue_script( 'imagesloaded-pkgd', get_theme_file_uri( '/assets/js/imagesloaded-pkgd.js' ), array( 'jquery' ), '4.1.4', true );

    wp_enqueue_script( 'masonary-pkgd', get_theme_file_uri( '/assets/js/masonary.js' ), array( 'jquery' ), '4.2.2', true );

    // one page menu
    wp_enqueue_script( 'onpage-menu', get_theme_file_uri( '/assets/js/onpage-menu.js' ), array( 'jquery' ), '3.0.0', true );

    // parallax-scroll
    wp_enqueue_script( 'parallax-scroll', get_theme_file_uri( '/assets/js/parallax-scroll.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // parallax
    wp_enqueue_script( 'parallax', get_theme_file_uri( '/assets/js/parallax.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // swiper-bundle
    wp_enqueue_script( 'swiper-bundle', get_theme_file_uri( '/assets/js/swiper-bundle.js' ), array( 'jquery' ), '6.5.0', true );

    // slider-init
    wp_enqueue_script( 'slider-init', get_theme_file_uri( '/assets/js/slider-init.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // jquery magnific popup 
    wp_enqueue_script( 'magnific-popup', get_theme_file_uri( '/assets/js/magnific-popup.js' ), array( 'jquery' ), '1.1.0', true );

    // waypoints
    wp_enqueue_script( 'waypoints', get_theme_file_uri( '/assets/js/waypoints.js' ), array( 'jquery' ), '4.0.0', true );

    // wow
    wp_enqueue_script( 'wow', get_theme_file_uri( '/assets/js/wow.js' ), array( 'jquery' ), '1.1.3', true );

    // jquery nice select 
    wp_enqueue_script( 'nice-select', get_theme_file_uri( '/assets/js/nice-select.js' ), array( 'jquery' ), '1.0', true );

    // slick min
    wp_enqueue_script( 'slick', get_theme_file_uri( '/assets/js/slick.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // main js
    wp_enqueue_script( 'main-js', get_theme_file_uri( '/assets/js/main.js' ), array('jquery'), wp_get_theme()->get( 'Version' ), true );

    // comment reply
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'adina_essential_scripts',99 );


function adina_block_editor_assets( ) {
    // Add custom fonts.
	wp_enqueue_style( 'adina-editor-fonts', adina_google_fonts(), array(), null );
}

add_action( 'enqueue_block_editor_assets', 'adina_block_editor_assets' );
 
function adina_google_fonts() {
    $font_families = array(
        'Manrope:300,400,500,600,700,800',
        'Poppins:300,400,500,600,700,800',
        'Inter:300,400,500,600,700,800',
    );

    $familyArgs = array(
        'family' => urlencode( implode( '|', $font_families ) ),
        'subset' => urlencode( 'latin,latin-ext' ),
    );

    $fontUrl = add_query_arg( $familyArgs, '//fonts.googleapis.com/css' );

    return esc_url_raw( $fontUrl );
}