<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }


    // preloader hook function
    if( ! function_exists( 'adina_preloader_wrap_cb' ) ) {
        function adina_preloader_wrap_cb() {
            $preloader_display              =  adina_opt('adina_display_preloader');

            if( class_exists('ReduxFramework') ){
                if( $preloader_display ){
                    echo '<div id="preloader">';
                        echo '<div id="loader">';
                        echo '</div>';
                    echo '</div>';
                }
            }else{
                echo '<div id="preloader">';
                    echo '<div id="loader">';
                    echo '</div>';
                echo '</div>';
            }
        }
    }

    // Header Hook function
    if( !function_exists('adina_header_cb') ) {
        function adina_header_cb( ) {
            get_template_part('templates/header');
            get_template_part('templates/header-menu-bottom');
        }
    }

    // back top top hook function
    if( ! function_exists( 'adina_back_to_top_cb' ) ) {
        function adina_back_to_top_cb( ) {
            $backtotop_trigger = adina_opt('adina_display_bcktotop');
            $custom_bcktotop   = adina_opt('adina_custom_bcktotop');
            $custom_bcktotop_icon   = adina_opt('adina_custom_bcktotop_icon');
            if( class_exists( 'ReduxFramework' ) ) {
                if( $backtotop_trigger ) {
                    if( $custom_bcktotop ) {
                        echo '<!-- Back to Top Button -->';
                        echo '<a href="#" class="scrollToTop scroll-btn">';
                            echo '<i class="fa '.esc_attr( $custom_bcktotop_icon ).'"></i>';
                        echo '</a>';
                        echo '<!-- End of Back to Top Button -->';
                    } else {
                        echo '<!-- Back to Top Button -->';
                        echo '<a href="#" class="scrollToTop scroll-btn">';
                            echo '<i class="fas fa-arrow-up"></i>';
                        echo '</a>';
                        echo '<!-- End of Back to Top Button -->';
                    }
                }
            }

        }
    }

    // Blog Start Wrapper Function
    if( !function_exists('adina_blog_start_wrap_cb') ) {
        function adina_blog_start_wrap_cb() {
            echo '<div class="td-postbox-area pt-140">';
                echo '<div class="container">';
                    echo '<div class="row">';
        }
    }

    // Blog End Wrapper Function
    if( !function_exists('adina_blog_end_wrap_cb') ) {
        function adina_blog_end_wrap_cb() {
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }
    }

    // Blog Column Start Wrapper Function
    if( !function_exists('adina_blog_col_start_wrap_cb') ) {
        function adina_blog_col_start_wrap_cb() {
            if( class_exists('ReduxFramework') ) {
                $adina_blog_sidebar = adina_opt('adina_blog_sidebar');
                if( $adina_blog_sidebar == '2' && is_active_sidebar('adina-blog-sidebar') ) {
                    echo '<div class="col-xl-9 col-lg-8 mb-140 order-lg-last">';
                } elseif( $adina_blog_sidebar == '3' && is_active_sidebar('adina-blog-sidebar') ) {
                    echo '<div class="col-xl-9 col-lg-8 mb-140">';
                        echo '<div class="td-postbox-wrapper td-postbox-wrapper-space">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('adina-blog-sidebar') ) {
                    echo '<div class="col-xl-9 col-lg-8 mb-140">';
                        echo '<div class="td-postbox-wrapper td-postbox-wrapper-space">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }
    // Blog Column End Wrapper Function
    if( !function_exists('adina_blog_col_end_wrap_cb') ) {
        function adina_blog_col_end_wrap_cb() { 
				if( class_exists('ReduxFramework') ) {
					$adina_blog_sidebar = adina_opt('adina_blog_sidebar');
					if( $adina_blog_sidebar == '3' ){
						echo '</div>';
					}
				}else{
					echo '</div>';
				}
            echo '</div>';
        }
    }

    // Blog Sidebar
    if( !function_exists('adina_blog_sidebar_cb') ) {
        function adina_blog_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_blog_sidebar = adina_opt('adina_blog_sidebar');
            } else {
                $adina_blog_sidebar = 2;
            }
            if( $adina_blog_sidebar != 1 && is_active_sidebar('adina-blog-sidebar') ) {
                // Sidebar
                get_sidebar();
            }
        }
    }


    if( !function_exists('adina_blog_details_sidebar_cb') ) {
        function adina_blog_details_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_blog_single_sidebar = adina_opt('adina_blog_single_sidebar');
            } else {
                $adina_blog_single_sidebar = 4;
            }
            if( $adina_blog_single_sidebar != 1 ) {
                // Sidebar
                get_sidebar();
            }

        }
    }

    // Blog Pagination Function
    if( !function_exists('adina_blog_pagination_cb') ) {
        function adina_blog_pagination_cb( ) {
            get_template_part('templates/pagination');
        }
    }

    // Blog Content Function
    if( !function_exists('adina_blog_content_cb') ) {
        function adina_blog_content_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_blog_grid = adina_opt('adina_blog_grid');
            } else {
                $adina_blog_grid = '1';
            }

            if( $adina_blog_grid == '1' ) {
                $adina_blog_grid_class = 'col-lg-12';
            } elseif( $adina_blog_grid == '2' ) {
                $adina_blog_grid_class = 'col-sm-6';
            } else {
                $adina_blog_grid_class = 'col-lg-4 col-sm-6';
            }

            echo '<div class="row">';
                if( have_posts() ) {
                    while( have_posts() ) {
                        the_post();
                        echo '<div class="'.esc_attr($adina_blog_grid_class).'">';
                            get_template_part('templates/content',get_post_format());
                        echo '</div>';
                    }
                    wp_reset_postdata();
                } else{
                    get_template_part('templates/content','none');
                }
            echo '</div>';
        }
    }

    // footer content Function
    if( !function_exists('adina_footer_content_cb') ) {
        function adina_footer_content_cb( ) {

            if( class_exists('ReduxFramework') && did_action( 'elementor/loaded' )  ){
                if( is_page() || is_page_template('template-builder.php') ) {
                    $post_id = get_the_ID();

                    // Get the page settings manager
                    $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

                    // Get the settings model for current post
                    $page_settings_model = $page_settings_manager->get_model( $post_id );

                    // Retrieve the Footer Style
                    $footer_settings = $page_settings_model->get_settings( 'adina_footer_style' );

                    // Footer Local
                    $footer_local = $page_settings_model->get_settings( 'adina_footer_builder_option' );

                    // Footer Enable Disable
                    $footer_enable_disable = $page_settings_model->get_settings( 'adina_footer_choice' );

                    if( $footer_enable_disable == 'yes' ){
                        if( $footer_settings == 'footer_builder' ) {
                            // local options
                            $adina_local_footer = get_post( $footer_local );
                            echo '<footer>';
                            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $adina_local_footer->ID );
                            echo '</footer>';
                        } else {
                            // global options
                            $adina_footer_builder_trigger = adina_opt('adina_footer_builder_trigger');
                            if( $adina_footer_builder_trigger == 'footer_builder' ) {
                                echo '<footer>';
                                $adina_global_footer_select = get_post( adina_opt( 'adina_footer_builder_select' ) );
                                $footer_post = get_post( $adina_global_footer_select );
                                echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                                echo '</footer>';
                            } else {
                                // wordpress widgets
                                adina_footer_global_option();
                            }
                        }
                    }
                } else {
                    // global options
                    $adina_footer_builder_trigger = adina_opt('adina_footer_builder_trigger');
                    if( $adina_footer_builder_trigger == 'footer_builder' ) {
                        echo '<footer>';
                        $adina_global_footer_select = get_post( adina_opt( 'adina_footer_builder_select' ) );
                        $footer_post = get_post( $adina_global_footer_select );
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                        echo '</footer>';
                    } else {
                        // wordpress widgets
                        adina_footer_global_option();
                    }
                }
            } else {
                echo '<div class="footer-copyright text-center bg-black py-3 link-inherit z-index-common">';
                    echo '<div class="container">';
                        echo '<p class="mb-0 text-white">'.sprintf( 'Copyright <i class="fas fa-copyright"></i> %s <a href="%s">%s</a> All Rights Reserved by <a href="%s">%s</a>',date('Y'),esc_url('#'),__( 'Adina.','adina' ),esc_url('#'),__( 'Themedox', 'adina' ) ).'</p>';
                    echo '</div>';
                echo '</div>';
            }

        }
    }

    // blog details wrapper start hook function
    if( !function_exists('adina_blog_details_wrapper_start_cb') ) {
        function adina_blog_details_wrapper_start_cb( ) {
            echo '<div class="td-postbox-area pt-140">';
                echo '<div class="container">';
                    echo '<div class="row">';
        }
    }

    // blog details column start hook function
    if( !function_exists('adina_blog_details_col_start_cb') ) {
        function adina_blog_details_col_start_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_blog_single_sidebar = adina_opt('adina_blog_single_sidebar');
                if( $adina_blog_single_sidebar == '2' && is_active_sidebar('adina-blog-sidebar') ) {
                    echo '<div class="col-xl-9 col-lg-8 mb-140 order-last">';
                } elseif( $adina_blog_single_sidebar == '3' && is_active_sidebar('adina-blog-sidebar') ) {
                    echo '<div class="col-xl-9 col-lg-8 mb-140">';
                        echo '<div class="td-postbox-wrapper td-postbox-wrapper-space td-postbox-wrapper-space-2">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('adina-blog-sidebar') ) {
                    echo '<div class="col-xl-9 col-lg-8 mb-140">';
                        echo '<div class="td-postbox-wrapper td-postbox-wrapper-space td-postbox-wrapper-space-2">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }

    // blog details post meta hook function
    if( !function_exists('adina_blog_post_meta_cb') ) {
        function adina_blog_post_meta_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_display_post_date      =  adina_opt('adina_display_post_date');
                $adina_display_post_author    =  adina_opt('adina_display_post_author');
                $adina_display_post_comments    =  adina_opt('adina_display_post_comments');

            } else {
                $adina_display_post_date      = '1';
                $adina_display_post_author    = '1';
                $adina_display_post_comments    = '1';
            }

            echo '<!-- Blog Meta -->';
            echo '<div class="td-postbox-meta">';
                if( $adina_display_post_author ){
                    echo '<div class="td-postbox-user">';
                        echo '<a href="' . esc_url( get_author_posts_url( get_the_author_meta('ID') ) ) . '">';
                            echo '<img src="' . esc_url( get_avatar_url( get_the_author_meta('ID'), array('size' => 150) ) ) . '" alt="' . esc_attr( get_the_author() ) . '">';
                            echo 'By <span>' . esc_html( ucwords( get_the_author() ) ) . '</span>';
                        echo '</a>';
                    echo '</div>';
                }

                echo '<div class="td-postbox-meta-here">';
                    // Date start  
                    if( $adina_display_post_date ) {
                        $date_url = get_day_link( get_the_time('Y'), get_the_time('m'), get_the_time('d') ); // Generate the link for the post date
                        echo '<span><i class="fa-light fa-calendar-days"></i> <a href="' . esc_url( $date_url ) . '">' . esc_html( get_the_date() ) . '</a></span>';
                    }
                    // Date end

                    // Comments start  
                    if( $adina_display_post_comments ){
                        if( get_comments_number() == 1 ){
                            $comment_text = __( 'Comment', 'adina' );
                        }else{
                            $comment_text = __( 'Comments', 'adina' );
                        }
                        echo '<span><i class="fa-light fa-comment-dots"></i><a href="'.esc_url( get_comments_link( get_the_ID() ) ).'">'.esc_html( get_comments_number() ).' '.$comment_text.'</a></span>';
                    }
                    // Comments end

                echo '</div>';
            echo '</div>';

        }
    }

    // blog details share options hook function
    if( !function_exists('adina_blog_details_share_options_cb') ) {
        function adina_blog_details_share_options_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_post_details_share_options = adina_opt('adina_post_details_share_options');
            } else {
                $adina_post_details_share_options = false;
            }
            if( function_exists( 'adina_social_sharing_buttons' ) && $adina_post_details_share_options ) {
                echo '<div class="blog-details__tag-share-share">';
                    echo '<div class="title"><h3>'.esc_html__( 'Share:', 'adina' ).'</h3></div>';
                    echo '<ul class="social-links">';
                        echo adina_social_sharing_buttons();
                    echo '</ul>';
                echo '</div>';
            }
        }
    }

    // blog details post navigation hook function
    if( !function_exists('adina_blog_details_post_navigation_cb') ) {
        function adina_blog_details_post_navigation_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_post_details_post_navigation = adina_opt('adina_post_details_post_navigation');
            } else {
                $adina_post_details_post_navigation = true;
            }

            $prevpost = get_previous_post();
            $nextpost = get_next_post();

            if( $adina_post_details_post_navigation && ! empty( $prevpost ) || !empty( $nextpost ) ) {
                echo '<!-- Post Navigation -->';
                echo '<div class="post-pagination">';
                    echo '<div class="row justify-content-between align-items-center">';
                        echo '<div class="col-6">';
                        if( ! empty( $prevpost ) ) {
                            echo '<!-- Nav Previous -->';
                            
                            echo '<div class="post-pagi-box prev">';
                                echo '<a href="'.esc_url( get_permalink( $prevpost->ID ) ).'">';
                                    echo  '<i class="fas fa-angle-double-left"></i>';
                                    echo esc_html__( 'Previous Post', 'adina' );
                                echo '</a>';
                            echo '</div>';
                        }
                        echo '</div>';
                        echo '<!-- End Nav Previous -->';
                        
                        echo '<div class="col-6">';
                        if( !empty( $nextpost ) ) {
                                echo '<div class="post-pagi-box next">';
                                    echo '<a href="'.esc_url( get_permalink( $nextpost->ID ) ).'">';
                                        echo  '<i class="fas fa-angle-double-right"></i>';
                                        echo esc_html__( 'Next Post', 'adina' );
                                    echo '</a>';
                                echo '</div>';
                            }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
                echo '<!-- End Post Navigation -->';
            }
        }
    }
    // blog details author bio hook function
    if( !function_exists('adina_blog_details_author_bio_cb') ) {
        function adina_blog_details_author_bio_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $postauthorbox =  adina_opt( 'adina_post_details_author_desc_trigger' );
            } else {
                $postauthorbox = '1';
            }
            if( !empty( get_the_author_meta('description')  ) && $postauthorbox == '1' ) {
                echo '<!-- Post Author -->';
                echo '<div class="blog-author">';
                    echo '<!-- Author Thumb -->';
                    echo '<div class="media-img">';
                        echo adina_img_tag( array(
                            "url"   => esc_url( get_avatar_url( get_the_author_meta('ID'), array(
                            "size"  => 189
                            ) ) ),
                        ) );
                    echo '</div>';
                    echo '<!-- End of Author Thumb -->';
                    echo '<div class="media-body">';
                        echo adina_heading_tag( array(
                            "tag"   => "h3",
                            "text"  => adina_anchor_tag( array(
                                "text"  => esc_html( ucwords( get_the_author() ) ),
                                "url"   => esc_url( get_author_posts_url( get_the_author_meta('ID') ) ),
                                'class' => 'text-inherit',
                            ) ),
                            'class' => 'author-name h4',
                        ) );
                        
                        if( ! empty( get_the_author_meta('description') ) ) {
                            echo '<p class="author-text">';
                                echo esc_html( get_the_author_meta('description') );
                            echo '</p>';
                        };
                        if( function_exists( 'adina_social_icon' ) ){
                            adina_social_icon();
                        }
                    echo '</div>';
                echo '</div>';
                echo '<!-- End of Post Author -->';
            }

        }
    }

    // Blog Details Comments hook function
    if( !function_exists('adina_blog_details_comments_cb') ) {
        function adina_blog_details_comments_cb( ) {
            if ( ! comments_open() ) {
                echo '<div class="blog-comment-area">';
                    echo adina_heading_tag( array(
                        "tag"   => "h3",
                        "text"  => esc_html__( 'Comments are closed', 'adina' ),
                        "class" => "inner-title"
                    ) );
                echo '</div>';
            }

            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
        }
    }

    // Blog Details Related Post hook function
    if( !function_exists('adina_blog_details_related_post_cb') ) {
        function adina_blog_details_related_post_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_excerpt_length = '4';
                $adina_post_details_related_post = adina_opt('adina_post_details_related_post');
            } else {
                $adina_excerpt_length = '4';
                $adina_post_details_related_post = false;
            }
            $relatedpost = new WP_Query( array(
                "post_type"         => "post",
                "posts_per_page"    => "3",
                "category__in"      => wp_get_post_categories(get_the_ID()),
                "post__not_in"      =>  array( get_the_ID() )
            ) );
            if( $relatedpost->have_posts() && $adina_post_details_related_post ) {
                echo '<!-- Related Post -->';
                echo '<div class="related-post-wrapper pt-40">';
                    echo '<h2 class="inner-title1 h1">'.esc_html__( 'Relatetd', 'adina' ).' <span class="text-theme">'.esc_html__( 'Post', 'adina' ).'</span></h2>';
                    echo '<div class="row text-center">';
                        while( $relatedpost->have_posts() ) {
                            $relatedpost->the_post();
                            echo '<div class="col-lg-4">';
                                echo '<!-- Single Post -->';
                                echo '<div class="fav-blog blog-grid">';
                                    if( has_post_thumbnail(  ) ){
                                        the_post_thumbnail( 'adina-related-post-size', [ 'class'  => 'w-100' ] );
                                    }
                                    echo '<div class="blog-standard-page__single-content">';
                                        if( get_the_title() ){
                                            echo '<!-- Post Title -->';
                                            echo '<h4 class="blog-title fw-semibold"><a href="'.esc_url( get_permalink() ).'">'.esc_html( wp_trim_words( get_the_title(), '3', '' ) ).'</a></h4>';
                                            echo '<!-- End Post Title -->';
                                        }
                                        echo '<span><a href="'.esc_url( adina_blog_date_permalink() ).'">';
                                            echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
                                        echo '</a></span>';
                                        echo '<span>';
                                            echo adina_getPostViews( get_the_ID() );
                                            echo esc_html__( ' Views', 'adina' );
                                        echo '</span>';
                                    echo '</div>';
                                echo '</div>';
                                echo '<!-- End Single Post -->';
                            echo '</div>';
                        }
                        wp_reset_postdata();
                    echo '</div>';
                echo '</div>';
                echo '<!-- End Related Post -->';
            }
        }
    }

    // Blog Details Column end hook function
    if( !function_exists('adina_blog_details_col_end_cb') ) {
        function adina_blog_details_col_end_cb( ) {
                  echo '</div>';
                echo '</div>';
        }
    }

    // Blog Details Wrapper end hook function
    if( !function_exists('adina_blog_details_wrapper_end_cb') ) {
        function adina_blog_details_wrapper_end_cb( ) {
			  
                echo '</div>';
            echo '</div>';
        }
    }

    // page start wrapper hook function
    if( !function_exists('adina_page_start_wrap_cb') ) {
        function adina_page_start_wrap_cb( ) {
            if( is_page( 'cart' ) ){
                $section_class = "fav-cart-wrapper space-top space-extra-bottom";
            }elseif( is_page( 'checkout' ) ){
                $section_class = "fav-checkout-wrapper space-top space-extra-bottom";
            }else{
                $section_class = "space-top space-extra-bottom";
            }
            echo '<section class="'.esc_attr( $section_class ).'">';
                echo '<div class="content-block">';
                    echo '<div class="container">';
                        echo '<div class="row">';
        }
    }

    // page wrapper end hook function
    if( !function_exists('adina_page_end_wrap_cb') ) {
        function adina_page_end_wrap_cb( ) {
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page column wrapper start hook function
    if( !function_exists('adina_page_col_start_wrap_cb') ) {
        function adina_page_col_start_wrap_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_page_sidebar = adina_opt('adina_page_sidebar');
            }else {
                $adina_page_sidebar = '1';
            }
            if( $adina_page_sidebar == '2' && is_active_sidebar('adina-page-sidebar') ) {
                echo '<div class="col-lg-8 order-last">';
            } elseif( $adina_page_sidebar == '3' && is_active_sidebar('adina-page-sidebar') ) {
                echo '<div class="col-lg-8">';
            } else {
                echo '<div class="col-lg-12">';
            }

        }
    }

    // page column wrapper end hook function
    if( !function_exists('adina_page_col_end_wrap_cb') ) {
        function adina_page_col_end_wrap_cb( ) {
            echo '</div>';
        }
    }

    // page sidebar hook function
    if( !function_exists('adina_page_sidebar_cb') ) {
        function adina_page_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $adina_page_sidebar = adina_opt('adina_page_sidebar');
            }else {
                $adina_page_sidebar = '1';
            }

            if( class_exists('ReduxFramework') ) {
                $adina_page_layoutopt = adina_opt('adina_page_layoutopt');
            }else {
                $adina_page_layoutopt = '3';
            }

            if( $adina_page_layoutopt == '1' && $adina_page_sidebar != 1 ) {
                get_sidebar('page');
            } elseif( $adina_page_layoutopt == '2' && $adina_page_sidebar != 1 ) {
                get_sidebar();
            }
        }
    }

    // page content hook function
    if( !function_exists('adina_page_content_cb') ) {
        function adina_page_content_cb( ) {
            echo '<div class="page--content clearfix">';

                the_content();

                // Link Pages
                adina_link_pages();

            echo '</div>';
            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }

        }
    }


    // Blog Post Thumb hook function start
    if( !function_exists('adina_blog_post_thumb_cb') ) {
        function adina_blog_post_thumb_cb( ) {
            if( get_post_format() ) {
                $format = get_post_format();
            }else{
                $format = 'standard';
            }

            $adina_post_slider_thumbnail = adina_meta( 'post_format_slider' );

            if( !empty( $adina_post_slider_thumbnail ) ){
                    echo '<div class="td-postbox-thumb p-relative mb-40 fav-carousel" data-arrows="true" data-slide-show="1" data-fade="true">';
                        // Category
                        if( class_exists('ReduxFramework') ) {
                            $adina_display_post_category   =  adina_opt('adina_display_post_category');
            
                        } else {
                            $adina_display_post_category   = '1';
                        }
                        if( $adina_display_post_category ){
                            $category = get_the_category(); // Get the category object for the current post.
                            if (!empty($category)) {
                                echo '<span class="td-postbox-badge">';
                                    echo esc_html($category[0]->name); // Output the category name.
                                echo '</span>';
                            }
                        }

                        echo '<div class="td-postbox-slider swiper-container p-relative">';
                            echo '<div class="swiper-wrapper">';
                                foreach( $adina_post_slider_thumbnail as $single_image ){
                                    echo '<div class="td-postbox-slider-item swiper-slide">';
                                        echo adina_img_tag( array(
                                            'url'   => esc_url( $single_image )
                                        ) );
                                    echo '</div>';
                                }
                            echo '</div>';
                            echo '<div class="td-postbox-nav">';
                                echo '<button class="td-postbox-slider-button-next"><i class="fa-regular fa-angle-right"></i></button>';
                                echo '<button class="td-postbox-slider-button-prev"><i class="fa-regular fa-angle-left"></i></button>';
                            echo '</div>';
                        echo '</div>';

                    echo '</div>';
            }elseif( has_post_thumbnail() && $format == 'standard' ) {
                echo '<!-- Post Thumbnail -->';
                echo '<div class="td-postbox-thumb p-relative mb-40">';
                    the_post_thumbnail();

                    // Category
                    if( class_exists('ReduxFramework') ) {
                        $adina_display_post_category   =  adina_opt('adina_display_post_category');
        
                    } else {
                        $adina_display_post_category   = '1';
                    }
                    if( $adina_display_post_category ){
                        $category = get_the_category(); // Get the category object for the current post.
                        if (!empty($category)) {
                            echo '<span class="td-postbox-badge">';
                                echo esc_html($category[0]->name); // Output the category name.
                            echo '</span>';
                        }
                    }
                   
                echo '</div>';
                echo '<!-- End Post Thumbnail -->';
            }elseif( $format == 'video' ){
                if( has_post_thumbnail() && !empty ( adina_meta( 'post_format_video' ) ) ){
                    echo '<div class="blog-video td-postbox-thumb p-relative mb-40">';
                        the_post_thumbnail();

                        // Category
                        if( class_exists('ReduxFramework') ) {
                            $adina_display_post_category   =  adina_opt('adina_display_post_category');
            
                        } else {
                            $adina_display_post_category   = '1';
                        }
                        if( $adina_display_post_category ){
                            $category = get_the_category(); // Get the category object for the current post.
                            if (!empty($category)) {
                                echo '<span class="td-postbox-badge">';
                                    echo esc_html($category[0]->name); // Output the category name.
                                echo '</span>';
                            }
                        }

                        echo '<div class="td-video-7-popup">';
                            echo '<a href="'.esc_url( adina_meta( 'post_format_video' ) ).'" class="td-video-play td-video-5-play popup-video td-pulse-border">';
                                echo '<span class="p-relative z-index-11">';
                                    echo    '<svg width="14" height="20" viewBox="0 0 14 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M14 10L0 20V0L14 10Z" fill="currentColor" />
                                            </svg>';
                                echo '</span>';
                            echo '</a>';
                        echo '</div>';
                       
                    echo '</div>';
                }elseif( ! has_post_thumbnail() && ! is_single() ){
                    echo '<div class="blog-video td-postbox-thumb p-relative mb-40">';
                        the_post_thumbnail();

                        // Category
                        if( class_exists('ReduxFramework') ) {
                            $adina_display_post_category   =  adina_opt('adina_display_post_category');
            
                        } else {
                            $adina_display_post_category   = '1';
                        }
                        if( $adina_display_post_category ){
                            $category = get_the_category(); // Get the category object for the current post.
                            if (!empty($category)) {
                                echo '<span class="td-postbox-badge">';
                                    echo esc_html($category[0]->name); // Output the category name.
                                echo '</span>';
                            }
                        }
                       
                    echo '</div>';
                }
            }elseif( $format == 'audio' ){
                $adina_audio = adina_meta( 'post_format_audio' );
                if( !empty( $adina_audio ) ){
                    echo '<div class="blog-audio td-postbox-thumb p-relative mb-40">';
                            echo wp_oembed_get( $adina_audio );
                    echo '</div>';
                }elseif( !is_single() ){
                    echo '<div class="blog-audio td-postbox-thumb p-relative mb-40">';
                            echo adina_embedded_media( array( 'audio', 'iframe' ) );
                    echo '</div>';
                }
            }

        }
    }
    // Blog Post Thumb hook function end

    // Blog Post Details Thumb hook function start
    if( !function_exists('adina_blog_post_details_thumb_cb') ) {
        function adina_blog_post_details_thumb_cb( ) {
            if( get_post_format() ) {
                $format = get_post_format();
            }else{
                $format = 'standard';
            }

            $adina_post_slider_thumbnail = adina_meta( 'post_format_slider' );

            if( !empty( $adina_post_slider_thumbnail ) ){
                    echo '<div class="td-postbox-thumb mb-60 fav-carousel" data-arrows="true" data-slide-show="1" data-fade="true">';
                        // Category
                        if( class_exists('ReduxFramework') ) {
                            $adina_display_post_category   =  adina_opt('adina_display_post_category');
            
                        } else {
                            $adina_display_post_category   = '1';
                        }
                        if( $adina_display_post_category ){
                            $category = get_the_category(); // Get the category object for the current post.
                            if (!empty($category)) {
                                echo '<span class="td-postbox-badge">';
                                    echo esc_html($category[0]->name); // Output the category name.
                                echo '</span>';
                            }
                        }

                        echo '<div class="td-postbox-slider swiper-container p-relative">';
                            echo '<div class="swiper-wrapper">';
                                foreach( $adina_post_slider_thumbnail as $single_image ){
                                    echo '<div class="td-postbox-slider-item swiper-slide">';
                                        echo adina_img_tag( array(
                                            'url'   => esc_url( $single_image )
                                        ) );
                                    echo '</div>';
                                }
                            echo '</div>';
                            echo '<div class="td-postbox-nav">';
                                echo '<button class="td-postbox-slider-button-next"><i class="fa-regular fa-angle-right"></i></button>';
                                echo '<button class="td-postbox-slider-button-prev"><i class="fa-regular fa-angle-left"></i></button>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
            }elseif( has_post_thumbnail() && $format == 'standard' ) {
                echo '<!-- Post Thumbnail -->';
                echo '<div class="td-postbox-thumb mb-60">';
                    the_post_thumbnail();
                echo '</div>';
                echo '<!-- End Post Thumbnail -->';
            }elseif( $format == 'video' ){
                if( has_post_thumbnail() && !empty ( adina_meta( 'post_format_video' ) ) ){
                    echo '<div class="blog-video td-postbox-thumb p-relative mb-60">';
                        the_post_thumbnail();

                        echo '<div class="td-video-7-popup">';
                            echo '<a href="'.esc_url( adina_meta( 'post_format_video' ) ).'" class="td-video-play td-video-5-play popup-video td-pulse-border">';
                                echo '<span class="p-relative z-index-11">';
                                    echo    '<svg width="14" height="20" viewBox="0 0 14 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M14 10L0 20V0L14 10Z" fill="currentColor" />
                                            </svg>';
                                echo '</span>';
                            echo '</a>';
                        echo '</div>';
                    echo '</div>';
                }elseif( ! has_post_thumbnail() && ! is_single() ){
                    echo '<div class="blog-video td-postbox-thumb p-relative mb-60">';
                        the_post_thumbnail();

                        echo '<div class="td-video-7-popup">';
                            echo '<a href="'.esc_url( adina_meta( 'post_format_video' ) ).'" class="td-video-play td-video-5-play popup-video td-pulse-border">';
                                echo '<span class="p-relative z-index-11">';
                                    echo    '<svg width="14" height="20" viewBox="0 0 14 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M14 10L0 20V0L14 10Z" fill="currentColor" />
                                            </svg>';
                                echo '</span>';
                            echo '</a>';
                        echo '</div>';
                    echo '</div>';
                }
            }elseif( $format == 'audio' ){
                $adina_audio = adina_meta( 'post_format_audio' );
                if( !empty( $adina_audio ) ){
                    echo '<div class="blog-audio td-postbox-thumb mb-60">';
                            echo wp_oembed_get( $adina_audio );
                    echo '</div>';
                }elseif( !is_single() ){
                    echo '<div class="blog-audio td-postbox-thumb mb-60">';
                            echo adina_embedded_media( array( 'audio', 'iframe' ) );
                    echo '</div>';
                }
            }

        }
    }
    // Blog Post Details Thumb hook function end


    if( !function_exists( 'adina_blog_post_content_cb' ) ) {
        function adina_blog_post_content_cb( ) {
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
                'sup'       => array(),
                'sub'       => array(),
            );
            echo '<!-- blog-content -->';

            echo '<div class="td-postbox-content">';

                if( ! is_single() ){
                    // Post Title
                    echo '<h2 class="td-postbox-title mb-25"><a href="'.esc_url( get_permalink() ).'">'.wp_kses( get_the_title(), $allowhtml ).'</a></h2>';
                }

                // Excerpt And Read More Button
                do_action( 'adina_blog_postexcerpt_read_content' );

                // Blog Post Meta
                do_action( 'adina_blog_post_meta' );

            echo '</div>';
            echo '<!-- End Post Content -->';
        }
    }

    if( ! function_exists( 'adina_blog_postexcerpt_read_content_cb') ) {
        function adina_blog_postexcerpt_read_content_cb( ) {
            if( class_exists( 'ReduxFramework' ) ) {
                $adina_excerpt_length = adina_opt('adina_blog_postExcerpt');
            } else {
                $adina_excerpt_length = '24';
            }
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );

            echo '<!-- Post Summary -->';
            echo '<div class="td-postbox-text mb-20 pb-15"><p>' . 
                wp_kses( wp_trim_words( get_the_excerpt(), $adina_excerpt_length, '' ), $allowhtml ) . 
                '</p></div>';                     
            echo '<!-- End Post Summary -->';
        }
    }