<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    adina_setPostViews( get_the_ID() );

    ?>
    <div <?php post_class(); ?> >
    <?php
        if( class_exists('ReduxFramework') ) {
            $adina_post_details_title_position = adina_opt('adina_post_details_title_position');
        } else {
            $adina_post_details_title_position = 'header';
        }

        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array(),
                'class'     => array(),
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );

            // Blog Post Thumbnail
            do_action( 'adina_blog_post_details_thumb' );

            //title
            if( $adina_post_details_title_position != 'header' ) {
                echo '<h2 class="blog-title">'.wp_kses( get_the_title(), $allowhtml ).'</h2>';
            }

            // Blog COntent
            the_content();
            // Link Pages
            adina_link_pages();

            $adina_post_tag = get_the_tags();

            if( class_exists('ReduxFramework') ) {
                $adina_post_details_share_options = adina_opt('adina_post_details_share_options');
            } else {
                $adina_post_details_share_options = false;
            }

            if( ! empty( $adina_post_tag ) || ( function_exists( 'adina_social_sharing_buttons' ) && $adina_post_details_share_options ) ){
                echo '<!-- Share Links Area -->';
                echo '<div class="blog-details__tag-share">';
                    echo '<div class="blog-details__tag-share-tag">';
                        if ($adina_post_tag !== false && is_array($adina_post_tag)) {
                            if (count($adina_post_tag) > 1) {
                                $tag_text = __('Tags:', 'adina');
                            } elseif (count($adina_post_tag) === 1) {
                                $tag_text = __('Tag:', 'adina');
                            } else {
                                $tag_text = __('No Tags', 'adina');
                            }
                        } else {
                            // Handle cases where $adina_post_tag is false or not an array
                            // For example, you could set a default value for $tag_text
                            $tag_text = __('No Tags', 'adina');
                        }
                    

                        echo '<div class="title"><h3>'.$tag_text.'</h3></div>';
                        echo '<ul>';
                            if ($adina_post_tag !== false && is_array($adina_post_tag)) {
                                foreach( $adina_post_tag as $tags ){
                                    echo '<li><a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a></li>';
                                }
                            } else {
                                // Handle the case where $adina_post_tag is false or not an array
                            }
                        echo '</ul>';
                    echo '</div>';
                    /**
                    *
                    * Hook for Blog Details Share Options
                    *
                    * Hook adina_blog_details_share_options
                    *
                    * @Hooked adina_blog_details_share_options_cb 10
                    *
                    */
                    do_action( 'adina_blog_details_share_options' );
                echo '</div>';
            }
            
            do_action( 'adina_blog_details_comments' );




        
    echo '</div>';

    /**
    *
    * Hook for Blog Details Post Navigation Options
    *
    * Hook adina_blog_details_post_navigation
    *
    * @Hooked adina_blog_details_post_navigation_cb 10
    *
    */
    // do_action( 'adina_blog_details_post_navigation' );

    /**
    *
    * Hook for Blog Details Author Bio
    *
    * Hook adina_blog_details_author_bio
    *
    * @Hooked adina_blog_details_author_bio_cb 10
    *
    */
    do_action( 'adina_blog_details_author_bio' );

    /**
    *
    * Hook for Blog Details Related Post
    *
    * Hook adina_blog_details_related_post
    *
    * @Hooked adina_blog_details_related_post_cb 10
    *
    */
    do_action( 'adina_blog_details_related_post' );
