<?php
/**
 * @Packge     : Adina
 * @Version    : 1.0
 * @Author     : Themedox
 * @Author URI : https://www.themedox.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $adina_post_id = get_the_ID();

            // Get the page settings manager
            $adina_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $adina_page_settings_model = $adina_page_settings_manager->get_model( $adina_post_id );

            // Retrieve the color we added before
            $adina_header_style = $adina_page_settings_model->get_settings( 'adina_header_style' );
            $adina_header_builder_option = $adina_page_settings_model->get_settings( 'adina_header_builder_option' );

            if( $adina_header_style == 'header_builder'  ) {

                if( !empty( $adina_header_builder_option ) ) {
                    $adinaheader = get_post( $adina_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $adinaheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $adina_header_builder_trigger = adina_opt('adina_header_options');
                if( $adina_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $adina_global_header_select = get_post( adina_opt( 'adina_header_select_options' ) );
                    $header_post = get_post( $adina_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    adina_global_header_option();
                }
            }
        } else {
            $adina_header_options = adina_opt('adina_header_options');
            if( $adina_header_options == '1' ) {
                adina_global_header_option();
            } else {
                $adina_header_select_options = adina_opt('adina_header_select_options');
                $adinaheader = get_post( $adina_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $adinaheader->ID );
                echo '</header>';
            }
        }
    } else {
        adina_global_header_option();
    }