<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Footer Menu Widget .
 *
 */
class Adina_Footer_Menu extends Widget_Base {

	public function get_name() {
		return 'adinafootermenu';
	}

	public function get_title() {
		return __( 'Footer Menu', 'adina' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'footer_menu_section',
			[
				'label' 	=> __( 'Footer Menu', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'menu_text',
			[
				'label' 	=> __( 'Text', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Login', 'adina' )
			]
        );
        
        $repeater->add_control(
            'text_link',
            [
                'label' 		=> __( 'Link', 'adina' ),
                'type' 			=> Controls_Manager::URL,
                'placeholder' 	=> __( 'https://your-link.com', 'adina' ),
                'show_external' => true,
                'default' 		=> [
                    'url' 			=> '#',
                    'is_external' 	=> true,
                    'nofollow' 		=> true,
                ],
            ]
        );


		$this->add_control(
			'menu_texts',
			[
				'label' 		=> __( 'Footer Menus', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'menu_text'    => __( 'Volunteer', 'adina' ),
						'text_link'    => __( '#', 'adina' ),

					]
                ],
                'title_field' 	=> '{{{ menu_text }}}',
			]
		);
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'footer_menu_style',
			[
				'label' 	=> __( 'Style', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'menu_text_typography',
				'label' 		=> __( 'Menu Typography', 'adina' ),
                'selector' 		=> '{{WRAPPER}} .footer-widget.widget_nav_menu a',
			]
		);

        $this->add_control(
			'menu_text_color',
			[
				'label'     => __( 'Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-widget.widget_nav_menu a' => 'color: {{VALUE}}!important',
                ],
			]
        );
        $this->add_control(
			'menu_text_color_hover',
			[
				'label'     => __( 'Hover Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-widget.widget_nav_menu a:hover' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_control(
			'menu_text_color_icon',
			[
				'label'     => __( 'Icon Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-widget.widget_nav_menu a:before' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->end_controls_section();



	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        
        ?>
            <div class="widget widget_nav_menu  footer-widget">
                <div class="menu-all-pages-container footer-menu">
                    <ul class="menu">
                        <?php foreach( $settings[ 'menu_texts' ] as $menu_text ): 
                            $target = $menu_text['text_link']['is_external'] ? ' target="_blank"' : '';
                            $nofollow = $menu_text['text_link']['nofollow'] ? ' rel="nofollow"' : '';
                            ?>
                            <li><a <?php echo $target; ?> <?php echo $nofollow; ?> href="<?php echo esc_url( $menu_text[ 'text_link' ]['url'] ); ?>">
                                <?php echo esc_html( $menu_text[ 'menu_text' ] ); ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php
	}
}
$widgets_manager->register( new \Adina_Footer_Menu() );