<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Gallery Image Widget .
 *
 */
class Adina_Gallery_Image extends Widget_Base {

	public function get_name() {
		return 'adinagalleryimage';
	}

	public function get_title() {
		return __( 'Footer Gallery', 'adina' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'gallery_image_section',
			[
				'label' 	=> __( 'Gallery Image', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'gallery_image',
			[
				'label' 	=> __( 'Gallery Image', 'adina' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'gallery',
			[
				'label' 		=> __( 'Gallery Images', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
					[
						'gallery_image' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

	
			echo '<div class="sidebar-gallery">';
				if( ! empty( $settings['gallery'] ) ){
					foreach( $settings['gallery'] as $singlelogo ) {
						echo '<div class="gallery-thumb">';
							echo '<img class="w-100" src="'.esc_url( $singlelogo['gallery_image']['url'] ).'" alt="'.esc_attr( adina_image_alt( $singlelogo['gallery_image']['url']) ).'">';
							echo '<a class="popup-image gal-btn"  href="'.esc_url( $singlelogo['gallery_image']['url'] ).'"><i class="fal fa-plus"></i></a>';
						echo '</div>';
					}
				}
			echo '</div>';
		
	}
}
$widgets_manager->register( new \Adina_Gallery_Image() );