<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Icons_Manager;;
use \Elementor\Repeater;
/**
 *
 * Footer Menu Widget .
 *
 */
class Adina_Social_Links extends Widget_Base {

	public function get_name() {
		return 'adina_footer_social';
	}

	public function get_title() {
		return __( 'Social Links', 'adina' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'social_section',
			[
				'label' 	=> __( 'Social Links', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' => __( 'Icon', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
        
        $repeater->add_control(
            'social_link',
            [
                'label' 		=> __( 'Url', 'adina' ),
                'type' 			=> Controls_Manager::URL,
                'placeholder' 	=> __( 'https://your-link.com', 'adina' ),
                'show_external' => true,
                'default' 		=> [
                    'url' 			=> '#',
                    'is_external' 	=> true,
                    'nofollow' 		=> true,
                ],
            ]
        );


		$this->add_control(
			'social_items',
			[
				'label' 		=> __( 'Footer Menus', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'social_icon'    => [
							'value' => 'fas fa-star',
							'library' => 'solid',
						],
						'social_link'    => __( '#', 'adina' ),

					]
                ],
                'title_field' 	=> '{{{ social_link }}}',
			]
		);
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
			'social_style',
			[
				'label' 	=> __( 'Social Profile', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'text_typography',
				'label' 		=> __( 'Typography', 'adina' ),
                'selector' 		=> '{{WRAPPER}} .footer-social a',
			]
		);
		
        $this->add_control(
			'icon_color',
			[
				'label'     => __( 'Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-social a' => 'color: {{VALUE}}!important',
                ],
			]
        );

		$this->add_control(
			'icon_color_background',
			[
				'label'     => __( 'Background Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-social a' => 'background-color: {{VALUE}}!important',
                ],
			] 
        );

		$this->add_control(
			'icon_color_hover',
			[
				'label'     => __( 'Hover Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-social a:hover' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_control(
			'icon_color_bg_hover',
			[
				'label'     => __( 'Background Hover Color', 'adina' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .footer-social a:hover' => 'background-color: {{VALUE}}!important',
                ],
			]
        );

        

       

        $this->end_controls_section();



	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        
        ?>

			<div class="footer-social">

				<?php foreach( $settings[ 'social_items' ] as $social_item ): 
					$target = $social_item['social_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $social_item['social_link']['nofollow'] ? ' rel="nofollow"' : '';
					?>
					<a <?php echo $target; ?> <?php echo $nofollow; ?> href="<?php echo esc_url( $social_item[ 'social_link' ]['url'] ); ?>">
						<?php Icons_Manager::render_icon( $social_item['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</a>
				<?php endforeach; ?>
			</div>
        <?php
	}
}
$widgets_manager->register( new \Adina_Social_Links() );