<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaAboutOne extends Widget_Base {
    public function get_name() {
        return 'adina-about-one';
    }
    public function get_title() {
        return __('About One', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Hero', 'About', 'section'];
    }

    protected function register_controls() {
        
        $this->start_controls_section('general_section',
            [
                'label' => __('About Section 01', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        // About one Left image section in here
        $this->start_controls_tabs(
            'style_tabs'
        );
        
        $this->start_controls_tab(
            'Aboutleft_section',
            [
                'label' => esc_html__( 'Left Section', 'adina' ),
            ]
        );
        $this->add_control(
			'left_big_title',
			[
				'label' => esc_html__( 'Big Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'adina', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'left_shape01',
			[
				'label' => esc_html__( 'Shape Upload 01', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'left_image',
			[
				'label' => esc_html__( 'Background image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'btn_image',
			[
				'label' => esc_html__( 'Button image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'left_btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        
        $this->end_controls_tab();

         // About oneTitle section in here
        $this->start_controls_tab(
            'Right_title_section',
            [
                'label' => esc_html__( 'Title Section', 'adina' ),
            ]
        );
        $this->add_control(
			'Sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'About Company', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'Title_content',
			[
				'label' => esc_html__( 'Content Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Digital & Trusted Transport
                Logistic Company', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'Title_discription',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod of
                tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspend
                ultrices
                gravida risus commodo viverra maecenas.', 'adina' ),
				'label_block' => true,
			]
		);

          // Icon box 01
        $this->add_control(
			'Box_icon01',
			[
				'label' => esc_html__( 'Box Icon 01', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'Icon_title01',
			[
				'label' => esc_html__( 'Icon box title 01', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Fast Worldwide Delivery', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'Box_discription01',
			[
				'label' => esc_html__( 'Box Content 01', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                eiusmod of tempor incididunt ut labore et dolore.', 'adina' ),
				'label_block' => true,
			]
		);
        // Icon box 02
        $this->add_control(
			'Box_icon02',
			[
				'label' => esc_html__( 'Box Icon 02', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'Icon_title02',
			[
				'label' => esc_html__( 'Icon box title 02', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Safe And Secure Delivery', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'Box_discription02',
			[
				'label' => esc_html__( 'Box Content 02', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'There are many variations of passages of Lorem Ipsum available but
                the majority have suffered alteration in some form,', 'adina' ),
				'label_block' => true,
			]
		);
        $this->end_controls_tabs();


        $this->end_controls_section();




        /********* Start Style Controls /*********/
        /////////////// Left Images and shape ////////////////////////////
        $this->start_controls_section(
            '_leftimag',
            [
                'label' => __( 'Images', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'left_imag_ewidth',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__img .inner img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'left_imag_height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__img .inner img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'left_imag_margin',
            [
                'label' => __( 'Image Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__img .inner img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'left_imag_padding',
            [
                'label' => __( 'Image Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__img .inner img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        // //////////////// About 01 shape 01 ///////////////////////////
        $this->add_control(
            '_left_shape',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Shape', 'adina' ),
            ]
        );
        $this->add_responsive_control(
			'left_shape_ewidth',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__img .shape1' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'left_shape_height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__img .shape1' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'left_shape_margin',
            [
                'label' => __( 'Shape Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__img .shape1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'left_shape_padding',
            [
                'label' => __( 'Shape Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__img .shape1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    
        
        ////// Big title in here about 01 /////////////////////
        $this->start_controls_section(
            '_aboutbig_title',
            [
                'label' => __( 'Big Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'big_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-one__big-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'big_title_typography',
				'selector' => '{{WRAPPER}} .about-one__big-title',
			]
		);
        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'big_title_shadow',
				'selector' => '{{WRAPPER}} .about-one__big-title',
			]
		);
        $this->add_responsive_control(
            'big_title_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__big-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'big_title_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__big-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ///////////  Sub Title  /////////////////////////////////
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Title / Content', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            '_heading_title_sub',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Sub Title', 'adina' ),
            ]
        );
        $this->add_control(
            'title_color_sub',
            [
                'label' => __( 'Sub Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sub-title h5' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .sub-title h5',
			]
		);
        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_shadow',
				'selector' => '{{WRAPPER}} .sub-title h5',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'selector' => '{{WRAPPER}} .sub-title h5',
			]
		);
   
        $this->add_responsive_control(
            'Sub_title_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sub-title h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Sub_title_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sub-title h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
         // ///////////  Content  Title  /////////////////////////////////
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Content Title', 'adina' ),
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .sec-title h2',
			]
		);
        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_shadow',
				'selector' => '{{WRAPPER}} .sec-title h2',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
// ///////////  Content // discription   /////////////////////////////////
            $this->add_control(
            '_heading_discription',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Discription', 'adina' ),
            ]
        );
        $this->add_control(
            'discription_color',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'discription_typography',
                'selector' => '{{WRAPPER}} .text p',
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'discription_shadow',
                'selector' => '{{WRAPPER}} .text p',
            ]
        );
        $this->add_responsive_control(
            'discription_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'discription_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
	
        $this->end_controls_section();

        // ///////////////////   Icon   //////////////////////////////////
        $this->start_controls_section(
            '_heading_icon01',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__content-features ul li .inner .icon-box' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__content-features ul li .inner .icon-box' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'adina' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);
        $this->end_controls_section();

        /////////////////////  Icon Box  ///////////////////////////////////
        $this->start_controls_section(
            '_heading_icon_box',
            [
                'label' => __( 'Icon Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'icon_box_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__content-features ul li' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'icon_box_height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__content-features ul li' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .about-one__content-features ul li',
			]
		);
        $this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .about-one__content-features ul li',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'Box_border',
				'selector' => '{{WRAPPER}} .about-one__content-features ul li',
			]
		);   
		$this->add_control(
			'Iconbox_boder_radius',
			[
				'label' => esc_html__( 'border_radius', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .about-one__content-features ul li' => 'border_radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
            'icon_box',
            [
                'label' => __( 'Box Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_box_padding',
            [
                'label' => __( 'Box Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // //////////////// Icon title  ////////////////////////
        $this->add_control(
            '_heading_icon_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Icon Title', 'adina' ),
            ]
        );
        $this->add_control(
            'icon_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li .inner .text-box h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_title_typography',
				'selector' => '{{WRAPPER}} .about-one__content-features ul li .inner .text-box h4',
			]
		);
        $this->add_responsive_control(
            'icon_title_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li .inner .text-box h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_title_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li .inner .text-box h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // //////////////// Icon discription  ////////////////////////
        $this->add_control(
            '_heading_icon_discription',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Content', 'adina' ),
            ]
        );
        $this->add_control(
            'icon_discription_color',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li .inner .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'icon_discription_typography',
                'selector' => '{{WRAPPER}} .about-one__content-features ul li .inner .text-box p',
            ]
        );
        $this->add_responsive_control(
            'icon_discription_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li .inner .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_discription_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-one__content-features ul li .inner .text-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /////////////////////  Button img  ///////////////////////////////////
        $this->start_controls_section(
            'btn_img_style',
            [
                'label' => __( 'Button Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'btn_img_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__img .btn-box a img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'btn_img_height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-one__img .btn-box a img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        ?>




        <!--Start About One-->
       <div class="about-one">
            <!-- Big title in here -->
             <?php if ( !empty($settings['left_big_title']) ) : ?>
            <div class="about-one__big-title"><?php echo adina_kses( $settings['left_big_title'] ); ?></div>
            <?php endif; ?>

            <div class="container">
                <div class="row">
                    <div class="col-xl-5">
                        <div class="about-one__img clearfix">
                         <!-- shape 01 upload in here -->
                        <?php if( !empty( $settings[ 'left_shape01' ]['url'] ) ): ?>
                            <div class="shape1 float-bob-x"><img src="<?php echo esc_url( $settings[ 'left_shape01' ]['url'] ); ?>" alt="">
                        <?php endif;  ?>

                            </div>
                           <!-- image upload in here -->
                           <?php if( !empty( $settings[ 'left_image' ]['url'] ) ): ?>
                                <div class="inner clearfix">
                                    <img class="float-bob-y" src="<?php echo esc_url( $settings[ 'left_image' ]['url'] ); ?>" alt="">
                                </div>
                            <?php endif;  ?>

                            <div class="btn-box">
                                <a href="<?php echo esc_url( $settings['left_btn_url'] ); ?>"><img src="<?php echo esc_url( $settings[ 'btn_image' ]['url'] ); ?>" alt=""></a>
                            </div>
                        </div>
                    </div>

                    <!-- title section  -->
                    <div class="col-xl-7">
                        <div class="about-one__content">
                            <div class="about-one__content-top">
                                <div class="sec-title">
                                    <!-- Sub title in here -->
                                    <?php if ( !empty($settings['Sub_title']) ) : ?>
                                    <div class="sub-title">
                                        <h5><span class="icon-right-arrow-1"></span><?php echo adina_kses( $settings['Sub_title'] ); ?></h5>
                                    </div>
                                    <?php endif; ?>

                                    <!-- title in here -->
                                    <?php if ( !empty($settings['Title_content']) ) : ?>
                                      <h2><?php echo adina_kses( $settings['Title_content'] ); ?></h2>
                                    <?php endif; ?>
                                </div>

                                <!-- Discription in here -->
                                <?php if ( !empty($settings['Title_discription']) ) : ?>
                                <div class="text">
                                    <p><?php echo adina_kses( $settings['Title_discription'] ); ?></p>
                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="about-one__content-features">
                                <ul>
                                    <li class="wow fadeInRight" data-wow-delay="0ms" data-wow-duration="1500ms">
                                        <div class="inner">
                                            <!-- icon upload in here -->
                                           <?php if( !empty( $settings[ 'Box_icon01' ]['url'] ) ): ?>
                                            <div class="icon-box">
                                                <img src="<?php echo esc_url( $settings[ 'Box_icon01' ]['url'] ); ?>" alt="#">
                                            </div>
                                            <?php endif;  ?>

                                            <div class="text-box">

                                             <!-- title in here -->
                                               <?php if ( !empty($settings['Icon_title01']) ) : ?>
                                                <h4><?php echo adina_kses( $settings['Icon_title01'] ); ?></h4>
                                                <?php endif; ?>

                                              <!-- Discription in here -->
                                              <?php if ( !empty($settings['Box_discription01']) ) : ?>
                                                <p><?php echo adina_kses( $settings['Box_discription01'] ); ?></p>
                                                <?php endif; ?>

                                            </div>
                                        </div>
                                    </li>
                                    <!--  icon box 02 -->

                                    <li class="wow fadeInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
                                        <div class="inner">

                                         <!-- icon upload in here 02 -->
                                           <?php if( !empty( $settings[ 'Box_icon02' ]['url'] ) ): ?>
                                            <div class="icon-box">
                                                <img src="<?php echo esc_url( $settings[ 'Box_icon02' ]['url'] ); ?>" alt="#">
                                            </div>
                                            <?php endif; ?>

                                            <div class="text-box">
                                                <!-- title in here 02-->
                                               <?php if ( !empty($settings['Icon_title02']) ) : ?>
                                                <h4><?php echo adina_kses( $settings['Icon_title02'] ); ?></h4>
                                                <?php endif; ?>

                                              <!-- Discription in here 02-->
                                               <?php if ( !empty($settings['Box_discription02']) ) : ?>
                                                <p><?php echo adina_kses( $settings['Box_discription02'] ); ?></p>
                                                <?php endif; ?>

                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--End About One-->
        
    
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaAboutOne());