<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaAbouTwo extends Widget_Base {
    public function get_name() {
        return 'adina-about-two';
    }
    public function get_title() {
        return __('Adina Image Box', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Image', 'Box', 'About'];
    }

    protected function register_controls() {

        // Adina image Box section in here
        $this->start_controls_section(
            'general_section',
            [
                'label' => __('Adina Image', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'Adina_image01',
			[
				'label' => esc_html__( 'Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->end_controls_section();

        // Adina Count image in here
        $this->start_controls_section(
            'general_sections',
        [
            'label' => __('Count Title / Image', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'Adina_image02',
            [
                'label' => esc_html__( 'Background Image', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'Title_contents',
            [
                'label' => esc_html__( 'Content Title', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '30+', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'Title_discriptions',
            [
                'label' => esc_html__( 'Content', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Year of Experience', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        /////////////Video btn and round text //////////////
        $this->start_controls_section(
            'general_sectiones',
        [
            'label' => __('Adina Video Box', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
        ]
        );
        $this->add_control(
            'Adina_image03',
            [
                'label' => esc_html__( 'Background Image', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'video_btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();


     /********* Start Style Controls /*********/
     /////////Image  ///////////
            $this->start_controls_section(
            '_adina_images',
            [
                'label' => __( 'Image', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'image_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__img1 img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'image_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__img1 img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__img1 img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__img1 img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////// Count prev  title////////////////////////////
        $this->start_controls_section(
            '_count_prev',
            [
                'label' => __( 'Count Prev /Next Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'count_prev_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'prev_title_typography',
                'selector' => '{{WRAPPER}} .about-two__experience-box .inner h2',
            ]
        );
        $this->add_responsive_control(
            'count_prev_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'count_prev_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //////////// Count Next title//////////////////////////////
        $this->add_control(
            '_count_next_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Count Next Title', 'adina' ),
            ]
        );
        $this->add_control(
            'count_next_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner h2 .plus' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'next_title_typography',
                'selector' => '{{WRAPPER}} .about-two__experience-box .inner h2 .plus',
            ]
        );
        $this->add_responsive_control(
            'count_next_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner h2 .plus' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'count_next_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner h2 .plus' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        //////////// Count content//////////////////////////////
        $this->add_control(
            '_count_content',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Content', 'adina' ),
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .about-two__experience-box .inner .text p',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box .inner .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////////// Count Box  ///////////
        $this->start_controls_section(
            '_count_box',
            [
                'label' => __( 'Count Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'count_box_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'count_box_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} ..about-two__experience-box',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} ..about-two__experience-box',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'Box_border',
                'selector' => '{{WRAPPER}} .about-two__experience-box',
            ]
        );   
        $this->add_control(
            'count_box_boder_radius',
            [
                'label' => esc_html__( 'border_radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box' => 'border_radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'count_box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'count_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__experience-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        

        // //////// Video Box Section in here //////////////////////
        $this->start_controls_section(
            '_video_box_about02',
            [
                'label' => __( 'Video Box', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ////////// Video Box////////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        
        $this->start_controls_tab(
            'video_bstyle_normal_tabes',
            [
                'label' => esc_html__( 'Box', 'textdomain' ),
            ]
        );
        $this->add_control(
            'video_box_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'video_box_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'boxs-background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__video',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'boxs_shadow',
                'selector' => '{{WRAPPER}} .about-two__video',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'Boxs_border',
                'selector' => '{{WRAPPER}} .about-two__video',
            ]
        );   
        $this->add_control(
            'video_box_boder_radius',
            [
                'label' => esc_html__( 'Border_radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video' => 'border_radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'video_box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'video_box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        ////////// Video Icon Normal///////////////////////////
        $this->start_controls_tab(
            'style_normal_tabss',
            [
                'label' => esc_html__( 'Icon Normal', 'textdomain' ),
            ]
        );
        $this->add_control(
            'normal_icons_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'normal_icons_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'normals_icons_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__video-box a',
            ]
        );
        $this->add_control(
            'normal_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'normals_box_shadow',
                'selector' => '{{WRAPPER}} .about-two__video-box a',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'Normal_Box_border',
                'selector' => '{{WRAPPER}} .about-two__video-box a',
            ]
        );   
        $this->add_control(
            'normal_icons_boder_radius',
            [
                'label' => esc_html__( 'Border_radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a' => 'border_radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_icons_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        ////////////// Icon Hover///////////////////////
        $this->start_controls_tab(
            'style_hover_tabsss',
            [
                'label' => esc_html__( 'Hover Icon', 'textdomain' ),
            ]
        );
        $this->add_control(
            'hover_icons_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a:hover' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'hover_icons_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a:hover' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hovers_icons_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__video-box a:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hovers_box_shadow',
                'selector' => '{{WRAPPER}} .about-two__video-box a:hover',
            ]
        );
        $this->add_control(
            'hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_Box_border',
                'selector' => '{{WRAPPER}} .about-two__video-box a:hover',
            ]
        );   
        $this->add_control(
            'hover_icons_boder_radius',
            [
                'label' => esc_html__( 'Border_radius', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a:hover' => 'border_radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_icons_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__video-box a:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();
        

    /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        ?>

            <div class="about-two__img">
                <div class="about-two__experience-box text-center wow fadeInLeft" data-wow-delay="0ms"
                    data-wow-duration="1500ms">
                    <!-- Count Background image -->
                    <?php if( !empty( $settings[ 'Adina_image02' ]['url'] ) ): ?>
                    <div class="about-two__experience-box-bg"
                        style="background-image: url(<?php echo esc_url( $settings[ 'Adina_image02' ]['url'] ); ?>);"></div>
                        <?php endif; ?> 
                    <div class="inner">

                        <!-- Count Title in here  -->
                        <?php if ( !empty($settings['Title_contents']) ) : ?>
                        <h2 class="count"><?php echo adina_kses( $settings['Title_contents'] ); ?>
                        </h2>
                        <?php endif; ?> 

                        <!-- Content -->
                        <?php if ( !empty($settings['Title_discriptions']) ) : ?>
                        <div class="text">
                            <p><?php echo adina_kses( $settings['Title_discriptions'] ); ?></p>
                        </div>
                        <?php endif; ?> 
                    </div>
                </div>

                <!-- Image 01 upload  -->
                <?php if( !empty( $settings[ 'Adina_image01' ]['url'] ) ): ?>
                <div class="about-two__img1">
                    <img src="<?php echo esc_url( $settings[ 'Adina_image01' ]['url'] ); ?>" alt="">
                </div>
                <?php endif;  ?>

                <div class="about-two__video wow fadeInRight" data-wow-delay="0ms"
                    data-wow-duration="1500ms">
                    <!-- Video Background image -->
                    <?php if( !empty( $settings[ 'Adina_image03' ]['url'] ) ): ?>
                    <div class="about-two__video-bg"
                        style="background-image: url(<?php echo esc_url( $settings[ 'Adina_image03' ]['url'] ); ?>);"></div>
                        <?php endif;  ?>
                    <div class="about-two__video-box">
                        <!-- btn video -->
                        <?php if( !empty( $settings[ 'video_btn_url' ] ) ): ?>
                        <a href="<?php echo esc_url( $settings['video_btn_url'] ); ?>"
                            class="about-two__video-icon video-popup">
                            <span class="icon-play-button-arrowhead"></span>
                        </a>
                        <?php endif;  ?>
                    </div>
                </div>
            </div>
        

        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaAbouTwo());