<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
/**
 *
 * Faq Widget .
 *
 */
class Adina_Faq extends Widget_Base {

	public function get_name() {
		return 'adinafaq';
	}

	public function get_title() {
		return __( 'Faq', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'faq_section',
			[
				'label'		 	=> __( 'Faq', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
		
		$this->add_control(
			'faq_style',
			[
				'label' 	=> __( 'FAQ Style', 'adina' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    '1'   		=> __( 'Style One', 'adina' ),
                    '2'   		=> __( 'Style Two', 'adina' ),
                ],
                'default'  	=> '1'
			]
        );
		
        $repeater = new Repeater();

        $repeater->add_control(
			'faq_question',
			[
				'label' 	=> __( 'Faq Question', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Ethical testing rather than ethical interfaces?', 'adina' )
			]
        );

        $repeater->add_control(
			'faq_answer',
			[
				'label' 	=> __( 'Faq Answer', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Assertively conceptualize cooperative potentialities with process centric internal or "organic" sources. Authoritatively pontificate B2C metrics via one-to-one synergy.', 'adina' )
			]
        );

		$this->add_control(
			'faq_repeater',
			[
				'label' 		=> __( 'Faq', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'faq_question'    => __( 'Ethical testing rather than ethical interfaces?', 'adina' ),
						'faq_answer'      => __( 'Assertively conceptualize cooperative potentialities with process centric internal or "organic" sources. Authoritatively pontificate B2C metrics via one-to-one synergy.', 'adina' ),
					],
					[
						'faq_question'    => __( 'Latin derived from Cicero\'s 1st-century BC text De', 'adina' ),
                        'faq_answer'      => __( 'Assertively conceptualize cooperative potentialities with process centric internal or "organic" sources. Authoritatively pontificate B2C metrics via one-to-one synergy.', 'adina' ),
					],
					[
						'faq_question'    => __( 'Creation timelines for the standard lorem passage', 'adina' ),
                        'faq_answer'      => __( 'Assertively conceptualize cooperative potentialities with process centric internal or "organic" sources. Authoritatively pontificate B2C metrics via one-to-one synergy.', 'adina' ),
					],
					[
						'faq_question'    => __( 'Lorem ipsum was purposefully designed to have', 'adina' ),
                        'faq_answer'      => __( 'Assertively conceptualize cooperative potentialities with process centric internal or "organic" sources. Authoritatively pontificate B2C metrics via one-to-one synergy.', 'adina' ),
					],
				],
				'title_field' 	=> '{{{ faq_question }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'faq_style_section',
			[
				'label' => __( 'Faq Question Style', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);


        $this->add_control(
			'accordion_box_color',
			[
				'label' 	=> __( 'Accordion Box Background', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .accordion-box' => 'background-color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'faq_question_color',
			[
				'label' 	=> __( 'Faq Question Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .accordion-box .accordion-button' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'faq_question_typography',
				'label' 	=> __( 'Faq Question Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .accordion-box .accordion-button',
			]
		);

        $this->add_responsive_control(
			'faq_question_margin',
			[
				'label' 		=> __( 'Faq Question Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-box .accordion-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'faq_question_padding',
			[
				'label' 		=> __( 'Faq Question Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-box .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->add_control(
			'faq_answer_color',
			[
				'label' 		=> __( 'Faq Answer Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-body p' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before'
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'faq_answer_typography',
				'label' 	=> __( 'Faq Answer Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .accordion-body p',
			]
        );

        $this->add_responsive_control(
			'faq_answer_margin',
			[
				'label' 		=> __( 'Faq Answer Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'faq_answer_padding',
			[
				'label' 		=> __( 'Faq Answer Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .accordion-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		
		
        if (!empty($settings['faq_repeater'])) {
			// Generate a unique ID for this widget instance
			$widget_unique_id = 'faqWidget_' . uniqid();
		
			echo '<div class="accordion accordion-style1 " id="' . esc_attr($widget_unique_id) . '">';
		
			$x = 1;
			foreach ($settings['faq_repeater'] as $single_data) {
				if ($x == '1') {
					$ariaexpanded = 'true';
					$class = 'show';
					$collesed = ''; 
					$active = 'active';
				} else {
					$ariaexpanded = 'false';
					$class = '';
					$collesed = 'collapsed';
					$active = '';
				}
				echo '<div class="accordion-item accordion-box ' . esc_attr($active) . '">';
				if (!empty($single_data['faq_question'])) {
					// Generate a unique ID for this FAQ item
					$faq_unique_id = 'faq_' . uniqid();
		
					echo '<div class="accordion-header" id="' . esc_attr($faq_unique_id) . '">';
					echo '<button class="accordion-button ' . esc_attr($collesed) . '" type="button" data-bs-toggle="collapse" data-bs-target="#' . esc_attr($faq_unique_id) . '_collapse" aria-expanded="' . esc_attr($ariaexpanded) . '" aria-controls="' . esc_attr($faq_unique_id) . '_collapse">';
					echo esc_html($single_data['faq_question']);
					echo '</button>';
					echo '</div>';
				}
				if (!empty($single_data['faq_answer'])) {
					echo '<div id="' . esc_attr($faq_unique_id) . '_collapse" class="accordion-collapse collapse ' . esc_attr($class) . '" aria-labelledby="' . esc_attr($faq_unique_id) . '" data-bs-parent="#' . esc_attr($widget_unique_id) . '">';
					echo '<div class="accordion-body">';
					echo '<p>' . esc_html($single_data['faq_answer']) . '</p>';
					echo '</div>';
					echo '</div>';
				}
				echo '</div>';
				$x++;
			}
			echo '</div>';
		}
	}
}
$widgets_manager->register_widget_type( new \Adina_Faq() );