<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\HEADING;
use \Elementor\Repeater;
/**
 *
 * Image Widget .
 *
 */
class Adina_FeatureBox extends Widget_Base {

	public function get_name() {
		return 'adinafeaturebox';
	}
 
	public function get_title() {
		return __( 'Feature Box', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'feature_layout',
			[
				'label' => __( 'Style', 'adina' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __( 'Style 1', 'adina' ),
					'2' => __( 'Style 2', 'adina' ),
					'3' => __( 'Style 3', 'adina' ),
				],
			]
		);

		$this->add_control(
			'media_image',
			[
				'label' 		=> __( 'Svg Icon', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'feature_layout' => [ '1' ] ],
			]
		);

		$this->add_control(
			'feature_image',
			[
				'label' 		=> __( 'Image', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'feature_layout' => [ '2', '3' ] ],
			]
		);
        $this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Personalized Learning' , 'adina' ),
				'label_block' 	=> true,
				
			]
        );

        $this->add_control(
			'discription', [
				'label' 		=> __( 'Discription', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Our goal is to carefully educate and develop children in a fun way. We strive learning process into a bright.' , 'adina' ),
				'label_block' 	=> true,
				'condition'		=> [ 'feature_layout' => [ '1', '2' ] ],
			]
        );


		$repeater = new Repeater();
        $repeater->add_control(
			'feature_list_text',
			[
				'label' 	=> __( 'Text', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Help parents get to work on time', 'adina' ), 
			]
        );
		$this->add_control(
			'feature_items',
			[
				'label' 		=> __( 'Feature List', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'feature_list_text'    => __( 'Help parents get to work on time', 'adina' ),
					]
				],
				'condition'		=> [ 'feature_layout' => [ '3' ] ],
			]
		);
        $this->end_controls_section();

		$this->start_controls_section(
			'mdeia_style_option',
			[
				'label' 	=> __( 'Style', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'sahe_color',
			[
				'label' 		=> __( 'Shape Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .fav-circle' => 'border-color: {{VALUE}} !important',
                ],
				'condition'		=> [ 'feature_layout' => [ '2' ] ],
				
			]
        );

		$this->add_responsive_control(
			'media-align',
			[
				'label' 		=> __( 'Alignment', 'adina' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'adina' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'adina' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'adina' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'toggle' 	=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-style1, {{WRAPPER}} .feature-style2' => 'text-align: {{VALUE}};',
                ]
			]
		);

		$this->add_control(
			'more_options',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		//Title
		$this->add_control(
			'mdeia_color',
			[
				'label' 		=> __( 'Title Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-title' => 'color: {{VALUE}} !important',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'mdeia_typography',
				'label'         => __( 'Title Typography', 'adina' ),
                'selector'      => '{{WRAPPER}} .feature-style1 .feature-title, {{WRAPPER}} .feature-style2 .feature-title',
			]
		);
		$this->add_control(
			'subtitles',
			[
				'label' => esc_html__( 'Discription', 'adina' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .feature-text' => 'color: {{VALUE}} !important',
                ]
			]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'          => 'subtitle_typography',
				'label'         => __( 'Typography', 'adina' ),
                'selector'      => '{{WRAPPER}} .feature-style1 .feature-text, {{WRAPPER}} .feature-style2 .feature-text',
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		$feature_layout = $settings[ 'feature_layout' ];
		?>

        <div class="feature-style<?php echo esc_attr( $feature_layout ); ?>">
			<?php 	
				if ($feature_layout) {
					include('feature-box/'.$feature_layout.'.php');
				}
			?>
        </div>
	<?php
	}
}
$widgets_manager->register( new \Adina_FeatureBox() );