<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\HEADING;
use \Elementor\Repeater;
/**
 *
 * Image Widget .
 *
 */
class Adina_Icon extends Widget_Base {

	public function get_name() {
		return 'adinaicon';
	}
 
	public function get_title() {
		return __( 'Adina Icon', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'icon_section',
			[
				'label' 	=> __( 'Content', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'icon_image',
			[
				'label' 		=> __( 'Icon', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
		?>
        <?php if( $settings['icon_image']['url'] ): ?>
            <div class="icon-btn style2 mb-4 mb-lg-5">
                <?php echo adina_img_tag( array(
                    'url'	=> esc_url( $settings['icon_image']['url'] ),
                    'alt'   => 'icon',
                ) );
                ?>
            </div>
        <?php endif; ?>
	<?php
	}
}
$widgets_manager->register( new \Adina_Icon() );