<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Section Title Widget .
 *
 */
class Adina_List_Info extends Widget_Base {

	public function get_name() {
		return 'adinainfotitle';
	}

	public function get_title() {
		return __( 'Info List', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_info_section',
			[
				'label'		 	=> __( 'Info List', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'section_info_layout',
			[
				'label' => __( 'Layout', 'adina' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __( 'Layout 1', 'adina' ),
					'2' => __( 'Layout 2', 'adina' ),
				],
			]
		);

        $this->add_control(
			'info_label',
			[
				'label' 	=> __( 'Label', 'adina' ),
                'type' 		=> Controls_Manager::WYSIWYG,
                'default'   => __('Address :', 'adina'),
                'label_block' => true,
			]
        );

        $this->add_control(
			'info_text',
			[
				'label' 	=> __( 'Text', 'adina' ),
                'type' 		=> Controls_Manager::WYSIWYG,
                'default'   => __('Centerl Park West LA87, New York', 'adina'),
                'label_block' => true,
			]
        );
		

		
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $info_label = $settings['info_label'];
        $info_text = $settings['info_text'];


        ?>
        <div class="contact-table">
            <?php if( '1' == $settings['section_info_layout'] ): ?>
                <div class="tr">
                    <div class="tb-col">
                        <?php if(!empty($info_label)): ?>
                            <?php echo wp_kses_post($info_label);  ?>
                        <?php endif; ?>

                        <?php if(!empty($info_text)): ?>
                            <?php echo wp_kses_post($info_text); ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if( '2' == $settings['section_info_layout'] ): ?>
                <div class="tr">
                    <?php if(!empty($info_label)): ?>
                        <div class="tb-col">
                            <?php echo wp_kses_post($info_label);  ?>
                        </div>
                    <?php endif; ?>
                    <div class="tb-col">
                        <?php echo wp_kses_post($info_text); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php

        
	}
}