<?php

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Icons_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Widget_Base;

class Adina_List_group extends Widget_Base {

	public function get_name() {
		return 'adina-list-groups';
	}

	public function get_title() {
		return esc_html__( 'List Group', 'adina' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ol adina';
	}

	public function get_categories() {
		return [ 'adina' ];
	}

	public function get_keywords() {
		return [ 'adina', 'information', 'group', 'list', 'icon', 'socail' ];
	}

	protected function register_controls() {

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'adina_section_list_content',
			[
				'label' => esc_html__( 'Content', 'adina' )
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
            'adina_list_icon_type',
            [
                'label' => __( 'Media Type', 'adina' ),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'icon',
				'options' => [
					'icon' => [
						'title' => __( 'Icon', 'adina' ),
						'icon' => 'eicon-star',
					],
					'number' => [
						'title' => __( 'Number', 'adina' ),
						'icon' => 'eicon-number-field',
					],
					'image' => [
						'title' => __( 'Image', 'adina' ),
						'icon' => 'eicon-image',
					],
				],
				'toggle' => false,
                'style_transfer' => true,
            ]
        );

		$repeater->add_control(
			'adina_list_icon',
			[
				'label'       => __( 'Icon', 'adina' ),
				'type'        => Controls_Manager::ICONS,
				'label_block' => true,
				'separator'   =>'after',
				'default'     => [
					'value'   => 'far fa-check-circle',
					'library' => 'fa-regular'
				],
				'condition' =>[
					'adina_list_icon_type' => 'icon'
				]
			]
		);

		$repeater->add_control(
			'adina_list_icon_number',
			[
				'label'   => esc_html__( 'Number', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( '1', 'adina' ),
				'separator'   =>'after',
				'condition' =>[
					'adina_list_icon_type' => 'number'
				]
			]
		);

		$repeater->add_control(
			'adina_list_icon_number_image',
			[
				'label' => __( 'Choose Image', 'adina' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'separator'   =>'after',
				'dynamic' => [
					'active' => true,
				],
				'condition' =>[
					'adina_list_icon_type' => 'image'
				]
			]
		);

        $repeater->add_control(
			'adina_list_text',
			[
				'label'   => esc_html__( 'Text', 'adina' ),
				'type'    => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'List Text', 'adina' ),
				'dynamic' => [ 'active' => true ]
			]
		);

		$repeater->add_control(
			'adina_list_link',
			[
				'label' => __( 'List URL', 'adina' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'adina' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'adina_list_group',
			[
				'label' => __( 'List Items', 'elementor' ),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'default' => [
					[
						'adina_list_text' => __( 'List Item #1', 'elementor' ),
						'adina_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
					[
						'adina_list_text' => __( 'List Item #2', 'elementor' ),
						'adina_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
					[
						'adina_list_text' => __( 'List Item #3', 'elementor' ),
						'adina_list_icon' => [
							'value' => 'fas fa-check',
							'library' => 'fa-solid',
						],
					],
				],
				'title_field' => '{{{ elementor.helpers.renderIcon( this, adina_list_icon, {}, "i", "panel" ) }}}{{{ adina_list_text }}}'
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'adina_section_list_style',
			[
				'label' => esc_html__( 'Container', 'adina' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_control(
			'adina_section_list_layout',
			[
				'label' => __( 'Layout', 'adina' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'layout_1',
				'options' => [
					'layout_1' => __( 'Layout 1', 'adina' ),
					'layout_2' => __( 'Layout 2', 'adina' ),
					'layout_3' => __( 'Layout 3', 'adina' ),
				],
			]
		);

		$this->add_responsive_control(
			'adina_section_list_alignment',
			[
				'label'       => esc_html__( 'Alignment', 'adina' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'adina-list-group-left'   => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					],
					'adina-list-group-center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon'  => 'eicon-text-align-center'
					],
					'adina-list-group-right'  => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon'  => 'eicon-text-align-right'
					]
				],
				'selectors_dictionary' => [
					'adina-list-group-left' => 'justify-content: flex-start; text-align: left;',
					'adina-list-group-center' => 'justify-content: center; text-align: center;',
					'adina-list-group-right' => 'justify-content: flex-end; text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper' => '{{VALUE}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item' => '{{VALUE}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item a' => '{{VALUE}};',
				],
				'default'     => 'adina-list-group-left',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'adina_section_list_group_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .adina-list-group',
			]
		);

		$this->add_responsive_control(
			'adina_section_list_group_padding',
			[
				'label'      => __( 'Padding', 'adina' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '0',
                    'left'     => '0',
                    'unit'     => 'px',
                    'isLinked' => true
                ],
				'selectors'  => [
					'{{WRAPPER}} .adina-list-group' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'adina_section_list_group_border',
				'selector'  => '{{WRAPPER}} .adina-list-group'
			]
		);

		$this->add_responsive_control(
			'adina_section_list_group_radius',
			[
				'label'        => __( 'Border Radius', 'adina' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .adina-list-group' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'adina_section_list_group_shadow',
				'selector' => '{{WRAPPER}} .adina-list-group'
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Content
		*/
		$this->start_controls_section(
			'adina_section_list_item_style',
			[
				'label' => esc_html__( 'List Item', 'adina' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'adina_section_list_item_padding',
			[
				'label'        => __( 'Item Padding', 'adina' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_control(
			'adina_section_list_item_separator',
            [
				'label'        => __( 'Item Separator', 'adina' ),
				'type'         =>  Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'adina' ),
				'label_off'    => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'adina_section_list_layout!' => 'layout_3'
				]
			]
        );

		$this->add_responsive_control(
			'adina_section_list_item_separator_height',
			[
				'label' => __( 'Separator Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_1 .adina-list-group-item:not(:last-child):after' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_2 .adina-list-group-item:not(:last-child):after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'adina_section_list_item_separator' => 'yes',
					'adina_section_list_layout!' => 'layout_3'
				]
			]
		);

		$this->add_control(
			'adina_section_list_item_separator_color',
			[
				'label' => __( 'Separator Color', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#e5e5e5',
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_1 .adina-list-group-item:not(:last-child):after' => 'background: {{VALUE}}',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_2 .adina-list-group-item:not(:last-child):after' => 'background: {{VALUE}}',
				],
				'condition' => [
					'adina_section_list_item_separator' => 'yes',
					'adina_section_list_layout!' => 'layout_3'
				]
			]
		);

		$this->add_responsive_control(
			'adina_list_item_spacing',
			[
				'label' => __( 'Item Spacing', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_3 .adina-list-group-item:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'adina_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'adina_list_item_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_3 .adina-list-group-item',
				'condition' => [
					'adina_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'adina_list_item_border',
				'selector'  => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_3 .adina-list-group-item',
				'fields_options'  => [
                    'border' 	  => [
                        'default' => 'solid'
                    ],
                    'width'  	  => [
                        'default' 	 => [
                            'top'    => '1',
                            'right'  => '1',
                            'bottom' => '1',
                            'left'   => '1'
                        ]
                    ],
                    'color' 	  => [
                        'default' => '#e5e5e5',
                    ]
                ],
				'condition' => [
					'adina_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_responsive_control(
			'adina_list_item_radius',
			[
				'label'        => __( 'Border Radius', 'adina' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '10',
					'right'    => '10',
					'bottom'   => '10',
					'left'     => '10',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_3 .adina-list-group-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'adina_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'adina_list_item_shadow',
				'selector' => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_3 .adina-list-group-item',
				'condition' => [
					'adina_section_list_layout' => 'layout_3'
				]
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Icon Style
		*/
		$this->start_controls_section(
			'adina_section_list_icon_style',
			[
				'label' => esc_html__( 'Icon', 'adina' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'adina_list_icon_position',
			[
				'label'       => esc_html__( 'Icon Position', 'adina' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'adina-icon-left'   => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon'  => 'eicon-h-align-left'
					],
					'adina-icon-center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon'  => 'eicon-v-align-top'
					],
					'adina-icon-right'  => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon'  => 'eicon-h-align-right'
					]
				],
				'default'     => 'adina-icon-left'
			]
		);

		$this->add_responsive_control(
			'adina_list_icon_alignment',
			[
				'label'       => esc_html__( 'Icon Vertical Alignment', 'adina' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'adina-icon-align-left'   => [
						'title' => esc_html__( 'Top', 'adina' ),
						'icon'  => 'eicon-v-align-top'
					],
					'adina-icon-align-center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon'  => 'eicon-v-align-middle'
					],
					'adina-icon-align-right'  => [
						'title' => esc_html__( 'Bottom', 'adina' ),
						'icon'  => 'eicon-v-align-bottom'
					]
				],
				'default'     => 'adina-icon-align-left',
				'selectors_dictionary' => [
					'adina-icon-align-left' => 'align-items: flex-start;',
					'adina-icon-align-center' => 'align-items: center;',
					'adina-icon-align-right' => 'align-items: flex-end;',
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item' => '{{VALUE}};',
				],
				'condition' => [
					'adina_list_icon_position!' => 'adina-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'adina_list_icon_top_alignment',
			[
				'label'       => esc_html__( 'Icon Alignment', 'adina' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'adina-icon-top-align-left'   => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon'  => 'eicon-v-align-top'
					],
					'adina-icon-top-align-center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon'  => 'eicon-v-align-middle'
					],
					'adina-icon-top-align-right'  => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon'  => 'eicon-v-align-bottom'
					]
				],
				'default'     => 'adina-icon-left',
				'selectors_dictionary' => [
					'adina-icon-top-align-left' => 'text-align: left; margin-right: auto;',
					'adina-icon-top-align-center' => 'text-align: center; margin-left: auto; margin-right: auto;',
					'adina-icon-top-align-right' => 'text-align: right; margin-left: auto;',
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon' => '{{VALUE}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon .adina-list-group-icon-image' => '{{VALUE}};',
				],
				'condition' => [
					'adina_list_icon_position' => 'adina-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'adina_section_list_item_icon_spacing',
			[
				'label' => __( 'Icon Right Spacing', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-text' => 'padding-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'adina_list_icon_position' => 'adina-icon-left'
				]
			]
		);

		$this->add_responsive_control(
			'adina_section_list_item_icon_margin_bottom',
			[
				'label' => __( 'Icon Bottom Spacing', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'adina_section_list_item_icon_left_spacing',
			[
				'label' => __( 'Icon Left Spacing', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'adina_list_icon_position' => 'adina-icon-right'
				]
			]
		);
		$this->add_responsive_control(
			'adina_section_list_item_icon_bottom_spacing',
			[
				'label' => __( 'Icon Bottom Spacing', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'adina_list_icon_position' => 'adina-icon-center'
				]
			]
		);

		$this->add_responsive_control(
			'adina_section_list_item_icon_size',
			[
				'label' => __( 'Icon Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon svg' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon .adina-list-group-icon-image' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'adina_section_list_item_icon_color',
			[
				'label' => __( 'Icon Color', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'adina_section_list_item_icon_color_hover',
			[
				'label' => __( 'Icon Color Hover', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon:hover i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon:hover svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'adina_section_list_item_icon_bg_color_hover',
			[
				'label' => __( 'Icon Background Hover', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes:hover' => 'background-color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'adina_section_list_item_icon_border color_hover',
			[
				'label' => __( 'Icon Border Hover', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes:hover' => 'border-color: {{VALUE}} !important',
				],
			]
		);


		$this->add_responsive_control(
			'adina_section_list_item_image_radius',
			[
				'label'        => __( 'Image Radius', 'adina' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon .adina-list-group-icon-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

		$this->add_control(
			'adina_list_item_icon_box_enable',
			[
				'label' => __( 'Enable Icon Box', 'adina' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'adina' ),
				'label_off' => __( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'adina_list_item_icon_box_width',
			[
				'label' => __( 'Icon Box Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_1 .adina-list-group-item .adina-list-group-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_2 .adina-list-group-item .adina-list-group-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper.layout_3 .adina-list-group-item .adina-list-group-text' => 'width: calc( 100% - {{SIZE}}{{UNIT}} );',
				],
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'adina_list_item_icon_box_height',
			[
				'label' => __( 'Icon Box Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'adina_list_item_icon_box_background',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes',
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'            => 'adina_list_item_icon_box_background_hover',
				'types'           => [ 'classic', 'gradient' ],
				'selector'        => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes:hover',
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'adina_list_item_icon_box_border',
				'selector'  => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes',
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'adina_list_item_icon_box_radius',
			[
				'label'        => __( 'Border Radius', 'adina' ),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => [ 'px', '%', 'em' ],
				'default'      => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px'
				],
				'selectors'    => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'adina_list_item_icon_box_shadow',
				'selector' => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-icon.yes',
				'condition' => [
					'adina_list_item_icon_box_enable' => 'yes'
				]
			]
		);

		$this->end_controls_section();

		/*
		* Icon List Text
		*/
		$this->start_controls_section(
			'adina_section_list_text_style',
			[
				'label' => esc_html__( 'Text', 'adina' ),
				'tab'   => Controls_Manager::TAB_STYLE
			]
		);

		$this->add_responsive_control(
			'adina_section_list_text_alignment',
			[
				'label'       => esc_html__( 'Text Alignment', 'adina' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'label_block' => false,
				'options'     => [
					'adina-text-align-left'   => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					],
					'adina-text-align-center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					],
					'adina-text-align-right'  => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon'  => 'eicon-text-align-left'
					]
				],
				'default'     => 'adina-text-align-left',
				'selectors_dictionary' => [
					'adina-text-align-left' => 'text-align: left;',
					'adina-text-align-center' => 'text-align: center;',
					'adina-text-align-right' => 'text-align: right;',
				],
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-text' => '{{VALUE}};',
				],
				'condition' => [
					'adina_list_icon_position' => 'adina-icon-center'
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'adina_section_list_text_typography',
				'label' => __( 'Typography', 'adina' ),
				'selector' => '{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-text',
			]
		);

		$this->add_control(
			'adina_section_list_text_color',
			[
				'label' => __( 'Text Color', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'adina_section_list_text_hover_color',
			[
				'label' => __( 'Text Color Hover', 'adina' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .adina-list-group .adina-list-group-wrapper .adina-list-group-item .adina-list-group-text:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
		<div class="adina-list-group">
			<ul class="adina-list-group-wrapper <?php echo $settings['adina_section_list_layout']; ?>">
				<?php foreach( $settings['adina_list_group'] as $list ) : ?>
				<?php
					$target = $list['adina_list_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $list['adina_list_link']['nofollow'] ? ' rel="nofollow"' : '';
				?>
					<li class="adina-list-group-item <?php echo $settings['adina_list_icon_position']?>">
						<?php if ( !empty( $list['adina_list_link']['url'] ) ) { ?>
						<a href="<?php echo $list['adina_list_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> >
						<?php } ?>
							<div class="adina-list-group-icon <?php echo $settings['adina_list_item_icon_box_enable']; ?>">
								<?php if ( $list['adina_list_icon_type'] === 'icon' && !empty($list['adina_list_icon']) ){ ?>
									<?php Icons_Manager::render_icon( $list['adina_list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
								<?php } ?>
								<?php if ( $list['adina_list_icon_type'] === 'number' && !empty($list['adina_list_icon_type']) ){ ?>
									<div class="adina-list-group-icon-number">
										<?php echo $list['adina_list_icon_number']; ?>
									</div>
								<?php } ?>
								<?php if ( $list['adina_list_icon_type'] === 'image' && !empty($list['adina_list_icon_type']) ){ ?>
									<div class="adina-list-group-icon-image">
										<img src="<?php echo $list['adina_list_icon_number_image']['url'] ?>" alt="<?php echo $list['adina_list_text']; ?>">
									</div>
								<?php } ?>
							</div>
							<?php if ( !empty( $list['adina_list_text'] ) ) { ?>
								<span class="adina-list-group-text">
									<?php echo $list['adina_list_text']; ?>
								</span>
							<?php } ?>
						<?php if ( !empty( $list['adina_list_link']['url'] ) ) { ?>
						</a>
						<?php } ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		<?php
	}
};
$widgets_manager->register( new \Adina_List_group() );