<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Repeater;
use \Elementor\Utils;
/**
 *
 * Pricing Table Widget .
 *
 */
class Adina_Pricing_Table extends Widget_Base {

	public function get_name() {
		return 'adinapricingtable';
	}

	public function get_title() {
		return __( 'Pricing Table', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'pricing_table_section',
			[
				'label' 	=> __( 'Pricing Table', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$repeater = new Repeater();
		$repeater->add_control(
			'active_price',
			[
				'label'     => esc_html__( 'Active?', 'adina' ),
				'type'      => Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'Show', 'adina' ),
				'label_off' => esc_html__( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'   => 'no',
			]
		);

		$repeater->add_control(
			'package_icon',
			[
				'label' 		=> __( 'Package Icon', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater->add_control(
			'package',
			[
				'label' 	=> __( 'Pricing Plan Name', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Basic', 'adina' )
			]
        );

        $repeater->add_control(
			'price',
			[
				'label' 	=> __( 'Item Price', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '27.99', 'adina' ),
			]
        );
        $repeater->add_control(
			'package_duration',
			[
				'label' 	=> __( 'Item Price Time', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '/monthly', 'adina' ),
			]
        );

        $repeater->add_control(
			'package_list',
			[
				'label'         => __( 'Description', 'adina' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'Default description', 'adina' ),
				'placeholder'   => __( 'Type your description here', 'adina' ),
			]
		);

        $repeater->add_control(
			'package_btn',
			[
				'label' 	=> __( 'Button Text', 'adina' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Get Started', 'adina' )
			]
        );
        $repeater->add_control(
			'link',
			[
				'label' 		=> __( 'Link', 'adina' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'adina' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'price' 			=> __( '$27.99', 'adina' ),
						'package' 	=> __( 'Basic Plan', 'adina' ),
					],
					[
						'price' 			=> __( '$37.99', 'adina' ),
						'package' 	=> __( 'Silver Plan', 'adina' ),
					],
					[
						'price' 			=> __( '$47.99', 'adina' ),
						'package' 	=> __( 'Gold Plan', 'adina' ),
					],
					[
						'price' 			=> __( '$97.99', 'adina' ),
						'package' 	=> __( 'VIP Plan', 'adina' ),
					],
				],
				'title_field' 	=> '{{{ package }}}',
			]
		);

        $this->end_controls_section();


        $this->start_controls_section(
			'pricing_table_style_section',
			[
				'label' 	=> __( 'Pricing Table Style', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'pricing_table_color',
			[
				'label' 		=> __( 'Pricing Title Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-style1 .package-name' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'pricing_table_typography',
				'label' 	=> __( 'Pricing Title Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .package-style1 .package-name',
			]
        );

        $this->add_responsive_control(
			'pricing_table_margin',
			[
				'label' 		=> __( 'Pricing Title Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-style1 .package-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'pricing_table_padding',
			[
				'label' 		=> __( 'Pricing Title Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .package-style1 .package-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
				'separator'		=> 'after',
			]
		);

		$this->add_control(
			'plan_price_color',
			[
				'label' 		=> __( 'Plan Price Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-style1 .package-price' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'plan_price_typography',
				'label' 	=> __( 'Plan Price Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .package-style1 .package-price',
			]
        );

		$this->add_control(
			'plan_list_color',
			[
				'label' 		=> __( 'Plan List Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .package-style1 .list-style1 li' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'plan_list_typography',
				'label' 	=> __( 'Plan List Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .package-style1 .list-style1 li',
			]
        );

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn' => 'color: {{VALUE}}',
                ],
				'separator'		=> 'before',
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn' => 'background-color: {{VALUE}}',
                ],
			]
        );
        $this->add_control(
			'button_bg_color_hover',
			[
				'label' 		=> __( 'Button Background Hover Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn::before,{{WRAPPER}} .fav-btn::after' => 'background-color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .fav-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .fav-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .fav-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'adina' ),
				'selector' 	=> '{{WRAPPER}} .fav-btn',
			]
		);

        $this->end_controls_section();

    }
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'row justify-content-center' );

		?>	
		<?php if( !empty( $settings[ 'slides' ] ) ): ?>
			<div <?php echo $this->get_render_attribute_string('wrapper') ; ?>>
				<?php 

				foreach( $settings[ 'slides' ] as $slide):
					
					if( 'yes' == $slide[ 'active_price' ] ){
						$active = 'active';
					}else{ 
						$active = '';
					}

					?>
					<div class="col-md-6 col-lg-4 package-style1 <?php echo esc_attr( $active ); ?>">
						<!-- price top -->
						<div class="package-top">
							<?php if( $slide['package_icon']['url'] ): ?>
								<div class="package-icon">
									<?php echo adina_img_tag( array(
										'url'	=> esc_url( $slide['package_icon']['url'] ),
										'alt'   => 'icon',
									) );
									?>
								</div>
							<?php endif; ?>

							<?php if(!empty($slide['package'])): ?>
								<h3 class="h5 package-name">
									<?php echo esc_html($slide['package']); ?>
								</h3>
							<?php endif; ?>
							<?php if(!empty($slide['price'])): ?>
								<p class="package-price">
									<?php echo esc_html($slide['price']); ?>
									<?php if($slide['package_duration']): ?>
										<span class="duration">
											<?php echo esc_html( $slide['package_duration'] ); ?>
										</span>
									<?php ?>
								</p>
							<?php endif; ?>
						</div>

						<div class="package-body">
							<div class="list-style1">
								<ul class="list-unstyled">
									<?php  echo adina_get_meta( $slide['package_list'] ); ?>
								</ul>
							</div>

							<?php if(!empty($slide['package_btn'])); ?>
								<a class="fav-btn style3" href="<?php echo esc_url( $slide[ 'link' ][ 'url' ] ); ?>">
									<?php echo esc_html($slide['package_btn']); ?>
								</a>
							<?php endif; ?>	
						</div>				
					</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
		<?php 

	}
}
$widgets_manager->register( new \Adina_Pricing_Table() );