<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Service Box Widget .
 *
 */
class Adina_Service_Box extends Widget_Base {

	public function get_name() {
		return 'adinaservicebox';
	}

	public function get_title() {
		return __( 'Service Box', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Service Box', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			] 
        );

		$this->add_control(
			'service_style',
			[
				'label' 	=> __( 'Service Style', 'adina' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'adina' ),
					'2' 		=> __( 'Style Two', 'adina' ),
					'3' 		=> __( 'Style Three', 'adina' ),
					'4' 		=> __( 'Style Four', 'adina' ),
				],
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'service_icon',
			[
				'label' 	=> esc_html__( 'Service Icon Svg', 'adina' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'service_title',
			[
				'label' 	=> __( 'Service Title', 'adina' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Development Services', 'adina' ),
			]
		);

		$repeater->add_control(
			'service_url',	
			[
				'label' 	=> __( 'Service Url', 'adina' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'   => __( '#', 'adina' ),
			]
		);

		$repeater->add_control(
			'service_description',
			[
				'label' 	=> __( 'Service Description', 'adina' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Completely implement via highly efficient process improvements. engage high value before progressive data.', 'adina' ),
			]
		);

		$this->add_control(
			'srvice_slides',
			[
				'label' 		=> __( 'Service Content', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_title' 		=> __( 'Learning & Fun', 'adina' ),
						'service_description' 	=> __( 'Our goal is to carefully educate and develop children in a fun way. We strive learning process into a bright.', 'adina' ),
					],
					[
						'service_title' 		=> __( 'Healthy Meals', 'adina' ),
						'service_description' 	=> __( 'Our goal is to carefully educate and develop children in a fun way. We strive learning process into a bright.', 'adina' ),
					],
					[
						'service_title' 		=> __( 'Children Safety', 'adina' ),
						'service_description' 	=> __( 'Our goal is to carefully educate and develop children in a fun way. We strive learning process into a bright.', 'adina' ),
					],
				],
				'title_field' 	=> '{{{ service_title }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'service_boxstyle_section',
			[
				'label' => __( 'Service Box ', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'box_margin',
			[
				'label'         => __( 'Margin', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .service-style2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();


        $this->start_controls_section(
			'service_icon_section',
			[
				'label' => __( 'Icon Box ', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_bg_color',
			[
				'label' 	=> __( 'Background Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-style2 .service-icon' => 'background-color: {{VALUE}}!important',
                ],
			]
        );

		$this->add_responsive_control(
			'icon_border_radius',
			[
				'label'         => __( 'Border Radius', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .service-style2 .service-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		
		$this->add_responsive_control(
			'icon_margin',
			[
				'label'         => __( 'Margin', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .service-style2 .service-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'service_style_title',
			[
				'label' => __( 'Title ', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'service_title_color',
			[
				'label' 	=> __( 'Title Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-title' => 'color: {{VALUE}}!important',
                ],
			]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_title_typography',
				'label' 	=> __( 'Service Title Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .service-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label'         => __( 'Margin', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .service-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'service_style_discription',
			[
				'label' => __( 'Discription ', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'service_desc_color',
			[
				'label' 	=> __( 'Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-text' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_text_typography',
				'label' 	=> __( 'Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .service-text',
			]
		);
		$this->add_responsive_control(
			'dis_margin',
			[
				'label'         => __( 'Margin', 'adina' ),
				'type'          => Controls_Manager::DIMENSIONS,
				'size_units'    => [ 'px', '%', 'em' ],
				'selectors'     => [
					'{{WRAPPER}} .service-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {
        $settings = $this->get_settings_for_display();
		?>
			<div class="row gx-80 gy-30 pt-lg-2">
				<svg class="svg-hidden">
					<clipPath id="service-clip1" clipPathUnits="objectBoundingBox">
						<path d="M0.379,0.037 C0.459,-0.006,0.558,-0.006,0.638,0.037 L0.879,0.167 C0.959,0.21,1,0.289,1,0.375 V0.635 C1,0.721,0.959,0.8,0.879,0.843 L0.638,0.973 C0.558,1,0.459,1,0.379,0.973 L0.138,0.843 C0.058,0.8,0.008,0.721,0.008,0.635 V0.375 C0.008,0.289,0.058,0.21,0.138,0.167 L0.379,0.037"></path>
					</clipPath>
				</svg>
				<?php foreach( $settings[ 'srvice_slides' ] as $srvice_slide ): ?>
					<div class="col-md-6 col-lg-4">
						<div class="service-style2">
							<?php if( $srvice_slide['service_icon']['url'] ): ?>
								<div class="service-icon">
									<div class="service-shape1"></div>
									<div class="service-shape2"></div>
									<div class="service-shape3"></div>
									<?php echo adina_img_tag( array(
										'url'	=> esc_url( $srvice_slide['service_icon']['url'] ),
										'alt'   => 'icon',
									) );
									?>
								</div>
							<?php endif; ?>
							<div class="service-content">
								<?php if( !empty( $srvice_slide[ 'service_title' ] ) ): ?>
									<h3 class="service-title">
										<a class="text-inherit" href="<?php echo esc_url( $srvice_slide[ 'service_url' ] ); ?>">
											<?php echo esc_html( $srvice_slide[ 'service_title' ] ); ?>
										</a>
									</h3>
								<?php endif; ?>
								<?php if( !empty( $srvice_slide[ 'service_description' ] ) ): ?>
									<p class="service-text">
										<?php echo esc_html( $srvice_slide[ 'service_description' ] ); ?>
									</p>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php
	}
}
$widgets_manager->register( new \Adina_Service_Box() );