<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Service Slider Widget .
 *
 */
class Adina_Service_Slider extends Widget_Base {

	public function get_name() {
		return 'adinaserviceslider';
	}

	public function get_title() {
		return __( 'Service Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Service Slider', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'service_style',
			[
				'label' 		=> __( 'Service Style', 'adina' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'adina' ),
					'2' 			=> __( 'Style Two', 'adina' ),
					'3' 			=> __( 'Style Three', 'adina' ),
					'4' 			=> __( 'Style Four', 'adina' ),
				],
			]
		);
		$this->add_control(
			'active_slider',
			[
				'label'     => esc_html__( 'Slider?', 'adina' ),
				'type'      => Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'Show', 'adina' ),
				'label_off' => esc_html__( 'Hide', 'adina' ),
				'return_value' => 'yes',
				'default'   => 'yes',
			]
		);

		$this->add_control(
			'service_column',
			[
				'label' 		=> __( 'Service Column', 'mixlax' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '3',
				'options'		=> [
					'12'  			=> __( 'Full Width', 'mixlax' ),
					'6' 			=> __( '2 Column', 'mixlax' ),
					'4' 			=> __( '3 Column', 'mixlax' ),
					'3' 			=> __( '4 Column', 'mixlax' ),
					'2' 			=> __( '6 Column', 'mixlax' ),
				],
				'condition'		=> [ 'active_slider' => '' ]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'service_image',
			[
				'label' 	=> esc_html__( 'Service Image', 'adina' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'service_icon',
			[
				'label' 	=> esc_html__( 'Service Icon', 'adina' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		

		$repeater->add_control(
			'service_title',
			[
				'label' 	=> __( 'Service Title', 'adina' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'   => __( 'Development Services', 'adina' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'service_description',
			[
				'label' 	=> __( 'Service Description', 'adina' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Completely implement via highly efficient process improvements. engage high value before progressive data.', 'adina' ),
			]
		);

		$repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'adina' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'   => __( 'Read More', 'adina' ),
				'label_block' 	=> true,
			]
		);
		
		$repeater->add_control(
			'service_url',
			[
				'label' 	=> __( 'Service Url', 'adina' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'   => __( '#', 'adina' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_title' 		=> __( 'Skin Treatment', 'adina' ),
						'service_description' 	=> __( 'There are many variations passages Ipsum available, but the majority have suffered in some.', 'adina' ),
					],
					[
						'service_title' 		=> __( 'Skin Treatment', 'adina' ),
						'service_description' 	=> __( 'There are many variations passages Ipsum available, but the majority have suffered in some.', 'adina' ),
					],
					[
						'service_title' 		=> __( 'Clean Ingredient', 'adina' ),
						'service_description' 	=> __( 'There are many variations passages Ipsum available, but the majority have suffered in some.', 'adina' ),
					],
				],
				'title_field' 	=> '{{{ service_title }}}',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'adina' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'service_style_section',
			[
				'label' => __( 'Title', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'service_title_color',
			[
				'label' 	=> __( 'Service Title Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-style1 .service-title a' => 'color: {{VALUE}}!important',
                ],
			]
        );


        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_title_typography',
				'label' 	=> __( 'Service Title Typography', 'adina' ),
                'selector' 	=> '{{WRAPPER}} .service-style1 .service-title a',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'service_style_dis',
			[
				'label' => __( 'Discription', 'adina' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'service_desc_color',
			[
				'label' 	=> __( 'Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .service-style1 .service-text' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_text_typography',
				'label' 	=> __( 'Service Slider Text Typography', 'adina' ),
                'selector' 	=> '.service-style1 .service-text',
			]
		);
		$this->end_controls_section();

		// dots
		$this->start_controls_section(
			'dots_style',
			[
				'label' 	=> __( 'Dots', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'dots_color',
			[
				'label' 		=> __( 'Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .slick-dots button' => 'background-color: {{VALUE}}',
                ]
			]
        );

		$this->add_control(
			'dots_active',
			[
				'label' 		=> __( 'Hover / Active', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .slick-dots button:hover, {{WRAPPER}} .slick-dots .slick-active button' => 'background-color: {{VALUE}}',
                ]
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if('yes'  == $settings['active_slider'] ){
			$this->add_render_attribute( 'wrapper', 'class', 'row service-carousel' );
			$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
			$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
			$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );
			$this->add_render_attribute( 'wrapper', 'data-slick-dots', 'false' );
			$column_class = '3';
		}else{
			$this->add_render_attribute( 'wrapper', 'class', 'row' );
			$column_class = $settings['service_column'];
		}

		?>
		<div <?php echo $this->get_render_attribute_string('wrapper'); ?> >
			<?php foreach( $settings[ 'slides' ] as $slides ): ?>
				<div class="service-style1 col-xl-<?php echo esc_attr($column_class); ?>">
					<div class="service-body">
						<?php if( $slides['service_image']['url'] ): ?>
							<div class="service-img">
								<a href="<?php echo esc_url($slides['service_url']); ?>">
									<?php echo adina_img_tag( array(
										'url'	=> esc_url( $slides['service_image']['url'] ),
										'alt'   => 'service',
									) );
									?>
								</a>
							</div>
						<?php endif; ?>
						<div class="service-content">
							<?php if( $slides['service_icon']['url'] ): ?>
								<div class="service-icon">
									<?php echo adina_img_tag( array(
										'url'	=> esc_url( $slides['service_icon']['url'] ),
										'alt'   => 'service',
									) );
									?>
								</div>
							<?php endif; ?>

							<?php if( $slides[ 'service_title' ] ): ?>
								<h3 class="service-title">
									<a href="<?php echo esc_url($slides['service_url']); ?>">
										<?php echo esc_html( $slides[ 'service_title' ] ) ?>
									</a>
								</h3>
							<?php endif; ?>

							<?php  if( !empty( $slides[ 'service_description' ] ) ): ?>
								<p class="service-text">
									<?php echo esc_html( $slides[ 'service_description' ]  ); ?>
								</p>
							<?php endif; ?>
							
							<?php if( $slides[ 'button_text' ] ): ?>
								<div class="service-bottom">
									<a href="<?php echo esc_url($slides['service_url']); ?>" class="service-btn">
										<?php echo esc_html( $slides[ 'button_text' ] ) ?>
									</a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>
		<?php 
	}
}
$widgets_manager->register( new \Adina_Service_Slider() );