<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Adina_Testimonial_Slider extends Widget_Base{

	public function get_name() {
		return 'adinatestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial Slider', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __( 'Testimonial Style', 'adina' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'adina' ),
					'2' 			=> __( 'Style Two', 'adina' ),
					'3' 			=> __( 'Style Three', 'adina' ),
				],
			]
		);

        $this->add_control(
			'testimonial_title',
            [
				'label'         => __( 'Title', 'adina' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'What Parents Say' , 'adina' ),
				'label_block'   => true,
				'condition'		=> [ 'testimonial_style' => [ '3' ] ],
			]
		);

		$this->add_control(
			'testimonial_sub_title',
            [
				'label'         => __( 'Sub Title', 'adina' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'SERVICE REVIEWS' , 'adina' ),
				'label_block'   => true,
				'condition'		=> [ 'testimonial_style' => [ '3' ] ],
			]
		);
		
		$repeater = new Repeater();

		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Alax Markun' , 'adina' ),
				'label_block' 	=> true,
			]
        );

		$repeater->add_control(
			'rating',
			[
				'label' 		=> __( 'Rating?', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$repeater->add_control(
			'quate',
			[
				'label' 		=> __( 'Quate', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $repeater->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'adina' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock' , 'adina' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'adina' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __( 'Alax Markun', 'adina' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'adina' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Vivi Marian', 'adina' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'adina' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'fade',
			[
				'label' 		=> __( 'Fade?', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'active_arrow',
			[
				'label' 		=> __( 'Arrow?', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'active_dots',
			[
				'label' 		=> __( 'Dots?', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		

        $this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'adina' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 2,
				],
			]
		);

		
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();


		$this->start_controls_section(
			'testimonial_general',
			[
				'label' 	=> __( 'General', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'testimonial_rating_color',
			[
				'label' 		=> __( ' Star Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-rating, {{WRAPPER}} .testi-style2 .arrow-shape' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' 		=> __( ' Box Background', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->add_responsive_control(
			'box_margin',
			[
				'label' 		=> __( 'Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		
		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1, {{WRAPPER}} .testi-style2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_name_style_section',
			[
				'label' 	=> __( 'Client Name', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_name_color',
			[
				'label' 		=> __( 'Client Name Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-name, .testi-style2 .testi-name' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_name_typography',
				'label' 	=> __( 'Client Name Typography', 'adina' ),
				'selector' 	=> '{{WRAPPER}} .testi-style1 .testi-name, .testi-style2 .testi-name',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_margin',
			[
				'label' 		=> __( 'Client Name Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-name, .testi-style2 .testi-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_padding',
			[
				'label' 		=> __( 'Client Name Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-name, .testi-style2 .testi-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_feedback_style_section',
			[
				'label' 	=> __( 'Client Feedback', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_feedback_color',
			[
				'label' 	=> __( 'Client Feedback Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi-style1 .testi-text, .testi-style2 .testi-text' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_feedback_typography',
				'label' 	=> __( 'Feedback Typography', 'adina' ),
				'selector' 	=> '{{WRAPPER}} .testi-style1 .testi-text, .testi-style2 .testi-text',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_margin',
			[
				'label' 		=> __( 'Feedback Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-text, .testi-style2 .testi-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_padding',
			[
				'label' 		=> __( 'Feedback Padding', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-style1 .testi-text, .testi-style2 .testi-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		
        $this->start_controls_section(
			'testimonial_quate_style_section',
			[
				'label' 	=> __( 'Quate', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_quate_color',
			[
				'label' 	=> __( 'Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi-icon' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_control(
			'testimonial_quate_bg_color',
			[
				'label' 	=> __( 'Backround Color', 'adina' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi-icon' => 'background-color: {{VALUE}}!important',
				],
			]
        );

        $this->add_responsive_control(
			'testimonial_quate_margin',
			[
				'label' 		=> __( 'Margin', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
			]
        );
        $this->end_controls_section();
		




	}
	protected function render() {

		$settings = $this->get_settings_for_display();


		$this->add_render_attribute( 'wrapper', 'class', 'row testimonial-carousel testislide3' );

		if( $settings['active_dots'] == 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-slick-dots', 'true' );
		} else {
			$this->add_render_attribute( 'wrapper', 'data-slick-dots', 'false' );
		}
		if( $settings['fade'] == 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-slick-fade', 'true' );
		} else {
			$this->add_render_attribute( 'wrapper', 'data-slick-fade', 'false' );
		}
		if( $settings['slider_autoplay'] == 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'true' );
		} else {
			$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
		}
		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );

		$testimonial_style = $settings[ 'testimonial_style' ];

		?>	
		<div class="">
			<?php if( '3'  == $settings[ 'testimonial_style' ] ): ?>
				<div class="row justify-content-between text-center text-md-start">
					<div class="col-md-auto">
						<div class="title-area">
							<?php if( !empty( $settings[ 'testimonial_sub_title' ] ) ): ?>
								<span class="sec-subtitle">
									<?php echo esc_html( $settings[ 'testimonial_sub_title' ] ); ?>
								</span>
							<?php endif; ?>
							<?php if( !empty( $settings[ 'testimonial_title' ] ) ): ?>
								<h2 class="sec-title"><?php echo esc_html( $settings[ 'testimonial_title' ] ); ?></h2>
							<?php endif; ?>
						</div>
					</div>
					<?php if( 'yes'  == $settings['active_arrow']): ?>			
						<div class="col-md-auto align-self-end">
							<div class="sec-btns">
								<button class="icon-btn" data-slick-prev=".testislide3"><i class="far fa-arrow-left"></i></button>
								<button class="icon-btn" data-slick-next=".testislide3"><i class="far fa-arrow-right"></i></button>
							</div>
						</div>
					<?php endif; ?>	
				</div>
			<?php endif; ?>

			
			<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
				<?php 	
					if ($testimonial_style) {
						include('testimonila/'.$testimonial_style.'.php');
					}
				?>
			</div>
		</div>
		<?php 
	}
}
$widgets_manager->register( new \Adina_Testimonial_Slider() );
