<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaAuthorBox extends Widget_Base {
    public function get_name() {
        return 'adina-author-box';
    }
    public function get_title() {
        return __('Author Box', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Author','Box','Image'];
    }

    protected function register_controls() {
        
        $this->start_controls_section('general_section',
            [
                'label' => __('Author Box', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'author_image',
			[
				'label' => esc_html__( 'Images', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'author_name',
			[
				'label' => esc_html__( 'Author Name', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Rebecca Tylor', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'author_designation',
			[
				'label' => esc_html__( 'Author Designation', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'CEO - Founder', 'adina' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();

        
        
    
    /********* Start Style Controls /*********/
    
        /////////////// Author Image /////////////////////
        $this->start_controls_section(
            '_Author_image_style',
            [
                'label' => __( 'Images', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            ' Author_images_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            ' Author_images_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            ' Author_images_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'author_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'author_images_border',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img',
            ]
        );
        $this->add_control(
            ' Author_images',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            ' Author_images_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            ' Author_images_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .img-box img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        ///////////////// Author title////////////////////////////
        $this->start_controls_section(
            '_author_name',
            [
                'label' => __( 'Author Name', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'author_color',
            [
                'label' => __( 'author Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .text-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'author_title_typography',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .author-box .text-box h3',
            ]
        );
        $this->add_responsive_control(
            'author_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .text-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'author_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .text-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////// Designation////////////////////////////
        $this->start_controls_section(
            'designation_text',
            [
                'label' => __( 'Designation Text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'designation_color',
            [
                'label' => __( ' designation Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .author-box .text-box p',
            ]
        );
        $this->add_responsive_control(
            'designation_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'designation_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .author-box .text-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();



        ?>
                <div class="about-two__content-bottom">
                    <div class="author-box">
                      <?php if( !empty( $settings[ 'author_image' ]['url'] ) ): ?>
                        <div class="img-box">
                            <img src="<?php echo esc_url( $settings[ 'author_image' ]['url'] ); ?>" alt="">
                        </div>
                        <?php endif;  ?>

                        <!-- Author Name -->
                        <div class="text-box">
                           <?php if( !empty( $settings[ 'author_name' ] ) ): ?>
                            <h3><?php echo adina_kses( $settings[ 'author_name' ] ); ?></h3>
                            <?php endif;  ?>

                            <!--designation  -->
                            <?php if( !empty( $settings[ 'author_designation' ] ) ): ?>
                            <p><?php echo adina_kses( $settings[ 'author_designation' ] ); ?></p>
                            <?php endif;  ?>
                        </div>
                    </div>
                </div>

        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaAuthorBox());