<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
/**
 *
 * Gallery Image Widget .
 *
 */
class Adina_Brand_Logo extends Widget_Base {

	public function get_name() {
		return 'adinabrandlogo';
	}

	public function get_title() {
		return __( 'Brand Images', 'adina' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'adina' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'brand_image_section',
			[
				'label' 	=> __( 'Brand Logo', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'brand_image',
			[
				'label' 	=> __( 'Image', 'adina' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'brand',
			[
				'label' 		=> __( 'Brand Images', 'adina' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'brand_image' => Utils::get_placeholder_image_src(),
					],
					[
						'brand_image' => Utils::get_placeholder_image_src(),
					],
					[
						'brand_image' => Utils::get_placeholder_image_src(),
					],
					[
						'brand_image' => Utils::get_placeholder_image_src(),
					],
					[
						'brand_image' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Two Control', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'active_arrow',
			[
				'label' 		=> __( 'Arrow?', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		

        $this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'adina' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 4,
				],
			]
		);

		
		$this->add_control(
			'slider_autoplay',
			[
				'label' 		=> __( 'Autoplay', 'adina' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'adina' ),
				'label_off' 	=> __( 'No', 'adina' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
        $this->add_control(
			'slider_speed',
			[
				'label' => __('Autoplay Timeout', 'adina'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'default' => '10000',
				'options' => [
					'1000'  => __('1 Second', 'adina'),
					'2000'  => __('2 Second', 'adina'),
					'3000'  => __('3 Second', 'adina'),
					'4000'  => __('4 Second', 'adina'),
					'5000'  => __('5 Second', 'adina'),
					'6000'  => __('6 Second', 'adina'),
					'7000'  => __('7 Second', 'adina'),
					'8000'  => __('8 Second', 'adina'),
					'9000'  => __('9 Second', 'adina'),
					'10000' => __('10 Second', 'adina'),
					'11000' => __('11 Second', 'adina'),
					'12000' => __('12 Second', 'adina'),
					'13000' => __('13 Second', 'adina'),
					'14000' => __('14 Second', 'adina'),
					'15000' => __('15 Second', 'adina'),
				],
				'condition' => [
					'slider_autoplay' => 'yes',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'brand_box',
			[
				'label' 		=> __( 'Box', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'color',
			[
				'label' 		=> __( 'Background Color', 'adina' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .brand-style1' => 'background-color: {{VALUE}} !important',
                ]
			]
        );
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'border',
				'label'     => __( 'Border', 'adina' ),
				'selector'  => '{{WRAPPER}} .brand-style1',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'      => 'border_hover',
				'label'     => __( 'Border Hover', 'adina' ),
				'selector'  => '{{WRAPPER}} .brand-style1',
			]
		);

        $this->add_control(
			'border_radius',
			[
				'label' 		=> __( 'Border Radius', 'adina' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .brand-style1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
			]
		);
        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();


        $this->add_render_attribute( 'wrapper', 'class', 'row brand-carousel gx-10' );
        $this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );
        $this->add_render_attribute( 'wrapper', 'data-slider-speed', $settings['slider_speed']);

        if('yes' == $settings[ 'slider_autoplay' ]){
            $this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'true' );
        }else{
            $this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
        }
        

        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <?php foreach( $settings['brand'] as $singlelogo ): ?>
                <div class="col-auto" >
                    <div class="brand-style1">
                        <?php if( $singlelogo['brand_image']['url'] ): ?>
                            <div class="brand-img">
                                <?php echo adina_img_tag( array(
                                    'url'	=> esc_url( $singlelogo['brand_image']['url'] ),
                                    'alt'   => 'brand',
                                ) );
                                ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <?php 
		
	}
}
$widgets_manager->register( new \Adina_Brand_Logo() );

?>
		