<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaBrandOne extends Widget_Base {
    public function get_name() {
        return 'adina-brand-one';
    }
    public function get_title() {
        return __('Brand One', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Brand', 'Slider', 'Slick'];
    }

    protected function register_controls() {
        
        $this->start_controls_section(
            'brand_section',
            [
                'label' => __('Brand Section', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'big_title',
			[
				'label' => esc_html__( ' Big Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'partner', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'brand_shape',
			[
				'label' => esc_html__( 'Right Shape', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $brand_repeater = new Repeater();

        $brand_repeater->add_control(
			'brand_image01',
			[
				'label' => esc_html__( 'Image 01', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $brand_repeater->add_control(
			'brand_image02',
			[
				'label' => esc_html__( 'Image 02', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'adina_brand_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $brand_repeater->get_controls(),
				'default' => [
					[
						'brand_image01'        => Utils::get_placeholder_image_src(), 
                        'brand_image02'        => Utils::get_placeholder_image_src(),
					],
                    [
						'brand_image01'        => Utils::get_placeholder_image_src(), 
                        'brand_image02'        => Utils::get_placeholder_image_src(),
					],
                    [
						'brand_image01'        => Utils::get_placeholder_image_src(), 
                        'brand_image02'        => Utils::get_placeholder_image_src(),
					],
				],
			]
		);
        $this->end_controls_section();


         /********* End Style Controls /*********/

                 // //////// Brand title in here /////////
        $this->start_controls_section(
            '_brand_bottom_title',
            [
                'label' => __( 'Big Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bottom_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .brand-one .big-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bottom_title_typography',
                'selector' => '{{WRAPPER}} .brand-one .big-title',
            ]
        );
        $this->add_responsive_control(
            'bottom_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .brand-one .big-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'bottom_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .brand-one .big-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // /////////  Brand background color //////////////////
        $this->start_controls_section(
            'brand_backgeound_color',
            [
                'label' => __( 'Brand Box', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'brand_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .brand-one',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'brand_border',
                'selector' => '{{WRAPPER}} .brand-one',
            ]
        );
        $this->add_responsive_control(
            'brand_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .brand-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $slides = $settings[ 'adina_brand_slides' ];
        
        ?>

                    <!--Start Brand One-->
            <div class="brand-one">
               <?php if( !empty( $settings[ 'brand_shape' ]['url'] ) ): ?>
                <div class="shape1 float-bob-x"><img src="<?php echo esc_url( $settings[ 'brand_shape' ]['url'] ); ?>" alt=""></div>
                <?php endif; ?>
                <!--  -->
                <?php if ( !empty($settings['big_title']) ) : ?>
                <div class="big-title"><?php echo adina_kses( $settings['big_title'] ); ?></div>
                <?php endif; ?>

                <div class="container">
                    <div class="thm-swiper__slider swiper-container">
                    <div class="swiper-wrapper">
                        <!-- foreach loop -->
                        <?php foreach( $slides as $slide  ):
                    
                            ?>

                        <div class="swiper-slide">
                        <?php if( !empty( $slide[ 'brand_image01' ]['url'] ) ): ?>
                            <div class="img-box">
                                <img src="<?php echo esc_url( $slide[ 'brand_image01' ]['url'] ); ?>" alt="#">
                            </div>
                            <?php endif; ?>

                            <?php if( !empty( $slide[ 'brand_image02' ]['url'] ) ): ?>
                            <div class="img-box2">
                                <img src="<?php echo esc_url( $slide[ 'brand_image02' ]['url'] ); ?>" alt="#">
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; ?>

                    </div>
                </div>
            </div>
            <!--End Brand One -->
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaBrandOne());

