<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaButton extends Widget_Base {
    public function get_name() {
        return 'adina-button';
    }
    public function get_title() {
        return __('Adina Button', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Button'];
    }

    protected function register_controls() {
        
        $this->start_controls_section('general_section',
            [
                'label' => __('Button', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            '_button_icon',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Icon', 'adina' ),
            ]
        );
        $this->add_control(
			'arrow_icon_btn',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-right-arrow', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Calculate Package', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		); 
        $this->end_controls_section();

        
        
    
    /********* Start Style Controls /*********/
    

        // /////////////// button hero 01/////////////////
        $this->start_controls_section(
            '_hero_01_button',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
       /////////////////// Button Normal part/////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'Normal_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'normal_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'normal_text_typography',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'normal_text_shadow',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after',
            ]
        );
        $this->add_responsive_control(
            'normal_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:after' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
    

        ////////////// Button Hover part in here ////////////////////////
        $this->start_controls_tab(
            'style_hover_tabss',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'adina' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hover_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'hover_text_typography',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn .txt',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_text_border',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'hover_text_shadow',
                'selector' => '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before',
            ]
        );
        $this->add_responsive_control(
            'hover_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-bottom .btn-box .thm-btn::before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();



        ?>
            <div class="about-two__content-bottom">
            <?php if( !empty( $settings[ 'btn_text' ] ) ): ?>
                <div class="btn-box">
                    <a class="thm-btn" href="<?php echo esc_url( $settings['btn_url'] ); ?>">
                        <span class="txt"><?php echo esc_html(  $settings[ 'btn_text' ] ); ?></span> <i class="<?php echo esc_html(  $settings[ 'arrow_icon_btn' ] ); ?>"></i>
                    </a>
                </div>
                <?php endif;  ?>
            </div>

        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaButton());