<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaCheckList extends Widget_Base {
    public function get_name() {
        return 'adina-check_list';
    }
    public function get_title() {
        return __('Check List', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Check-list', 'Icon', 'Box'];
    }

    protected function register_controls() {
        
        $this->start_controls_section(
            'check_list',
            [
                'label' => __('Check List', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $checklist_repeater = new Repeater();
        
        $checklist_repeater->add_control(
            'checklist_icon_show',
            [
                'label' => esc_html__( 'Icon show', 'adina' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'adina' ),
                'label_off' => esc_html__( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $checklist_repeater->add_control(
			'checklist_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-check-marked-1', 'adina' ),
				'label_block' => true,
                'condition' => [
                    'checklist_icon_show' => 'yes'
                ],
			]
		);
        $checklist_repeater->add_control(
			'checklist_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Day-to-day fleet management', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'adina_check_list',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $checklist_repeater->get_controls(),
				'default' => [
					[
						'checklist_icon'     => esc_html__( 'icon-check-marked-1', 'adina' ),
                        'checklist_content'  => esc_html__( 'Day-to-day fleet management', 'adina' ),
					],
                    [
						'checklist_icon'      => esc_html__( 'icon-check-marked-1', 'adina' ),
                        'checklist_content'   => esc_html__( 'Day-to-day fleet management', 'adina' ),
					],
				],
			]
		);
        $this->end_controls_section();


         /********* End Style Controls /*********/

        ///////// Check List Icon ///////////
        $this->start_controls_section(
            '_check_lists_icon',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'check_lists_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-two__content-list ul li .icon-box span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'check_lists_height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .about-two__content-list ul li .icon-box span' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'check_lists_border_colors',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'check_lists_border',
                'selector' => '{{WRAPPER}} .about-two__content-list ul li .icon-box span',
            ]
        );
        $this->add_control(
            'check_lists_iconss',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li .icon-box span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .about-two__content-list ul li .icon-box span',
			]
		);
        $this->add_responsive_control(
            'check_lists_conten_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li .icon-box span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'check_lists_content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li .icon-box span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
  
        ////////////// Content/////////////////////
        $this->start_controls_section(
            '_check_lists_content_text',
            [
                'label' => __( 'Content text', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'check_lists_content_text_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_title_typography',
                'selector' => '{{WRAPPER}} .about-two__content-list ul li p',
            ]
        );
        $this->add_responsive_control(
            'check_listsl_content_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'check_lists_content_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .about-two__content-list ul li p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $slides = $settings[ 'adina_check_list' ];
        
        ?>

            <div class="about-two__content-list">
                <ul>
                  <?php foreach( $slides as $slide  ):
                        
                   ?>
                    <li>
                        <!-- Icon in here -->
                        <?php if ( !empty( $slide['checklist_icon']) ) : ?>
                        <div class="icon-box">
                            <span class="<?php echo adina_kses( $slide['checklist_icon'] ); ?>"></span>
                        </div>
                        <?php endif; ?>
                         <!--  Content  text  in here -->
                         <?php if ( !empty( $slide['checklist_content']) ) : ?>
                        <p><?php echo adina_kses( $slide['checklist_content'] ); ?></p>
                        <?php endif; ?>
                    </li>
                    <?php endforeach; ?>

                </ul>
            </div>

        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaCheckList());

