<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Group_Control_Typography;
/**
 *
 * Counter Box Widget .
 *
 */

class Adina_Counter_Box extends Widget_Base {

	public function get_name() {
		return 'adinacounterbox';
	}

	public function get_title() {
		return __( 'Counter Box', 'adina' );
	}

	public function get_icon() {
		return 'eicon-code adina';
    }

	public function get_categories() {
		return [ 'adina' ];
	}

    public function get_keywords() {
		return [ 'counter'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'adina_counter',
			[
				'label' 	=> __( 'Counter Box', 'adina' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		
        $this->add_control(
			'counter_image',
			[
				'label' 	=> __( 'Counter Image', 'adina' ),
                'type' 		=> Controls_Manager::MEDIA,
                'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
        );
        
        $this->add_control(
			'countdown_title',
			[
				'label' 	=> __( 'Countdown Title', 'adina' ),
                'type' 		=> Controls_Manager::TEXT,
				'default'   => __( 'Seminar Staring Soon', 'adina' ),
			]
        );

        $this->add_control(
			'countdown_date',
			[
				'label' 	=> __( 'Countdown Date ( Format Like 01/12/2024 )', 'adina' ),
                'type' 		=> Controls_Manager::TEXT,
				'default'   => __( '01/12/2024', 'adina' ),
			]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label'		 	=> __( 'General Style', 'adina' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label'     => __( 'Box Bg Color', 'adina' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .countdown-style1' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => __(' Title Color', 'adina'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .countdown-style1 .countdown-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'title_typography',
				'label' 		=> __( 'Typography', 'adina' ),
				'selector' 		=> '{{WRAPPER}} .countdown-style1 .countdown-title',
			]
		);

        $this->add_control(
            'countdown_color',
            [
                'label'     => __( 'Countdown Color', 'adina'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .countdown-style1 li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'countdown_typography',
				'label' 		=> __( 'Countdown Typography', 'adina' ),
				'selector' 		=> '{{WRAPPER}} .countdown-style1 li',
			]
		);
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<div class="countdown-style1">';
            if( ! empty( $settings['countdown_date'] ) ){
                echo '<ul class="countdown-active" data-end-date="'.esc_attr( $settings['countdown_date'] ).'">';
                    echo '<li><span class="day"></span>d</li>';
                    echo '<li><span class="hour"></span>h</li>';
                    echo '<li><span class="minute"></span>m</li>';
                    echo '<li><span class="seconds"></span>S</li>';
                echo '</ul>';
            }
        echo '</div>';
	}
}
$widgets_manager->register_widget_type( new \Adina_Counter_Box() );