<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaCounter extends Widget_Base {
    public function get_name() {
        return 'adina-counter';
    }
    public function get_title() {
        return __('Counter', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['counter', 'number'];
    }

    protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'adina_counter',
            [
                'label' => esc_html__('Content', 'adina'),
            ]
        );
        $this->add_control(
            'counter_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                    'layout-4' => esc_html__('Layout 4', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->add_control(
			'counter_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome Class (for layout-2 & 3)', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-special-shipments', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'icon_bg',
			[
				'label' => esc_html__( 'Icon Background Shape', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'counter_layout' => 'layout-4'
                ],
			]
		);
        $this->add_control(
			'counter_prefix',
			[
				'label' => esc_html__( 'Prefix (for layout-2 & 4)', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'counter_number',
			[
				'label' => esc_html__( 'Number', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '35', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'counter_suffix',
			[
				'label' => esc_html__( 'Suffix (for layout-1 & 3)', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'counter_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Years of Experience', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();


        /********* Start Box Style /*********/
        $this->start_controls_section(
            'Box_style',
            [
                'label' => __( 'Counter Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single, .fact-counter-two__single-inner, .why-choose-two__counter-single' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .fact-counter-one__single, .fact-counter-two__single-inner, .why-choose-two__counter-single',
            ]
        );
        $this->add_control(
            'box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single, .fact-counter-two__single-inner, .why-choose-two__counter-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single, .fact-counter-two__single, .why-choose-two__counter-single' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single, .fact-counter-two__single-inner, .why-choose-two__counter-single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_top_padding',
            [
                'label' => __( 'Top Padding (for layout-2)', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'content_align',
			[
				'label' => esc_html__( 'Alignment', 'adina' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .fact-counter-two__single' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->end_controls_section();

        /********* End Box Style /*********/

        /********* Start Icon Style /*********/
        $this->start_controls_section(
            'icon_style',
            [
                'label' => __( 'Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single .icon-box span, .why-choose-two__counter-single .icon-box span, .fact-counter-two--about .fact-counter-two__single .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single .icon-box, .fact-counter-two--about .fact-counter-two__single .icon-box span' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
			'icon_width',
			[
				'label' => esc_html__( 'Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'selectors' => [
					'{{WRAPPER}} .fact-counter-two__single .icon-box, .why-choose-two__counter-single .icon-box, .fact-counter-two--about .fact-counter-two__single .icon-box span' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'icon_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single .icon-box, .why-choose-two__counter-single .icon-box, .fact-counter-two--about .fact-counter-two__single .icon-box span' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icon_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single .icon-box, .why-choose-two__counter-single .icon-box, .fact-counter-two--about .fact-counter-two__single .icon-box span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* End Icon Style /*********/

        /********* Start Prefix Style /*********/
        $this->start_controls_section(
            'prefix_style',
            [
                'label' => __( 'Prefix', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'prefix_color',
            [
                'label' => __('Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single-inner h2 .plus' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'prefix_typography',
                'selector' => '{{WRAPPER}} .fact-counter-two__single-inner h2 .plus',
            ]
        );

        $this->end_controls_section();

        /********* End Prefix Style /*********/

        /********* Start Number Style /*********/
        $this->start_controls_section(
            'number_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'number_color',
            [
                'label' => __('Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single .inner h2, .fact-counter-two__single-inner h2, .why-choose-two__counter-single .text-box h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .fact-counter-one__single .inner h2, .fact-counter-two__single-inner h2, .why-choose-two__counter-single .text-box h2',
            ]
        );
        $this->add_responsive_control(
            'number_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-two__single.layout-04 .fact-counter-two__single-inner h2, .fact-counter-one__single .inner h2, .fact-counter-two__single-inner h2, .why-choose-two__counter-single .text-box h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* End Number Style /*********/

        /********* Start Suffix Style /*********/
        $this->start_controls_section(
            'suffix_style',
            [
                'label' => __( 'Suffix', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'suffix_color',
            [
                'label' => __('Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single .inner h2 .plus, .why-choose-two__counter-single .text-box h2 .plus' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'suffix_typography',
                'selector' => '{{WRAPPER}} .fact-counter-one__single .inner h2 .plus, .why-choose-two__counter-single .text-box h2 .plus',
            ]
        );

        $this->end_controls_section();

        /********* End Suffix Style /*********/

        /********* Start Title Style /*********/
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single .inner .text p, .fact-counter-two__single-inner .text p, .why-choose-two__counter-single .text-box .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .fact-counter-one__single .inner .text p, .fact-counter-two__single-inner .text p, .why-choose-two__counter-single .text-box .text p',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single .inner .text, .fact-counter-two__single-inner .text, .why-choose-two__counter-single .text-box .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .fact-counter-one__single .inner .text, .fact-counter-two__single-inner .text, .why-choose-two__counter-single .text-box .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /********* End Title Style /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display(); 
        $layout = $settings['counter_layout'];

        ?> 
            <?php
                if ( $layout) {
                    include('counter/'.$layout.'.php');
                }
            ?>
        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaCounter());

