<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaCtaBox extends Widget_Base {
    public function get_name() {
        return 'adina_cta_box';
    }
    public function get_title() {
        return __('Cta Box', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['cta', 'cta-box'];
    }
    protected function register_controls() {
        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'cta1_shape',
			[
				'label' => esc_html__( 'Shape One', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'cta2_shape',
			[
				'label' => esc_html__( 'Shape Two', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'cta3_shape',
			[
				'label' => esc_html__( 'Shape Three', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'cta_title',
			[
				'label' => esc_html__( 'Cta Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'We are best transport agency for give best quality service', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'cta_btn',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Request Services', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();


        // Cta Box STYLE
        $this->start_controls_section('cta_box_style',
            [
                'label' => __('Cta Box', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'cta_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .cta-one' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'cta_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Cta Title STYLE
        $this->start_controls_section('cta_title_style',
            [
                'label' => __('Cta Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'cta_title_colors',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .title-box h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'cta_title_typography',
                'selector' => '{{WRAPPER}} .cta-one__inner-box .title-box h2',
            ]
        );
        $this->add_responsive_control(
            'cta_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .title-box h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'cta_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .title-box h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Button STYLE
        $this->start_controls_section('btn_style',
            [
                'label' => __('Button', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'btn_styles'
        );

        $this->start_controls_tab(
            'btn_normal_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_colors',
            [
                'label' => __( 'Button Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .btn-box .thm-btn::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typography',
                'selector' => '{{WRAPPER}} .cta-one__inner-box .btn-box .thm-btn',
            ]
        );
        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} ..cta-one__inner-box .btn-box .thm-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} ..cta-one__inner-box .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();


        $this->start_controls_tab(
            'btn_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'btn_hover_colors',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .btn-box .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one__inner-box .btn-box .thm-btn::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

    ?>
        
        <section class="cta-one">
            <div class="container">
                <div class="cta-one__inner">
                    <div class="cta-one__shape1"><img src="<?php echo esc_url( $settings['cta1_shape']['url'] ); ?>" alt=""></div>
                    <div class="cta-one__shape2"><img src="<?php echo esc_url( $settings['cta2_shape']['url'] ); ?>" alt=""></div>
                    <div class="cta-one__shape3 float-bob-x">
                        <img src="<?php echo esc_url( $settings['cta3_shape']['url'] ); ?>" alt="#">
                    </div>
                    <div class="cta-one__inner-box">
                        <div class="title-box">
                            <h2><?php echo esc_html( $settings['cta_title']); ?></h2>
                        </div>

                        <div class="btn-box">
                            <a class="thm-btn" href="<?php echo esc_url( $settings['btn_url'] ); ?>">
                                <span class="txt"><?php echo esc_html( $settings['cta_btn']); ?></span> <i class="icon-right-arrow"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaCtaBox());