<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaFaqSection extends Widget_Base {
    public function get_name() {
        return 'adina-faq-section';
    }
    public function get_title() {
        return __('Faq Section', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Faq', 'Section'];
    }

    protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Content', 'adina'),
            ]
        );
        $this->add_control(
            'faq_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        // /////// Faq left part ////////////////////
        $this->start_controls_tabs(
            'style_tabsee'
        );
        $this->start_controls_tab(
            'faq_left_parts',
            [
                'label' => esc_html__( 'Faq Left Part', 'adina' ),
            ]
        );
        $this->add_control(
			'faq_bg_image',
			[
				'label' => esc_html__( 'Background Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'big_faq_title',
			[
				'label' => esc_html__( 'Big Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Faq', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'faq_h1_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-right-arrow-1', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'faq_h1_top_title',
			[
				'label' => esc_html__( 'Heading Top Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'FAQ ?', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'faq_h1_title',
			[
				'label' => esc_html__( 'Heading Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Question & Answer', 'adina' ),
				'label_block' => true,
			]
		);
        $faqlists = new Repeater();
        $faqlists->add_control(
            'faq_active',
            [
                'label' => __('Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        $faqlists->add_control(
			'faq_number_title',
			[
				'label' => esc_html__( 'Number', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '01', 'adina' ),
				'label_block' => true,
			]
		);
        $faqlists->add_control(
			'faq_title',
			[
				'label' => esc_html__( 'faq Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'How can I pay for your logistics services?', 'adina' ),
				'label_block' => true,
			]
		);
        $faqlists->add_control(
			'faq_ans_title',
			[
				'label' => esc_html__( 'Answer Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Answer', 'adina' ),
				'label_block' => true,
			]
		);
        $faqlists->add_control(
			'faq_content',
			[
				'label' => esc_html__( 'Faq Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
                tempor incididunt ut labore et dolore magna aliqua', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'faqsection_list',
			[
				'label' => esc_html__( 'faq Box', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $faqlists->get_controls(),
				'default' => [
					[
						'faq_number_title'=> esc_html__( '01', 'adina' ),
                        'faq_title'       => esc_html__( ' How can I pay for your logistics services?', 'adina' ),
						'faq_ans_title'   => esc_html__( 'Answer', 'adina' ),
						'faq_content'     => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
                        tempor incididunt ut labore et dolore magna aliqua', 'adina' ),
						'faq_active'      =>  __('Active', 'adina'),
					],
                    [
						'faq_number_title'=> esc_html__( '01', 'adina' ),
                        'faq_title'       => esc_html__( ' How can I pay for your logistics services?', 'adina' ),
						'faq_ans_title'   => esc_html__( 'Answer', 'adina' ),
						'faq_content'     => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
                        tempor incididunt ut labore et dolore magna aliqua', 'adina' ),
						'faq_active'      =>  __('Active', 'adina'),
					],
                    [
						'faq_number_title'=> esc_html__( '01', 'adina' ),
                        'faq_title'       => esc_html__( ' How can I pay for your logistics services?', 'adina' ),
						'faq_ans_title'   => esc_html__( 'Answer', 'adina' ),
						'faq_content'     => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
                        tempor incididunt ut labore et dolore magna aliqua', 'adina' ),
						'faq_active'      =>  __('Active', 'adina'),
					],
				],
                'title_field' => '{{{ faq_title }}}',

			]
		);
        $this->end_controls_tab();

        // ////// faq right part ///////////////////////////
        $this->start_controls_tab(
            'style_normal_tabse',
            [
                'label' => esc_html__( 'Faq Right Part', 'adina' ),
            ]
        );
        $this->add_control(
			'right_top_title',
			[
				'label' => esc_html__( 'Top Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Let’s Talk', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'right_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'You need any help? get free consultation', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'right_phone_icon',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-call', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'right_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Have Any Questions', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'Right_number',
			[
				'label' => esc_html__( 'Number', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '(00) 112 365 489', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'number_url',
			[
				'label' => esc_html__( 'Number Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Contact Us', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		); 
        $this->end_controls_tabs();
        $this->end_controls_section();


        /////////////////////faq border  Styles ///////////////////////////
        $this->start_controls_section(
            'container_styles',
            [
                'label' => __( 'Container', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'left_bggg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one, .faq-one--two' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'container_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'container_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /////////////////////faq border  Styles ///////////////////////////
        $this->start_controls_section(
            'faq_container_styles',
            [
                'label' => __( 'Accordion', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'container_border',
                'selector' => '{{WRAPPER}} .faq-one__faq ul li',
            ]
        );
        $this->end_controls_section();
        
        /////////////// Faq big title ////////////////////
        $this->start_controls_section(
            '_faq_big_title',
            [
                'label' => __( 'Faq Big Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'big_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one .big-title h2, .faq-one--two .big-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'selector' => '{{WRAPPER}} .faq-one .big-title h2, .faq-one--two .big-title h2',
			]
		);
        $this->add_responsive_control(
            'big_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one .big-title h2, .faq-one--two .big-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'big_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one .big-title h2, .faq-one--two .big-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////Heading Top title ////////////////////
        $this->start_controls_section(
            '_heading_title_top1',
            [
                'label' => __( 'Heading Top Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'heading_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one--two .sec-title-two .sub-title' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'heading_top_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title .sub-title h5, .sec-title-two .sub-title h5' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Top-typography',
                'selector' => '{{WRAPPER}} .sec-title .sub-title h5, .sec-title-two .sub-title h5',
            ]
        );
        $this->add_responsive_control(
            'heading_top_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title .sub-title h5, .sec-title-two .sub-title h5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'heading_top_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title .sub-title h5, .sec-title-two .sub-title h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .sec-title-two .sub-title::before',
            ]
        );

        $this->end_controls_section();

        
        ///////////////Heading Title ////////////////////
        $this->start_controls_section(
            '_heading_title',
            [
                'label' => __( 'Heading Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'heading_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__faq .sec-title h2, .faq-one--two .sec-title-two h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title-typography',
                'selector' => '{{WRAPPER}} .faq-one__faq .sec-title h2, .faq-one--two .sec-title-two h2',
            ]
        );
        $this->add_responsive_control(
            'heading_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__faq .sec-title h2, .faq-one--two .sec-title-two h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'heading_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__faq .sec-title h2, .faq-one--two .sec-title-two h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////Number Title  faq////////////////////
        $this->start_controls_section(
            '_number_title',
            [
                'label' => __( 'Faq Number', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'number_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span, .faq-one__accrodion .accrodion .accrodion-title h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number-typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span, .faq-one__accrodion .accrodion .accrodion-title h2 span',
            ]
        );
        $this->add_responsive_control(
            'number_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span, .faq-one__accrodion .accrodion .accrodion-title h2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'number_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span, .faq-one__accrodion .accrodion .accrodion-title h2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Faq Title ////////////////////
        $this->start_controls_section(
            '_faq_title',
            [
                'label' => __( 'Faq Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'faqtitle_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one--two .faq-one__accrodion .accrodion.active .accrodion-title' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'faq_title_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2, .faq-one__accrodion .accrodion .accrodion-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'faq-typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2, .faq-one__accrodion .accrodion .accrodion-title h2',
            ]
        );
        $this->add_responsive_control(
            'faq_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2, .faq-one__accrodion .accrodion .accrodion-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'faq_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2, .faq-one__accrodion .accrodion .accrodion-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Answer Title ////////////////////
        $this->start_controls_section(
            '_Answer_title',
            [
                'label' => __( 'Answer', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Answer_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner span, .faq-one__accrodion .accrodion .accrodion-content .inner span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Answer-typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner span, .faq-one__accrodion .accrodion .accrodion-content .inner span',
            ]
        );
        $this->add_responsive_control(
            'Answer_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner span, .faq-one__accrodion .accrodion .accrodion-content .inner span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Answer_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner span, .faq-one__accrodion .accrodion .accrodion-content .inner span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //////////////Faq content ////////////////////
        $this->start_controls_section(
            '_content_faq',
            [
                'label' => __( 'Content', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner p,.faq-one__accrodion .accrodion .accrodion-content .inner p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content-typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner p, .faq-one__accrodion .accrodion .accrodion-content .inner p',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner p, .faq-one__accrodion .accrodion .accrodion-content .inner p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner p, .faq-one__accrodion .accrodion .accrodion-content .inner p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /////////////////////  faq active Icon ///////////////////////////
        $this->start_controls_section(
            'icon_styles',
            [
                'label' => __( 'Active/Inactive Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'active_icon_colors',
            [
                'label' => __( 'Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion.active .accrodion-title h2::before, .faq-one--two .faq-one__accrodion .accrodion.active .accrodion-title h2::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'inactive_icon_colors',
            [
                'label' => __( 'Inactive Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2::before, .faq-one__accrodion .accrodion .accrodion-title h2::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'icon_typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2::before, .faq-one--two .faq-one__accrodion .accrodion .accrodion-title h2::before {
                    ',
            ]
        );
        $this->end_controls_section();

        ////////////// Right Box ///// Right part///////////////
        $this->start_controls_section(
            '_right_box_title',
            [
                'label' => __( 'Right Box', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'right_box_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info, .faq-one--two .faq-one__contact-info' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'right_box__margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info, .faq-one__contact-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'right_box__padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info, .faq-one__contact-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //////////////Top  title ///// Right part///////////////
        $this->start_controls_section(
            '_righttop_title',
            [
                'label' => __( 'Top Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'righttop_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .title-box p, .faq-one--two .faq-one__contact-info .title-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'righttop-typography',
                'selector' => '{{WRAPPER}} .faq-one__contact-info .title-box p, .faq-one--two .faq-one__contact-info .title-box p',
            ]
        );
        $this->add_responsive_control(
            'righttop_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .title-box p, .faq-one--two .faq-one__contact-info .title-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'righttop_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .title-box p, .faq-one--two .faq-one__contact-info .title-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// title ///// Right part///////////////
        $this->start_controls_section(
            '_right_title',
            [
                'label' => __( 'Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'right_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .title-box h3, .faq-one__contact-info .title-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'right-typography',
                'selector' => '{{WRAPPER}} .faq-one__contact-info .title-box h3, .faq-one__contact-info .title-box h3',
            ]
        );
        $this->add_responsive_control(
            'right_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .title-box h3, .faq-one__contact-info .title-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'right_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .title-box h3, .faq-one__contact-info .title-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Sub  title ///// Right part///////////////
        $this->start_controls_section(
            '_right_sub_title',
            [
                'label' => __( 'Sub Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'right_sub_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .text p, .faq-one__contact-info-number .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'right_sub-typography',
                'selector' => '{{WRAPPER}} .faq-one__contact-info-number .text p, .faq-one__contact-info-number .text p',
            ]
        );
        $this->add_responsive_control(
            'right_sub_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .text p, .faq-one__contact-info-number .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'right_sub_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .text p, .faq-one__contact-info-number .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Number title ///// Right part///////////////
        $this->start_controls_section(
            '_right_number_title',
            [
                'label' => __( 'Contact Number', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'right_number_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .text h3 a, .faq-one__contact-info-number .text h3 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'right_number-typography',
                'selector' => '{{WRAPPER}} .faq-one__contact-info-number .text h3, .faq-one__contact-info-number .text h3',
            ]
        );
        $this->add_responsive_control(
            'right_number_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .text h3, .faq-one__contact-info-number .text h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'right_number_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .text h3, .faq-one__contact-info-number .text h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ////////////// Icon color  ///// Right part///////////////
        $this->start_controls_section(
            '_right_icon',
            [
                'label' => __( 'Icon', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'right_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .icon span, .faq-one--two .faq-one__contact-info-number .icon span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info-number .icon, .faq-one--two .faq-one__contact-info-number .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////////// button 01/////////////////
        $this->start_controls_section(
            '_hero_01_button',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        /////////////////// Button Normal part/////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_control(
            'bar_btn_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn::after, .faq-one--two .faq-one__contact-info .btn-box .thm-btn::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'normal_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn, .faq-one__contact-info .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'normal_text_typography',
                'selector' => '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn, .faq-one__contact-info .btn-box .thm-btn',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn, .faq-one__contact-info .btn-box .thm-btn',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn, .faq-one__contact-info .btn-box .thm-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn, .faq-one__contact-info .btn-box .thm-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn, .faq-one__contact-info .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
    

        ////////////// Button Hover part in here ////////////////////////
        $this->start_controls_tab(
            'style_hover_tabss',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'ho_btn_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__contact-info .btn-box .thm-btn::before, .faq-one--two .faq-one__contact-info .btn-box .thm-btn::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display(); 
        $layout = $settings['faq_layout'];
        $faq_list = $settings['faqsection_list'];
        ?> 

        <?php
            if ( $layout) {
                include('faq-section/'.$layout.'.php');
            }
          
        ?> 
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaFaqSection());

