<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaFaq extends Widget_Base {
    public function get_name() {
        return 'adina_faq';
    }
    public function get_title() {
        return __('Faq', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['faq', 'accordion'];
    }
    protected function register_controls() {

        $this->start_controls_section('general_section',
            [
                'label' => __('Content ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $faq_repeater = new Repeater();

        $faq_repeater->add_control(
            'faq_active',
            [
                'label' => __('Active', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $faq_repeater->add_control(
			'title_number',
			[
				'label' => esc_html__( 'Title Number', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '01.', 'adina' ),
				'label_block' => true,
			]
		);
        $faq_repeater->add_control(
			'faq_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'How can I pay for your logistics services?', 'adina' ),
				'label_block' => true,
			]
		);
        $faq_repeater->add_control(
			'faq_description',
			[
				'label' => esc_html__( 'Description', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'adina' ),
				'label_block' => true,
			]
		);

        $this->add_control(
			'adina_faq',
			[
				'label' => esc_html__( 'Accordion', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $faq_repeater->get_controls(),
				'default' => [
					[
						'title_number'      => esc_html__( '01.', 'adina' ),
						'faq_title'         => esc_html__( 'How can I pay for your logistics services?', 'adina' ),
                        'faq_description'   => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'adina' ),
						'faq_title'         => __('Slider Active', 'adina'),
					],
                    [
						'title_number'      => esc_html__( '02.', 'adina' ),
						'faq_title'         => esc_html__( 'How can I track my shipments?', 'adina' ),
                        'faq_description'   => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'adina' ),
						'faq_title'         => __('Slider Active', 'adina'),
					],
                    [
						'title_number'      => esc_html__( '03.', 'adina' ),
						'faq_title'         => esc_html__( 'Can i specify a delivery date when ordering?', 'adina' ),
                        'faq_description'   => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'adina' ),
						'faq_title'         => __('Slider Active', 'adina'),
					],
                    [
						'title_number'      => esc_html__( '04.', 'adina' ),
						'faq_title'         => esc_html__( 'Any advice for a first time shipper?', 'adina' ),
                        'faq_description'   => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'adina' ),
						'faq_title'         => __('Slider Active', 'adina'),
					],
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section('big_title_section',
            [
                'label' => __('Overlay Text ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'overlay_text',
			[
				'label' => esc_html__( 'Overlay Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'FAQ', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();

        ///////////////////// Icon  Styles ///////////////////////////
        $this->start_controls_section(
            'container_styles',
            [
                'label' => __( 'Container', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'container_border',
                'selector' => '{{WRAPPER}} .faq-three__faq ul li',
            ]
        );

        $this->end_controls_section();

        

        ///////////////////// Number  Styles ///////////////////////////
        $this->start_controls_section(
            'title_number_styles',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_number_colors',
            [
                'label' => __( 'Number Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span',
            ]
        );
        $this->add_responsive_control(
            'number_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'number_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        ///////////////////// Title  Styles ///////////////////////////
        $this->start_controls_section(
            'title_styles',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_colors',
            [
                'label' => __( 'Number Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion .accrodion-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_bg_color',
            [
                'label' => __('Background Color', 'adina'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion.active .accrodion-title' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion.active .accrodion-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-title h2',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion.active .accrodion-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion.active .accrodion-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        ///////////////////// Description  Styles ///////////////////////////
        $this->start_controls_section(
            'description_styles',
            [
                'label' => __( 'Description', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_colors',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion .accrodion-content .inner p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .faq-one__accrodion .accrodion .accrodion-content .inner p',
            ]
        );
        $this->add_responsive_control(
            'description_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion .accrodion-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'description_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion .accrodion-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        ///////////////////// Icon  Styles ///////////////////////////
        $this->start_controls_section(
            'icon_styles',
            [
                'label' => __( 'Active/Inactive Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'active_icon_colors',
            [
                'label' => __( 'Active Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion.active .accrodion-title h2::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'inactive_icon_colors',
            [
                'label' => __( 'Inactive Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion .accrodion-title h2::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'icon_typography',
                'selector' => '{{WRAPPER}} .faq-three__faq .faq-one__accrodion .accrodion .accrodion-title h2::before',
            ]
        );

        $this->end_controls_section();


        

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $faqs = $settings[ 'adina_faq' ];


       

        ?>

        <div class="faq-three__faq">
            <ul class="accrodion-grp faq-one__accrodion" data-grp-name="faq-one-accrodion">
                <?php foreach( $faqs as $faq ) :
                    $active = '';

                    if($faq['faq_active'] == 'yes'){
                        $active = 'active';
                    }else{
                        $active = '';
                    }
                    
                    ?>
                    <li class="accrodion <?php echo esc_attr( $active ); ?>">
                        <div class="accrodion-title">

                            <?php if ( !empty( $faq['faq_title']) ) : ?>
                                <h2>
                                    <?php if ( !empty( $faq['title_number']) ) : ?>
                                        <span><?php echo esc_html( $faq['title_number'] ); ?></span> 
                                    <?php endif; ?>
                                    
                                    <?php echo esc_html( $faq['faq_title'] ); ?>
                                </h2>
                            <?php endif; ?>

                        </div>
                        <div class="accrodion-content">
                            <div class="inner">
                                <?php if ( !empty( $faq['faq_description']) ) : ?>
                                    <p><?php echo esc_html( $faq['faq_description'] ); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaFaq());