<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaHeader extends Widget_Base {
    public function get_name() {
        return 'adina-header';
    }
    public function get_title() {
        return __('Header', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['header', 'menu', 'header section'];
    }

    private function get_available_menus() {

        $menus = wp_get_nav_menus();

        $options = [];

        foreach ( $menus as $menu ) {

            $options[$menu->slug] = $menu->name;

        }

        return $options;

    }

    protected function register_controls() {

        // layout
        $this->start_controls_section('layout_section',
            [
                'label' => __('Layout', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'header_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();

        // Logo
        $this->start_controls_section('logo_section',
            [
                'label' => __('Logo', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'logo_img',
            [
                'label' => esc_html__( 'Logo Image', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'logo_bg',
            [
                'label' => esc_html__( 'Logo Background Image', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'header_layout' => 'layout-1',
                ],
            ]
        );
        $this->end_controls_section();

        // header top
        $this->start_controls_section('header_top_section',
            [
                'label' => __('Header Top', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'header_top_bg_img',
            [
                'label' => esc_html__( 'Header Top Bg Image', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'address_text',
            [
                'label' => esc_html__( 'Address', 'adina' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Jones Street, New York, USA', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'mail_text',
            [
                'label' => esc_html__( 'Email', 'adina' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Info@example.com', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'mail_url',
            [
                'label' => esc_html__( 'Mail link', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phone_text',
            [
                'label' => esc_html__( 'Call', 'adina' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( '+70 264 566 579', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'phone_url',
            [
                'label' => esc_html__( 'Call link', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->start_controls_tabs(
            'social_icon_tabs'
        );
        $this->start_controls_tab(
            'social_icons_tab',
            [
                'label' => esc_html__( 'Social Icons', 'adina' ),
            ]
        );

        $this->add_control(
            'icon01_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'facebook',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'icon02_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'twitter',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'icon03_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'instagram',
                'label_block' => true,

            ]
        );
        $this->add_control(
            'icon04_select',
            [
                'label' => __('Icon select', 'adina'),
                'type' => Controls_Manager::SELECT2,
                'options' => adina_icon_list_options(),
                'default' => 'linkedin',
                'label_block' => true,

            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'social_icon_url_tab',
            [
                'label' => esc_html__( 'Url', 'adina' ),
            ]
        );
        $this->add_control(
            'fb_url',
            [
                'label' => esc_html__( 'Facebook', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tw_url',
            [
                'label' => esc_html__( 'Twitter', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'insta_url',
            [
                'label' => esc_html__( 'Instagram', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'linkedin_url',
            [
                'label' => esc_html__( 'Linkedin', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        // Menu
        $this->start_controls_section('menu_section',
            [
                'label' => __('Menu', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'use_main_menu',
            [
                'label'        => __( 'Use Main Menu', 'tekup-hp' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'Yes', 'tekup-hp' ),
                'label_off'    => __( 'No', 'tekup-hp' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $menus = $this->get_available_menus();

        if ( !empty( $menus ) ) {
            $this->add_control(
                'primary_menu',
                [
                    'label'        => __( 'Menu', 'header-footer-elementor' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => $menus,
                    'default'      => array_keys( $menus )[0],
                    'save_default' => true,
                    'separator'    => 'after',
                    'description'  => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'header-footer-elementor' ), admin_url( 'nav-menus.php' ) ),
                    'condition'    => [
                        'use_main_menu!' => 'yes',
                    ],
                ]
            );
        } else {
            $this->add_control(
                'menu',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => sprintf( __( '<strong>There are no menus in your site.</strong><br>Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'header-footer-elementor' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                    'separator'       => 'after',
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                ]
            );
        }
        $this->end_controls_section();

        // Search
        $this->start_controls_section('search_section',
            [
                'label' => __('Search', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'search_switch',
            [
                'label' => __('Want Search?', 'adina'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'adina'),
                'label_off' => __('No', 'adina'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

        // Button
        $this->start_controls_section('button_section',
            [
                'label' => __('Button', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'adina' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Get Free Quote', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Icon Class', 'adina' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'icon-right-arrow', 'adina' ),
                'placeholder' => esc_html__( 'use icomoon class', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'btn_url',
            [
                'label' => esc_html__( 'Mail link', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        // Side info
        $this->start_controls_section('side_info_section',
            [
                'label' => __('Side Info', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->add_control(
            'adina_Offcanvas_builder',
            [
                'label'     => __( 'Select Offcanvas', 'adina' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => $this->adina_offcanvas_one(),
                'default'	=> ''
            ]
        );
        $this->end_controls_section();

        // Mobile Menu
        $this->start_controls_section('mobile_menu_section',
            [
                'label' => __('Mobile Menu', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'mobile_menu_logo',
            [
                'label' => esc_html__( 'Mobile Logo', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $iconrepeater = new Repeater();
        $iconrepeater->add_control(
            'select_icon01',
            [
                'label' => __( 'Icon 01', 'adina' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $iconrepeater->add_control(
            'select_icon01_url',
            [
                'label' => esc_html__( 'Icon01 Url', 'adina' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__( '#', 'adina' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'icon_repeater',
            [
                'type' 		=> Controls_Manager::REPEATER,
                'fields' 	=> $iconrepeater->get_controls(),
                'default'	=> [
                    [ 
                        'select_icon01'  => esc_html__( 'Icon 01', 'adina' ),
                        'select_icon01_url'  => esc_html__( 'Icon01 Url', 'adina' ),
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        // Logo Style
        $this->start_controls_section(
            'logo_style',
            [
                'label' => __( 'Logo', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'logo_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 170,
				],
				'selectors' => [
					'{{WRAPPER}} .logo-box-one a img, .logo-box-two a img, .logo-box-three a img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'logo1_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo-box-one__bg::before' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'header_layout' => 'layout-1',
                ],
            ]
        );
        $this->add_control(
            'logo2_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo-box-custom:before' => 'border-bottom-color: {{VALUE}}',
                ],
                'condition' => [
                    'header_layout' => 'layout-2',
                ],
            ]
        );
        $this->add_control(
            'logo3_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .logo-box-three' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Color
        $this->start_controls_section(
            'header_color',
            [
                'label' => __( 'Header Color', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'header_top_bg_color',
				'types' => [ 'gradient' ],
				'selector' => '{{WRAPPER}} .main-header-one__top-pattern::before, .main-header-two__top-pattern::before, .main-header-three__top-pattern::before',
			]
		);
        $this->add_control(
            'header_bottom_bg_color',
            [
                'label' => __( 'Bottom bg Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-one__bottom::before, .main-header-two__bottom::before, .main-header-three__bottom' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

        // Header Top
        $this->start_controls_section(
            'header_top',
            [
                'label' => __( 'Header Top', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'top_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-contact-info ul li .icon-box span, .header-contact-info-style2 ul li .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'top_icon_typography',
				'selector' => '{{WRAPPER}} .header-contact-info ul li .icon-box span, .header-contact-info-style2 ul li .icon-box span',
			]
		);
        $this->add_control(
            'top_icon_bg',
            [
                'label' => __( 'Icon Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-contact-info-style2 ul li .icon-box' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->add_control(
            'top_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-contact-info-style2 ul li .text-box p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'top_title_typography',
				'selector' => '{{WRAPPER}} .header-contact-info-style2 ul li .text-box p',
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
			]
		);
        $this->add_control(
            'icon_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-contact-info-style2 ul li .text-box h4, .header-contact-info ul li p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'icon_text_hover_color',
            [
                'label' => __( 'Text Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-contact-info ul li p a:hover, .header-contact-info-style2 ul li .text-box h4 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_text_typography',
				'selector' => '{{WRAPPER}} .header-contact-info-style2 ul li .text-box h4, .header-contact-info ul li p',
			]
		);
        $this->end_controls_section();

        // Social Icon
        $this->start_controls_section(
            'social_icon',
            [
                'label' => __( 'Social Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'social_icon_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-three__top-right .title p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'social_icon_title_typography',
				'selector' => '{{WRAPPER}} .main-header-three__top-right .title p',
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
			]
		);
        $this->add_responsive_control(
            'social_icon_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-header-three__top-right .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->add_control(
            'social_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-social-links ul li a, .main-header-three__top-right .social-links a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'social_icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .header-social-links ul li a:hover, .main-header-three__top-right .social-links a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'social_icon_typography',
				'selector' => '{{WRAPPER}} .header-social-links ul li a span, .main-header-three__top-right .social-links a span',
			]
		);
        $this->add_responsive_control(
            'social_icon_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .header-social-links ul li, .main-header-three__top-right .social-links a+a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Menu
        $this->start_controls_section(
            'menu_style',
            [
                'label' => __( 'Menu', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'menu_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li a, .main-header-two .navbar-wrap ul li a, .main-header-three .navbar-wrap ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'menu_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap>ul>li:hover>a, .main-header-two .navbar-wrap>ul>li:hover>a, .main-header-three .navbar-wrap>ul>li:hover>a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_typography',
				'selector' => '{{WRAPPER}} .navbar-wrap ul li a',
			]
		);
        $this->add_responsive_control(
            'menu_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap>ul>li.menu-item-has-children>a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'menu_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li a, .main-header-two .navbar-wrap ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'menu_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap>ul>li.menu-item-has-children>a::after' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'menu_icon_typography',
				'selector' => '{{WRAPPER}} .navbar-wrap>ul>li.menu-item-has-children>a::after',
			]
		);
        $this->end_controls_section();

        // Sub Menu
        $this->start_controls_section(
            'sub_menu_style',
            [
                'label' => __( 'Sub Menu', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_menu_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li .sub-menu li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'submenu_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li .sub-menu li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_menu_typography',
				'selector' => '{{WRAPPER}} .navbar-wrap ul li .sub-menu li a',
			]
		);
        $this->add_control(
            'sub_menu_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li .sub-menu li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'sub_menu_hover_bg_color',
            [
                'label' => __( 'Hover Bg Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li .sub-menu li a:hover, .main-header-two .navbar-wrap ul li .sub-menu li a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_menu_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .navbar-wrap ul li .sub-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Search
        $this->start_controls_section(
            'search_style',
            [
                'label' => __( 'Search', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'search_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-one__bottom-right .search-box a, .main-header-two__bottom-right .search-box a, .main-header-three__bottom-right .search-box a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'search_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-one__bottom-right .search-box a:hover, .main-header-two__bottom-right .search-box a:hover, .main-header-three__bottom-right .search-box a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'search_typography',
				'selector' => '{{WRAPPER}} .main-header-one__bottom-right .search-box a, .main-header-two__bottom-right .search-box a, .main-header-three__bottom-right .search-box a',
			]
		);
        $this->end_controls_section();

        // Button
        $this->start_controls_section(
            'btn_style',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn, .main-header-two__top-right .inner .btn-box a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn:hover, .main-header-two__top-right .inner .btn-box a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-one__bottom-right .btn-box .thm-btn::after, .main-header-two__top-right .inner .btn-box a::before, .thm-btn:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_hover_bg_color',
            [
                'label' => __( 'Hover Bg Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn:before, .main-header-two__top-right .inner .btn-box a:hover::before, .main-header-three__bottom-right .btn-box .thm-btn::before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'selector' => '{{WRAPPER}} .thm-btn, .main-header-two__top-right .inner .btn-box a',
			]
		);
        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-header-one__bottom-right .btn-box, .main-header-two__top-right .inner .btn-box, .main-header-three__bottom-right .btn-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .thm-btn, .main-header-two__top-right .inner .btn-box a, .main-header-three__bottom-right .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // Number two
        $this->start_controls_section(
            'nmbr_two_style',
            [
                'label' => __( 'Number', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => 'layout-2',
                ],
            ]
        );
        $this->add_control(
            'nmbr_two_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-two__bottom-right .contact-box .text p a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nmbr_two_hover_color',
            [
                'label' => __( 'Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-two__bottom-right .contact-box .text p a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'nmbr_two_typography',
				'selector' => '{{WRAPPER}} .main-header-two__bottom-right .contact-box .text p a',
			]
		);
        $this->add_responsive_control(
            'nmbr_two_margin',
            [
                'label' => __( 'Text Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-header-two__bottom-right .contact-box .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'nmbr_two_icon_color',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-two__bottom-right .contact-box .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'nmbr_two_icon_bg_color',
            [
                'label' => __( 'Background Color', 'adina' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-two__bottom-right .contact-box .icon-box' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'nmbr_two_icon_typography',
				'selector' => '{{WRAPPER}} .main-header-two__bottom-right .contact-box .icon-box span',
			]
		);
        $this->end_controls_section();

        // Side info
        $this->start_controls_section(
            'sideinfo_style',
            [
                'label' => __( 'Sidebar', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'header_layout' => 'layout-3',
                ],
            ]
        );
        $this->start_controls_tabs(
            'sideinfo_style_tabs'
        );
        $this->start_controls_tab(
            'sideinfo_style_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_control(
            'sideinfo_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-three__bottom-right .navSidebar-button-box a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sideinfo_typography',
				'selector' => '{{WRAPPER}} .main-header-three__bottom-right .navSidebar-button-box a span',
			]
		);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'sideinfo_style_tab_hover',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
            'sideinfo_hover_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-header-three__bottom-right .navSidebar-button-box a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


    }

    public function adina_offcanvas_one(){

        $adina_post_query = new \WP_Query( array(
            'post_type'				=> 'adina_off_build',
            'posts_per_page'	    => -1,
        ) );

        $adina_tab_builder_title_title = array();
        $adina_tab_builder_title_title[''] = __( 'Select a Title','adina');

        while( $adina_post_query->have_posts() ) {
            $adina_post_query->the_post();
            $adina_tab_builder_title_title[ get_the_ID() ] =  get_the_title();
        }
        wp_reset_postdata();
        return $adina_tab_builder_title_title;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( 'yes' == $settings['use_main_menu'] ) {
            $args = [
                'theme_location'  => 'primary-menu',
                'menu_class'      => 'navigation',
                'menu_id'         => 'menu-header-menu',
                'container_class' => 'navbar-wrap main-menu',
            ];
        } else {
            $args = [
                // 'theme_location'        => 'main-menu',
                'menu'            => $settings['primary_menu'],
                'menu_class'      => 'navigation',
                'menu_id'         => 'menu-header-menu',
                'container_class' => 'navbar-wrap main-menu',
            ];
        }
        
        $icons = $settings['icon_repeater'];

        $layout = $settings['header_layout'];

        ?>

            <?php
                if ( $layout) {
                    include('header/'.$layout.'.php');
                }
            ?> 

        <?php
    }
}
$widgets_manager->register(new \Elementor\AdinaHeader());
