<header class="main-header main-header-two">
    <div id="sticky-header" class="menu-area">
        <div class="main-header-two__outer">
            <div class="logo-box-two">
                <a href="<?php echo esc_url( home_url('/') ); ?>">
                    <img src="<?php echo esc_url( $settings[ 'logo_img' ]['url'] ); ?>" alt="<?php echo esc_attr__('logo', 'adina'); ?>">
                </a>
            </div>
            <div class="menu-area__inner">
                <div class="mobile-nav-toggler">
                    <i class="fas fa-bars"></i>
                </div>
                <div class="menu-wrap">
                    <nav class="menu-nav">
                        <div class="main-header-two__inner">
                            <div class="main-header-two__top">
                                <div class="main-header-two__top-pattern"
                                    style="background-image: url(<?php echo esc_url( $settings[ 'header_top_bg_img' ]['url'] ); ?>);">
                                </div>

                                <div class="main-header-two__top-inner">
                                    <div class="main-header-two__top-left">
                                        <div class="header-contact-info">
                                            <ul>
                                                <li>
                                                    <div class="icon-box"><span class="icon-pin"></span>
                                                    </div>
                                                    <p><?php echo esc_html( $settings['address_text'] ); ?></p>
                                                </li>
                                                <li>
                                                    <div class="icon-box"><span class="icon-paper-plane"></span>
                                                    </div>
                                                    <p><a href="<?php echo esc_url( $settings[ 'mail_url' ] ); ?>"><?php echo esc_html( $settings['mail_text'] ); ?></a>
                                                    </p>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="main-header-two__top-right">
                                        <div class="inner">
                                            <div class="header-social-links">
                                                <ul>
                                                    <li>
                                                        <a href="<?php echo esc_url( $settings[ 'fb_url' ] ); ?>">
                                                            <span class="icon-<?php echo esc_html( $settings[ 'icon01_select' ] ); ?>"></span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="<?php echo esc_url( $settings[ 'tw_url' ] ); ?>">
                                                            <span class="icon-<?php echo esc_html( $settings[ 'icon02_select' ] ); ?>"></span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="<?php echo esc_url( $settings[ 'insta_url' ] ); ?>">
                                                            <span class="icon-<?php echo esc_html( $settings[ 'icon03_select' ] ); ?>"></span>
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a href="<?php echo esc_url( $settings[ 'linkedin_url' ] ); ?>">
                                                            <span class="icon-<?php echo esc_html( $settings[ 'icon04_select' ] ); ?>"></span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>

                                            <div class="btn-box">
                                                <a href="<?php echo esc_url( $settings[ 'btn_url' ] ); ?>"><?php echo esc_html( $settings[ 'btn_text' ] ); ?> <span
                                                        class="<?php echo esc_attr( $settings[ 'btn_icon' ] ); ?>"></span></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="main-header-two__bottom">
                                <div class="main-header-two__bottom-left">
                                    <?php wp_nav_menu( $args );?>
                                </div>


                                <div class="main-header-two__bottom-right">
                                    <?php if ( !empty( $settings['search_switch']) ) : ?>
                                        <div class="search-box">
                                            <a href="#"
                                                class="main-menu__search search-toggler icon-magnifying-glass"></a>
                                        </div>
                                    <?php endif; ?>

                                    <div class="contact-box">
                                        <div class="icon-box">
                                            <span class="icon-out-call"></span>
                                        </div>
                                        <div class="text">
                                            <p><a href="<?php echo esc_url( $settings[ 'phone_url' ] ); ?>"><?php echo esc_html( $settings['phone_text'] ); ?></a></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>

            <!-- Mobile Menu  -->
            <div class="mobile-menu">
                <nav class="menu-box">
                    <div class="close-btn"><i class="fas fa-times"></i></div>
                    <div class="nav-logo">
                        <a href="<?php echo esc_url( home_url('/') ); ?>">
                            <img src="<?php echo esc_url( $settings[ 'mobile_menu_logo' ]['url'] ); ?>" alt="<?php echo esc_attr__('logo', 'adina'); ?>">
                        </a>
                    </div>
                    <div class="menu-outer">
                        <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                    </div>
                    <div class="contact-info">
                        <div class="icon-box"><span class="icon-telephone-handle-silhouette"></span></div>
                        <p><a href="<?php echo esc_url( $settings[ 'phone_url' ] ); ?>"><?php echo esc_html( $settings['phone_text'] ); ?></a></p>
                    </div>
                    <div class="social-links">
                        <ul class="clearfix list-wrap">
                            <?php foreach ( $icons as $icon ): ?>
                                <li>
                                    <a href="<?php echo esc_url( $icon[ 'select_icon01_url' ] ); ?>">
                                        <?php Elementor\Icons_Manager::render_icon( $icon['select_icon01'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </a>
                                </li>
                            <?php endforeach;?>
                        </ul>
                    </div>
                </nav>
            </div>
            <div class="menu-backdrop"></div>
            <!-- End Mobile Menu -->
        </div>
    </div>
</header>


<div class="search-popup">
    <div class="search-popup__overlay search-toggler">
        <div class="search-popup__close-icon">
            <span class="icon-plus"></span>
        </div>
    </div>
    <div class="search-popup__content">
        <form action="<?php echo esc_url( home_url( '/' ) ); ?>">
            <label for="search" class="sr-only"><?php echo esc_html__( 'Search', 'adina' ); ?></label>
            <input type="text" id="search" name="s" placeholder="<?php echo esc_attr__( 'Search Here...', 'adina' ); ?>" />
            <button type="submit" aria-label="search submit" class="btn-box">
                <i class="icon-magnifying-glass"></i>
            </button>
        </form>
    </div>
</div>