<!-- Start sidebar widget content -->
<div class="xs-sidebar-group info-group info-sidebar">
    <div class="xs-overlay xs-bg-black"></div>
    <div class="xs-sidebar-widget">
        <?php  $elementor = \Elementor\Plugin::instance();
            echo $elementor->frontend->get_builder_content_for_display($settings['adina_Offcanvas_builder']); 
        ?>
        <div class="widget-heading">
            <a href="#" class="close-side-widget"><?php echo esc_html__('X', 'adina'); ?></a>
        </div>
    </div>
</div>
<!-- End sidebar widget content -->

<header class="main-header main-header-three">
    <div id="sticky-header" class="menu-area">
        <div class="menu-area__inner">
            <div class="mobile-nav-toggler">
                <i class="fas fa-bars"></i>
            </div>
            <div class="menu-wrap">
                <nav class="menu-nav">
                    <div class="container">
                        <div class="main-header-three__inner">
                            <div class="logo-box-three">
                                <a href="<?php echo esc_url( home_url('/') ); ?>">
                                    <img src="<?php echo esc_url( $settings[ 'logo_img' ]['url'] ); ?>" alt="<?php echo esc_attr__('logo', 'adina'); ?>">
                                </a>
                            </div>

                            <div class="main-header-three__top">
                                <div class="main-header-three__top-pattern"
                                    style="background-image: url(<?php echo esc_url( $settings[ 'header_top_bg_img' ]['url'] ); ?>);">
                                </div>
                                <div class="main-header-three__top-inner">
                                    <div class="main-header-three__top-left">
                                        <div class="header-contact-info-style2">
                                            <ul class="clearfix">
                                                <li>
                                                    <div class="icon-box">
                                                        <span class="icon-pin"></span>
                                                    </div>
                                                    <div class="text-box">
                                                        <p><?php echo esc_html__('Address', 'adina'); ?></p>
                                                        <h4><?php echo esc_html( $settings['address_text'] ); ?></h4>
                                                    </div>
                                                </li>

                                                <li>
                                                    <div class="icon-box">
                                                        <span class="icon-paper-plane"></span>
                                                    </div>
                                                    <div class="text-box">
                                                        <p><?php echo esc_html__('Email', 'adina'); ?></p>
                                                        <h4>
                                                            <a href="<?php echo esc_url( $settings[ 'mail_url' ] ); ?>"><?php echo esc_html( $settings['mail_text'] ); ?>
                                                            </a>
                                                        </h4>
                                                    </div>
                                                </li>

                                                <li>
                                                    <div class="icon-box">
                                                        <span class="icon-out-call"></span>
                                                    </div>
                                                    <div class="text-box">
                                                        <p><?php echo esc_html__('Phone', 'adina'); ?></p>
                                                        <h4><a href="<?php echo esc_url( $settings[ 'phone_url' ] ); ?>"><?php echo esc_html( $settings['phone_text'] ); ?></a></h4>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="main-header-three__top-right">
                                        <div class="title">
                                            <p><?php echo esc_html__( 'Get Our Socials', 'adina' ); ?></p>
                                        </div>
                                        <div class="social-links">
                                            <a href="<?php echo esc_url( $settings[ 'fb_url' ] ); ?>">
                                                <span class="icon-<?php echo esc_html( $settings[ 'icon01_select' ] ); ?>"></span>
                                            </a>
                                            <a href="<?php echo esc_url( $settings[ 'tw_url' ] ); ?>">
                                                <span class="icon-<?php echo esc_html( $settings[ 'icon02_select' ] ); ?>"></span>
                                            </a>
                                            <a href="<?php echo esc_url( $settings[ 'insta_url' ] ); ?>">
                                                <span class="icon-<?php echo esc_html( $settings[ 'icon03_select' ] ); ?>"></span>
                                            </a>
                                            <a href="<?php echo esc_url( $settings[ 'linkedin_url' ] ); ?>">
                                                <span class="icon-<?php echo esc_html( $settings[ 'icon04_select' ] ); ?>"></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="main-header-three__bottom">
                                <div class="main-header-three__bottom-left">
                                    <?php wp_nav_menu( $args );?>
                                </div>

                                <div class="main-header-three__bottom-right">
                                    <?php if ( !empty( $settings['search_switch']) ) : ?>
                                        <div class="search-box">
                                            <a href="#"
                                                class="main-menu__search search-toggler icon-magnifying-glass"></a>
                                        </div>
                                    <?php endif; ?>

                                    <div class="navSidebar-button-box">
                                        <a class="navSidebar-button icon2" href="#">
                                            <span class="icon-menu"></span>
                                        </a>
                                    </div>

                                    <div class="btn-box">
                                        <a class="thm-btn" href="<?php echo esc_url( $settings[ 'btn_url' ] ); ?>">
                                            <span class="txt"><?php echo esc_html( $settings[ 'btn_text' ] ); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </div>

        <!-- Mobile Menu  -->
        <div class="mobile-menu">
            <nav class="menu-box">
                <div class="close-btn"><i class="fas fa-times"></i></div>
                <div class="nav-logo">
                    <a href="<?php echo esc_url( home_url('/') ); ?>">
                        <img src="<?php echo esc_url( $settings[ 'mobile_menu_logo' ]['url'] ); ?>" alt="<?php echo esc_attr__('logo', 'adina'); ?>">
                    </a>
                </div>
                <div class="menu-outer">
                    <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                </div>
                <div class="contact-info">
                    <div class="icon-box"><span class="icon-telephone-handle-silhouette"></span></div>
                    <p><a href="<?php echo esc_url( $settings[ 'phone_url' ] ); ?>"><?php echo esc_html( $settings['phone_text'] ); ?></a></p>
                </div>
                <div class="social-links">
                    <ul class="clearfix list-wrap">
                        <?php foreach ( $icons as $icon ): ?>
                            <li>
                                <a href="<?php echo esc_url( $icon[ 'select_icon01_url' ] ); ?>">
                                    <?php Elementor\Icons_Manager::render_icon( $icon['select_icon01'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                            </li>
                        <?php endforeach;?>
                    </ul>
                </div>
            </nav>
        </div>
        <div class="menu-backdrop"></div>
        <!-- End Mobile Menu -->
    </div>
</header>



<div class="search-popup">
    <div class="search-popup__overlay search-toggler">
        <div class="search-popup__close-icon">
            <span class="icon-plus"></span>
        </div>
    </div>
    <div class="search-popup__content">
        <form action="<?php echo esc_url( home_url( '/' ) ); ?>">
            <label for="search" class="sr-only"><?php echo esc_html__( 'Search', 'adina' ); ?></label>
            <input type="text" id="search" name="s" placeholder="<?php echo esc_attr__( 'Search Here...', 'adina' ); ?>" />
            <button type="submit" aria-label="search submit" class="btn-box">
                <i class="icon-magnifying-glass"></i>
            </button>
        </form>
    </div>
</div>

