<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaHeadingThree extends Widget_Base {
    public function get_name() {
        return 'adina-heading-three';
    }
    public function get_title() {
        return __('Heading Three', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Heading', 'Title', 'section'];
    }

    protected function register_controls() {
        
        $this->start_controls_section(
            'general_section',
            [
                'label' => __('Heading Two', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'heading_icon',
			[
				'label' => esc_html__( 'Top Icon', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'Sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'About Company', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'Title_content',
			[
				'label' => esc_html__( 'Content Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Digital & Trusted Transport
                Logistic Company', 'adina' ),
				'label_block' => true,
			]
		);
        $this->end_controls_section();
        

     


        /********* Start Style Controls /*********/

        /////////////// Icon in here  /////////////////////
        $this->start_controls_section(
            '_heading03_icon',
            [
                'label' => __( 'Icon ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'heading03_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title .icon img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'heading03_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title .icon img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            ' Author_images_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title .icon img' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'heading_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .sec-title-style3 .sub-title .icon img',
            ]
        );

        $this->add_responsive_control(
            'heading_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'heading_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        
        // ///////////  Sub Title  ///////////////
        $this->start_controls_section(
            '_section_style_content',
            [
                'label' => __( 'Sub Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color_sub',
            [
                'label' => __( 'Sub Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title h5' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .sec-title-style3 .sub-title h5',
			]
		);
        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_shadow',
				'selector' => '{{WRAPPER}} .sec-title-style3 .sub-title h5',
			]
		);
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'selector' => '{{WRAPPER}} .sec-title-style3 .sub-title h5',
			]
		);
   
        $this->add_responsive_control(
            'Sub_title_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Sub_title_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'sub_title_align',
			[
				'label' => esc_html__( 'Alignment', 'adina' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
                    'flex-start' => __('Start', 'adina'),
                    'center' => __('Center', 'adina'),
                    'flex-end' => __('End', 'adina'),
                 ],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .sec-title-style3 .sub-title.center' => 'justify-content: {{VALUE}};',
				],
			]
		);
        $this->end_controls_section();
    
        //////// Content Title in here ////////////
        $this->start_controls_section(
            '_heading_titles',
            [
                'label' => __( 'Content Title', 'tocore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .sec-title-style3 h2',
			]
		);
        $this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'title_shadow',
				'selector' => '{{WRAPPER}} .sec-title-style3 h2',
			]
		);
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Content Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Content Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sec-title-style3 h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'title_align',
			[
				'label' => esc_html__( 'Alignment', 'adina' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'adina' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'adina' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'adina' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .sec-title-style3 h2' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->end_controls_section();
        

        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        ?>


            <div class="sec-title-style3 text-center">
                <div class="sub-title center">

                    <!-- icon upload in here  -->
                    <?php if( !empty( $settings[ 'heading_icon' ]['url'] ) ): ?>
                        <div class="icon">
                            <img src="<?php echo esc_url( $settings[ 'heading_icon' ]['url'] ); ?>" alt="">
                        </div>
                    <?php endif; ?>

                    <!-- Sub title -->
                    <?php if ( !empty($settings['Sub_title']) ) : ?>
                        <h5><?php echo adina_kses( $settings['Sub_title'] ); ?></h5>
                    <?php endif; ?>
                </div>
                
                <!-- Title -->
                <?php if ( !empty($settings['Title_content']) ) : ?>
                    <h2><?php echo adina_kses( $settings['Title_content'] ); ?></h2>
                <?php endif; ?>
            </div>
                
    
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaHeadingThree());