<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaHeroOne extends Widget_Base {
    public function get_name() {
        return 'adina-hero-one';
    }
    public function get_title() {
        return __('Hero One', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Hero', 'slider', 'section'];
    }

    protected function register_controls() {

        //Slider Setting
        $this->start_controls_section('slider_settings',
        [
            'label' => __('Slider Settings', 'adina'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'drag',
            [
                'label' => __( 'Drag?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Auto Play?', 'adina' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'adina' ),
                'label_off' => __( 'Hide', 'adina' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => __( 'Autoplay Timeout', 'adina' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => '7000',
                'options' => [
                    '1000'  => __( '1 Second', 'adina' ),
                    '2000'  => __( '2 Second', 'adina' ),
                    '3000'  => __( '3 Second', 'adina' ),
                    '4000'  => __( '4 Second', 'adina' ),
                    '5000'  => __( '5 Second', 'adina' ),
                    '6000'  => __( '6 Second', 'adina' ),
                    '7000'  => __( '7 Second', 'adina' ),
                    '8000'  => __( '8 Second', 'adina' ),
                    '9000'  => __( '9 Second', 'adina' ),
                    '10000' => __( '10 Second', 'adina' ),
                    '11000' => __( '11 Second', 'adina' ),
                    '12000' => __( '12 Second', 'adina' ),
                    '13000' => __( '13 Second', 'adina' ),
                    '14000' => __( '14 Second', 'adina' ),
                    '15000' => __( '15 Second', 'adina' ),
                ],
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section('general_section',
            [
                'label' => __('General', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $heroone_repeater = new Repeater();

        $heroone_repeater->add_control(
			'hero_bg',
			[
				'label' => esc_html__( 'Background Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $heroone_repeater->add_control(
			'hero_shape_image',
			[
				'label' => esc_html__( 'Right corner Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $heroone_repeater->add_control(
			'hero_hape01',
			[
				'label' => esc_html__( 'Icon 01', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $heroone_repeater->add_control(
			'hero_shape02',
			[
				'label' => esc_html__( 'Icon 02', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $heroone_repeater->add_control(
			'bottom_big_title',
			[
				'label' => esc_html__( 'Bottom big Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Air Freight', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'hero_subtitle',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '01. AIR Freight', 'adina' ),
				'label_block' => true,
			]
		);

        $heroone_repeater->add_control(
			'hero_title',
			[
				'label' => esc_html__( 'Content Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Fast and safe transport your product', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'hero_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                auctor nisi elit more consequat ipsum.', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Calculate Package', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);


        $this->add_control(
			'adina_heroone_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $heroone_repeater->get_controls(),
				'default' => [
					[
						'hero_bg'          => Utils::get_placeholder_image_src(),
                        'hero_shape_image' => Utils::get_placeholder_image_src(),
                        'hero_hape01'      => Utils::get_placeholder_image_src(),
                        'hero_shape02'     => Utils::get_placeholder_image_src(),
						'bottom_big_title' => esc_html__( 'Air Freight', 'adina' ),
						'hero_subtitle' => esc_html__( '01. AIR Freight', 'adina' ),
						'hero_title'    => esc_html__( 'Fast and safe transport your product', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
                    [
						'hero_bg'          => Utils::get_placeholder_image_src(),
                        'hero_shape_image' => Utils::get_placeholder_image_src(),
                        'hero_hape01'      => Utils::get_placeholder_image_src(),
                        'hero_shape02'     => Utils::get_placeholder_image_src(),
						'bottom_big_title' => esc_html__( 'Air Freight', 'adina' ),
						'hero_subtitle' => esc_html__( '01. AIR Freight', 'adina' ),
						'hero_title'    => esc_html__( 'Fast and safe transport your product', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
                    [
						'hero_bg'          => Utils::get_placeholder_image_src(),
                        'hero_shape_image' => Utils::get_placeholder_image_src(),
                        'hero_hape01'      => Utils::get_placeholder_image_src(),
                        'hero_shape02'     => Utils::get_placeholder_image_src(),
						'bottom_big_title' => esc_html__( 'Air Freight', 'adina' ),
						'hero_subtitle' => esc_html__( '01. AIR Freight', 'adina' ),
						'hero_title'    => esc_html__( 'Fast and safe transport your product', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
				],
			]
		);


        $this->end_controls_section();


        /********* Start Style Controls /*********/
        
        // //////// bottom title in here /////////
        $this->start_controls_section(
            '_hero_01bottom_title',
            [
                'label' => __( 'Bottom Big Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bottom_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one .big-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'bottom_title_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .main-slider-one .big-title h2',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bottom_title_typography',
                'selector' => '{{WRAPPER}} .main-slider-one .big-title h2',
            ]
        );
        $this->add_responsive_control(
            'bottom_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one .big-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'bottom_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one .big-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        // //////// sub  title in here ////////////////////////////
        $this->start_controls_section(
            '_hero_01_sub_title',
            [
                'label' => __( 'Sub Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-one__content h3',
			]
		);
        $this->add_responsive_control(
            'sub_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /////////////// content Title /////////////////////////////
        $this->start_controls_section(
            '_hero_01_content_title',
            [
                'label' => __( 'Content Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'Content_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-one__content h2',
			]
		);
        $this->add_responsive_control(
            'Content_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Content_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        
        ////////////////// Transparent title /////////////////
        $this->start_controls_section(
            '_hero_Provider_title',
            [
                'label' => __( 'Transparent Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Provider_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'provider_title_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .main-slider-one__content h2 span',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'provider_title_typography',
                'selector' => '{{WRAPPER}} .main-slider-one__content h2 span',
            ]
        );
        $this->add_responsive_control(
            'Provider_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Provider_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content h2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////// Discription or content in here /////////////////////////////
        $this->start_controls_section(
            '_hero_01_content',
            [
                'label' => __( 'Content ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Content_typography',
                'selector' => '{{WRAPPER}} .main-slider-one__content p',
            ]
        );
        $this->add_responsive_control(
            'Content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // /////////////// button hero 01////////////////////////
        $this->start_controls_section(
            '_hero_01_button',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
 /////////////////// Button Normal part//////////////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'Normal_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'normal_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'normal_text_typography',
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn .txt',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'normal_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:after',
            ]
        );
        $this->add_responsive_control(
            'normal_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:after' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:after' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        ////////////// Button Hover part in here ////////////////////////
        $this->start_controls_tab(
            'style_hover_tabss',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'adina' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hover_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'hover_text_typography',
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn .txt',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_text_border',
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'hover_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_responsive_control(
            'hover_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-one__content .btn-box .thm-btn::before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        ///////////// Arrow button color ////////////////////////////////
        $this->start_controls_section(
            '_section_arrow',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ///////////// Arrow Normal ////////////////
        $this->start_controls_tabs(
            'style_tabses'
        );
        
        $this->start_controls_tab(
            'style__arrow_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_text_typography',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_text_border',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_responsive_control(
            'arrow_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_tab();

        /////////////////// Arrow Hover ////////////////////////////
        $this->start_controls_tab(
            'style_hover_arrow',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_typography',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_responsive_control(
            'arrow_margin',

            
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();


        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $slides = $settings[ 'adina_heroone_slides' ];

        ?>
            <section class="main-slider main-slider-one">
            <div class="swiper-container thm-swiper__slider">
                <div class="swiper-wrapper">
                    <?php foreach( $slides as $slide  ):
                        
                        ?>
                        <!--Start Swiper Slide Single-->
                        <div class="swiper-slide">
                            <?php if( !empty( $slide[ 'hero_bg' ]['url'] ) ): ?>
                                <div class="image-layer" style="background-image: url(<?php echo esc_url( $slide[ 'hero_bg' ]['url'] ); ?>);">
                                </div>
                            <?php endif;  ?>
                            
                            <?php if( !empty( $slide[ 'bottom_big_title' ] ) ): ?>
                                <div class="big-title">
                                    <h2><?php echo esc_html( $slide[ 'bottom_big_title' ]  ); ?></h2>
                                </div>
                            <?php endif;  ?>

                            <!-- Icon and images -->
                            <?php if( !empty( $slide[ 'hero_shape_image' ]['url'] ) ): ?>
                            <div class="img-box"><img src="<?php echo esc_url( $slide[ 'hero_shape_image' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>

                            <?php if( !empty( $slide[ 'hero_hape01' ]['url'] ) ): ?>
                            <div class="icon-one"><img src="<?php echo esc_url( $slide[ 'hero_hape01' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>

                            <?php if( !empty( $slide[ 'hero_shape02' ]['url'] ) ): ?>
                            <div class="icon-two"><img src="<?php echo esc_url( $slide[ 'hero_shape02' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>


                            <div class="container">
                                <div class="main-slider-one__single">
                                    <div class="main-slider-one__content">
                                        <?php if( !empty( $slide[ 'hero_subtitle' ] ) ): ?>
                                            <h3><?php echo adina_kses( $slide[ 'hero_subtitle' ] ); ?></h3>
                                        <?php endif;  ?>
                                        
                                        <?php if( !empty( $slide[ 'hero_title' ] ) ): ?>
                                            <h2><?php echo adina_kses( $slide[ 'hero_title' ] ); ?></h2>
                                        <?php endif;  ?>
                                        
                                        <?php if( !empty( $slide[ 'hero_content' ] ) ): ?>
                                            <p><?php echo adina_kses( $slide[ 'hero_content' ] ); ?></p>
                                        <?php endif;  ?>

                                        <?php if( !empty( $slide[ 'btn_text' ] ) ): ?>
                                            <div class="btn-box">
                                                <a class="thm-btn" href="<?php echo esc_url( $slide['btn_url'] ); ?>">
                                                    <span class="txt"><?php echo esc_html(  $slide[ 'btn_text' ] ); ?>
                                                    <i class="icon-right-arrow"></i>
                                                </a>
                                            </div>
                                        <?php endif;  ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <!--End Swiper Slide Single-->
                    <?php endforeach; ?>
                </div>

                <!-- If we need navigation buttons -->
                <div class="swiper-pagination" id="main-slider-pagination"></div>

                <div class="main-slider__nav">
                    <div class="swiper-button-prev" id="main-slider__swiper-button-next">
                        <i class="fa fa-angle-left" aria-hidden="true"></i>
                    </div>
                    <div class="swiper-button-next" id="main-slider__swiper-button-prev">
                        <i class="fa fa-angle-right" aria-hidden="true"></i>
                    </div>
                </div>
            </div>
        </section>
        <!--End Main Slider One-->

        
    
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaHeroOne());