<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaHeroThree extends Widget_Base {
    public function get_name() {
        return 'adina-hero-three';
    }
    public function get_title() {
        return __('Hero three', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Hero', 'slider', 'section'];
    }

    protected function register_controls() {
        
        $this->start_controls_section('general_section',
            [
                'label' => __('General', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $heroone_repeater = new Repeater();

        $heroone_repeater->add_control(
            'herotitle_icon',
            [
                'label' => esc_html__('Title Icon', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $heroone_repeater->add_control(
            'heroshape_image',
            [
                'label' => esc_html__('Shape Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $heroone_repeater->add_control(
			'hero_bg',
			[
				'label' => esc_html__( 'Background Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $heroone_repeater->add_control(
			'Sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'We are the leading', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'hero_bottomtitle',
			[
				'label' => esc_html__( 'Content bottom Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Cargo Freight', 'adina' ),
				'label_block' => true,
			]
		);

        $heroone_repeater->add_control(
			'hero_title',
			[
				'label' => esc_html__( 'Content Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Fast and safe transport your product', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'hero_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                auctor nisi elit more consequat ipsum.', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Calculate Package', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'adina_heroone_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $heroone_repeater->get_controls(),
				'default' => [
					[
						
                        'herotitle_icon'   => Utils::get_placeholder_image_src(),
                        'heroshape_image'  => Utils::get_placeholder_image_src(),
                        'hero_bg'          => Utils::get_placeholder_image_src(),
						'Sub_title'        => esc_html__( 'We are the leading', 'adina' ),
						'hero_bottomtitle' => esc_html__( 'Cargo Freight', 'adina' ),
						'hero_title'       => esc_html__( 'Fast and safe transport your product', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
                    [
						
                        'herotitle_icon'   => Utils::get_placeholder_image_src(),
                        'heroshape_image'  => Utils::get_placeholder_image_src(),
                        'hero_bg'          => Utils::get_placeholder_image_src(),
						'Sub_title'        => esc_html__( 'We are the leading', 'adina' ),
						'hero_bottomtitle' => esc_html__( 'Cargo Freight', 'adina' ),
						'hero_title'    => esc_html__( 'Fast and safe transport your product', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
                    [
						
                        'herotitle_icon'   => Utils::get_placeholder_image_src(),
                        'heroshape_image'  => Utils::get_placeholder_image_src(),
                        'hero_bg'          => Utils::get_placeholder_image_src(),
						'Sub_title'        => esc_html__( 'We are the leading', 'adina' ),
						'hero_bottomtitle' => esc_html__( 'Cargo Freight', 'adina' ),
						'hero_title'       => esc_html__( 'Fast and safe transport your product', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
				],
			]
		);
        $this->end_controls_section();


        /********* Start Style Controls /*********/
            /////////////////////  top icon ///////////////////////////
        $this->start_controls_section(
            '_section_top_icon',
            [
                'label' => __( 'Top Icon', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'top_icon_width',
            [
                'label' => esc_html__( 'Width', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .tagline-box .icon img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'top_icon_height',
            [
                'label' => esc_html__( 'height', 'adina' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .tagline-box .icon img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'top_icon_colors',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .tagline-box .icon img' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-three__content .tagline-box .icon img',
            ]
        );
        
        $this->end_controls_section();
        // //////// sub  title in here ////////////
        $this->start_controls_section(
            '_hero_01_sub_title',
            [
                'label' => __( 'Sub Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .tagline-box .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sub_title_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .main-slider-three__content .tagline-box .text p',
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-three__content .tagline-box .text p',
			]
		);
        $this->add_responsive_control(
            'Top_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .tagline-box .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .tagline-box .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //////////////////Transparent  title /////////////////
        $this->start_controls_section(
            '_hero_transparent_title',
            [
                'label' => __( 'Transparent Text', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'transparent_title_color',
            [
                'label' => __( ' Transparent Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'transparent_title_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .main-slider-three__content .title-box h2 span',
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'Transparent_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-three__content .title-box h2 span',
			]
		);
        $this->add_responsive_control(
            'transparent_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box h2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'transparent_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box h2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /////////////// content Title /////////////////////////////
        $this->start_controls_section(
            '_hero_01_content_title',
            [
                'label' => __( 'Content Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'Content_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-three__content .title-box h2',
			]
		);
        $this->add_responsive_control(
            'Content_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Content_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////// Discription or content in here /////////////////////////////
        $this->start_controls_section(
            '_hero_01_content',
            [
                'label' => __( 'Content ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Content_typography',
                'selector' => '{{WRAPPER}} .main-slider-three__content .title-box p',
            ]
        );
        $this->add_responsive_control(
            'Content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .title-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // /////////////// button hero 01////////////////////////
        $this->start_controls_section(
            '_hero_01_button',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
 /////////////////// Button Normal part//////////////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'Normal_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn',
            ]
        );
        $this->add_control(
            'normal_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'normal_text_typography',
                'selector' => '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'normal_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn',
            ]
        );
        $this->add_responsive_control(
            'normal_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider .swiper-slide-active .main-slider-three__content .btn-box .thm-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
    

        ////////////// Button Hover part in here ////////////////////////
        $this->start_controls_tab(
            'style_hover_tabss',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'adina' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hover_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'hover_text_typography',
                'selector' => '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_text_border',
                'selector' => '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'hover_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_responsive_control(
            'hover_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__content .btn-box .thm-btn::before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        ///////////// Bottom Title /////////////////////////////
        $this->start_controls_section(
            '_hero_01_bottom',
            [
                'label' => __( 'Bottom Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bottom_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__single .bottom-text-box .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bottom_typography',
                'selector' => '{{WRAPPER}} .main-slider-three__single .bottom-text-box .text p',
            ]
        );
        $this->add_responsive_control(
            'bottom_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__single .bottom-text-box .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'bottom_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-three__single .bottom-text-box .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////////// Arrow button option ////////////////////////////////
        $this->start_controls_section(
            '_section_arrow',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ///////////// Arrow Normal ////////////////
        $this->start_controls_tabs(
            'style_tabses'
        );
        $this->start_controls_tab(
            'style__arrow_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_text_typography',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_text_border',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev',
            ]
        );
        $this->add_responsive_control(
            'arrow_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next, .main-slider__nav .swiper-button-prev' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();


        /////////////////// Arrow Hover ////////////////////////////
        $this->start_controls_tab(
            'style_hover_arrow',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_typography',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'selector' => '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover',
            ]
        );
        $this->add_responsive_control(
            'arrow_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider__nav .swiper-button-next:hover, .main-slider__nav .swiper-button-prev:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();
        
        /********* End Style Controls /*********/


    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $slides = $settings[ 'adina_heroone_slides' ];

    ?>
        <!--Start Main Slider Three-->
        <section class="main-slider main-slider-three">
            <div class="swiper-container hero_one__slider">

                <div class="swiper-wrapper">

                    <!--Start Swiper Slide Single-->
                    <?php foreach( $slides as $slide  ):
                        
                        ?>
                    <div class="swiper-slide">
                        <!-- background image upload -->
                        <?php if( !empty( $slide[ 'hero_bg' ]['url'] ) ): ?>
                            <div class="image-layer" style="background-image: url(<?php echo esc_url( $slide[ 'hero_bg' ]['url'] ); ?>);"></div>
                        <?php endif;  ?>

                        <div class="container">
                            <div class="main-slider-three__single">

                                    <!-- shape image upload -->
                                <?php if( !empty( $slide[ 'heroshape_image' ]['url'] ) ): ?>
                                    <div class="shape1"><img src="<?php echo esc_url( $slide[ 'heroshape_image' ]['url'] ); ?>" alt=""></div>
                                <?php endif;  ?>

                                <div class="main-slider-three__content text-center">
                                    <div class="tagline-box">

                                    <!-- Title icon upload -->  
                                        <?php if( !empty( $slide[ 'herotitle_icon' ]['url'] ) ): ?>
                                        <div class="icon">
                                            <img src="<?php echo esc_url( $slide[ 'herotitle_icon' ]['url'] ); ?>" alt="">
                                        </div>
                                        <?php endif;  ?>

                                        <!-- Sub  title in here -->
                                        <?php if( !empty( $slide[ 'Sub_title' ] ) ): ?>
                                        <div class="text">
                                            <p><?php echo esc_html( $slide[ 'Sub_title' ]  ); ?></p>
                                        </div>
                                        <?php endif;  ?>
                                    </div>

                                    <!-- Titlt  in here -->
                                    <div class="title-box">
                                        <?php if( !empty( $slide[ 'hero_title' ] ) ): ?>
                                        <h2><?php echo adina_kses( $slide[ 'hero_title' ] ); ?> </h2>
                                        <?php endif;  ?>

                                        <!-- discription in here  -->
                                        <?php if( !empty( $slide[ 'hero_content' ] ) ): ?>
                                        <p><?php echo adina_kses( $slide[ 'hero_content' ] ); ?></p>
                                        <?php endif;  ?>
                                    </div>
                                
                                    <!-- Btn text and url in here  -->
                                    <?php if( !empty( $slide[ 'btn_text' ] ) ): ?>
                                    <div class="btn-box">
                                        <a class="thm-btn" href="<?php echo esc_url( $slide['btn_url'] ); ?>">
                                            <span class="txt"><?php echo esc_html(  $slide[ 'btn_text' ] ); ?></span> <i class="icon-right-arrow"></i>
                                        </a>
                                    </div>
                                    <?php endif;  ?>

                                </div>
                                <div class="bottom-text-box">
                                    <div class="border"></div>

                                    <!-- Bottom title in hre  -->
                                    <?php if( !empty( $slide[ 'hero_bottomtitle' ] ) ): ?>
                                    <div class="text">
                                        <p><?php echo adina_kses( $slide[ 'hero_bottomtitle' ] ); ?></p>
                                    </div>
                                    <?php endif;  ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <!--End Swiper Slide Single-->

                </div>

                <!-- If we need navigation buttons -->
                <div class="swiper-pagination" id="main-slider-pagination"></div>
                <div class="main-slider__nav">
                    <div class="swiper-button-prev" id="main-slider__swiper-button-next">
                        <i class="fa fa-angle-left" aria-hidden="true"></i>
                    </div>
                    <div class="swiper-button-next" id="main-slider__swiper-button-prev">
                        <i class="fa fa-angle-right" aria-hidden="true"></i>
                    </div>
                </div>
            </div>
        </section>
        <!--End Main Slider Three-->

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaHeroThree());