<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaHeroTwo extends Widget_Base {
    public function get_name() {
        return 'adina-hero-two';
    }
    public function get_title() {
        return __('Hero Two', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Hero', 'slider', 'section'];
    }

    protected function register_controls() {
        
        $this->start_controls_section('general_section',
            [
                'label' => __('General', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $heroone_repeater = new Repeater();

        $heroone_repeater->add_control(
			'hero_bg',
			[
				'label' => esc_html__( 'Background Image', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
			]
		);
        $heroone_repeater->add_control(
			'bottom_title',
			[
				'label' => esc_html__( 'Bottom Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'adina', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'hero_subtitle',
			[
				'label' => esc_html__( 'Content Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Logistics & Supply Chain Solutions', 'adina' ),
				'label_block' => true,
			]
		);

        $heroone_repeater->add_control(
			'herotwo_title',
			[
				'label' => esc_html__( 'Content Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Fast and Safety World wide Service Provider', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'hero_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                auctor nisi elit more consequat ipsum.', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button Text', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Calculate Package', 'adina' ),
				'label_block' => true,
			]
		);
        $heroone_repeater->add_control(
			'btn_url',
			[
				'label' => esc_html__( 'Button Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        // shape upload in here start
        $heroone_repeater->add_control(
            'herotwo_shape_show',
            [
                'label' => esc_html__( 'Shape Upload Show', 'tpcore' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'tpcore' ),
                'label_off' => esc_html__( 'Hide', 'tpcore' ),
                'return_value' => 'yes',
            ]
        );
        $heroone_repeater->add_control(
			'herotwo_shape01',
			[
				'label' => esc_html__( 'Shape Upload 01', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'herotwo_shape_show' => 'yes'
                ],
			]
		);
        $heroone_repeater->add_control(
			'herotwo_shape02',
			[
				'label' => esc_html__( 'Shape Upload 02', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'herotwo_shape_show' => 'yes'
                ],
			]
		);
        $heroone_repeater->add_control(
			'herotwo_shape03',
			[
				'label' => esc_html__( 'Shape Upload 03', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'herotwo_shape_show' => 'yes'
                ],
			]
		);
        $heroone_repeater->add_control(
			'herotwo_shape04',
			[
				'label' => esc_html__( 'Shape Upload 04', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
				'default' => [
					'url' =>  Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'herotwo_shape_show' => 'yes'
                ],
			]
		);
        // shape upload End 

        $this->add_control(
			'adina_heroone_slides',
			[
				'label' => esc_html__( 'Slider List', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $heroone_repeater->get_controls(),
				'default' => [
					[
						'hero_bg'          => Utils::get_placeholder_image_src(),
                        'herotwo_shape01'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape02'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape03'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape04'  => Utils::get_placeholder_image_src(),
						'bottom_title'     => esc_html__( 'adina', 'adina' ),
						'hero_subtitle'    => esc_html__( 'Logistics & Supply Chain Solutions', 'adina' ),
						'herotwo_title'    => esc_html__( 'Fast and Safety World wide Service Provider', 'adina' ),
						'hero_content'     => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
                    [
						'hero_bg'          => Utils::get_placeholder_image_src(),
                        'herotwo_shape01'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape02'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape03'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape04'  => Utils::get_placeholder_image_src(),
						'bottom_title'     => esc_html__( 'adina', 'adina' ),
						'hero_subtitle'    => esc_html__( 'Logistics & Supply Chain Solutions', 'adina' ),
						'herotwo_title'    => esc_html__( 'Fast and Safety World wide Service Provider', 'adina' ),
						'hero_content'          => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
                    [
						'hero_bg'          => Utils::get_placeholder_image_src(),
                        'herotwo_shape01'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape02'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape03'  => Utils::get_placeholder_image_src(),
                        'herotwo_shape04'  => Utils::get_placeholder_image_src(),
						'bottom_title'     => esc_html__( 'adina', 'adina' ),
						'hero_subtitle'    => esc_html__( 'Logistics & Supply Chain Solutions', 'adina' ),
						'herotwo_title'    => esc_html__( 'Fast and Safety World wide Service Provider', 'adina' ),
						'hero_content'     => esc_html__( 'With more than 30 years of experience in the logistics industry bibendum
                        auctor nisi elit more consequat ipsum.', 'adina' ),
						'btn_text'         => esc_html__( 'Calculate Package', 'adina' ),
						'btn_url'          => esc_html__( '#', 'adina' ),
					],
				],
			]
		);
        $this->end_controls_section();
        
    
    /********* Start Style Controls /*********/
    
    // //////// bottom title in here /////////
            $this->start_controls_section(
                '_hero_01bottom_title',
                [
                    'label' => __( 'Bottom Big Title ', 'adina' ),
                    'tab'   => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_control(
                'bottom_title_color',
                [
                    'label' => __( 'Title Color', 'adina' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-slider-two .big-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'bottom_title_background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .main-slider .main-slider-two .big-title h2',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'bottom_title_typography',
                    'selector' => '{{WRAPPER}} .main-slider-two .big-title h2',
                ]
            );
            $this->add_responsive_control(
                'bottom_title_margin',
                [
                    'label' => __( 'Margin', 'adina' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .main-slider-two .big-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bottom_title_padding',
                [
                    'label' => __( 'Padding', 'adina' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .main-slider-two .big-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
    
            $this->end_controls_section();
            
        // //////// Sub title in here ////////////////////////////
        $this->start_controls_section(
            '_hero_01Sub_title',
            [
                'label' => __( 'Sub Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'sub_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .sub-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sub_title_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .main-slider-two__content .sub-title p',
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-two__content .sub-title p',
			]
		);
        $this->add_responsive_control(
            'sub_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .sub-title p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .sub-title p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ////////////////// Transparent /////////////////
        $this->start_controls_section(
            '_hero_Provider_title',
            [
                'label' => __( 'Transparent Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Provider_title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .title h2 span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'provider_title_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider .main-slider-two__content .title h2 span',
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'provider_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-two__content .title h2 span',
			]
		);
        $this->add_responsive_control(
            'Provider_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .title h2 span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Provider_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .title h2 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
  

        /////////////////////  top boder ///////////////////////////
        $this->start_controls_section(
            '_section_top_border',
            [
                'label' => __( 'Top border', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'top_border_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .main-slider-two__content .sub-title::before' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'top_border_height',
			[
				'label' => esc_html__( 'height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .main-slider-two__content .sub-title::before' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
            'top_border_colors',
            [
                'label' => __( 'border Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .sub-title::before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .main-slider-two__content .sub-title::before',
			]
		);
        
        $this->end_controls_section();
      

        /////////////// content Title /////////////////////////////
        $this->start_controls_section(
            '_hero_01_content_title',
            [
                'label' => __( 'Title ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_title_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'Content_title_typography',
				'selector' => '{{WRAPPER}} .main-slider-two__content .title h2',
			]
		);
        $this->add_responsive_control(
            'Content_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Content_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        ///////////// Discription or content in here /////////////////////////////
        $this->start_controls_section(
            '_hero_01_content',
            [
                'label' => __( 'Content ', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( ' Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Content_typography',
                'selector' => '{{WRAPPER}} .main-slider-two__content .text p',
            ]
        );
        $this->add_responsive_control(
            'Content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // /////////////// button hero 01////////////////////////
        $this->start_controls_section(
            '_hero_01_button',
            [
                'label' => __( 'Button', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
 /////////////////// Button Normal part//////////////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'Normal_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'normal_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'normal_text_typography',
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'normal_text_border',
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:after',
            ]
        );
        $this->add_control(
            'Normal_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'normal_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:after',
            ]
        );
        $this->add_responsive_control(
            'normal_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:after' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'normal_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:after' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
    

        ////////////// Button Hover part in here ////////////////////////
        $this->start_controls_tab(
            'style_hover_tabss',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'adina' ),
				'type' => Controls_Manager::HOVER_ANIMATION,
			]
		);
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hover_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'hover_text_typography',
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn .txt',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_text_border',
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_control(
            'hover_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'hover_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn::before',
            ]
        );
        $this->add_responsive_control(
            'hover_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn::before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two__content .btn-box .thm-btn::before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();



        ///////////// Arrow button option ////////////////////////////////
        $this->start_controls_section(
            '_section_arrow',
            [
                'label' => __( 'Arrow', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        ///////////// Arrow Normal ////////////////
        $this->start_controls_tabs(
            'style_tabses'
        );
        
        $this->start_controls_tab(
            'style__arrow_normal',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_text_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_text_typography',
                'selector' => '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_text_border',
                'selector' => '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_control(
            'arrow_text_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_text_shadow',
                'selector' => '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev',
            ]
        );
        $this->add_responsive_control(
            'arrow_text_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_text_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .main-slider-two .swiper-nav-style1 .swiper-button-next, .main-slider-two .swiper-nav-style1 .swiper-button-prev' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_tab();


        /////////////////// Arrow Hover ////////////////////////////
        $this->start_controls_tab(
            'style_hover_arrow',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'arrow_background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_color',
            [
                'label' => __( 'Text Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'arrow_typography',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'arrow_border',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_control(
            'arrow_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'arrow_shadow',
                'selector' => '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover',
            ]
        );
        $this->add_responsive_control(
            'arrow_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-style1 .swiper-button-next:hover, .swiper-nav-style1 .swiper-button-prev:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

        
        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        //Repiter id ta cariable korche in here
        $slides = $settings[ 'adina_heroone_slides' ];

        ?>

                <!--Start Main Slider Two-->
            <section class="main-slider main-slider-two">
                <div class="swiper-container hero-two-slider">
                    <div class="swiper-wrapper">

                        <!--Start Swiper Slide Single-->
                        <?php foreach( $slides as $slide  ):
                            
                            ?>
                        <div class="swiper-slide">
                            <!-- background image upload -->
                            <?php if( !empty( $slide[ 'hero_bg' ]['url'] ) ): ?>
                                <div class="image-layer" style="background-image: url(<?php echo esc_url( $slide[ 'hero_bg' ]['url'] ); ?>);"></div>
                            <?php endif;  ?>

                            <!-- shape upload in here -->
                            <?php if( !empty( $slide[ 'herotwo_shape01' ]['url'] ) ): ?>
                            <div class="shape1"><img src="<?php echo esc_url( $slide[ 'herotwo_shape01' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>

                            <?php if( !empty( $slide[ 'herotwo_shape02' ]['url'] ) ): ?>
                            <div class="shape2"><img src="<?php echo esc_url( $slide[ 'herotwo_shape02' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>

                            <?php if( !empty( $slide[ 'herotwo_shape03' ]['url'] ) ): ?>
                            <div class="shape3"><img src="<?php echo esc_url( $slide[ 'herotwo_shape03' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>

                            <?php if( !empty( $slide[ 'herotwo_shape04' ]['url'] ) ): ?>
                            <div class="shape4"><img class="float-bob-x" src="<?php echo esc_url( $slide[ 'herotwo_shape04' ]['url'] ); ?>" alt=""></div>
                            <?php endif;  ?>

                            <!-- Bottom title in here -->
                            <?php if( !empty( $slide[ 'bottom_title' ] ) ): ?>
                            <div class="big-title">
                                <h2><?php echo esc_html( $slide[ 'bottom_title' ]  ); ?></h2>
                            </div>
                            <?php endif;  ?>

                            <div class="container">
                                <div class="main-slider-two__single">
                                    <div class="main-slider-two__content">

                                        <!-- Sub title in hre  -->
                                        <?php if( !empty( $slide[ 'hero_subtitle' ] ) ): ?>
                                        <div class="sub-title">
                                            <p><?php echo adina_kses( $slide[ 'hero_subtitle' ] ); ?></p>
                                        </div>
                                        <?php endif;  ?>

                                        <!-- Titlt  in here -->
                                        <?php if( !empty( $slide[ 'herotwo_title' ] ) ): ?>
                                        <div class="title">
                                            <h2><?php echo adina_kses( $slide[ 'herotwo_title' ] ); ?> </h2>
                                        </div>
                                        <?php endif;  ?>

                                        <!-- discription in here  -->
                                        <?php if( !empty( $slide[ 'hero_content' ] ) ): ?>
                                        <div class="text">
                                            <p><?php echo adina_kses( $slide[ 'hero_content' ] ); ?></p>
                                        </div>
                                        <?php endif;  ?>


                                        <!-- Btn text and url in here  -->
                                    <?php if( !empty( $slide[ 'btn_text' ] ) ): ?>
                                    <div class="btn-box">
                                            <a class="thm-btn" href="<?php echo esc_url( $slide['btn_url'] ); ?>">
                                                <span class="txt"><?php echo esc_html(  $slide[ 'btn_text' ] ); ?></span> <i class="icon-right-arrow"></i>
                                            </a>
                                        </div>
                                        <?php endif;  ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        <!--End Swiper Slide Single-->
                    </div>

                    <!-- If we need navigation buttons -->

                    <div class="swiper-nav-style1">
                        <div class="swiper-button-prev" id="main-slider-two__swiper-button-next">
                            <i class="icon-left-arrow-5" aria-hidden="true"></i>
                        </div>
                        <div class="swiper-button-next" id="main-slider-two__swiper-button-prev">
                            <i class="icon-right-arrow-5" aria-hidden="true"></i>
                        </div>
                    </div>


                </div>
            </section>
            <!--End Main Slider One-->
    
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaHeroTwo());