<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */
namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaIconBoxFour extends Widget_Base {
    public function get_name() {
        return 'adina-icon-box-four';
    }
    public function get_title() {
        return __('Icon Box Four', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['Icon', 'Box'];
    }

    protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            'tp_layout',
            [
                'label' => esc_html__('Content', 'adina'),
            ]
        );
        $this->add_control(
            'iconbox_layout',
            [
                'label' => esc_html__('Select Layout', 'adina'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'adina'),
                    'layout-2' => esc_html__('Layout 2', 'adina'),
                    'layout-3' => esc_html__('Layout 3', 'adina'),
                ],
                'default' => 'layout-1',
            ]
        );
        $iconbox = new Repeater();
        $iconbox->add_control(
			'_icon_04',
			[
				'label' => esc_html__( 'Here you can use Fontawsome or Icomoon Class', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'icon-global-network', 'adina' ),
				'label_block' => true,
			]
		);
        $iconbox->add_control(
			'icon_title',
			[
				'label' => esc_html__( 'Title', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Fast Worldwide Delivery', 'adina' ),
				'label_block' => true,
			]
		);
        $iconbox->add_control(
			'icon_content',
			[
				'label' => esc_html__( 'Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing <br>
                do eiusmod of tempor labore.', 'adina' ),
				'label_block' => true,
			]
		);

        $iconbox->add_control(
            'icon_box_sahpe',
            [
                'label' => esc_html__( 'Image', 'adina' ),
                'type' =>  Controls_Manager::MEDIA,
                'default' => [
                    'url' =>  Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
			'iconbox_lists',
			[
				'label' => esc_html__( 'Iocn Box', 'adina' ),
				'type' =>  Controls_Manager::REPEATER,
				'fields' => $iconbox->get_controls(),
				'default' => [
					[
						'icon_box_04'    => esc_html__( 'Fast Worldwide Delivery', 'adina' ),
                        '_icon_04'       => esc_html__( 'icon-global-network', 'adina' ),
						'icon_title'     => esc_html__( 'Fast Worldwide Delivery', 'adina' ),
						'icon_content'   => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing <br>  do eiusmod of tempor labore.', 'adina' ),
                        'icon_box_sahpe' => Utils::get_placeholder_image_src(),
					],
				],
                'title_field' => '{{{ icon_title }}}',

			]
		);
        $this->end_controls_section();


        /********* End Style Controls /*********/
////////////////////  Icon color in here ///////////////////////////////////
        $this->start_controls_section(
            'layout_01_icon',
            [
                'label' => __( 'Icon Color', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'layout_01_icon_color',
            [
                'label' => __( 'Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .icon-box span, .company-benefit-one__content-list li .icon-box span, .about-three__content-list li .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'layout_01_icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-three__content-list li:hover .icon-box span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'layout_01_icon_size',
			[
				'label' => esc_html__( 'size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors' => [
					'{{WRAPPER}} .company-benefit-one__content-list li .icon-box span, .request-services-one__content-list li .icon-box span' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
            'content_box',
            [
                'label' => __( 'Content Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'content_box_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .company-benefit-one__content-list li .content-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //////// Title in here ////////////
        $this->start_controls_section(
            '_icon_title',
            [
                'label' => __( 'Title', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .text-box h3, .company-benefit-one__content-list li .content-box h3, .about-three__content-list li .text-box h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .request-services-one__content-list li .text-box h3, .company-benefit-one__content-list li .content-box h3, .about-three__content-list li .text-box h3',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .text-box h3, .company-benefit-one__content-list li .content-box h3, .about-three__content-list li .text-box h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .text-box h3, .company-benefit-one__content-list li .content-box h3, .about-three__content-list li .text-box h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //////// Content  in here ////////////
        $this->start_controls_section(
            '_icon_content',
            [
                'label' => __( 'Content', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .text-box p, .company-benefit-one__content-list li .content-box p, .about-three__content-list li .text-box p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .request-services-one__content-list li .text-box p, .company-benefit-one__content-list li .content-box p, .about-three__content-list li .text-box p',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .text-box p, .company-benefit-one__content-list li .content-box p, .about-three__content-list li .text-box p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .request-services-one__content-list li .text-box p, .company-benefit-one__content-list li .content-box p, .about-three__content-list li .text-box p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        ///////// Icon Box //////////
        $this->start_controls_section(
            '_icon_box_04',
            [
                'label' => __( 'Icon Box', 'adina' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        //////////////  Box Normal//////////////////////////
        $this->start_controls_tabs(
            'style_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .company-benefit-one__content-list li .icon-box',
			]
		);
        $this->add_responsive_control(
			'iconbox_width',
			[
				'label' => esc_html__( 'Width', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .company-benefit-one__content-list li .icon-box' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'iconbox_height',
			[
				'label' => esc_html__( 'Height', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .company-benefit-one__content-list li .icon-box' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'full_box_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .company-benefit-one__content-list li',
			]
		);
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'icon_normal_border',
                'selector' => '{{WRAPPER}} .company-benefit-one__content-list li .icon-box',
            ]
        );
        $this->add_control(
            'icon_normal_raidus',
            [
                'label' => esc_html__( 'Border Radius', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .company-benefit-one__content-list li .icon-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_normalmargin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .company-benefit-one__content-list li, .request-services-one__content-list li, .about-three__content-list li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_normal_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .company-benefit-one__content-list li, .request-services-one__content-list li, .about-three__content-list li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        
        ////////////// Box Hover ////////////////////
        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );
        $this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'hover_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .company-benefit-one__content-list li .icon-box::before',
			]
		);
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_hover_border',
                'selector' => '{{WRAPPER}} .company-benefit-one__content-list li:hover:before',
            ]
        );
        $this->end_controls_tabs();
        $this->end_controls_section();

     
        /********* End Style Controls /*********/

    }

    protected function render() {
        $settings = $this->get_settings_for_display(); 
        $layout = $settings['iconbox_layout'];
        $iconbox_list = $settings['iconbox_lists'];
        ?> 

            <?php
                if ( $layout) {
                    include('iconbox/'.$layout.'.php');
                }
            ?> 
        <?php
}
}
$widgets_manager->register(new \Elementor\AdinaIconBoxFour());

