<?php
/**
 * Happyden Team Widget.
 *
 *
 * @since 1.0.0
 */

namespace Elementor;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\URL;
use \Elementor\Control_Media;

if (!defined('ABSPATH')) {
    exit;
}
// If this file is called directly, abort.
class AdinaIconBoxOne extends Widget_Base {
    public function get_name() {
        return 'adina_iconbox_one';
    }
    public function get_title() {
        return __('IconBox One', 'adina');
    }
    public function get_icon() {
        return ('eicon-person');
    }
    public function get_categories() {
        return ['adina-addons'];
    }
    public function get_keywords() {
        return ['iconbox', 'steps', 'process'];
    }
    protected function register_controls() {
        $this->start_controls_section('general_section',
            [
                'label' => __('General ', 'adina'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'icon_shape',
			[
				'label' => esc_html__( 'Shape', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'icons',
			[
				'label' => esc_html__( 'Icon', 'adina' ),
				'type' =>  Controls_Manager::MEDIA,
			]
		);
        $this->add_control(
			'icon_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'STEP - 1', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'icon_title',
			[
				'label' => esc_html__( 'Icon Title', 'adina' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'The Paperwork', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'title_url',
			[
				'label' => esc_html__( 'Title Url', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '#', 'adina' ),
				'label_block' => true,
			]
		);
        $this->add_control(
			'icon_content',
			[
				'label' => esc_html__( 'Icon Content', 'adina' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Once you place your order via mail or fax our field staff will collect the documents and consignments from the shipper.', 'adina' ),
				'label_block' => true,
			]
		);

        $this->end_controls_section();


        // ICON STYLE
        $this->start_controls_section('icon_style',
            [
                'label' => __('Icon', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'icon_width',
			[
				'label' => esc_html__( 'Size', 'adina' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 58,
				],
				'selectors' => [
					'{{WRAPPER}} .working-process-one__single-top .icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        // Sub Title STYLE
        $this->start_controls_section('sub_title_style',
            [
                'label' => __('Sub Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'sub_title_colors',
            [
                'label' => __( 'Sub Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-top .text h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'selector' => '{{WRAPPER}} .working-process-one__single-top .text h2',
            ]
        );
        $this->add_responsive_control(
            'sub_title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-top .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sub_title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-top .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Title STYLE
        $this->start_controls_section('title_style',
            [
                'label' => __('Title', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_styles'
        );

        $this->start_controls_tab(
            'iconbox_title_style',
            [
                'label' => esc_html__( 'Normal', 'adina' ),
            ]
        );

        $this->add_control(
            'title_colors',
            [
                'label' => __( 'Title Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content h2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .working-process-one__single-content h2',
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();


        $this->start_controls_tab(
            'title_hover_style',
            [
                'label' => esc_html__( 'Hover', 'adina' ),
            ]
        );

        $this->add_control(
            'title_hover_colors',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content h2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        // Content STYLE
        $this->start_controls_section('content_style',
            [
                'label' => __('Content', 'adina'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_colors',
            [
                'label' => __( 'Content Color', 'adina' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .working-process-one__single-content p',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', 'adina' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .working-process-one__single-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

    ?>
        
        <div class="working-process-one__single">
            <?php if ( !empty($settings['icon_shape']) ) : ?>
                <div class="shape1"><img src="<?php echo esc_url( $settings['icon_shape']['url'] ); ?>" alt=""></div>
            <?php endif; ?>
            <div class="working-process-one__single-top">
                <?php if ( !empty($settings['icons']) ) : ?>
                    <div class="icon">
                        <img src="<?php echo esc_url( $settings['icons']['url'] ); ?>" alt="">
                    </div>
                <?php endif; ?>
                <?php if ( !empty($settings['icon_sub_title']) ) : ?>
                    <div class="text">
                        <h2><?php echo esc_html( $settings['icon_sub_title']); ?></h2>
                    </div>
                <?php endif; ?>
            </div>
            <div class="working-process-one__single-content">
                <?php if ( !empty($settings['icon_title']) ) : ?>
                    <h2><a href="<?php echo esc_url( $settings['title_url']); ?>"><?php echo esc_html( $settings['icon_title']); ?></a></h2>
                <?php endif; ?>

                <?php if ( !empty($settings['icon_content']) ) : ?>
                    <p><?php echo esc_html( $settings['icon_content']); ?></p>
                <?php endif; ?>
            </div>
        </div>

    <?php
}
}
$widgets_manager->register(new \Elementor\AdinaIconBoxOne());